/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ORMContext;
import com.kingdee.bos.dao.ormapping.WholeTableAffectedException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.KeyWord;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameter;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameters;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorBuilder;
import com.kingdee.bos.dao.ormapping.impl.SQLGenerator;
import com.kingdee.bos.dao.ormapping.impl.SQLGeneratorCache;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.db.TableDesc;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntityAccess {
    private static Logger logger = Logger.getLogger(EntityAccess.class);
    private final Connection cn;
    private final SolutionInfo solution;
    private final Context ctx;
    private final TableDesc tableDesc;
    private final EntityObjectInfo bo;
    private final Map values;
    private final List<String> paramNames;
    private final RTFilterParameters filterParameters;
    private final RTFilterParameters entryFilterParameters;
    private List<PropertyInfo> fieldList = null;
    private Map<String, String> aliasMapping = null;
    private SorterItemCollection sorter = null;
    private RTSelector selector = null;
    private boolean entryPermCol = false;

    public static EntityAccess getInstance(EntityObjectInfo bo, SolutionInfo solution, EntityViewInfo view, Context ctx) throws SQLException, InvalidDAOMetaDataException {
        EntityAccess ea = EntityAccess.getInstance(null, bo, solution, view.getFilter(), view.getSorter(), RTSelectorBuilder.buildSelfPropSelector(view.getSelector(), bo), ctx);
        ea.entryPermCol = view.isEntryPermCol();
        return ea;
    }

    private void initialize(EntityObjectInfo bo, RTSelector selector, FilterInfo filter, SorterItemCollection sorter) throws SQLException, InvalidDAOMetaDataException {
        if (filter != null) {
            FilterItemCollection itemCol = filter.getFilterItems();
            int size = itemCol.size();
            for (int i = 0; i < size; ++i) {
                Object value;
                FilterItemInfo filterItem = itemCol.get(i);
                selector = this.addSelectorProperty(bo, selector, filterItem.getPropertyName());
                if (!filterItem.isCompareValueIsProperty() || (value = filterItem.getCompareValue()) == null) continue;
                selector = this.addSelectorProperty(bo, selector, value.toString());
            }
        }
        this.setSelector(selector);
        if (filter != null) {
            this.addFilter(bo, filter);
        }
        if (sorter != null) {
            for (int i = 0; i < sorter.size(); ++i) {
                SorterItemInfo sorterItem = sorter.get(i);
                this.addSortItem(sorterItem);
            }
        }
    }

    private RTSelector addSelectorProperty(EntityObjectInfo bo, RTSelector selector, String name) throws InvalidDAOMetaDataException {
        if (name == null || name.indexOf(".") < 0) {
            return selector;
        }
        if (selector == null || selector.size() == 0) {
            selector = new RTSelector();
        }
        selector.addProperty(bo, name);
        return selector;
    }

    private void processEntityInherit(EntityObjectInfo bo) throws SQLException, InvalidDAOMetaDataException {
        PropertyCollection flds = bo.getInheritedPropertiesRuntime();
        int n = flds.size();
        for (int j = 0; j < n; ++j) {
            PropertyInfo propSupplier;
            RelationshipInfo relation;
            PropertyInfo fld = flds.get(j);
            if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ((LinkPropertyInfo)fld).getRelationship()).getType())) continue;
            PropertyInfo propClient = relation.getClientProperty();
            if (propClient instanceof LinkPropertyInfo) {
                this.processInheritProperty(relation.getClientObject(), (LinkPropertyInfo)propClient, bo);
            }
            if (!((propSupplier = relation.getSupplierProperty()) instanceof LinkPropertyInfo)) continue;
            this.processInheritProperty(relation.getSupplierObject(), (LinkPropertyInfo)propSupplier, bo);
        }
    }

    private void processInheritProperty(EntityObjectInfo propEntity, LinkPropertyInfo prop, EntityObjectInfo bo) throws SQLException, InvalidDAOMetaDataException {
        if (prop == null) {
            return;
        }
        RelationshipInfo relation = prop.getRelationship();
        if (relation == null) {
            throw new InvalidDAOMetaDataException("Can't find prop's relation! Entity:" + bo.getFullName() + " prop:" + prop.getName());
        }
        EntityObjectInfo boClient = relation.getClientObject();
        if (boClient != bo && ImplUtils.isInhereitedEntity(boClient, bo)) {
            String key = ImplUtils.getRTRelaKeyName(propEntity, prop);
            ORMContext ctx = ImplUtils.getContext();
            if (!ctx.containsKey(key)) {
                RelationshipInfo cloned = (RelationshipInfo)relation.getRuntimeCopy();
                cloned.setClientObject(bo);
                ctx.setRTRelationship(key, cloned);
            }
        }
    }

    public static EntityAccess getInstance(Connection cn, EntityObjectInfo bo, SolutionInfo solution, FilterInfo filter, SorterItemCollection sorter, RTSelector selector, Context ctx) throws SQLException, InvalidDAOMetaDataException {
        DataTableInfo table = bo.getTable();
        if (table == null) {
            throw new InvalidDAOMetaDataException((bo.getFullName() == null ? bo.toString() : bo.getFullName()) + " not define table");
        }
        EntityAccess ea = new EntityAccess(bo, cn, table.getName(), solution, ctx);
        ea.initialize(bo, selector, filter, sorter);
        return ea;
    }

    protected EntityAccess(EntityObjectInfo bo, Connection cn, String tableName, SolutionInfo solution, Context ctx) {
        this.cn = cn;
        this.solution = solution;
        this.ctx = ctx;
        this.bo = bo;
        this.tableDesc = new TableDesc(tableName);
        this.values = new HashMap();
        this.filterParameters = new RTFilterParameters();
        this.entryFilterParameters = new RTFilterParameters();
        this.paramNames = new ArrayList<String>();
        this.fieldList = new ArrayList<PropertyInfo>();
        this.aliasMapping = null;
    }

    public IObjectCollection select(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef) throws SQLException, InvalidDAOMetaDataException {
        return this.select(bo, isMultilingual, crossTable, isCrossTableMainRef, Integer.MIN_VALUE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IObjectPK[] getPkList(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount) throws SQLException, InvalidDAOMetaDataException {
        IObjectPK[] iObjectPKArray;
        this.processEntityInherit(bo);
        String sql = this.getSQLGenerator().selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, "", topCount);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "select", sql);
        }
        ResultSet rset = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareParam(sql);
            rset = this.execQuerySQL(stmt);
            iObjectPKArray = ImplUtils.getPkList(rset, bo, this.fieldList, this.aliasMapping, this.ctx);
        }
        catch (InvalidDAOMetaDataException e) {
            try {
                logger.error((Object)("getPkList() occur error:" + e.getMessage() + " \nsql: " + sql));
                throw new InvalidDAOMetaDataException("error:" + e.getMessage() + ",  sql:" + sql, (Throwable)e);
                catch (SQLException e2) {
                    logger.error((Object)("getPkList() occur error:" + e2.getMessage() + " \nsql: " + sql));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rset, (Statement)stmt);
                if (ProfileConfig.getInstance().logORMapping) {
                    ThreadProfileContext.getInstance().exit();
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rset, (Statement)stmt);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().exit();
        }
        return iObjectPKArray;
    }

    public String getSql(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount) throws SQLException, InvalidDAOMetaDataException {
        this.processEntityInherit(bo);
        String sql = this.getSQLGenerator().selectSQLWithTrueValue(bo, isMultilingual, crossTable, isCrossTableMainRef);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "select", sql);
        }
        return sql;
    }

    public IObjectCollection select(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount) throws SQLException, InvalidDAOMetaDataException {
        return this.select(bo, isMultilingual, crossTable, isCrossTableMainRef, topCount, 0, true);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IObjectCollection select(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, int topCount, int offset, boolean isOffset) throws SQLException, InvalidDAOMetaDataException {
        IObjectCollection iObjectCollection;
        this.processEntityInherit(bo);
        String sql = null;
        sql = isOffset ? this.getSQLGenerator().selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, "", topCount, offset) : this.getSQLGenerator().selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, "", topCount);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "select", sql);
        }
        ResultSet rset = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareParam(sql);
            rset = this.execQuerySQL(stmt);
            iObjectCollection = ImplUtils.fillObjectValue(rset, bo, this.fieldList, this.aliasMapping, this.ctx);
        }
        catch (InvalidDAOMetaDataException e) {
            try {
                logger.error((Object)("select() occur error:" + e.getMessage() + " \nsql: " + sql));
                throw new InvalidDAOMetaDataException("error:" + e.getMessage() + ",  sql:" + sql, (Throwable)e);
                catch (SQLException e2) {
                    logger.error((Object)("select() occur error:" + e2.getMessage() + " \nsql: " + sql));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rset, (Statement)stmt);
                if (ProfileConfig.getInstance().logORMapping) {
                    ThreadProfileContext.getInstance().exit();
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rset, (Statement)stmt);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().exit();
        }
        return iObjectCollection;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IObjectCollection select(EntityObjectInfo bo, boolean isMultilingual, CrossTableInfo crossTable, boolean isCrossTableMainRef, int start, int length) throws SQLException, InvalidDAOMetaDataException {
        IObjectCollection iObjectCollection;
        PreparedStatement stmt;
        ResultSet rset;
        String sql;
        block10: {
            this.processEntityInherit(bo);
            sql = this.getSQLGenerator().selectSQL(bo, isMultilingual, crossTable, isCrossTableMainRef, "", start + length);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().enter(this.getClass().getName(), "select", sql);
            }
            int dbType = KSqlUtil.getDbType((Connection)this.cn);
            PagingHelper pageHelper = new PagingHelper(false);
            sql = pageHelper.getPagingSql(this.ctx, dbType, sql, start, length);
            rset = null;
            stmt = null;
            stmt = this.prepareParam(sql, pageHelper.getParamData());
            rset = this.execQuerySQL(stmt);
            if (dbType == 5) break block10;
            IObjectCollection iObjectCollection2 = ImplUtils.fillObjectValue(rset, bo, this.fieldList, this.aliasMapping, this.ctx);
            SQLUtils.cleanup((ResultSet)rset, (Statement)stmt);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
            return iObjectCollection2;
        }
        try {
            iObjectCollection = ImplUtils.fillObjectValue(rset, bo, this.fieldList, this.aliasMapping, this.ctx, start, length);
        }
        catch (InvalidDAOMetaDataException e) {
            try {
                logger.error((Object)("select() occur error:" + e.getMessage() + " \nsql: " + sql));
                throw new InvalidDAOMetaDataException("error:" + e.getMessage() + ",  sql:" + sql, (Throwable)e);
                catch (SQLException e2) {
                    logger.error((Object)("select() occur error:" + e2.getMessage() + " \nsql: " + sql));
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rset, stmt);
                if (ProfileConfig.getInstance().logORMapping) {
                    ThreadProfileContext.getInstance().exit();
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rset, (Statement)stmt);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().exit();
        }
        return iObjectCollection;
    }

    public boolean exists(EntityObjectInfo bo) throws SQLException, InvalidDAOMetaDataException {
        boolean bl;
        String existSql = this.getSQLGenerator().selectSQL(bo, false, null, false, KeyWord.TOP_ONE);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "exists", existSql);
        }
        ResultSet rset = null;
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareParam(existSql);
            rset = this.execQuerySQL(stmt);
            bl = rset.next();
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("exists() occur error! \nsql: " + existSql));
                throw sqle;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rset, (Statement)stmt);
                if (ProfileConfig.getInstance().logORMapping) {
                    ThreadProfileContext.getInstance().exit();
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rset, (Statement)stmt);
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().exit();
        }
        return bl;
    }

    public int getCount(EntityObjectInfo bo) throws SQLException, InvalidDAOMetaDataException {
        PreparedStatement stmt;
        ResultSet rset;
        String countSql;
        block8: {
            countSql = this.getSQLGenerator().selectSQL(bo, false, null, false, KeyWord.COUNT);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().enter(this.getClass().getName(), "getCount", countSql);
            }
            rset = null;
            stmt = null;
            stmt = this.prepareParam(countSql);
            rset = this.execQuerySQL(stmt);
            if (!rset.next()) break block8;
            int n = rset.getInt(1);
            SQLUtils.cleanup((ResultSet)rset, (Statement)stmt);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
            return n;
        }
        try {
            try {
                throw new SQLException("Return no data when get count!");
            }
            catch (SQLException sqle) {
                logger.error((Object)("getCount occur error! \nsql: " + countSql));
                throw sqle;
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rset, (Statement)stmt);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
            throw throwable;
        }
    }

    public void update() throws WholeTableAffectedException, SQLException {
        this.execUpdateSQL(this.getSQLGenerator().update());
    }

    public void delete() throws SQLException, WholeTableAffectedException {
        this.execUpdateSQL(this.getSQLGenerator().delete());
    }

    public void deleteBySQL(EntityObjectInfo bo) throws SQLException, WholeTableAffectedException {
        this.execUpdateSQL(this.getSQLGenerator().deleteBySQL(bo));
    }

    private ResultSet execQuerySQL(PreparedStatement stmt) throws SQLException {
        return stmt.executeQuery();
    }

    private int execUpdateSQL(String sql) throws SQLException {
        if (StringUtils.isEmpty((String)sql)) {
            return 0;
        }
        if (ProfileConfig.getInstance().logORMapping) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "execUpdateSQL", sql);
        }
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareParam(sql);
            int n = stmt.executeUpdate();
            return n;
        }
        catch (SQLException sqle) {
            logger.error((Object)("execUpdateSQL error! " + sqle.getMessage() + "\nSQL: " + sql));
            throw sqle;
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
            if (ProfileConfig.getInstance().logORMapping) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private PreparedStatement prepareParam(String sql, ParamData paramData) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(" *** sql is : \n" + sql));
        }
        PreparedStatement preparedStmt = this.cn.prepareStatement(sql);
        ParamData.setParamDataToStatement((ParamData)paramData, (PreparedStatement)preparedStmt);
        int n = this.paramNames.size();
        for (int i = 0; i < n; ++i) {
            String field = this.paramNames.get(i);
            this.tableDesc.bindToParam(preparedStmt, i + 1, field, this.values.get(field));
        }
        return preparedStmt;
    }

    private PreparedStatement prepareParam(String sql) throws SQLException {
        return this.prepareParam(sql, null);
    }

    private final SQLGenerator getSQLGenerator() {
        return new SQLGeneratorCache(this, this.ctx);
    }

    public SolutionInfo getSolution() {
        return this.solution;
    }

    public String getTableName() {
        return this.tableDesc.getTableName();
    }

    public RTFilterParameters getFilterParameters() {
        return this.filterParameters;
    }

    public SorterItemCollection getSorter() {
        if (this.sorter == null) {
            return new SorterItemCollection();
        }
        return this.sorter;
    }

    public RTSelector getSelector() {
        return this.selector;
    }

    public void setSelector(RTSelector selector) {
        this.selector = selector;
    }

    public List<String> getParamNames() {
        return this.paramNames;
    }

    public int getParamSize() {
        return this.paramNames.size();
    }

    public String getFilterFormat() {
        return this.filterParameters.getFormat();
    }

    public void setFilterFormat(String format) {
        this.filterParameters.setFormat(format);
    }

    public Map<String, String> getAliasMapping() {
        return this.aliasMapping;
    }

    public void setAliasMapping(Map<String, String> map) {
        this.aliasMapping = map;
    }

    public List<PropertyInfo> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<PropertyInfo> list) {
        this.fieldList = list;
    }

    public void parseEntryFilter(EntityObjectInfo bo, FilterInfo entryPermFilter) throws SQLException, InvalidDAOMetaDataException {
        if (bo == null || entryPermFilter == null) {
            return;
        }
        FilterItemCollection itemCol = entryPermFilter.getFilterItems();
        int size = itemCol.size();
        for (int i = 0; i < size; ++i) {
            Object obj;
            FilterItemInfo filterItem = itemCol.get(i);
            String propName = filterItem.getPropertyName();
            PropertyInfo fld = bo.getFieldByFullName(propName);
            if (fld == null) {
                throw new InvalidDAOMetaDataException("field " + filterItem.getPropertyName() + " can not found");
            }
            ColumnInfo col = fld.getMappingField();
            this.addFilter(this.entryFilterParameters, filterItem, col, bo.isBOSUuidCol(fld));
            this.selector = this.addSelectorProperty(bo, this.selector, propName);
            if (!filterItem.isCompareValueIsProperty() || (obj = filterItem.getCompareValue()) == null) continue;
            this.selector = this.addSelectorProperty(bo, this.selector, obj.toString());
        }
        this.entryFilterParameters.setFormat(entryPermFilter.getMaskString());
        this.setSelector(this.selector);
    }

    public void addFilter(EntityObjectInfo bo, FilterInfo filter) throws SQLException, InvalidDAOMetaDataException {
        filter.toString();
        this.setFilterFormat(filter.getMaskString());
        FilterItemCollection itemCol = filter.getFilterItems();
        int size = itemCol.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo filterItem = itemCol.get(i);
            String propertyName = null;
            if (filterItem.isFuncCol()) {
                List fieldList = filterItem.getFieldList();
                HashSet<String> set = new HashSet<String>();
                for (int j = 0; j < fieldList.size(); ++j) {
                    propertyName = (String)fieldList.get(j);
                    set.add((String)fieldList.get(j));
                }
                if (set.size() != fieldList.size()) {
                    throw new InvalidDAOMetaDataException("Expression not supported ! " + filterItem);
                }
            } else {
                propertyName = filterItem.getPropertyName();
            }
            if (propertyName == null) {
                throw new InvalidDAOMetaDataException("field " + filterItem.getPropertyName() + " propertyName is null can not found on entity " + bo.getFullName());
            }
            PropertyInfo fld = bo.getFieldByFullName(propertyName);
            if (fld == null) {
                throw new InvalidDAOMetaDataException("field " + filterItem.getPropertyName() + " can not found on entity " + bo.getFullName());
            }
            ColumnInfo col = fld.getMappingField();
            this.addFilter(this.filterParameters, filterItem, col, bo.isBOSUuidCol(fld));
        }
    }

    public void addFilter(FilterItemInfo filter, ColumnInfo column, boolean isBOSUuidCol) {
        this.processAddFilter(this.filterParameters, filter, column, isBOSUuidCol);
    }

    public void addFilter(RTFilterParameters collection, FilterItemInfo filter, ColumnInfo column, boolean isBOSUuidCol) {
        this.processAddFilter(collection, filter, column, isBOSUuidCol);
    }

    protected void processAddFilter(RTFilterParameters collection, FilterItemInfo filter, ColumnInfo column, boolean isBOSUuidCol) {
        CompareType type = filter.getCompareType();
        if (CompareType.INNER.equals((Object)type) || CompareType.NOTINNER.equals((Object)type) || CompareType.EXISTS.equals((Object)type) || CompareType.NOTEXISTS.equals((Object)type)) {
            isBOSUuidCol = false;
        }
        Object compareValue = filter.getCompareValue();
        if (!(column == null || filter.isCompareValueIsProperty() || compareValue == null || CompareType.INCLUDE.equals((Object)type) || CompareType.NOTINCLUDE.equals((Object)type) || CompareType.INNER.equals((Object)type) || CompareType.NOTINNER.equals((Object)type) || CompareType.EXISTS.equals((Object)type) || CompareType.NOTEXISTS.equals((Object)type) || !SQLType.NCHAR.equals((Object)column.getTypeName()) && !SQLType.NVARCHAR.equals((Object)column.getTypeName()))) {
            filter.setCompareValue((Object)("~9^Nz" + compareValue));
        }
        ColumnInfo column2 = null;
        if (filter.isCompareValueIsProperty() && compareValue != null) {
            String fieldName = compareValue.toString();
            try {
                PropertyInfo fld = this.bo.getFieldByFullName(fieldName);
                if (fld == null) {
                    throw new InvalidDAOMetaDataException("field " + filter.getPropertyName() + " can not found on bo " + this.bo.getFullName());
                }
                column2 = fld.getMappingField();
            }
            catch (InvalidDAOMetaDataException e) {
                throw new RuntimeException(e);
            }
        }
        this.innerAddFilter(collection, filter, column, column2, this.ctx.getLocale().toString(), isBOSUuidCol);
    }

    private void innerAddFilter(RTFilterParameters collection, FilterItemInfo filter, ColumnInfo column, ColumnInfo column2, String langID, boolean isBOSUuidCol) {
        String fullName;
        int index;
        assert (filter != null && column != null && column2 != null);
        String colName = column.getName();
        if (column.isMultilingual()) {
            colName = colName + "_" + langID;
        }
        fullName = (index = (fullName = filter.getPropertyName()).lastIndexOf(46)) > 0 ? fullName.substring(0, index + 1) + colName : colName;
        String valueColName = "";
        String fullValueFieldName = "";
        if (column2 != null && filter.getCompareValue() != null) {
            valueColName = column2.getName();
            if (column2.isMultilingual()) {
                valueColName = valueColName + "_" + langID;
            }
            fullValueFieldName = (index = (fullValueFieldName = (String)filter.getCompareValue()).lastIndexOf(46)) > 0 ? fullValueFieldName.substring(0, index + 1) + valueColName : colName;
        }
        RTFilterParameter parameter = new RTFilterParameter(fullName, colName, fullValueFieldName, valueColName, column.getSQLType(), filter, isBOSUuidCol);
        parameter.setCompareValueIsProperty(filter.isCompareValueIsProperty());
        collection.add(parameter);
    }

    public void addSortItem(SorterItemInfo sorterItem) {
        SorterItemCollection sort = this.getSorter();
        sort.add(sorterItem);
        this.sorter = sort;
    }

    public void addSortItemAtFirst(SorterItemInfo sorterItem) {
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(sorterItem);
        sort.addObjectCollection((IObjectCollection)this.getSorter());
        this.sorter = sort;
    }

    public void addParameter(String name, Object value, int sqltype) {
        this.addParameter(name, value, sqltype, null);
    }

    public void addParameter(String name, Object value, int sqltype, String langPostFix) {
        if (!StringUtils.isEmpty((String)langPostFix)) {
            name = name + "_" + langPostFix;
        }
        this.tableDesc.addFieldDesc(name, sqltype);
        this.paramNames.add(name);
        if (value == null || value.toString().length() == 0) {
            this.values.put(name, "");
        } else {
            this.values.put(name, value);
        }
    }

    public RTFilterParameters getEntryFilterParameters() {
        return this.entryFilterParameters;
    }

    public boolean isEntryPermCol() {
        return this.entryPermCol;
    }

    void setEntryPermCol(boolean entryPermCol) {
        this.entryPermCol = entryPermCol;
    }
}

