/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.impl.IObjectCreator;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ORMappingMdChangeListener;
import com.kingdee.bos.dao.ormapping.impl.ObjectHandler;
import com.kingdee.bos.metadata.configure.MetadataChangeListener;
import com.kingdee.bos.metadata.configure.MetadataChangeListenerManager;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.KeyMapCollection;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.rule.formula.FormulaExecuteException;
import com.kingdee.bos.seq.app.SequenceFacadeFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.CommandBuilder;
import com.kingdee.util.db.TableDesc;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ObjectCreator
extends ObjectHandler
implements IObjectCreator {
    private static Logger logger = Logger.getLogger(ObjectCreator.class);
    private static boolean isUseNewUuid = true;

    ObjectCreator(Context ctx, Connection cn, SolutionInfo solution) {
        super(ctx, cn, solution);
    }

    @Override
    public IObjectPK create(EntityObjectInfo bo, IObjectValue saveData) throws SQLException, InvalidDAOMetaDataException, FormulaExecuteException {
        EntityObjectInfo basebo;
        this.setObjectUuid(bo, saveData);
        this.createRecord(bo, saveData);
        IObjectPK pk = Utils.getObjectPK(bo, saveData);
        for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
        }
        if (basebo != null) {
            PropertyInfo key = basebo.getLogicalKeyPropertiesRuntime().get(0);
            String uuid = saveData.get(saveData.getPKField()).toString();
            saveData.put(key.getName(), (Object)uuid);
            this.create(basebo, saveData);
        }
        return pk;
    }

    private void createRecord(EntityObjectInfo bo, IObjectValue saveData) throws SQLException, InvalidDAOMetaDataException, FormulaExecuteException {
        CompositeValue value;
        int i;
        saveData = ImplUtils.cloneIObjectValue(bo, saveData);
        this.processData(bo, saveData);
        ArrayList<CompositeValue> leftCompositeValue = new ArrayList<CompositeValue>(4);
        ArrayList<CompositeValue> rightCompositeValue = new ArrayList<CompositeValue>(4);
        ArrayList<CompositeValue> entryValue = new ArrayList<CompositeValue>(4);
        this.processCompisiteProp(saveData, bo, leftCompositeValue, rightCompositeValue, entryValue);
        int size = leftCompositeValue.size();
        for (int i2 = 0; i2 < size; ++i2) {
            CompositeValue value2 = (CompositeValue)leftCompositeValue.get(i2);
            this.create(value2.bo, (IObjectValue)value2.data);
        }
        CommandParam param = this.getCommandParam(bo, this.solution, saveData);
        CommandBuilder cb = new CommandBuilder(this.cn, param.tableDesc, param.insertValues);
        cb.addnew();
        int size2 = rightCompositeValue.size();
        for (i = 0; i < size2; ++i) {
            value = (CompositeValue)rightCompositeValue.get(i);
            this.create(value.bo, (IObjectValue)value.data);
        }
        size2 = entryValue.size();
        for (i = 0; i < size2; ++i) {
            value = (CompositeValue)entryValue.get(i);
            EntityObjectInfo entryBO = value.bo;
            IObjectCollection entryDatas = (IObjectCollection)value.data;
            int n = entryDatas.size();
            for (int j = 0; j < n; ++j) {
                this.create(entryBO, entryDatas.getObject(j));
            }
        }
        PropertyCollection flds = bo.getPropertiesRuntime();
        int size3 = flds.size();
        for (int i3 = 0; i3 < size3; ++i3) {
            IObjectCollection childDatas;
            RelationshipInfo relation;
            PropertyInfo fld = flds.get(i3);
            if (!(fld instanceof LinkPropertyInfo) || !saveData.containsKey(fld.getName()) || CardinalityType.isOneORZero((CardinalityType)(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld)).getParentCardinality(bo)) || CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo)) || relation.getCrossTable() == null || (childDatas = (IObjectCollection)saveData.get(fld.getName())) == null) continue;
            this.createSubCrossRecords(bo, (LinkPropertyInfo)fld, childDatas, saveData);
        }
        this.createExtRecord(bo, saveData);
    }

    void createSubRecords(EntityObjectInfo bo, LinkPropertyInfo fld, IObjectCollection childDatas, IObjectValue parentData) throws InvalidDAOMetaDataException, FormulaExecuteException, SQLException {
        RelationshipInfo rel = ImplUtils.getRTRelation(bo, fld);
        if (CardinalityType.ONE_TO_UNBOUNDED.equals((Object)rel.getChildCardinality(bo)) && childDatas.size() == 0) {
            throw new SQLException("ChildObject collection count is zero,but ChildCardinality is CardinalityType.ONE_TO_UNBOUNDED. relationship:" + rel.getName());
        }
        EntityObjectInfo chidObject = rel.getChildObject(bo);
        PropertyInfo parentProp = rel.getParentProperty(bo);
        PropertyInfo childProp = rel.getChildProperty(bo);
        int size = childDatas.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue childData = childDatas.getObject(i);
            childData.put(childProp.getName(), parentData.get(parentProp.getName()));
            this.createRecord(chidObject, childData);
        }
    }

    void createSubCrossRecords(EntityObjectInfo bo, LinkPropertyInfo fld, IObjectCollection childDatas, IObjectValue parentData) throws SQLException, InvalidDAOMetaDataException {
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, fld);
        EntityObjectInfo chidObject = relation.getChildObject(bo);
        CrossTableInfo crossTable = relation.getCrossTable();
        KeyMapCollection clientKeyMaps = crossTable.getClientTableMap().getKeyMaps();
        KeyMapCollection supplierKeyMaps = crossTable.getSupplierTableMap().getKeyMaps();
        boolean mainref = ImplUtils.isMainObjRefCrossTable(bo, chidObject, fld, crossTable);
        CommandBuilder cb = new CommandBuilder(this.cn, crossTable.getName());
        int size = childDatas.size();
        for (int i = 0; i < size; ++i) {
            Object val;
            PropertyInfo refProp;
            ColumnInfo refColumn;
            ColumnInfo selfColumn;
            int j;
            IObjectValue childData = childDatas.getObject(i);
            int n = clientKeyMaps.size();
            for (j = 0; j < n; ++j) {
                selfColumn = clientKeyMaps.get(j).getSelfColumn();
                refColumn = clientKeyMaps.get(j).getRefColumn();
                if (mainref) {
                    refProp = bo.getInheritedPropertyByColName(refColumn.getName());
                    val = parentData.get(refProp.getName());
                } else {
                    refProp = chidObject.getInheritedPropertyByColName(refColumn.getName());
                    val = childData.get(refProp.getName());
                }
                cb.addField(selfColumn.getName(), val, selfColumn.getSQLType());
            }
            n = supplierKeyMaps.size();
            for (j = 0; j < n; ++j) {
                selfColumn = supplierKeyMaps.get(j).getSelfColumn();
                refColumn = supplierKeyMaps.get(j).getRefColumn();
                if (mainref) {
                    refProp = chidObject.getInheritedPropertyByColName(refColumn.getName());
                    val = childData.get(refProp.getName());
                } else {
                    refProp = bo.getInheritedPropertyByColName(refColumn.getName());
                    val = parentData.get(refProp.getName());
                }
                cb.addField(selfColumn.getName(), val, selfColumn.getSQLType());
            }
            cb.addnew();
        }
    }

    private void createExtRecord(EntityObjectInfo bo, IObjectValue saveData) throws SQLException, InvalidDAOMetaDataException, FormulaExecuteException {
        PropertyCollection flds = bo.getPropertiesRuntime();
        HashMap<String, CommandBuilder> extCBs = new HashMap<String, CommandBuilder>();
        int size = flds.size();
        for (int i = 0; i < size; ++i) {
            CommandBuilder extCmdBuilder;
            PropertyInfo fld = flds.get(i);
            ExtendedFieldInfo extfld = fld.getExtendedField();
            if (extfld == null) continue;
            ColumnInfo col = extfld.getExtendedColumn();
            String tableName = extfld.getExtendedTable().getName();
            if (!extCBs.containsKey(tableName)) {
                extCmdBuilder = new CommandBuilder(this.cn, extfld.getExtendedTable().getName());
                extCBs.put(tableName, extCmdBuilder);
                PropertyCollection keys = bo.getLogicalKeyPropertiesRuntime();
                int m = keys.size();
                for (int j = 0; j < m; ++j) {
                    PropertyInfo prop = keys.get(j);
                    ColumnInfo keycol = prop.getMappingField();
                    extCmdBuilder.addField(keycol.getName(), saveData.get(prop.getName()), keycol.getSQLType());
                }
            } else {
                extCmdBuilder = (CommandBuilder)extCBs.get(tableName);
            }
            boolean isExists = saveData.containsKey(fld.getName());
            Object dataValue = null;
            if (isExists) {
                dataValue = saveData.get(fld.getName());
            }
            if (fld instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
                if (!CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) continue;
                if (RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo)) && isExists && dataValue != null) {
                    this.create(relation.getChildObject(bo), (IObjectValue)dataValue);
                }
                if (dataValue != null) {
                    dataValue = ((IObjectValue)dataValue).get(relation.getChildProperty(bo).getName());
                }
                if (dataValue == null) continue;
                extCmdBuilder.addField(col.getName(), dataValue, col.getSQLType());
                continue;
            }
            if (col.isMultilingual()) {
                LanguageCollection langs = this.solution.getLanguages();
                int n = langs.size();
                for (int j = 0; j < n; ++j) {
                    LanguageInfo lang = langs.get(j);
                    String fieldName = ObjectCreator.localedName(fld.getName(), lang);
                    if (!saveData.containsKey(fieldName)) continue;
                    String colName = ObjectCreator.localedName(col.getName(), lang);
                    Object propValue = saveData.get(fieldName);
                    this.checkConstriant(fld, propValue);
                    extCmdBuilder.addField(colName, propValue, col.getSQLType());
                }
                continue;
            }
            if (!isExists) continue;
            this.checkConstriant(fld, dataValue);
            extCmdBuilder.addField(col.getName(), dataValue, col.getSQLType());
        }
        Iterator iter = extCBs.entrySet().iterator();
        while (iter.hasNext()) {
            CommandBuilder extCmdBuilder = (CommandBuilder)iter.next().getValue();
            extCmdBuilder.addnew();
        }
    }

    private BOSUuid newUuid(BOSObjectType type) {
        BOSUuid id;
        if (isUseNewUuid) {
            try {
                id = SequenceFacadeFactory.getLocalInstance(this.ctx).nextValue(type.toString());
            }
            catch (Exception e) {
                logger.error((Object)"set objet uuid in sequence way error.", (Throwable)e);
                isUseNewUuid = false;
                id = BOSUuid.create((BOSObjectType)type);
            }
        } else {
            id = BOSUuid.create((BOSObjectType)type);
        }
        return id;
    }

    private void processData(EntityObjectInfo bo, IObjectValue saveData) throws FormulaExecuteException, InvalidDAOMetaDataException, SQLException {
        PropertyCollection flds = bo.getPropertiesRuntime();
        int size = flds.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo fld = flds.get(i);
            if (!(fld instanceof OwnPropertyInfo)) continue;
            String fldName = fld.getName();
            ColumnInfo col = bo.getMappingFieldOfProperty(fld);
            if (col != null && bo.isLogicalKey(fld) && ((OwnPropertyInfo)fld).getDataType().equals((Object)DataType.BOSUUID) && saveData.get(fldName) == null) {
                saveData.put(fldName, (Object)this.newUuid(saveData.getBOSType()));
            }
            this.calculateFormula(fld, col, bo, saveData);
        }
    }

    private void processCompisiteProp(IObjectValue saveData, EntityObjectInfo bo, List<CompositeValue> leftCompositionValue, List<CompositeValue> rightCompositionValue, List<CompositeValue> entryValue) throws SQLException {
        EntityObjectInfo.Compositions compositions = bo.getCompositions();
        List one2one = compositions.one2one;
        int size = one2one.size();
        for (int i = 0; i < size; ++i) {
            boolean valueNotNull;
            EntityObjectInfo.Prop2ChildBoMapping pm = (EntityObjectInfo.Prop2ChildBoMapping)one2one.get(i);
            LinkPropertyInfo prop = (LinkPropertyInfo)pm.prop;
            Object dataValue = saveData.get(prop.getName());
            boolean bl = valueNotNull = dataValue != null && dataValue instanceof IObjectValue;
            if (!valueNotNull) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, prop);
            boolean propAtRight = relation.getChildProperty(bo) instanceof LinkPropertyInfo;
            if (propAtRight) {
                ((IObjectValue)dataValue).put(pm.childPropName, (Object)saveData);
                rightCompositionValue.add(new CompositeValue(pm.childBO, dataValue));
                continue;
            }
            leftCompositionValue.add(new CompositeValue(pm.childBO, dataValue));
        }
        List one2Many = compositions.one2many;
        int size2 = one2Many.size();
        for (int i = 0; i < size2; ++i) {
            boolean valueNotNull;
            EntityObjectInfo.Prop2ChildBoMapping pm = (EntityObjectInfo.Prop2ChildBoMapping)one2Many.get(i);
            LinkPropertyInfo prop = (LinkPropertyInfo)pm.prop;
            Object dataValue = saveData.get(prop.getName());
            boolean bl = valueNotNull = dataValue != null && dataValue instanceof IObjectCollection && ((IObjectCollection)dataValue).size() > 0;
            if (!valueNotNull) continue;
            IObjectCollection childDatas = (IObjectCollection)dataValue;
            OwnPropertyInfo seqProp = pm.childBO.getSequenceProperty();
            String seqPropName = seqProp != null ? seqProp.getName() : null;
            int count = childDatas.size();
            for (int j = 0; j < count; ++j) {
                IObjectValue val = childDatas.getObject(j);
                if (seqPropName != null) {
                    val.put(seqPropName, (Object)(j + 1));
                }
                val.put(pm.childPropName, (Object)saveData);
            }
            entryValue.add(new CompositeValue(pm.childBO, dataValue));
        }
    }

    private void setObjectUuid(EntityObjectInfo bo, IObjectValue dataValue) {
        PropertyCollection keys = bo.getLogicalKeyPropertiesRuntime();
        int n = keys.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo key = keys.get(i);
            String keyName = key.getName();
            if (dataValue.get(keyName) != null || !(key instanceof OwnPropertyInfo) || !((OwnPropertyInfo)key).getDataType().equals((Object)DataType.BOSUUID)) continue;
            String uuid = this.newUuid(dataValue.getBOSType()).toString();
            dataValue.put(keyName, (Object)uuid);
            this.setBaseObjectUuid(bo, dataValue, i, uuid);
        }
    }

    private void setBaseObjectUuid(EntityObjectInfo bo, IObjectValue dataValue, int keyIndex, String uuid) {
        PropertyInfo key;
        EntityObjectInfo basebo = bo.getBaseEntity();
        if (basebo != null && !basebo.isAbstract() && (key = basebo.getLogicalKeyPropertiesRuntime().get(keyIndex)) instanceof OwnPropertyInfo && ((OwnPropertyInfo)key).getDataType().equals((Object)DataType.BOSUUID)) {
            dataValue.put(key.getName(), (Object)uuid);
            this.setBaseObjectUuid(basebo, dataValue, keyIndex, uuid);
        }
    }

    private CommandParam getCommandParam(EntityObjectInfo bo, SolutionInfo solution, IObjectValue saveData) throws SQLException {
        assert (saveData != null);
        CommandParam param = new CommandParam(new TableDesc(bo.getTable().getName()), new HashMap());
        List propNamesMapping = bo.getCompositions().allInstProp;
        LanguageCollection langs = solution.getLanguages();
        String defaultPostfix = saveData.getDefaultLocale().toString();
        int size = propNamesMapping.size();
        for (int i = 0; i < size; ++i) {
            LanguageInfo lang;
            int j;
            int n;
            EntityObjectInfo.Name2PropMapping np = (EntityObjectInfo.Name2PropMapping)propNamesMapping.get(i);
            String propName = np.name;
            PropertyInfo prop = np.prop;
            ColumnInfo col = bo.getMappingFieldOfProperty(prop);
            if (col == null) continue;
            String colName = col.getName();
            int colType = col.getSQLType();
            if (col.isMultilingual()) {
                n = langs.size();
                for (j = 0; j < n; ++j) {
                    lang = langs.get(j);
                    param.tableDesc.addFieldDesc(ObjectCreator.localedName(colName, lang), colType);
                }
            } else {
                param.tableDesc.addFieldDesc(colName, colType);
            }
            if (propName.indexOf(46) > 0) {
                Object propValue = saveData;
                String[] propNames = StringUtils.fastSplit((String)propName, (int)46);
                for (int j2 = 0; j2 < propNames.length && (propValue = propValue.get(propNames[j2])) instanceof IObjectValue; ++j2) {
                }
                if (propValue == null) continue;
                this.checkConstriant(prop, propValue);
                param.insertValues.put(colName, propValue);
                continue;
            }
            if (col.isMultilingual()) {
                n = langs.size();
                for (j = 0; j < n; ++j) {
                    lang = langs.get(j);
                    Object propValue = defaultPostfix.equalsIgnoreCase(lang.getPostfix()) ? saveData.get(propName) : saveData.get(ObjectCreator.localedName(propName, lang));
                    if (propValue == null) continue;
                    this.checkConstriant(prop, propValue);
                    param.insertValues.put(ObjectCreator.localedName(colName, lang), ObjectCreator.addUnicodeTag(propValue, col));
                }
                continue;
            }
            if (prop instanceof LinkPropertyInfo && param.insertValues.containsKey(colName)) continue;
            Object propValue = saveData.get(propName);
            if (propValue instanceof IObjectCollection) {
                logger.error((Object)("found a collection property mapping to a column: entity:\t" + bo.getFullName() + "\tproperty:\t" + prop.getName()));
                continue;
            }
            if (propValue == null) continue;
            this.checkConstriant(prop, propValue);
            param.insertValues.put(colName, propValue);
        }
        return param;
    }

    static {
        MetadataChangeListenerManager.register((MetadataChangeListener)ORMappingMdChangeListener.getInstance());
    }

    private static class CommandParam {
        private final TableDesc tableDesc;
        private final Map insertValues;

        private CommandParam(TableDesc tableDesc, Map insertValues) {
            this.tableDesc = tableDesc;
            this.insertValues = insertValues;
        }
    }

    private static class CompositeValue {
        final EntityObjectInfo bo;
        final Object data;

        CompositeValue(EntityObjectInfo bo, Object data) {
            this.bo = bo;
            this.data = data;
        }
    }
}

