/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.MaskValue;
import com.kingdee.bos.dao.ormapping.impl.MaskValues;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.TypeUtils;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.token.CollectionFormulaParser;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectFilter {
    private static final int IGNORE_VALUE_TYPE_IGNORE = 0;
    private static final int IGNORE_VALUE_TYPE_NULL = 1;
    private List filterPropList = new ArrayList();

    public boolean filte(IObjectValue value, FilterInfo rule) throws DataAccessException {
        this.initFilterProp(rule);
        boolean rtn = this.filteObjectValue(value, rule, new HashMap(), null, false);
        return rtn;
    }

    private void initFilterProp(FilterInfo rule) {
        this.filterPropList.clear();
        FilterItemCollection fItems = rule.getFilterItems();
        int size = fItems.size();
        for (int i = 0; i < size; ++i) {
            String propertyName;
            FilterItemInfo item = fItems.get(i);
            if (item == null || (propertyName = item.getPropertyName()) == null) continue;
            String[] pns = propertyName.split("[.]");
            StringBuffer p = new StringBuffer(pns[0]);
            this.addToFilterPropList(p.toString());
            for (int j = 1; j < pns.length; ++j) {
                p.append(".").append(pns[j]);
                this.addToFilterPropList(p.toString());
            }
        }
    }

    private void addToFilterPropList(String key) {
        if (!this.filterPropList.contains(key = key.toLowerCase())) {
            this.filterPropList.add(key);
        }
    }

    private boolean isInFilterProp(String key) {
        key = key.toLowerCase();
        return this.filterPropList.contains(key);
    }

    private void clearObjectValueMap(Map map, String pre) {
        if (pre == null || pre.length() == 0) {
            map.clear();
        } else {
            pre = pre + ".";
            for (String key : map.keySet()) {
                if (key == null || !key.startsWith(pre)) continue;
                map.put(key, null);
            }
        }
    }

    private boolean filteObjectValue(IObjectValue value, FilterInfo rule, Map map, String pre, boolean isIgnoreCollection) throws DataAccessException {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (map == null) {
            throw new IllegalArgumentException("map is null");
        }
        if (pre == null) {
            pre = "";
        }
        this.clearObjectValueMap(map, pre);
        String entryName = null;
        Enumeration enu = value.keys();
        while (enu.hasMoreElements()) {
            String p;
            String key = (String)enu.nextElement();
            if (key == null || !this.isInFilterProp(p = (pre.length() == 0 ? "" : pre + ".") + key)) continue;
            Object val = value.get(key);
            if (val instanceof IObjectValue) {
                map.put(p, val);
                this.filteObjectValue((IObjectValue)val, rule, map, p, true);
                continue;
            }
            if (val instanceof IObjectCollection) {
                if (isIgnoreCollection) {
                    throw new IllegalArgumentException("value can not has a collection link property");
                }
                if (entryName == null) {
                    entryName = key;
                    continue;
                }
                throw new IllegalArgumentException("value has more than one collection link property");
            }
            if (val == null) continue;
            map.put(p, val);
        }
        if (!isIgnoreCollection) {
            if (entryName != null) {
                String p = (pre.length() == 0 ? "" : pre + ".") + entryName;
                boolean b1 = this.filteMainRule(map, rule, p, 0);
                if (!b1) {
                    return false;
                }
                IObjectCollection entries = (IObjectCollection)value.get(entryName);
                ArrayList<IObjectValue> list = new ArrayList<IObjectValue>();
                int len = entries.size();
                if (len == 0) {
                    return this.filteMainRule(map, rule, p, 1);
                }
                for (int i = 0; i < len; ++i) {
                    map.put(p, entries.getObject(i));
                    boolean obj = this.filteObjectValue(entries.getObject(i), rule, map, p, false);
                    if (obj) continue;
                    list.add(entries.getObject(i));
                }
                if (list.size() == len) {
                    return false;
                }
                int len2 = list.size();
                for (int j = 0; j < len2; ++j) {
                    entries.removeObject((IObjectValue)list.get(j));
                }
            } else {
                return this.filteMainRule(map, rule, null, 0);
            }
        }
        return true;
    }

    private boolean filteMainRule(Map map, FilterInfo rule, String ignorePre, int ignoreType) throws DataAccessException {
        if (map == null || rule == null) {
            return true;
        }
        FilterItemCollection fItems = rule.getFilterItems();
        MaskValues maskValues = new MaskValues();
        String maskString = rule.getMaskString();
        boolean flag = false;
        if (StringUtils.isEmpty((String)maskString) || fItems.size() == 1) {
            flag = true;
        }
        int size = fItems.size();
        for (int i = 0; i < size; ++i) {
            FilterItemInfo item = fItems.get(i);
            String propertyName = item.getPropertyName();
            propertyName = propertyName.toLowerCase(Locale.ENGLISH);
            Object ruleData = item.getCompareValue();
            CompareType compType = item.getCompareType();
            Object objectData = map.get(propertyName);
            if (ignorePre != null && propertyName.startsWith(ignorePre)) {
                if (ignoreType == 1) {
                    objectData = null;
                } else {
                    maskValues.add(new MaskValue(true));
                    continue;
                }
            }
            try {
                if (objectData != null && ruleData != null || objectData == null && ruleData != null && (CompareType.EXISTS.equals((Object)compType) || CompareType.NOTEXISTS.equals((Object)compType))) {
                    if (!this.regexMatcher(objectData, ruleData, compType)) {
                        if (flag) {
                            return false;
                        }
                        maskValues.add(new MaskValue(false));
                        continue;
                    }
                    maskValues.add(new MaskValue(true));
                    continue;
                }
                if (objectData == null && ruleData != null || objectData != null && ruleData == null) {
                    if (CompareType.NOTEQUALS.equals((Object)compType)) {
                        maskValues.add(new MaskValue(true));
                        continue;
                    }
                    if (flag) {
                        return false;
                    }
                    maskValues.add(new MaskValue(false));
                    continue;
                }
                if (CompareType.EQUALS.equals((Object)compType)) {
                    maskValues.add(new MaskValue(true));
                    continue;
                }
                if (flag) {
                    return false;
                }
                maskValues.add(new MaskValue(false));
                continue;
            }
            catch (InterpreterException e) {
                throw new InvalidDAOMetaDataException(e.getMessage());
            }
            catch (SQLException sqle) {
                throw new InvalidDAOMetaDataException(sqle.getMessage());
            }
        }
        if (flag) {
            return true;
        }
        if (maskValues.size() != 0) {
            String expr = null;
            try {
                CollectionFormulaParser parse = new CollectionFormulaParser(maskString, (AbstractObjectCollection)maskValues);
                expr = parse.tokenList.showValue();
                Object obj = this.calculateMaskString(expr);
                return (Boolean)obj;
            }
            catch (BOSException e1) {
                throw new DataAccessException((Throwable)e1);
            }
        }
        return false;
    }

    private Object calculateMaskString(String maskString) throws DataAccessException {
        if (maskString == null) {
            throw new IllegalArgumentException("Formula string couldn't be null.");
        }
        Interpreter interpreter = new Interpreter();
        String parse = maskString.toLowerCase().replaceAll("and", "&&").replaceAll("or", "||");
        try {
            return interpreter.evalExpr(parse, new HashMap());
        }
        catch (InterpreterException ie) {
            throw new DataAccessException((Throwable)ie);
        }
        catch (ParserException pe) {
            throw new DataAccessException((Throwable)pe);
        }
    }

    private static String unicode(char c) {
        String us = "0000" + Integer.toHexString(c & 0xFFFF);
        us = us.substring(us.length() - 4);
        return "\\u" + us;
    }

    public static String sql_like_to_regex(String sqlLike) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < sqlLike.length(); ++i) {
            char c = sqlLike.charAt(i);
            if (c == '%') {
                sb.append(".*");
                continue;
            }
            if (c == '_') {
                sb.append(".");
                continue;
            }
            if ("\\(){}.*+".indexOf(c) >= 0) {
                sb.append(ObjectFilter.unicode(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private boolean regexMatcher(Object leftVal, Object rightVal, CompareType type) throws InterpreterException, SQLException {
        if (CompareType.EQUALS.equals((Object)type)) {
            if (leftVal instanceof Boolean && rightVal instanceof Integer) {
                return ((Boolean)leftVal).booleanValue() ? (Integer)rightVal == 1 : (Integer)rightVal == 0;
            }
            return TypeUtils.equal((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.GREATER.equals((Object)type)) {
            return TypeUtils.greaterThan((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.GREATER_EQUALS.equals((Object)type)) {
            return TypeUtils.greaterThanOrEqual((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.LESS.equals((Object)type)) {
            return TypeUtils.lessThan((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.LESS_EQUALS.equals((Object)type)) {
            return TypeUtils.lessThanOrEqual((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.NOTEQUALS.equals((Object)type)) {
            if (leftVal instanceof Boolean && rightVal instanceof Integer) {
                return !((Boolean)leftVal == false ? (Integer)rightVal == 0 : (Integer)rightVal == 1);
            }
            return !TypeUtils.equal((Object)leftVal, (Object)rightVal);
        }
        if (CompareType.INNER.equals((Object)type)) {
            return this.computeInner(leftVal, rightVal);
        }
        if (CompareType.NOTINNER.equals((Object)type)) {
            return !this.computeInner(leftVal, rightVal);
        }
        if (CompareType.INCLUDE.equals((Object)type)) {
            return this.computeInclude(leftVal, rightVal);
        }
        if (CompareType.NOTINCLUDE.equals((Object)type)) {
            return !this.computeInclude(leftVal, rightVal);
        }
        if (CompareType.LIKE.equals((Object)type)) {
            return ObjectFilter.computeLike(leftVal, rightVal);
        }
        if (CompareType.NOTLIKE.equals((Object)type)) {
            return !ObjectFilter.computeLike(leftVal, rightVal);
        }
        if (CompareType.EXISTS.equals((Object)type)) {
            return this.computeExists(rightVal);
        }
        if (CompareType.NOTEXISTS.equals((Object)type)) {
            return !this.computeExists(rightVal);
        }
        throw new IllegalStateException();
    }

    private boolean computeExists(Object rightVal) throws SQLException {
        throw new IllegalArgumentException("don't suport 'inner' in filte object!");
    }

    private boolean computeInner(Object leftVal, Object rightVal) throws SQLException {
        throw new IllegalArgumentException("don't suport 'inner' in filte object!");
    }

    static boolean computeLike(Object leftVal, Object rightVal) {
        Pattern filterPattern = Pattern.compile(ObjectFilter.sql_like_to_regex(rightVal.toString()));
        Matcher filterMatcher = filterPattern.matcher(leftVal.toString());
        return filterMatcher.matches();
    }

    private boolean computeInclude(Object leftVal, Object rightVal) {
        return rightVal != null && rightVal instanceof Set && ((Set)rightVal).size() != 0 && ((Set)rightVal).contains(leftVal);
    }
}

