/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.IObjectRemover;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.ObjectReader;
import com.kingdee.bos.dao.ormapping.impl.RTFilter;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameter;
import com.kingdee.bos.dao.ormapping.impl.RTFilterParameters;
import com.kingdee.bos.dao.ormapping.impl.RTFilters;
import com.kingdee.bos.dao.ormapping.impl.RTSelector;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorBuilder;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorItem;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.data.KeyMapCollection;
import com.kingdee.bos.metadata.data.KeyMapInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class ObjectRemover
extends ObjectHandler
implements IObjectRemover {
    ObjectRemover(Context ctx, Connection cn, SolutionInfo solution) {
        super(ctx, cn, solution);
    }

    public void deleteBySQL(EntityObjectInfo bo, FilterInfo filterData) throws SQLException, DataAccessException {
        EntityObjectInfo basebo;
        for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
        }
        if (basebo != null) {
            this.deleteBySQL(basebo, filterData);
        }
        FilterInfo filter = filterData;
        if (bo.getTable() == null) {
            throw new InvalidDAOMetaDataException((bo.getName() == null ? bo.toString() : bo.getName()) + " not define table");
        }
        EntityAccess ea = this.getEntityAccess(bo, bo.getTable().getName());
        if (filter != null) {
            ea.setFilterFormat(filter.getMaskString());
            ea.addFilter(bo, filter);
        }
        PropertyCollection props = bo.getPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            RelationshipInfo relation;
            PropertyInfo fld = props.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !CardinalityType.isOneORZero((CardinalityType)(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld)).getParentCardinality(bo)) || CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
            this.deleteSubRecordsBySQL(bo, (LinkPropertyInfo)fld, filterData, ea.getFilterParameters());
        }
        HashSet<String> exttb = new HashSet<String>();
        int n2 = props.size();
        for (int i = 0; i < n2; ++i) {
            String tableName;
            ExtendedTableInfo extTable;
            ExtendedFieldInfo extField = props.get(i).getExtendedField();
            if (extField == null || (extTable = extField.getExtendedTable()) == null || extField.getExtendedColumn() == null || exttb.contains(tableName = extTable.getName())) continue;
            exttb.add(tableName);
            ea = this.getEntityAccess(bo, tableName);
            ea.addFilter(bo, filter);
            ea.delete();
        }
        Map subObjs = this.getOne2OneCompositionSubObjs(bo, filterData);
        ea.deleteBySQL(bo);
        this.deleteOne2OneCompositionSubObj(subObjs);
    }

    private void deleteOne2OneCompositionSubObj(Map subObjs) throws DataAccessException, SQLException {
        for (Map.Entry entry : subObjs.entrySet()) {
            EntityObjectInfo bo = (EntityObjectInfo)entry.getKey();
            if (bo == null) continue;
            RTFilters filters = (RTFilters)((Object)entry.getValue());
            int n = filters.size();
            for (int i = 0; i < n; ++i) {
                this.delete(bo, (IObjectValue)filters.get(i));
            }
        }
    }

    private Map getOne2OneCompositionSubObjs(EntityObjectInfo bo, FilterInfo filterData) throws DataAccessException, SQLException {
        HashMap<EntityObjectInfo, RTFilters> subObjs = new HashMap<EntityObjectInfo, RTFilters>();
        PropertyCollection props = bo.getPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            LinkPropertyInfo linkProp;
            RelationshipInfo relation;
            PropertyInfo fld = props.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !CardinalityType.isOneORZero((CardinalityType)(relation = ImplUtils.getRTRelation(bo, linkProp = (LinkPropertyInfo)fld)).getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
            IObjectCollection objs = this.getCompositionLinkValue(bo, filterData, relation);
            RTFilters filterDatas = new RTFilters();
            int m = objs.size();
            for (int j = 0; j < m; ++j) {
                IObjectValue obj = (IObjectValue)objs.getObject(j).get(linkProp.getName());
                if (obj == null) continue;
                filterDatas.add(new RTFilter(obj));
            }
            subObjs.put(relation.getChildObject(bo), filterDatas);
        }
        return subObjs;
    }

    private IObjectCollection getCompositionLinkValue(EntityObjectInfo bo, FilterInfo filterData, RelationshipInfo relation) throws DataAccessException, SQLException {
        RTSelector selectors = new RTSelector();
        selectors.add(new RTSelectorItem(bo, relation.getParentProperty(bo).getName()));
        return new ObjectReader(this.ctx, this.cn, this.solution).select(bo, filterData, null, selectors);
    }

    private void recombineFilters(EntityObjectInfo bo, RTFilterParameters parentFilter, RelationshipInfo relation, EntityObjectInfo childbo, EntityAccess ea) {
        if (parentFilter != null && parentFilter.size() > 0) {
            PropertyInfo chdSideProp = relation.getChildProperty(childbo);
            PropertyInfo parentSideProp = relation.getParentProperty(childbo);
            int n = parentFilter.size();
            for (int i = 0; i < n; ++i) {
                RTFilterParameter filterInfo = parentFilter.get(i);
                String parentFullPropName = filterInfo.getFullFieldName();
                if (parentFullPropName.indexOf(46) < 0) {
                    PropertyInfo prop = bo.getInheritedPropertyByColName(filterInfo.getFieldName(), "_" + this.ctx.getLocale().toString());
                    FilterItemInfo itemInfo = new FilterItemInfo(parentSideProp.getName() + '.' + filterInfo.getFieldName(), filterInfo.getCompareValue(), filterInfo.getCompareType());
                    ea.addFilter(itemInfo, prop.getMappingField(), bo.isBOSUuidCol(prop));
                    continue;
                }
                if (parentFullPropName.substring(0, parentFullPropName.indexOf(46)).equalsIgnoreCase(parentSideProp.getName())) {
                    ea.addFilter(new FilterItemInfo(parentFullPropName.substring(parentFullPropName.indexOf(46)), filterInfo.getCompareValue(), filterInfo.getCompareType()), chdSideProp.getMappingField(), childbo.isBOSUuidCol(chdSideProp));
                    continue;
                }
                EntityObjectInfo boTemp = ObjectRemover.getEntityInfo(parentFullPropName, bo);
                PropertyInfo prop = boTemp.getInheritedPropertyByColName(parentFullPropName.substring(parentFullPropName.lastIndexOf(".") + 1), "_" + this.ctx.getLocale().toString());
                ea.addFilter(new FilterItemInfo(parentSideProp.getName() + '.' + parentFullPropName, filterInfo.getCompareValue(), filterInfo.getCompareType()), prop.getMappingField(), boTemp.isBOSUuidCol(prop));
            }
            ea.getFilterParameters().setFormat(parentFilter.getFormat());
        }
    }

    private static EntityObjectInfo getEntityInfo(String parentFullPropName, EntityObjectInfo bo) {
        EntityObjectInfo boTemp = bo;
        PropertyInfo prop = null;
        String[] names = StringUtils.fastSplit((String)parentFullPropName, (String)".");
        int n = names.length - 1;
        for (int m = 0; m < n; ++m) {
            prop = boTemp.getPropertyByNameRuntime(names[m]);
            if (!(prop instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(boTemp, (LinkPropertyInfo)prop);
            boTemp = relation.getChildObject(boTemp);
        }
        return boTemp;
    }

    private void deleteSubRecordsBySQL(EntityObjectInfo bo, LinkPropertyInfo fld, FilterInfo filterData, RTFilterParameters parentFilter) throws SQLException, DataAccessException {
        PropertyInfo chdfld;
        ExtendedFieldInfo extField;
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, fld);
        EntityObjectInfo childObject = relation.getChildObject(bo);
        PropertyCollection props = childObject.getInheritedPropertiesRuntime();
        EntityAccess ea = this.getEntityAccess(childObject, childObject.getTable().getName());
        this.recombineFilters(bo, parentFilter, relation, childObject, ea);
        int n = props.size();
        for (int i = 0; i < n && ((extField = (chdfld = props.get(i)).getExtendedField()) == null || extField.getExtendedTable() == null || extField.getExtendedColumn() == null); ++i) {
            RelationshipInfo chdRelation;
            if (!(chdfld instanceof LinkPropertyInfo) || !CardinalityType.isOneORZero((CardinalityType)(chdRelation = ImplUtils.getRTRelation(bo, fld)).getParentCardinality(bo)) || CardinalityType.isOneORZero((CardinalityType)chdRelation.getChildCardinality(bo)) || !chdRelation.getLinkType(childObject).equals((Object)RelationshipType.COMPOSITION)) continue;
            this.deleteSubRecordsBySQL(childObject, (LinkPropertyInfo)chdfld, filterData, ea.getFilterParameters());
        }
        Map subObjs = this.getOne2OneCompositionSubObjs(childObject, filterData);
        ea.deleteBySQL(childObject);
        this.deleteOne2OneCompositionSubObj(subObjs);
    }

    @Override
    public void delete(EntityObjectInfo bo, IObjectValue filterData) throws SQLException, DataAccessException {
        PropertyInfo fld;
        EntityAccess ea;
        int i;
        EntityObjectInfo basebo;
        ImplUtils.setBaseObjectPKData(bo, filterData);
        for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
        }
        if (basebo != null) {
            this.delete(basebo, filterData);
        }
        HashMap<String, Object> pkData = new HashMap<String, Object>();
        PropertyCollection keyFields = bo.getLogicalKeyPropertiesRuntime();
        int n = keyFields.size();
        for (int i2 = 0; i2 < n; ++i2) {
            PropertyInfo fld2 = keyFields.get(i2);
            String fieldName = fld2.getName();
            if (!filterData.containsKey(fieldName)) {
                throw new SQLException("MissingPKData:" + bo.getName() + " " + fld2.getName());
            }
            pkData.put(fieldName, filterData.get(fieldName));
        }
        PropertyCollection props = bo.getPropertiesRuntime();
        int n2 = props.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            PropertyInfo fld3 = props.get(i3);
            if (!(fld3 instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld3);
            if (CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo)) && !CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                if (!RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
                this.deleteSubRecords(bo, (LinkPropertyInfo)fld3, filterData);
                continue;
            }
            if (CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo)) || CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
            this.deleteSubCrossRecords(bo, (LinkPropertyInfo)fld3, filterData);
        }
        HashSet<String> deletedExtTables = new HashSet<String>();
        int n3 = props.size();
        for (i = 0; i < n3; ++i) {
            String tableName;
            ExtendedTableInfo extTable;
            PropertyInfo prop = props.get(i);
            ExtendedFieldInfo extField = prop.getExtendedField();
            if (extField == null || (extTable = extField.getExtendedTable()) == null || extField.getExtendedColumn() == null || deletedExtTables.contains(tableName = extTable.getName())) continue;
            ea = this.getEntityAccess(bo, tableName);
            PKColumnCollection pks = extTable.getPrimaryKey().getPKColumns();
            int m = pks.size();
            for (int j = 0; j < m; ++j) {
                PropertyInfo fld4 = keyFields.get(j);
                String fldName = fld4.getName();
                ea.addFilter(new FilterItemInfo(fldName, pkData.get(fldName)), pks.get(j).getColumn(), bo.isBOSUuidCol(fld4));
            }
            ea.delete();
            deletedExtTables.add(tableName);
        }
        ea = this.getEntityAccess(bo, bo.getTable().getName());
        n3 = keyFields.size();
        for (i = 0; i < n3; ++i) {
            fld = keyFields.get(i);
            String keyName = fld.getName();
            ColumnInfo col = fld.getMappingField();
            int size = props.size();
            for (int k = 0; k < size; ++k) {
                PropertyInfo prop = props.get(k);
                if (!prop.getName().equals(keyName)) continue;
                col = prop.getMappingField();
                break;
            }
            ea.addFilter(new FilterItemInfo(fld.getName(), pkData.get(fld.getName())), col, bo.isBOSUuidCol(fld));
        }
        ea.delete();
        n3 = props.size();
        for (i = 0; i < n3; ++i) {
            IObjectValue dataValue;
            RelationshipInfo relation;
            fld = props.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !CardinalityType.isOneORZero((CardinalityType)(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld)).getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo)) || (dataValue = (IObjectValue)filterData.get(fld.getName())) == null) continue;
            this.delete(relation.getChildObject(bo), (IObjectValue)new RTFilter(dataValue));
        }
    }

    private void deleteSubRecords(EntityObjectInfo bo, LinkPropertyInfo fld, IObjectValue filterData) throws SQLException, DataAccessException {
        block14: {
            ArrayList<PropertyInfo> valRefFlds;
            EntityObjectInfo childObject;
            RelationshipInfo rel;
            IObjectCollection childDatas;
            block13: {
                PropertyInfo chdfld;
                int i;
                childDatas = (IObjectCollection)filterData.get(fld.getName());
                boolean hasCollectionLink = false;
                boolean isIncludeCollectionLink = false;
                rel = ImplUtils.getRTRelation(bo, fld);
                childObject = rel.getChildObject(bo);
                valRefFlds = new ArrayList<PropertyInfo>();
                String parentFieldName = rel.getParentProperty(bo).getName();
                hasCollectionLink = filterData.get(parentFieldName) == null;
                PropertyCollection props = childObject.getInheritedPropertiesRuntime();
                int n = props.size();
                for (i = 0; i < n; ++i) {
                    RelationshipInfo relation;
                    chdfld = props.get(i);
                    if (!(chdfld instanceof LinkPropertyInfo) || !(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)chdfld)).getLinkType(bo).equals((Object)RelationshipType.COMPOSITION) || CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || isIncludeCollectionLink || !childObject.equals((Object)relation.getClientObject())) continue;
                    isIncludeCollectionLink = true;
                    break;
                }
                if (!hasCollectionLink) {
                    n = props.size();
                    for (i = 0; i < n; ++i) {
                        RelationshipInfo relation;
                        chdfld = props.get(i);
                        ExtendedFieldInfo extField = chdfld.getExtendedField();
                        if (extField != null && extField.getExtendedColumn() != null && extField.getExtendedColumn() != null) {
                            hasCollectionLink = true;
                            break;
                        }
                        if (!(chdfld instanceof LinkPropertyInfo) || !(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)chdfld)).getLinkType(bo).equals((Object)RelationshipType.COMPOSITION)) continue;
                        if (!CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                            hasCollectionLink = true;
                            break;
                        }
                        if (!CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) continue;
                        valRefFlds.add(chdfld);
                    }
                }
                if (!hasCollectionLink) break block13;
                if (childDatas == null || childDatas.size() == 0) {
                    RelationshipInfo relation = rel;
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo(relation.getChildProperty(bo).getName(), filterData.get(relation.getParentProperty(bo).getName())));
                    if (childObject.getTable() == null) {
                        throw new InvalidDAOMetaDataException((childObject.getName() == null ? childObject.toString() : childObject.getName()) + " not define table");
                    }
                    EntityAccess ea = this.getEntityAccess(childObject, childObject.getTable().getName());
                    if (filter != null) {
                        ea.addFilter(childObject, filter);
                    }
                    if (!isIncludeCollectionLink) {
                        ea.delete();
                    } else {
                        childDatas = new ObjectReader(this.ctx, this.cn, this.solution).innerSelect(childObject, null, RTSelectorBuilder.buildSelfPKSelector(this.ctx, childObject), ea, null, false);
                    }
                }
                if (childDatas == null) break block14;
                n = childDatas.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    this.delete(childObject, (IObjectValue)new RTFilter(childDatas.getObject(i2)));
                }
                break block14;
            }
            EntityAccess ea = this.getEntityAccess(childObject, childObject.getTable().getName());
            RelationshipInfo relation = rel;
            ea.addFilter(new FilterItemInfo(relation.getParentProperty(bo).getName(), filterData.get(relation.getParentProperty(bo).getName())), relation.getChildProperty(bo).getMappingField(), bo.isBOSUuidCol(relation.getChildProperty(bo)));
            ea.delete();
            if (valRefFlds.size() > 0 && childDatas == null) {
                EntityObjectInfo chdbo = relation.getChildObject(bo);
                EntityAccess eac = this.getEntityAccess(chdbo, chdbo.getTable().getName());
                eac.addFilter(new FilterItemInfo(relation.getParentProperty(bo).getName(), filterData.get(relation.getParentProperty(bo).getName())), relation.getChildProperty(bo).getMappingField(), bo.isBOSUuidCol(relation.getChildProperty(bo)));
                eac.setSelector(RTSelectorBuilder.buildSelfPKSelector(this.ctx, bo));
                childDatas = eac.select(relation.getChildObject(bo), false, null, false);
            }
            int n = valRefFlds.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue childData;
                IObjectValue dataValue;
                LinkPropertyInfo chdfld = (LinkPropertyInfo)valRefFlds.get(i);
                int j = 0;
                int m = childDatas.size();
                if (i >= m || (dataValue = (IObjectValue)(childData = childDatas.getObject(j)).get(chdfld.getName())) == null) continue;
                RelationshipInfo chdRelation = ImplUtils.getRTRelation(childObject, chdfld);
                this.delete(chdRelation.getChildObject(childObject), (IObjectValue)new RTFilter(dataValue));
            }
        }
    }

    private void deleteSubCrossRecords(EntityObjectInfo bo, LinkPropertyInfo fld, IObjectValue filterData) throws SQLException, DataAccessException {
        RelationshipInfo rel = ImplUtils.getRTRelation(bo, fld);
        EntityObjectInfo chdObject = rel.getChildObject(bo);
        CrossTableInfo crossTable = rel.getCrossTable();
        boolean mainref = ImplUtils.isMainObjRefCrossTable(bo, chdObject, fld, crossTable);
        EntityAccess ea = this.getEntityAccess(chdObject, crossTable.getName());
        IObjectValue keyData = filterData;
        boolean retrieve = false;
        KeyMapCollection keyMaps = mainref ? crossTable.getClientTableMap().getKeyMaps() : crossTable.getSupplierTableMap().getKeyMaps();
        int n = keyMaps.size();
        for (int i = 0; i < n; ++i) {
            KeyMapInfo keyMap = keyMaps.get(i);
            ColumnInfo refCol = keyMap.getRefColumn();
            PropertyInfo refProp = bo.getInheritedPropertyByColName(refCol.getName());
            if (!keyData.containsKey(refProp.getName())) {
                if (!retrieve) {
                    keyData = new ObjectReader(this.ctx, this.cn, this.solution).select(bo, ImplUtils.createFilter(filterData), null, null).getObject(0);
                } else {
                    throw new SQLException("Missing crosstable filter key data. Property name:" + refProp.getName());
                }
            }
            ea.addFilter(new FilterItemInfo(refProp.getName(), keyData.get(refProp.getName())), keyMap.getSelfColumn(), true);
        }
        ea.delete();
    }
}

