/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.WholeTableAffectedException;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.IObjectUpdater;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.ObjectCreator;
import com.kingdee.bos.dao.ormapping.impl.ObjectHandler;
import com.kingdee.bos.dao.ormapping.impl.ObjectRemover;
import com.kingdee.bos.dao.ormapping.impl.Operation;
import com.kingdee.bos.dao.ormapping.impl.RTFilter;
import com.kingdee.bos.dao.ormapping.impl.SubObjectOperations;
import com.kingdee.bos.framework.agent.AgentException;
import com.kingdee.bos.framework.agent.AgentManager;
import com.kingdee.bos.framework.agent.AgentState;
import com.kingdee.bos.framework.agent.DynamicCollectionAgentManager;
import com.kingdee.bos.framework.agent.IObjectCollectionAgent;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.KeyMapCollection;
import com.kingdee.bos.metadata.data.KeyMapInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.rule.formula.FormulaExecuteException;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ObjectUpdater
extends ObjectHandler
implements IObjectUpdater {
    private static Logger logger = Logger.getLogger(ORMappingDAO.class);

    ObjectUpdater(Context ctx, Connection cn, SolutionInfo solution) {
        super(ctx, cn, solution);
    }

    private void updateExtendedField(EntityObjectInfo bo, IObjectValue saveData, EntityAccess extea, ExtendedFieldInfo extfld, Map extEAs) {
        if (extfld != null && extea != null) {
            PropertyCollection keys = bo.getLogicalKeyPropertiesRuntime();
            int keySize = keys.size();
            for (int j = 0; j < keySize; ++j) {
                ColumnInfo keycol = keys.get(j).getMappingField();
                extea.addFilter(new FilterItemInfo(keycol.getName(), saveData.get(keys.get(j).getName())), keycol, bo.isBOSUuidCol(keys.get(j)));
            }
        }
    }

    private void updateData(EntityAccess ea, PropertyInfo fld, ColumnInfo col, EntityObjectInfo bo, IObjectValue saveData, Object dataValue) throws InvalidDAOMetaDataException, SQLException {
        if (col != null) {
            String fldName = fld.getName();
            if (bo.isLogicalKey(fld)) {
                ea.addFilter(new FilterItemInfo(fldName, dataValue), fld.getMappingField(), bo.isBOSUuidCol(fld));
            } else if (col.isMultilingual()) {
                LanguageCollection langs = this.solution.getLanguages();
                int n = langs.size();
                for (int i = 0; i < n; ++i) {
                    LanguageInfo lang = langs.get(i);
                    String localedName = ObjectUpdater.localedName(fldName, lang);
                    if (!saveData.containsKey(localedName)) continue;
                    Object val = saveData.get(localedName);
                    this.checkConstriant(fld, val);
                    ea.addParameter(col.getName(), ObjectUpdater.addUnicodeTag(val, col), col.getSQLType(), lang.getPostfix());
                }
            } else {
                this.checkConstriant(fld, dataValue);
                ea.addParameter(col.getName(), dataValue, col.getSQLType());
            }
        }
    }

    private void updateExtendData(PropertyInfo fld, ColumnInfo col, IObjectValue saveData, Object dataValue, EntityAccess extea, ExtendedFieldInfo extfld) throws SQLException {
        ColumnInfo extcol = extfld.getExtendedColumn();
        if (extcol.isMultilingual()) {
            LanguageCollection langs = this.solution.getLanguages();
            int n = langs.size();
            for (int i = 0; i < n; ++i) {
                LanguageInfo lang = langs.get(i);
                String localedName = ObjectUpdater.localedName(fld.getName(), lang);
                if (!saveData.containsKey(localedName)) continue;
                Object val = saveData.get(localedName);
                this.checkConstriant(fld, val);
                extea.addParameter(extcol.getName(), ObjectUpdater.addUnicodeTag(val, col), extcol.getSQLType(), lang.getPostfix());
            }
        } else {
            this.checkConstriant(fld, dataValue);
            extea.addParameter(extcol.getName(), dataValue, extcol.getSQLType());
        }
    }

    public void updateBigObject(EntityObjectInfo bo, IObjectValue saveData, IObjectValue oldData) throws DataAccessException, InvalidDAOMetaDataException, FormulaExecuteException, SQLException {
        saveData = ImplUtils.cloneIObjectValue(bo, saveData);
        EntityAccess ea = this.getEntityAccess(bo, bo.getTable().getName());
        PropertyCollection flds = bo.getPropertiesRuntime();
        HashMap extEAs = new HashMap();
        ArrayList subObjOpts = new ArrayList();
        ArrayList<PropertyInfo> compositeFields = new ArrayList<PropertyInfo>();
        int fldSize = flds.size();
        for (int i = 0; i < fldSize; ++i) {
            PropertyInfo fld = flds.get(i);
            String fldName = fld.getName();
            ColumnInfo col = MetaDataUtils.getColumnInfoByPropFromEntity((EntityObjectInfo)bo, (PropertyInfo)fld);
            this.calculateFormula(fld, col, bo, saveData);
            EntityAccess extEA = null;
            ExtendedFieldInfo extfld = fld.getExtendedField();
            this.updateExtendedField(bo, saveData, extEA, extfld, extEAs);
            if (saveData.containsKey(fldName) || col != null && col.isMultilingual()) {
                Object dataValue = saveData.get(fldName);
                Object oldValue = oldData.get(fldName);
                if (fld instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
                    this.processLogicalKey(bo, ea, fld, dataValue, relation);
                    if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                        this.updateOneORZeroLnkObject(bo, oldData, ea, subObjOpts, fld, col, extEA, extfld, dataValue, oldValue, relation, true);
                        continue;
                    }
                    if (!RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
                    compositeFields.add(fld);
                    continue;
                }
                if (fld.getMappingField() != null) {
                    this.updateData(ea, fld, col, bo, saveData, dataValue);
                    continue;
                }
                if (extfld == null || extfld.getExtendedColumn() == null) continue;
                this.updateExtendData(fld, col, saveData, dataValue, extEA, extfld);
                continue;
            }
            if (col == null || !bo.isLogicalKey(fld)) continue;
            throw new SQLException("Missing PKData: " + bo.getName() + " " + fldName);
        }
        ea.update();
        this.updateSubObject(subObjOpts);
        this.updateCompositeField(bo, saveData, oldData, compositeFields, true);
        this.updateExtend(extEAs);
        this.updateParentObject(bo, saveData, oldData);
    }

    private void updateOneORZeroLnkObject(EntityObjectInfo bo, IObjectValue oldData, EntityAccess ea, ArrayList subObjOpts, PropertyInfo fld, ColumnInfo col, EntityAccess extea, ExtendedFieldInfo extfld, Object dataValue, Object oldValue, RelationshipInfo relation, boolean isBigObject) throws InvalidDAOMetaDataException, FormulaExecuteException, SQLException, DataAccessException {
        if (RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) {
            if (oldData.get(fld.getName()) == null && dataValue != null) {
                new ObjectCreator(this.ctx, this.cn, this.solution).create(relation.getChildObject(bo), (IObjectValue)dataValue);
            } else if (oldData.get(fld.getName()) != null && dataValue == null) {
                SubObjectOperations subObjOpt = new SubObjectOperations();
                subObjOpt.setEntityObject(relation.getChildObject(bo));
                subObjOpt.setObjectValue((IObjectValue)oldData.get(fld.getName()));
                subObjOpt.setOperation(Operation.DELETE);
                subObjOpts.add(subObjOpt);
            } else if (oldData.get(fld.getName()) != null && dataValue != null) {
                if (ImplUtils.isLogicalKeyChanged(relation.getChildObject(bo), (IObjectValue)oldData.get(fld.getName()), (IObjectValue)dataValue)) {
                    SubObjectOperations subObjOpt = new SubObjectOperations();
                    subObjOpt.setEntityObject(relation.getChildObject(bo));
                    subObjOpt.setObjectValue((IObjectValue)oldData.get(fld.getName()));
                    subObjOpt.setOperation(Operation.DELETE);
                    subObjOpts.add(subObjOpt);
                    new ObjectCreator(this.ctx, this.cn, this.solution).create(relation.getChildObject(bo), (IObjectValue)dataValue);
                } else if (isBigObject) {
                    this.updateBigObject(relation.getChildObject(bo), (IObjectValue)dataValue, (IObjectValue)oldValue);
                } else {
                    this.update(relation.getChildObject(bo), (IObjectValue)dataValue, (IObjectValue)oldValue);
                }
            }
        }
        if (dataValue != null) {
            dataValue = ((IObjectValue)dataValue).get(relation.getChildProperty(bo).getName());
        }
        if (extfld != null) {
            extea.addParameter(extfld.getExtendedColumn().getName(), dataValue, extfld.getExtendedColumn().getSQLType());
        } else if (col != null) {
            ea.addParameter(col.getName(), dataValue, col.getSQLType());
        }
    }

    private void processLogicalKey(EntityObjectInfo bo, EntityAccess ea, PropertyInfo fld, Object dataValue, RelationshipInfo relation) throws InvalidDAOMetaDataException {
        if (dataValue != null && fld.getMappingField() != null && bo.isLogicalKey(fld)) {
            Object temp = ((IObjectValue)dataValue).get(relation.getSupplierObject().getLogicalKeyPropertiesRuntime().get(0).getName());
            ea.addFilter(new FilterItemInfo(fld.getName(), temp), fld.getMappingField(), bo.isBOSUuidCol(fld));
        }
    }

    private void updateOneORZeroLnkObject(EntityObjectInfo bo, EntityAccess ea, ColumnInfo col, EntityAccess extea, ExtendedFieldInfo extfld, Object dataValue, RelationshipInfo relation, String itemName) throws InvalidDAOMetaDataException, FormulaExecuteException, SQLException, DataAccessException {
        if (RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo(itemName));
            this.updatePartial(relation.getChildObject(bo), (IObjectValue)dataValue, selector);
        }
        if (dataValue != null) {
            dataValue = ((IObjectValue)dataValue).get(relation.getChildProperty(bo).getName());
        }
        if (extfld != null) {
            extea.addParameter(extfld.getExtendedColumn().getName(), dataValue, extfld.getExtendedColumn().getSQLType());
        } else {
            ea.addParameter(col.getName(), dataValue, col.getSQLType());
        }
    }

    private static String getFirstName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        int pos = fullName.indexOf(46);
        if (pos > 0) {
            return fullName.substring(0, pos);
        }
        return fullName;
    }

    private static String getSurplusName(String fullName) {
        if (StringUtils.isEmpty((String)fullName)) {
            return "";
        }
        int pos = fullName.indexOf(46);
        if (pos > 0) {
            return fullName.substring(pos + 1);
        }
        return fullName;
    }

    private void updateParentObject(EntityObjectInfo bo, IObjectValue saveData, SelectorItemCollection selector) throws InvalidDAOMetaDataException, DataAccessException, FormulaExecuteException, SQLException {
        EntityObjectInfo basebo;
        for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
        }
        if (basebo != null) {
            this.updatePartial(basebo, saveData, selector);
        }
    }

    private static void addLogicalKeyInSelector(EntityObjectInfo bo, SelectorItemCollection selector) {
        PropertyCollection keyProps = bo.getLogicalKeyPropertiesRuntime();
        int n = keyProps.size();
        for (int i = 0; i < n; ++i) {
            String keyField = keyProps.get(i).getName();
            SelectorItemInfo item = new SelectorItemInfo(keyField);
            boolean bHas = false;
            int m = selector.size();
            for (int j = 0; j < m; ++j) {
                if (!selector.get(j).getPropertyName().equals(item.getPropertyName())) continue;
                bHas = true;
                break;
            }
            if (bHas) continue;
            selector.add(item);
        }
    }

    @Override
    public void updatePartial(EntityObjectInfo bo, IObjectValue saveData, SelectorItemCollection selector) throws DataAccessException, InvalidDAOMetaDataException, FormulaExecuteException, SQLException {
        if (selector == null || selector.size() == 0) {
            return;
        }
        EntityAccess ea = this.getEntityAccess(bo, bo.getTable().getName());
        ObjectUpdater.addLogicalKeyInSelector(bo, selector);
        HashMap exteas = new HashMap();
        ArrayList<PropertyInfo> compositeFields = new ArrayList<PropertyInfo>();
        HashMap compositeUpdateFields = new HashMap();
        int fldSize = selector.size();
        for (int i = 0; i < fldSize; ++i) {
            SelectorItemInfo item = selector.get(i);
            String itemName = item.getPropertyName();
            PropertyInfo fld = bo.getPropertyByNameRuntime(ObjectUpdater.getFirstName(itemName));
            if (fld == null) continue;
            String fldName = fld.getName();
            ColumnInfo col = MetaDataUtils.getColumnInfoByPropFromEntity((EntityObjectInfo)bo, (PropertyInfo)fld);
            this.calculateFormula(fld, col, bo, saveData);
            EntityAccess extea = null;
            ExtendedFieldInfo extfld = fld.getExtendedField();
            this.updateExtendedField(bo, saveData, extea, extfld, exteas);
            if (saveData.containsKey(fldName) || col != null && col.isMultilingual()) {
                Object dataValue = saveData.get(fldName);
                if (fld instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
                    this.processLogicalKey(bo, ea, fld, dataValue, relation);
                    if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                        this.updateOneORZeroLnkObject(bo, ea, col, extea, extfld, dataValue, relation, ObjectUpdater.getSurplusName(itemName));
                        continue;
                    }
                    if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
                    compositeFields.add(fld);
                    String cn = ObjectUpdater.getSurplusName(itemName);
                    if (cn.equals(itemName)) continue;
                    if (!compositeUpdateFields.containsKey(fld.getName())) {
                        compositeUpdateFields.put(fld.getName(), new ArrayList());
                    }
                    ((ArrayList)compositeUpdateFields.get(fld.getName())).add(cn);
                    continue;
                }
                if (fld.getMappingField() != null) {
                    this.updateData(ea, fld, col, bo, saveData, dataValue);
                    continue;
                }
                if (extfld == null || extfld.getExtendedColumn() == null) continue;
                this.updateExtendData(fld, col, saveData, dataValue, extea, extfld);
                continue;
            }
            if (col == null || !bo.isLogicalKey(fld)) continue;
            throw new SQLException("Missing PKData: " + bo.getName() + " " + fldName);
        }
        ea.update();
        this.updateExtend(exteas);
        this.updateCompositeFieldPartial(bo, saveData, compositeFields, compositeUpdateFields, false);
        this.updateParentObject(bo, saveData, selector);
    }

    private void updateCompositeFieldPartial(EntityObjectInfo bo, IObjectValue saveData, ArrayList compositeFields, Map compositeUpdateFields, boolean isBigObject) throws SQLException, DataAccessException, InvalidDAOMetaDataException, FormulaExecuteException {
        int n = compositeFields.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo fld = (PropertyInfo)compositeFields.get(i);
            String fldName = fld.getName();
            Object dataValue = saveData.get(fldName);
            ArrayList al = (ArrayList)compositeUpdateFields.get(fldName);
            SelectorItemCollection selector = new SelectorItemCollection();
            int len = al.size();
            for (int j = 0; j < len; ++j) {
                SelectorItemInfo item = new SelectorItemInfo((String)al.get(j));
                selector.add(item);
            }
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
            if (dataValue == null) continue;
            EntityObjectInfo childObject = relation.getChildObject(bo);
            IObjectCollection savecol = (IObjectCollection)dataValue;
            if (!CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo))) continue;
            for (int k = 0; k < savecol.size(); ++k) {
                try {
                    this.updatePartial(childObject, savecol.getObject(k), selector);
                    continue;
                }
                catch (Exception ex) {
                    logger.warn((Object)("ignored! update composite field error! because: " + ex.getMessage()));
                }
            }
        }
    }

    @Override
    public void update(EntityObjectInfo bo, IObjectValue saveData, IObjectValue oldData) throws DataAccessException, InvalidDAOMetaDataException, FormulaExecuteException, SQLException {
        saveData = ImplUtils.cloneIObjectValue(bo, saveData);
        EntityAccess ea = this.getEntityAccess(bo, bo.getTable().getName());
        PropertyCollection flds = bo.getPropertiesRuntime();
        HashMap<String, EntityAccess> exteas = new HashMap<String, EntityAccess>();
        ArrayList subObjOpts = new ArrayList();
        ArrayList<PropertyInfo> compositeFields = new ArrayList<PropertyInfo>();
        int fldSize = flds.size();
        for (int i = 0; i < fldSize; ++i) {
            PropertyInfo fld = flds.get(i);
            String fldName = fld.getName();
            ColumnInfo col = MetaDataUtils.getColumnInfoByPropFromEntity((EntityObjectInfo)bo, (PropertyInfo)fld);
            this.calculateFormula(fld, col, bo, saveData);
            EntityAccess extea = null;
            ExtendedFieldInfo extfld = fld.getExtendedField();
            if (extfld != null) {
                String tableName = extfld.getExtendedTable().getName();
                if (!exteas.containsKey(tableName)) {
                    extea = this.getEntityAccess(bo, tableName);
                    exteas.put(tableName, extea);
                } else {
                    extea = (EntityAccess)exteas.get(tableName);
                }
            }
            this.updateExtendedField(bo, saveData, extea, extfld, exteas);
            if (saveData.containsKey(fldName) || col != null && col.isMultilingual()) {
                Object dataValue = saveData.get(fldName);
                Object oldValue = oldData.get(fldName);
                if (fld instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
                    this.processLogicalKey(bo, ea, fld, dataValue, relation);
                    if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                        this.updateOneORZeroLnkObject(bo, oldData, ea, subObjOpts, fld, col, extea, extfld, dataValue, oldValue, relation, false);
                        continue;
                    }
                    if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
                    compositeFields.add(fld);
                    continue;
                }
                if (fld.getMappingField() != null) {
                    this.updateData(ea, fld, col, bo, saveData, dataValue);
                    continue;
                }
                if (extfld == null || extfld.getExtendedColumn() == null) continue;
                this.updateExtendData(fld, col, saveData, dataValue, extea, extfld);
                continue;
            }
            if (col == null || !bo.isLogicalKey(fld)) continue;
            throw new SQLException("Missing PKData: " + bo.getName() + " " + fldName);
        }
        ea.update();
        this.updateSubObject(subObjOpts);
        this.updateCompositeField(bo, saveData, oldData, compositeFields, false);
        this.updateExtend(exteas);
        this.updateParentObject(bo, saveData, oldData);
    }

    private void updateCompositeField(EntityObjectInfo bo, IObjectValue saveData, IObjectValue oldData, ArrayList compositeFields, boolean isBigObject) throws SQLException, DataAccessException, InvalidDAOMetaDataException, FormulaExecuteException {
        int n = compositeFields.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo fld = (PropertyInfo)compositeFields.get(i);
            String fldName = fld.getName();
            Object dataValue = saveData.get(fldName);
            Object oldValue = oldData.get(fldName);
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
            if (dataValue == null) continue;
            EntityObjectInfo childObject = relation.getChildObject(bo);
            IObjectCollection savecol = (IObjectCollection)dataValue;
            IObjectCollection oldcol = (IObjectCollection)oldValue;
            IObjectCollection deletedCol = Utils.newObjectCollectionInstance(childObject);
            IObjectCollection addedCol = Utils.newObjectCollectionInstance(childObject);
            IObjectCollection modifiedCol = Utils.newObjectCollectionInstance(childObject);
            IObjectCollection modifiedMappingOldCol = Utils.newObjectCollectionInstance(childObject);
            if (isBigObject) {
                this.getStateCollectionByObjectValue(savecol, oldcol, childObject, deletedCol, addedCol, modifiedCol, modifiedMappingOldCol);
            } else {
                this.getStateCollection(savecol, oldcol, childObject, deletedCol, addedCol, modifiedCol, modifiedMappingOldCol);
            }
            this.updateOneORUnbountLnkObject(bo, saveData, oldData, fld, relation, childObject, savecol, deletedCol, addedCol, modifiedCol, modifiedMappingOldCol, isBigObject);
        }
    }

    private void updateOneORUnbountLnkObject(EntityObjectInfo bo, IObjectValue saveData, IObjectValue oldData, PropertyInfo fld, RelationshipInfo relation, EntityObjectInfo childObject, IObjectCollection savecol, IObjectCollection deletedCol, IObjectCollection addedCol, IObjectCollection modifiedCol, IObjectCollection modifiedMappingOldCol, boolean isBigObject) throws SQLException, DataAccessException, InvalidDAOMetaDataException, FormulaExecuteException {
        if (CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo))) {
            this.deleteSubCollection(bo, (LinkPropertyInfo)fld, deletedCol);
            for (int k = 0; k < modifiedCol.size(); ++k) {
                String chdPropName = relation.getChildProperty(bo).getName();
                if (chdPropName == null) {
                    throw new InvalidDAOMetaDataException("cannot get link property at InnerBusinessObjectDAO.update()");
                }
                IObjectValue tempNewValue = modifiedCol.getObject(k);
                tempNewValue.remove(chdPropName);
                if (isBigObject) {
                    this.updateBigObject(relation.getChildObject(bo), tempNewValue, modifiedMappingOldCol.getObject(k));
                    continue;
                }
                this.update(relation.getChildObject(bo), tempNewValue, modifiedMappingOldCol.getObject(k));
            }
            if (addedCol != null && addedCol.size() > 0) {
                new ObjectCreator(this.ctx, this.cn, this.solution).createSubRecords(bo, (LinkPropertyInfo)fld, addedCol, saveData);
            }
        } else if (!CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo))) {
            this.deleteSubCrossCollection(bo, (LinkPropertyInfo)fld, deletedCol, oldData);
            if (addedCol != null && addedCol.size() > 0) {
                new ObjectCreator(this.ctx, this.cn, this.solution).createSubCrossRecords(bo, (LinkPropertyInfo)fld, addedCol, saveData);
            }
        }
    }

    private void updateParentObject(EntityObjectInfo bo, IObjectValue saveData, IObjectValue oldData) throws InvalidDAOMetaDataException, DataAccessException, FormulaExecuteException, SQLException {
        EntityObjectInfo basebo;
        for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
        }
        if (basebo != null) {
            this.update(basebo, saveData, oldData);
        }
    }

    private void updateExtend(Map exteas) throws WholeTableAffectedException, SQLException {
        for (EntityAccess extea : exteas.values()) {
            extea.update();
        }
    }

    private void updateSubObject(ArrayList subObjOpts) throws DataAccessException, SQLException {
        int subObjOptSize = subObjOpts.size();
        for (int i = 0; i < subObjOptSize; ++i) {
            SubObjectOperations subObjOpt = (SubObjectOperations)((Object)subObjOpts.get(i));
            if (!subObjOpt.getOperation().equals((Object)Operation.DELETE)) continue;
            new ObjectRemover(this.ctx, this.cn, this.solution).delete(subObjOpt.getEntityObject(), (IObjectValue)new RTFilter(subObjOpt.getObjectValue()));
        }
    }

    private void getStateCollectionByObjectValue(IObjectCollection saveData, IObjectCollection oldData, EntityObjectInfo childObject, IObjectCollection deletedCollection, IObjectCollection addedCollection, IObjectCollection modifiedCollection, IObjectCollection modifiedMappingOldCollection) {
        IObjectCollectionAgent collAgent = DynamicCollectionAgentManager.getAgent(saveData);
        try {
            Iterator it = collAgent.getDeletedOVSet().iterator();
            IObjectValue ov = null;
            while (it.hasNext()) {
                ov = Utils.newObjectValueInstance(childObject);
                ov.put(ov.getPKField(), it.next());
                deletedCollection.addObject(ov);
            }
            IObjectValueAgent agent = null;
            int len = saveData.size();
            for (int i = 0; i < len; ++i) {
                int seq;
                agent = (IObjectValueAgent)saveData.getObject(i);
                IObjectValue target = agent.getTarget();
                String seqPropName = null;
                if (childObject.getSequenceProperty() != null) {
                    seqPropName = childObject.getSequenceProperty().getName();
                }
                if (AgentState.MODIFIED.equals((Object)agent.getAgentState())) {
                    if (seqPropName != null) {
                        seq = 0;
                        if (target.get(seqPropName) != null) {
                            seq = (Integer)target.get(seqPropName);
                        }
                        if (seq != i + 1) {
                            target.put(seqPropName, (Object)(i + 1));
                        }
                    }
                    modifiedCollection.addObject(target);
                    modifiedMappingOldCollection.addObject(oldData.getObject((Object)((ObjectUuidPK)AgentManager.getObjectPK(agent)).getKeyValue()));
                    continue;
                }
                if (AgentState.NEW.equals((Object)agent.getAgentState())) {
                    if (seqPropName != null) {
                        target.put(seqPropName, (Object)(i + 1));
                    }
                    addedCollection.addObject(target);
                    continue;
                }
                if (seqPropName == null) continue;
                seq = 0;
                if (target.get(seqPropName) != null) {
                    seq = (Integer)target.get(seqPropName);
                }
                if (seq == i + 1) continue;
                target.put(seqPropName, (Object)(i + 1));
                modifiedCollection.addObject(target);
                modifiedMappingOldCollection.addObject(oldData.getObject((Object)((ObjectUuidPK)AgentManager.getObjectPK(agent)).getKeyValue()));
            }
        }
        catch (Exception e) {
            throw new AgentException(e);
        }
    }

    private void getStateCollection(IObjectCollection saveData, IObjectCollection oldData, EntityObjectInfo bo, IObjectCollection deletedCollection, IObjectCollection addedCollection, IObjectCollection modifiedCollection, IObjectCollection modifiedMappingOldCollection) {
        int i;
        if (oldData == null) {
            try {
                oldData = (IObjectCollection)saveData.getClass().newInstance();
            }
            catch (Exception ex) {
                logger.info((Object)("oldData is null ! create " + saveData.getClass() + " instance error!"));
                throw new IllegalArgumentException("oldData is null ! create " + saveData.getClass() + " instance error!");
            }
        }
        PropertyCollection keyProperties = bo.getLogicalKeyPropertiesRuntime();
        int oldDataSize = oldData.size();
        for (i = 0; i < oldDataSize; ++i) {
            IObjectValue oldValue = oldData.getObject(i);
            boolean find = false;
            int saveDataSize = saveData.size();
            for (int j = 0; j < saveDataSize; ++j) {
                IObjectValue saveValue = saveData.getObject(j);
                boolean keyDiff = false;
                int keySize = keyProperties.size();
                for (int k = 0; k < keySize; ++k) {
                    PropertyInfo keyprop = keyProperties.get(k);
                    Object dbPK = oldValue.get(keyprop.getName());
                    Object voPK = saveValue.get(keyprop.getName());
                    if (!(dbPK == null && voPK != null || dbPK != null && voPK == null) && (dbPK == null || voPK == null || dbPK.toString().equals(voPK.toString()))) continue;
                    keyDiff = true;
                    break;
                }
                if (keyDiff) continue;
                find = true;
                break;
            }
            if (find) continue;
            deletedCollection.addObject(oldValue);
        }
        int saveDataSize = saveData.size();
        for (i = 0; i < saveDataSize; ++i) {
            IObjectValue saveValue = saveData.getObject(i);
            IObjectValue oldValue = null;
            boolean find = false;
            String seqPropName = null;
            if (bo.getSequenceProperty() != null) {
                seqPropName = bo.getSequenceProperty().getName();
            }
            if (seqPropName != null) {
                saveValue.put(seqPropName, (Object)(i + 1));
            }
            int oldDataSize2 = oldData.size();
            for (int j = 0; j < oldDataSize2; ++j) {
                oldValue = oldData.getObject(j);
                boolean keyDiff = false;
                int keySize = keyProperties.size();
                for (int k = 0; k < keySize; ++k) {
                    PropertyInfo keyprop = keyProperties.get(k);
                    Object dbPK = oldValue.get(keyprop.getName());
                    Object voPK = saveValue.get(keyprop.getName());
                    if (!(dbPK == null && voPK != null || dbPK != null && voPK == null) && (dbPK == null || voPK == null || dbPK.toString().equals(voPK.toString()))) continue;
                    keyDiff = true;
                    break;
                }
                if (keyDiff) continue;
                find = true;
                break;
            }
            if (!find) {
                addedCollection.addObject(saveValue);
                continue;
            }
            modifiedCollection.addObject(saveValue);
            modifiedMappingOldCollection.addObject(oldValue);
        }
    }

    private void deleteSubCollection(EntityObjectInfo bo, LinkPropertyInfo fld, IObjectCollection filterDatas) throws SQLException, DataAccessException {
        int i;
        if (filterDatas == null || filterDatas.size() == 0) {
            return;
        }
        EntityObjectInfo childObject = ImplUtils.getRTRelation(bo, fld).getChildObject(bo);
        boolean hasCollectionLink = false;
        ArrayList<PropertyInfo> valRefFlds = new ArrayList<PropertyInfo>();
        PropertyCollection props = childObject.getInheritedPropertiesRuntime();
        int n = props.size();
        for (i = 0; i < n; ++i) {
            RelationshipInfo relation;
            PropertyInfo chdfld = props.get(i);
            ExtendedFieldInfo extField = chdfld.getExtendedField();
            if (extField != null && extField.getExtendedTable() != null && extField.getExtendedColumn() != null) {
                hasCollectionLink = true;
                break;
            }
            if (!(chdfld instanceof LinkPropertyInfo) || !(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)chdfld)).getLinkType(bo).equals((Object)RelationshipType.COMPOSITION)) continue;
            if (!CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                hasCollectionLink = true;
                break;
            }
            valRefFlds.add(chdfld);
        }
        if (hasCollectionLink) {
            n = filterDatas.size();
            for (i = 0; i < n; ++i) {
                new ObjectRemover(this.ctx, this.cn, this.solution).delete(childObject, (IObjectValue)new RTFilter(filterDatas.getObject(i)));
            }
        } else {
            int i2;
            EntityAccess ea = this.getEntityAccess(childObject, childObject.getTable().getName());
            PropertyCollection keyFields = childObject.getLogicalKeyPropertiesRuntime();
            int count = 1;
            int n2 = filterDatas.size();
            for (i2 = 0; i2 < n2; ++i2) {
                IObjectValue filterData = filterDatas.getObject(i2);
                String format = null;
                int m = keyFields.size();
                for (int j = 0; j < m; ++j) {
                    PropertyInfo chdfld = keyFields.get(j);
                    String fieldName = chdfld.getName();
                    if (!filterData.containsKey(fieldName)) {
                        throw new SQLException("MissingPKData:" + childObject.getName() + " " + fld.getName());
                    }
                    format = format == null ? "(#" + count : format + " and #" + count;
                    ea.addFilter(new FilterItemInfo(chdfld.getName(), filterData.get(fieldName)), chdfld.getMappingField(), childObject.isBOSUuidCol(chdfld));
                    ++count;
                }
                format = format + ")";
                ea.setFilterFormat(ea.getFilterFormat() + format + " or ");
            }
            ea.setFilterFormat(ea.getFilterFormat().substring(0, ea.getFilterFormat().length() - 4));
            ea.delete();
            n2 = valRefFlds.size();
            for (i2 = 0; i2 < n2; ++i2) {
                LinkPropertyInfo chdfld;
                IObjectValue filterData;
                IObjectValue dataValue;
                int j = 0;
                int m = filterDatas.size();
                if (j >= m || (dataValue = (IObjectValue)(filterData = filterDatas.getObject(j)).get((chdfld = (LinkPropertyInfo)valRefFlds.get(i2)).getName())) == null) continue;
                RelationshipInfo relation = ImplUtils.getRTRelation(bo, chdfld);
                new ObjectRemover(this.ctx, this.cn, this.solution).delete(relation.getChildObject(childObject), (IObjectValue)new RTFilter(dataValue));
            }
        }
    }

    private void deleteSubCrossCollection(EntityObjectInfo bo, LinkPropertyInfo fld, IObjectCollection childDatas, IObjectValue parentData) throws SQLException, DataAccessException {
        CrossTableInfo crossTable;
        if (childDatas.size() == 0) {
            return;
        }
        RelationshipInfo relation = ImplUtils.getRTRelation(bo, fld);
        EntityObjectInfo chidObject = relation.getChildObject(bo);
        boolean mainref = ImplUtils.isMainObjRefCrossTable(bo, chidObject, fld, crossTable = relation.getCrossTable());
        if (mainref) {
            int m = childDatas.size();
            for (int i = 0; i < m; ++i) {
                PropertyInfo refProp;
                ColumnInfo refCol;
                KeyMapInfo keyMap;
                int j;
                EntityAccess ea = this.getEntityAccess(bo, crossTable.getName());
                IObjectValue childData = childDatas.getObject(i);
                KeyMapCollection keyMaps = crossTable.getClientTableMap().getKeyMaps();
                int n = keyMaps.size();
                for (j = 0; j < n; ++j) {
                    keyMap = keyMaps.get(j);
                    refCol = keyMap.getRefColumn();
                    refProp = bo.getInheritedPropertyByColName(refCol.getName());
                    ea.addFilter(new FilterItemInfo(refProp.getName(), parentData.get(refProp.getName())), keyMap.getSelfColumn(), true);
                }
                keyMaps = crossTable.getSupplierTableMap().getKeyMaps();
                n = keyMaps.size();
                for (j = 0; j < n; ++j) {
                    keyMap = keyMaps.get(j);
                    refCol = keyMap.getRefColumn();
                    refProp = chidObject.getInheritedPropertyByColName(refCol.getName());
                    ea.addFilter(new FilterItemInfo(refProp.getName(), childData.get(refProp.getName())), keyMap.getSelfColumn(), true);
                }
                ea.delete();
            }
        } else {
            int m = childDatas.size();
            for (int i = 0; i < m; ++i) {
                PropertyInfo refProp;
                ColumnInfo refCol;
                KeyMapInfo keyMap;
                int j;
                EntityAccess ea = this.getEntityAccess(bo, crossTable.getName());
                IObjectValue childData = childDatas.getObject(i);
                KeyMapCollection keyMaps = crossTable.getClientTableMap().getKeyMaps();
                int n = keyMaps.size();
                for (j = 0; j < n; ++j) {
                    keyMap = keyMaps.get(j);
                    refCol = keyMap.getRefColumn();
                    refProp = chidObject.getInheritedPropertyByColName(refCol.getName());
                    ea.addFilter(new FilterItemInfo(refProp.getName(), childData.get(refProp.getName())), keyMap.getSelfColumn(), true);
                }
                keyMaps = crossTable.getSupplierTableMap().getKeyMaps();
                n = keyMaps.size();
                for (j = 0; j < n; ++j) {
                    keyMap = keyMaps.get(j);
                    refCol = keyMap.getRefColumn();
                    refProp = bo.getInheritedPropertyByColName(refCol.getName());
                    ea.addFilter(new FilterItemInfo(refProp.getName(), parentData.get(refProp.getName())), keyMap.getSelfColumn(), true);
                }
                ea.delete();
            }
        }
    }
}

