/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.impl.EntityAccess;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.SQLGeneratorCache;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.util.BOSObjectType;
import java.sql.SQLException;
import java.util.Map;

public class QueryFilterUtils {
    public static void processEntryFilter(BOSObjectType bosType, EntityViewInfo view, Context ctx) throws SQLException, BOSException {
        EntityObjectInfo bo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
        QueryFilterUtils.processEntryFilter(bo, view, ctx);
    }

    public static void processEntryFilter(EntityObjectInfo bo, EntityViewInfo view, Context ctx) throws SQLException, BOSException {
        SolutionInfo solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        QueryFilterUtils.processEntryFilter(bo, view, ctx, solution);
    }

    private static void processEntryFilter(EntityObjectInfo bo, EntityViewInfo view, Context ctx, SolutionInfo solution) throws SQLException, BOSException {
        int n = view.getEntryFilters().size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo prop;
            FilterInfo entryFilter = view.getEntryFilters().get(i);
            EntryFilterType type = entryFilter.getEntryFilterType();
            FilterItemCollection items = entryFilter.getFilterItems();
            if (items.size() == 0 || !EntryFilterType.ENTRYALLWHERE.equals((Object)type) && !EntryFilterType.ENTRYANYWHERE.equals((Object)type) && !EntryFilterType.NORMAL.equals((Object)type) || (prop = bo.getPropertyByNameRuntime(entryFilter.getEntryName())) == null || !(prop instanceof LinkPropertyInfo)) continue;
            RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)prop);
            EntityObjectInfo childBO = relation.getChildObject(bo);
            PropertyInfo parentProp = relation.getParentProperty(bo);
            String childFieldName = relation.getChildProperty(bo).getMappingField().getName();
            EntityViewInfo childView = new EntityViewInfo();
            FilterInfo childFilter = new FilterInfo();
            int k = items.size();
            for (int j = 0; j < k; ++j) {
                childFilter.getFilterItems().add(items.get(j));
            }
            childFilter.setMaskString(entryFilter.getMaskString());
            childView.setFilter(childFilter);
            EntityAccess ea = EntityAccess.getInstance(childBO, solution, childView, ctx);
            ea.setFilterFormat(childView.getFilter().getMaskString());
            String childTmpSQL = new SQLGeneratorCache(ea, ctx).selectSQLWithTrueValue(childBO, true, null, false);
            String alias = "";
            if (ea.getAliasMapping() != null && ea.getAliasMapping().containsValue(childBO.getName())) {
                for (Map.Entry<String, String> entry : ea.getAliasMapping().entrySet()) {
                    if (!entry.getValue().equalsIgnoreCase(childBO.getName())) continue;
                    alias = entry.getKey();
                    break;
                }
            }
            String childSQL = "";
            childSQL = alias.length() > 0 ? "SELECT " + alias + "." + childFieldName + " " : "SELECT " + childFieldName + " ";
            childSQL = childSQL.toUpperCase();
            StringBuffer fromSQL = new StringBuffer();
            StringBuffer whereSQL = new StringBuffer();
            QueryFilterUtils.getPharseSQL(childTmpSQL, fromSQL, whereSQL);
            String childSQLFrom = fromSQL.toString();
            String childSQLWhere = whereSQL.toString();
            childSQL = childSQL + childSQLFrom;
            FilterItemInfo filterItem = null;
            if (EntryFilterType.ENTRYALLWHERE.equals((Object)type)) {
                childSQL = childSQL + "WHERE ";
                childSQL = childSQL + " NOT (" + childSQLWhere + ")";
                filterItem = new FilterItemInfo(parentProp.getName(), (Object)childSQL, CompareType.NOTINNER);
            } else if (EntryFilterType.ENTRYANYWHERE.equals((Object)type)) {
                childSQL = childSQL + "WHERE ";
                childSQL = childSQL + childSQLWhere;
                filterItem = new FilterItemInfo(parentProp.getName(), (Object)childSQL, CompareType.INNER);
            }
            if (filterItem == null) continue;
            FilterInfo otherFilter = new FilterInfo();
            otherFilter.getFilterItems().add(filterItem);
            if (view.getFilter() != null) {
                view.getFilter().mergeFilter(otherFilter, "AND");
                continue;
            }
            view.setFilter(otherFilter);
        }
    }

    private static void getPharseSQL(String sql, StringBuffer fromSQL, StringBuffer whereSQL) {
        try {
            SelectParser parser2 = null;
            parser2 = new SelectParser(sql.toString());
            SqlSelect select = (SqlSelect)parser2.select();
            QuerySQLFormater formater = new QuerySQLFormater(fromSQL);
            formater.getFromCause(select);
            formater.setBuffer(whereSQL);
            formater.getConditionCause(select);
        }
        catch (Exception e) {
            fromSQL.append(sql.substring(sql.toUpperCase().indexOf("FROM"), sql.toUpperCase().indexOf("WHERE")));
            whereSQL.append(sql.substring(sql.toUpperCase().indexOf("WHERE") + 5));
        }
    }
}

