/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.RTSelectorItem;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.util.StringUtils;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.HashSet;
import java.util.Set;

public class RTSelector
extends AbstractObjectCollection {
    private static final char DOT = '.';

    public RTSelector() {
        super(RTSelectorItem.class);
    }

    public boolean add(RTSelectorItem info) {
        return this.addObject((IObjectValue)info);
    }

    public boolean remove(RTSelectorItem info) {
        return this.removeObject((IObjectValue)info);
    }

    public RTSelectorItem get(int index) {
        return (RTSelectorItem)this.getObject(index);
    }

    public RTSelectorItem set(int index, RTSelectorItem info) {
        return (RTSelectorItem)this.setObject(index, (IObjectValue)info);
    }

    public boolean contains(RTSelectorItem info) {
        return this.containsObject((IObjectValue)info);
    }

    public boolean startsWithKey(String name) {
        if (name != null) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                if (!this.get(i).startsWithKey(name)) continue;
                return true;
            }
        }
        return false;
    }

    boolean selectorOnlyKeyField(String name) {
        if (name == null || name.lastIndexOf(46) <= 0) {
            return false;
        }
        boolean found = false;
        String nameFlag = name.substring(0, name.lastIndexOf(46));
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            RTSelectorItem thsItem = this.get(i);
            String propName = thsItem.getPropertyName();
            if (propName.indexOf(46) < 0 || propName.length() < nameFlag.length() || !thsItem.startsWithKey(nameFlag)) continue;
            if (propName.equalsIgnoreCase(name)) {
                found = true;
                continue;
            }
            return false;
        }
        return found;
    }

    public void addProperty(EntityObjectInfo entity, String name) throws InvalidDAOMetaDataException {
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        name = name.trim();
        boolean isExistAll = false;
        if ("*".equals(name)) {
            this.addAllProperties(entity, entity, "");
            isExistAll = true;
        } else if (name.indexOf("*") > 0) {
            if (name.indexOf("*") == name.length() - 1) {
                PropertyInfo prop = ImplUtils.getPropertyByName(entity, name = name.substring(0, name.lastIndexOf(46)));
                if (prop instanceof LinkPropertyInfo) {
                    RelationshipInfo relation = ImplUtils.getRTRelation(entity, (LinkPropertyInfo)prop);
                    EntityObjectInfo supplierObject = relation.getChildObject(entity);
                    this.addAllProperties(entity, supplierObject, name + '.');
                }
            } else {
                throw new InvalidDAOMetaDataException("invalid '*' format: " + name);
            }
            isExistAll = true;
        } else {
            PropertyInfo prop = ImplUtils.getPropertyByName(entity, name);
            if (prop instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ImplUtils.getRTRelation(entity, (LinkPropertyInfo)prop);
                EntityObjectInfo supplierObject = relation.getChildObject(entity);
                if (CardinalityType.isOneORZero((CardinalityType)relation.getSupplierCardinality())) {
                    this.addSelectionItem(new RTSelectorItem(name + '.' + relation.getSupplierProperty().getName()));
                } else {
                    if (supplierObject == null) {
                        throw new InvalidDAOMetaDataException(relation.getFullName() + " not found supplier object");
                    }
                    PropertyCollection props = supplierObject.getLogicalKeyPropertiesRuntime();
                    if (props == null || props.size() != 1) {
                        throw new InvalidDAOMetaDataException(supplierObject.getFullName() + " cannot found logic key");
                    }
                    this.addSelectionItem(new RTSelectorItem(name + '.' + props.get(0).getName()));
                }
            } else {
                this.addSelectionItem(new RTSelectorItem(name));
            }
        }
        if (isExistAll) {
            RTSelector.checkSelector(entity.getFullName());
        }
    }

    public static void checkSelector(String name) throws InvalidDAOMetaDataException {
    }

    private void addAllProperties(EntityObjectInfo entity, EntityObjectInfo bo, String prefixName) throws InvalidDAOMetaDataException {
        PropertyCollection props = bo.getInheritedPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            PropertyInfo fld = props.get(i);
            String fieldName = null;
            if (fld instanceof OwnPropertyInfo) {
                fieldName = prefixName + fld.getName();
            } else {
                PropertyCollection keyProps;
                EntityObjectInfo childObj;
                RelationshipInfo relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld);
                if (relation.isReverseLink(bo)) continue;
                if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo))) {
                    childObj = relation.getChildObject(bo);
                    if (childObj == null) {
                        throw new InvalidDAOMetaDataException(relation.getFullName() + " not found child object");
                    }
                    keyProps = childObj.getLogicalKeyPropertiesRuntime();
                    if (keyProps == null || keyProps.size() != 1) {
                        throw new InvalidDAOMetaDataException(childObj.getFullName() + " not found logic key");
                    }
                    fieldName = prefixName + fld.getName() + '.' + keyProps.get(0).getName();
                } else if (RelationshipType.COMPOSITION.equals((Object)relation.getType())) {
                    childObj = relation.getChildObject(bo);
                    if (childObj == null) {
                        throw new InvalidDAOMetaDataException(relation.getFullName() + " not found child object");
                    }
                    keyProps = childObj.getLogicalKeyPropertiesRuntime();
                    if (keyProps == null || keyProps.size() != 1) {
                        throw new InvalidDAOMetaDataException(childObj.getFullName() + " not found logic key");
                    }
                    fieldName = prefixName + fld.getName() + '.' + keyProps.get(0).getName();
                }
            }
            if (StringUtils.isEmpty((String)fieldName)) continue;
            this.addSelectionItem(new RTSelectorItem(fieldName));
        }
    }

    public void addNestProperty(EntityObjectInfo entity, String name) throws InvalidDAOMetaDataException {
        this.innerAddNestProperty(entity, name);
    }

    private void innerAddNestProperty(EntityObjectInfo entity, String name) throws InvalidDAOMetaDataException {
        if (StringUtils.isEmpty((String)name)) {
            this.addNestAllProperties(entity, entity, "");
        } else {
            PropertyInfo prop = ImplUtils.getPropertyByName(entity, name);
            if (prop instanceof LinkPropertyInfo) {
                RelationshipInfo relation = ImplUtils.getRTRelation(entity, (LinkPropertyInfo)prop);
                if (relation.getLinkType(entity).equals((Object)RelationshipType.COMPOSITION)) {
                    this.addNestAllProperties(entity, relation.getSupplierObject(), name);
                } else if (CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(entity))) {
                    EntityObjectInfo supplierObject = relation.getChildObject(entity);
                    PropertyCollection props = null;
                    if (supplierObject != null) {
                        props = supplierObject.getLogicalKeyPropertiesRuntime();
                    }
                    if (props == null || props.size() != 1) {
                        if (supplierObject != null) {
                            throw new InvalidDAOMetaDataException(supplierObject.getName() + " cannot found logic key");
                        }
                        throw new InvalidDAOMetaDataException(relation.getName() + " cannot found child object");
                    }
                    RTSelectorItem si = new RTSelectorItem(name + '.' + relation.getSupplierProperty().getName());
                    this.addSelectionItem(si);
                }
            } else {
                this.addSelectionItem(new RTSelectorItem(name));
            }
        }
    }

    private void addNestAllProperties(EntityObjectInfo entity, EntityObjectInfo bo, String prefixName) throws InvalidDAOMetaDataException {
        String prefix = prefixName + '.';
        this.addAllProperties(entity, bo, prefix);
        PropertyCollection props = bo.getInheritedPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            RelationshipInfo relation;
            PropertyInfo fld = props.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld)).getLinkType(bo)) || !CardinalityType.ONE.equals((Object)relation.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relation.getClientCardinality())) continue;
            EntityObjectInfo chdbo = relation.getChildObject(bo);
            String subPrefixName = prefix + fld.getName();
            HashSet<String> objects = new HashSet<String>();
            objects.add(bo.getName());
            this.addNestAllProperties(entity, chdbo, subPrefixName, objects);
        }
    }

    private void addNestAllProperties(EntityObjectInfo entity, EntityObjectInfo bo, String prefixName, Set<String> objects) throws InvalidDAOMetaDataException {
        String prefix = prefixName + '.';
        this.addAllProperties(entity, bo, prefix);
        PropertyCollection props = bo.getInheritedPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            RelationshipInfo relation;
            PropertyInfo fld = props.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld)).getLinkType(bo)) || !CardinalityType.ONE.equals((Object)relation.getClientCardinality()) && !CardinalityType.ZERO_TO_ONE.equals((Object)relation.getClientCardinality())) continue;
            String subPrefixName = prefix + fld.getName();
            EntityObjectInfo subEntity = relation.getSupplierObject();
            if (subEntity.getName().equals(bo.getName())) {
                subEntity = relation.getClientObject();
            }
            if (objects.contains(subEntity.getName())) continue;
            objects.add(subEntity.getName());
            this.addNestAllProperties(entity, subEntity, subPrefixName, objects);
        }
    }

    private void addSelectionItem(RTSelectorItem is) {
        this.add(is);
    }

    public boolean hasKey(String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (!this.get(i).getPropertyName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.get(i).getPropertyName());
            String tableName = this.get(i).getTableName();
            if (tableName == null) continue;
            sb.append("[");
            sb.append(tableName);
            sb.append("]");
        }
        return sb.toString();
    }

    public void marshal(Marshaller marshaller) throws IOException {
        throw new NotSerializableException();
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        throw new NotSerializableException();
    }
}

