/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl;

import com.kingdee.bos.framework.cache.CustomCacheService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SQLGenerCache {
    private static final SQLGenerCache instance = new SQLGenerCache();
    private static final CustomCacheService cache = new CustomCacheService("cache.SQLGenerCache");

    public static SQLGenerCache getInstance() {
        return instance;
    }

    public SelectDescriptor getSelectDesc(String key) {
        Object obj = cache.get(key);
        if (obj != null) {
            return (SelectDescriptor)obj;
        }
        return null;
    }

    public void putSelectDesc(String key, SelectDescriptor selectDesc) {
        cache.put(key, (Object)selectDesc);
    }

    public String getDeleteDesc(String key) {
        Object obj = cache.get(key);
        if (obj != null) {
            return (String)obj;
        }
        return null;
    }

    public void putDeleteDesc(String key, String deleteString) {
        cache.put(key, (Object)deleteString);
    }

    public void clear() {
        cache.removeAll();
    }

    static class SelectDescriptor
    implements Serializable {
        final String[] propName;
        final String[] propAlias;
        final List fieldList;
        final String sql;

        public SelectDescriptor(Map aliasMapping, List fieldList, String sql) {
            if (aliasMapping == null) {
                this.propName = new String[0];
                this.propAlias = new String[0];
            } else {
                this.propName = new String[aliasMapping.size()];
                this.propAlias = new String[aliasMapping.size()];
                Iterator it = aliasMapping.entrySet().iterator();
                int i = 0;
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    this.propName[i] = (String)e.getKey();
                    this.propAlias[i] = (String)e.getValue();
                    ++i;
                }
            }
            if (fieldList instanceof ArrayList) {
                ((ArrayList)fieldList).trimToSize();
            }
            this.fieldList = fieldList;
            this.sql = sql;
        }

        public Map getAliasMapping() {
            if (this.propName == null) {
                return new HashMap(0);
            }
            HashMap<String, String> aliasMapping = new HashMap<String, String>(this.propName.length);
            for (int i = 0; i < this.propName.length; ++i) {
                aliasMapping.put(this.propName[i], this.propAlias[i]);
            }
            return aliasMapping;
        }

        public List getFieldList() {
            return this.fieldList;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

