/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.Executable;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.ValuePreprocess;
import java.util.ArrayList;
import java.util.List;

class BatchAccessQueue
implements IBatchAccess {
    private static final long serialVersionUID = -1320056669182922411L;
    private final List<IBatchAccess> accesses = new ArrayList<IBatchAccess>(4);
    private final List<ValuePreprocess> processes = new ArrayList<ValuePreprocess>(2);

    BatchAccessQueue() {
    }

    void addAccess(IBatchAccess access) {
        if (access == null) {
            return;
        }
        this.accesses.add(access);
    }

    @Override
    public int getType() {
        return 9;
    }

    @Override
    public Executable[] execute(AccessValue value) throws BOSException {
        AccessValue data = value;
        int size = this.processes.size();
        for (int i = 0; i < size; ++i) {
            data = this.processes.get(i).process(data);
        }
        ArrayList<Executable> executors = new ArrayList<Executable>();
        int size2 = this.accesses.size();
        for (int i = 0; i < size2; ++i) {
            Executable[] exes = this.accesses.get(i).execute(data);
            if (exes == null) continue;
            for (int j = 0; j < exes.length; ++j) {
                executors.add(exes[j]);
            }
        }
        return executors.toArray(new Executable[0]);
    }

    void addProcessFirst(ValuePreprocess p) {
        this.processes.add(0, p);
    }

    void appendProcess(ValuePreprocess p) {
        this.processes.add(p);
    }
}

