/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.batch.AbstractBuilder;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessFactory;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessQueue;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ObjectRemover$CompositeHandler1_$;
import com.kingdee.bos.dao.ormapping.impl.batch.CommonCompositeBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.EntityBatchAccess4Remover;
import com.kingdee.bos.dao.ormapping.impl.batch.Field;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.Path;
import com.kingdee.bos.dao.ormapping.impl.batch.RemoveInfo;
import com.kingdee.bos.dao.ormapping.impl.batch.ValuePreprocess;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.ExtendedTableInfo;
import com.kingdee.bos.metadata.data.KeyMapCollection;
import com.kingdee.bos.metadata.data.KeyMapInfo;
import com.kingdee.bos.metadata.data.PKColumnCollection;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

class Builder4ObjectRemover
extends AbstractBuilder {
    private final EntityBatchAccess4Remover.LinkedBatchAccess parent;

    Builder4ObjectRemover(EntityObjectInfo bo) {
        super(bo);
        this.parent = null;
    }

    Builder4ObjectRemover(EntityObjectInfo bo, EntityBatchAccess4Remover.LinkedBatchAccess parent) {
        super(bo);
        this.parent = parent;
    }

    @Override
    protected IBatchAccess build(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        int i;
        EntityObjectInfo basebo;
        BatchAccessQueue queue = new BatchAccessQueue();
        for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
        }
        if (basebo != null) {
            queue.addAccess(BatchAccessFactory.getRemoveAccessProxy(basebo));
        }
        PropertyCollection keyFields = bo.getLogicalKeyPropertiesRuntime();
        String[] keys = new String[keyFields.size()];
        for (int j = 0; j < keys.length; ++j) {
            keys[j] = keyFields.get(j).getName();
        }
        queue.appendProcess(new RemoveValueProcess(keys));
        EntityBatchAccess4Remover batchAccess = new EntityBatchAccess4Remover(bo.getTable().getName(), this.parent);
        int n = keyFields.size();
        for (int i2 = 0; i2 < n; ++i2) {
            PropertyInfo fld = keyFields.get(i2);
            ColumnInfo col = bo.getMappingFieldOfProperty(fld);
            Field field = new Field(fld, col, new Field.ValueInfo(new Path(fld.getName()), bo.isBOSUuidCol(fld)));
            batchAccess.addLogicKey(field);
        }
        PropertyCollection props = bo.getPropertiesRuntime();
        int n2 = props.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            RelationshipInfo relation;
            PropertyInfo fld = props.get(i3);
            if (!(fld instanceof LinkPropertyInfo) || !RelationshipType.COMPOSITION.equals((Object)(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld)).getLinkType(bo))) continue;
            boolean prt1or0 = CardinalityType.isOneORZero((CardinalityType)relation.getParentCardinality(bo));
            boolean chld1or0 = CardinalityType.isOneORZero((CardinalityType)relation.getChildCardinality(bo));
            if (prt1or0 && !chld1or0) {
                IBatchAccess subRecordAccess = Builder4ObjectRemover.buildSubRecordBatchAccess(bo, relation, batchAccess);
                String key = fld.getName();
                CommonCompositeBatchAccess.SignedBatchAccess sa = new CommonCompositeBatchAccess.SignedBatchAccess(key, subRecordAccess);
                queue.addAccess(new CommonCompositeBatchAccess(new CommonCompositeBatchAccess.SignedBatchAccess[]{sa}, new Builder4ObjectRemover$CompositeHandler1_$(fld.getName())));
                continue;
            }
            if (prt1or0 || chld1or0) continue;
            queue.addAccess(Builder4ObjectRemover.buildSubCrossRecordBatchAccess(bo, relation, (LinkPropertyInfo)fld));
        }
        IBatchAccess[] accesses = Builder4ObjectRemover.buildExtBatchAccess(bo, props, keyFields);
        for (i = 0; i < accesses.length; ++i) {
            queue.addAccess(accesses[i]);
        }
        int n3 = props.size();
        for (i = 0; i < n3; ++i) {
            RelationshipInfo relation;
            PropertyInfo fld = props.get(i);
            if (!(fld instanceof LinkPropertyInfo) || !CardinalityType.isOneORZero((CardinalityType)(relation = ImplUtils.getRTRelation(bo, (LinkPropertyInfo)fld)).getChildCardinality(bo)) || !RelationshipType.COMPOSITION.equals((Object)relation.getLinkType(bo))) continue;
            EntityObjectInfo childbo = relation.getChildObject(bo);
            PropertyCollection chldKeys = childbo.getLogicalKeyPropertiesRuntime();
            String[] ckeys = new String[chldKeys.size()];
            for (int j = 0; j < ckeys.length; ++j) {
                ckeys[j] = chldKeys.get(j).getName();
            }
            IBatchAccess caccess = BatchAccessFactory.getRemoveAccessProxy(childbo);
            String key = fld.getName();
            CommonCompositeBatchAccess.SignedBatchAccess sa = new CommonCompositeBatchAccess.SignedBatchAccess(key, caccess);
            queue.addAccess(new CommonCompositeBatchAccess(new CommonCompositeBatchAccess.SignedBatchAccess[]{sa}, new CompositeHandler1_0(fld.getName(), ckeys)));
        }
        queue.addAccess(batchAccess);
        return queue;
    }

    private static IBatchAccess buildSubRecordBatchAccess(EntityObjectInfo bo, RelationshipInfo relation, EntityBatchAccess4Remover parent) throws InvalidDAOMetaDataException {
        PropertyInfo parentProp = relation.getParentProperty(bo);
        PropertyInfo childProp = relation.getChildProperty(bo);
        EntityObjectInfo childBO = relation.getChildObject(bo);
        ColumnInfo childCol = childBO.getMappingFieldOfProperty(childProp);
        ColumnInfo parentCol = bo.getMappingFieldOfProperty(parentProp);
        Field field = new Field(childProp, childCol, null);
        Field parentField = new Field(parentProp, parentCol, null);
        IBatchAccess subRecordRemover = new Builder4ObjectRemover(relation.getChildObject(bo), new EntityBatchAccess4Remover.LinkedBatchAccess(field, parent, parentField)).build();
        return subRecordRemover;
    }

    static IBatchAccess buildSubCrossRecordBatchAccess(EntityObjectInfo bo, RelationshipInfo rel, LinkPropertyInfo fld) throws InvalidDAOMetaDataException {
        EntityObjectInfo chdObject = rel.getChildObject(bo);
        CrossTableInfo crossTable = rel.getCrossTable();
        boolean mainref = ImplUtils.isMainObjRefCrossTable(bo, chdObject, fld, crossTable);
        EntityBatchAccess4Remover remover = new EntityBatchAccess4Remover(crossTable.getName(), null);
        KeyMapCollection keyMaps = mainref ? crossTable.getClientTableMap().getKeyMaps() : crossTable.getSupplierTableMap().getKeyMaps();
        int n = keyMaps.size();
        for (int i = 0; i < n; ++i) {
            KeyMapInfo keyMap = keyMaps.get(i);
            ColumnInfo refCol = keyMap.getRefColumn();
            PropertyInfo refProp = bo.getInheritedPropertyByColName(refCol.getName());
            remover.addLogicKey(new Field(refProp, keyMap.getSelfColumn(), new Field.ValueInfo(new Path(refProp.getName()), true)));
        }
        return remover;
    }

    private static IBatchAccess[] buildExtBatchAccess(EntityObjectInfo bo, PropertyCollection props, PropertyCollection keyFields) {
        HashSet<String> deletedExtTables = new HashSet<String>();
        ArrayList<EntityBatchAccess4Remover> accesses = null;
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            String tableName;
            ExtendedTableInfo extTable;
            PropertyInfo prop = props.get(i);
            ExtendedFieldInfo extField = prop.getExtendedField();
            if (extField == null || (extTable = extField.getExtendedTable()) == null || extField.getExtendedColumn() == null || deletedExtTables.contains(tableName = extTable.getName())) continue;
            EntityBatchAccess4Remover remover = new EntityBatchAccess4Remover(tableName, null);
            PKColumnCollection pks = extTable.getPrimaryKey().getPKColumns();
            int m = pks.size();
            for (int j = 0; j < m; ++j) {
                PropertyInfo fld = keyFields.get(j);
                remover.addLogicKey(new Field(fld, pks.get(j).getColumn(), new Field.ValueInfo(new Path(fld.getName()), bo.isBOSUuidCol(fld))));
            }
            if (accesses == null) {
                accesses = new ArrayList<EntityBatchAccess4Remover>(1);
            }
            accesses.add(remover);
            deletedExtTables.add(tableName);
        }
        if (accesses != null) {
            return accesses.toArray(new IBatchAccess[0]);
        }
        return new IBatchAccess[0];
    }

    private static class RemoveValueProcess
    implements ValuePreprocess {
        private static final long serialVersionUID = -1204255145707492594L;
        private final String[] logicKeys;

        RemoveValueProcess(String[] logicKeys) {
            this.logicKeys = logicKeys;
        }

        @Override
        public AccessValue process(AccessValue data) throws InvalidDAOMetaDataException {
            if (data.data instanceof RemoveInfo) {
                return data;
            }
            return RemoveInfo.AccessDataUtil.convert(data, this.logicKeys, null);
        }
    }

    static class CompositeHandler1_0
    implements CommonCompositeBatchAccess.AccessValueProvider {
        private static final long serialVersionUID = 2694433917197085675L;
        private final String key;
        private final String propName;
        private final String[] childLogicKey;

        CompositeHandler1_0(String propName, String[] childLogicKey) {
            this.key = propName;
            this.propName = propName;
            this.childLogicKey = childLogicKey;
        }

        @Override
        public Map<String, List<AccessValue>> getValues(AccessValue data) {
            HashMap<String, List<AccessValue>> map = new HashMap<String, List<AccessValue>>(1);
            ArrayList<AccessValue> values = new ArrayList<AccessValue>(1);
            AccessValue value = RemoveInfo.AccessDataUtil.convert(data, this.childLogicKey, this.propName);
            if (value != null) {
                values.add(value);
            }
            map.put(this.key, values);
            return map;
        }
    }
}

