/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.batch.AbstractBuilder;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessContext;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessFactory;
import com.kingdee.bos.dao.ormapping.impl.batch.BatchAccessQueue;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ObjectRemover;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4ObjectUpdater$CompositeHandler_1_$;
import com.kingdee.bos.dao.ormapping.impl.batch.Builder4SubCrossRecordCreator;
import com.kingdee.bos.dao.ormapping.impl.batch.CompositeBatchAccess4Updater;
import com.kingdee.bos.dao.ormapping.impl.batch.EntityBatchAccess4Updater;
import com.kingdee.bos.dao.ormapping.impl.batch.Field;
import com.kingdee.bos.dao.ormapping.impl.batch.FilterItemDesc;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.Path;
import com.kingdee.bos.dao.ormapping.impl.batch.PropertyAgent;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.ExtendedFieldInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import org.apache.log4j.Logger;

class Builder4ObjectUpdater
extends AbstractBuilder {
    private static Logger logger = Logger.getLogger(Builder4ObjectUpdater.class);

    Builder4ObjectUpdater(EntityObjectInfo bo) {
        super(bo);
    }

    @Override
    protected IBatchAccess build(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        BatchAccessQueue queue = new BatchAccessQueue();
        queue.appendProcess(AbstractBuilder.ValueClone.getInstance(bo));
        EntityBatchAccess4Updater batchAccess = new EntityBatchAccess4Updater(bo.getTable().getName());
        queue.addAccess(batchAccess);
        BatchAccessContext<EntityBatchAccess4Updater> bactx = new BatchAccessContext<EntityBatchAccess4Updater>(queue, batchAccess, bo);
        PropertyCollection flds = bo.getPropertiesRuntime();
        int fldSize = flds.size();
        for (int i = 0; i < fldSize; ++i) {
            PropertyInfo fld = flds.get(i);
            this.processProperty(bactx, fld);
        }
        this.updateParentObject(queue, bo);
        return queue;
    }

    BatchAccessQueue buildBatchAccessQueue(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        BatchAccessQueue queue = new BatchAccessQueue();
        EntityBatchAccess4Updater batchAccess = new EntityBatchAccess4Updater(bo.getTable().getName());
        queue.addAccess(batchAccess);
        BatchAccessContext<EntityBatchAccess4Updater> bactx = new BatchAccessContext<EntityBatchAccess4Updater>(queue, batchAccess, bo);
        PropertyCollection flds = bo.getPropertiesRuntime();
        int fldSize = flds.size();
        for (int i = 0; i < fldSize; ++i) {
            PropertyInfo fld = flds.get(i);
            this.processProperty(bactx, fld);
        }
        this.updateParentObject(queue, bo);
        return queue;
    }

    private void updateParentObject(BatchAccessQueue queue, EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        EntityObjectInfo basebo;
        for (basebo = bo.getBaseEntity(); basebo != null && basebo.isAbstract(); basebo = basebo.getBaseEntity()) {
        }
        if (basebo != null) {
            queue.addAccess(BatchAccessFactory.getUpdateAccessProxy(basebo));
        }
    }

    private void processProperty(BatchAccessContext<EntityBatchAccess4Updater> bactx, PropertyInfo fld) throws InvalidDAOMetaDataException {
        ColumnInfo col = bactx.bo.getMappingFieldOfProperty(fld);
        boolean isLogicKey = bactx.bo.isLogicalKey(fld);
        OwnPropertyInfo sequenceProp = bactx.bo.getSequenceProperty();
        boolean isSequence = fld.equals((Object)sequenceProp);
        ExtendedFieldInfo extfld = fld.getExtendedField();
        EntityBatchAccess4Updater extea = this.updateExtendedField(bactx, extfld);
        RelationshipInfo relation = null;
        if (fld instanceof LinkPropertyInfo) {
            relation = ImplUtils.getRTRelation(bactx.bo, (LinkPropertyInfo)fld);
        }
        PropertyAgent prop = new PropertyAgent(fld, col, extfld, isLogicKey, isSequence, relation);
        this.processLogicKey(bactx, prop);
        if (fld instanceof LinkPropertyInfo) {
            this.processLinkProperty(bactx, prop, extea);
        } else if (col != null) {
            this.updateData(bactx, prop);
        } else if (extfld != null) {
            this.updateExtendData(bactx, prop, extea);
        }
    }

    private void updateData(BatchAccessContext<EntityBatchAccess4Updater> bactx, PropertyAgent prop) throws InvalidDAOMetaDataException {
        if (prop.col != null && !prop.isLogicKey) {
            ((EntityBatchAccess4Updater)bactx.batchAccess).addProperty(new Field(prop.fld, prop.col, prop.isLogicKey, prop.isSequence, new Field.ValueInfo(new Path(prop.fld.getName()))));
        }
    }

    private void updateExtendData(BatchAccessContext<EntityBatchAccess4Updater> bactx, PropertyAgent prop, EntityBatchAccess4Updater extea) {
        ColumnInfo extcol = prop.extfld.getExtendedColumn();
        if (extcol == null) {
            return;
        }
        extea.addProperty(new Field(prop.fld, extcol, new Field.ValueInfo(new Path(prop.fld.getName()))));
    }

    private void processLinkProperty(BatchAccessContext<EntityBatchAccess4Updater> bactx, PropertyAgent prop, EntityBatchAccess4Updater extea) throws InvalidDAOMetaDataException {
        if (CardinalityType.isOneORZero((CardinalityType)prop.relation.getChildCardinality(bactx.bo))) {
            this.updateOneORZeroLnkObject(bactx, prop, extea);
        } else if (RelationshipType.COMPOSITION.equals((Object)prop.relation.getLinkType(bactx.bo))) {
            this.updateOneORUnbountLnkObject(bactx, prop);
        }
    }

    private void updateOneORUnbountLnkObject(BatchAccessContext<EntityBatchAccess4Updater> bactx, PropertyAgent prop) throws InvalidDAOMetaDataException {
        String[] logicKeys;
        EntityObjectInfo childBO = prop.relation.getChildObject(bactx.bo);
        String chdPropName = prop.relation.getChildProperty(bactx.bo).getName();
        String parentPropName = prop.relation.getParentProperty(bactx.bo).getName();
        if (chdPropName == null) {
            throw new InvalidDAOMetaDataException("cannot get link property at InnerBusinessObjectDAO.update()");
        }
        PropertyCollection keys = childBO.getLogicalKeyPropertiesRuntime();
        if (keys != null) {
            logicKeys = new String[keys.size()];
            for (int i = 0; i < logicKeys.length; ++i) {
                logicKeys[i] = keys.get(i).getName();
            }
        } else {
            logicKeys = null;
        }
        String seqPropName = null;
        if (childBO.getSequenceProperty() != null) {
            seqPropName = childBO.getSequenceProperty().getName();
        }
        boolean isPrt1or0 = CardinalityType.isOneORZero((CardinalityType)prop.relation.getParentCardinality(bactx.bo));
        boolean isChld1to$ = CardinalityType.ONE_TO_UNBOUNDED.equals((Object)prop.relation.getChildCardinality(bactx.bo));
        Builder4ObjectUpdater$CompositeHandler_1_$ hanlder = new Builder4ObjectUpdater$CompositeHandler_1_$(prop.fld.getName(), logicKeys, seqPropName, chdPropName, parentPropName, isPrt1or0, isChld1to$);
        if (isPrt1or0) {
            IBatchAccess create = BatchAccessFactory.getCreateAccessProxy(childBO);
            IBatchAccess update = BatchAccessFactory.getUpdateAccessProxy(childBO);
            IBatchAccess remover = BatchAccessFactory.getRemoveAccessProxy(childBO);
            CompositeBatchAccess4Updater compositeAccess = new CompositeBatchAccess4Updater(create, update, remover, hanlder);
            bactx.queue.addAccess(compositeAccess);
        } else {
            IBatchAccess create = new Builder4SubCrossRecordCreator(bactx.bo, prop.relation).build();
            IBatchAccess remover = Builder4ObjectRemover.buildSubCrossRecordBatchAccess(bactx.bo, prop.relation, (LinkPropertyInfo)prop.fld);
            CompositeBatchAccess4Updater compositeAccess = new CompositeBatchAccess4Updater(create, null, remover, hanlder);
            bactx.queue.addAccess(compositeAccess);
        }
    }

    private void updateOneORZeroLnkObject(BatchAccessContext<EntityBatchAccess4Updater> bactx, PropertyAgent prop, EntityBatchAccess4Updater extea) throws InvalidDAOMetaDataException {
        Field field;
        if (RelationshipType.COMPOSITION.equals((Object)prop.relation.getLinkType(bactx.bo))) {
            String[] logicKeys;
            EntityObjectInfo childBO = prop.relation.getChildObject(bactx.bo);
            PropertyCollection keys = childBO.getLogicalKeyPropertiesRuntime();
            if (keys != null) {
                logicKeys = new String[keys.size()];
                for (int i = 0; i < logicKeys.length; ++i) {
                    logicKeys[i] = keys.get(i).getName();
                }
            } else {
                logicKeys = null;
            }
            CompositeHandler_1_0 hanlder = new CompositeHandler_1_0(prop.fld.getName(), logicKeys);
            IBatchAccess create = BatchAccessFactory.getCreateAccessProxy(childBO);
            IBatchAccess update = BatchAccessFactory.getUpdateAccessProxy(childBO);
            IBatchAccess remover = BatchAccessFactory.getRemoveAccessProxy(childBO);
            CompositeBatchAccess4Updater compositeAccess = new CompositeBatchAccess4Updater(create, update, remover, hanlder);
            bactx.queue.addAccess(compositeAccess);
        }
        Path valuePath = new Path(prop.fld.getName()).append(prop.relation.getChildProperty(bactx.bo).getName());
        if (prop.extfld != null) {
            field = new Field(prop.fld, prop.extfld.getExtendedColumn(), new Field.ValueInfo(valuePath));
            extea.addProperty(field);
        } else if (prop.col != null) {
            field = new Field(prop.fld, prop.col, new Field.ValueInfo(valuePath));
            ((EntityBatchAccess4Updater)bactx.batchAccess).addProperty(field);
        }
    }

    private void processLogicKey(BatchAccessContext<EntityBatchAccess4Updater> bactx, PropertyAgent prop) {
        if (prop.isLogicKey && prop.col != null) {
            if (prop.fld instanceof LinkPropertyInfo) {
                Path valuePath = new Path(prop.fld.getName()).append(prop.relation.getSupplierObject().getLogicalKeyPropertiesRuntime().get(0).getName());
                Field.ValueInfo value = new Field.ValueInfo(valuePath, bactx.bo.isBOSUuidCol(prop.fld));
                ((EntityBatchAccess4Updater)bactx.batchAccess).addFilterItem(new FilterItemDesc(new Field(prop.fld, prop.col, prop.isLogicKey, prop.isSequence, value)));
            } else {
                Field.ValueInfo value = new Field.ValueInfo(new Path(prop.fld.getName()), bactx.bo.isBOSUuidCol(prop.fld));
                ((EntityBatchAccess4Updater)bactx.batchAccess).addFilterItem(new FilterItemDesc(new Field(prop.fld, prop.col, prop.isLogicKey, prop.isSequence, value)));
            }
        }
    }

    private EntityBatchAccess4Updater updateExtendedField(BatchAccessContext<EntityBatchAccess4Updater> bactx, ExtendedFieldInfo extfld) {
        EntityBatchAccess4Updater extea;
        if (extfld == null) {
            return null;
        }
        String tableName = extfld.getExtendedTable().getName();
        if (!bactx.extendBatchAccesses.containsKey(tableName)) {
            extea = new EntityBatchAccess4Updater(tableName);
            bactx.queue.addAccess(extea);
            bactx.extendBatchAccesses.put(tableName, extea);
        } else {
            extea = (EntityBatchAccess4Updater)bactx.extendBatchAccesses.get(tableName);
        }
        if (extea != null) {
            PropertyCollection keys = bactx.bo.getLogicalKeyPropertiesRuntime();
            int keySize = keys.size();
            for (int j = 0; j < keySize; ++j) {
                PropertyInfo prop = keys.get(j);
                extea.addFilterItem(new FilterItemDesc(new Field(prop, prop.getMappingField(), new Field.ValueInfo(new Path(prop.getName()), bactx.bo.isBOSUuidCol(prop)))));
            }
        }
        return extea;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }

    static class CompositeHandler_1_0
    implements CompositeBatchAccess4Updater.CompositeHandler {
        private static final long serialVersionUID = 5140306966180825534L;
        private final String linkPropName;
        private final String[] logicKeyOflinkBO;

        public CompositeHandler_1_0(String linkPropName, String[] logicKeyOflinkBO) {
            this.linkPropName = linkPropName;
            this.logicKeyOflinkBO = logicKeyOflinkBO;
        }

        @Override
        public CompositeBatchAccess4Updater.AccessValues execute(AccessValue value) {
            CompositeBatchAccess4Updater.AccessValues toHandle = new CompositeBatchAccess4Updater.AccessValues();
            IObjectValue newValue = (IObjectValue)value.data.get(this.linkPropName);
            IObjectValue oldValue = value.oldData == null ? newValue : (IObjectValue)value.oldData.get(this.linkPropName);
            if (oldValue == null && newValue != null) {
                toHandle.toCreate.add(new AccessValue(newValue, oldValue));
            } else if (oldValue != null && newValue == null) {
                toHandle.toDelete.add(new AccessValue(oldValue, null));
            } else if (oldValue != null && newValue != null) {
                if (ImplUtils.isKeyChanged(this.logicKeyOflinkBO, oldValue, newValue)) {
                    toHandle.toDelete.add(new AccessValue(oldValue, null));
                    toHandle.toCreate.add(new AccessValue(newValue, null));
                } else {
                    toHandle.toUpate.add(new AccessValue(newValue, oldValue));
                }
            }
            return toHandle;
        }

        @Override
        public String getPropName() {
            return this.linkPropName;
        }
    }
}

