/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.dao.ormapping.impl.batch.AbstractBuilder;
import com.kingdee.bos.dao.ormapping.impl.batch.EntityBatchAccess4Creator;
import com.kingdee.bos.dao.ormapping.impl.batch.Field;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.Path;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.CrossTableInfo;
import com.kingdee.bos.metadata.data.KeyMapCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;

class Builder4SubCrossRecordCreator
extends AbstractBuilder {
    private final RelationshipInfo relation;

    Builder4SubCrossRecordCreator(EntityObjectInfo bo, RelationshipInfo relation) {
        super(bo);
        this.relation = relation;
    }

    @Override
    protected IBatchAccess build(EntityObjectInfo bo) throws InvalidDAOMetaDataException {
        Field field;
        Field.ValueInfo value;
        PropertyInfo refProp;
        ColumnInfo refColumn;
        ColumnInfo selfColumn;
        int j;
        EntityObjectInfo chidObject = this.relation.getChildObject(bo);
        CrossTableInfo crossTable = this.relation.getCrossTable();
        KeyMapCollection clientKeyMaps = crossTable.getClientTableMap().getKeyMaps();
        KeyMapCollection supplierKeyMaps = crossTable.getSupplierTableMap().getKeyMaps();
        boolean mainref = ImplUtils.isMainObjRefCrossTable(bo, chidObject, this.relation, crossTable);
        EntityBatchAccess4Creator batchAccess = new EntityBatchAccess4Creator(crossTable.getName());
        int n = clientKeyMaps.size();
        for (j = 0; j < n; ++j) {
            selfColumn = clientKeyMaps.get(j).getSelfColumn();
            refColumn = clientKeyMaps.get(j).getRefColumn();
            refProp = bo.getInheritedPropertyByColName(refColumn.getName());
            value = mainref ? new Field.ValueInfo(new Path(refProp.getName()), "prt_V") : new Field.ValueInfo(new Path(refProp.getName()));
            field = new Field(selfColumn, value);
            batchAccess.addProperty(field);
        }
        n = supplierKeyMaps.size();
        for (j = 0; j < n; ++j) {
            selfColumn = supplierKeyMaps.get(j).getSelfColumn();
            refColumn = supplierKeyMaps.get(j).getRefColumn();
            refProp = chidObject.getInheritedPropertyByColName(refColumn.getName());
            value = mainref ? new Field.ValueInfo(new Path(refProp.getName())) : new Field.ValueInfo(new Path(refProp.getName()), "prt_V");
            field = new Field(selfColumn, value);
            batchAccess.addProperty(field);
        }
        return batchAccess;
    }
}

