/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

class CollectionComparator {
    private final IObjectCollection one;
    private final IObjectCollection another;
    private final String[] logicKey;
    private final Handler inited;
    private final Handler added;
    private final Handler modified;
    private final Handler deleted;
    private final TreeSet<Entry> setOne = new TreeSet<Entry>(new EntryComparator());
    private final TreeSet<Entry> setAnother = new TreeSet<Entry>(new EntryComparator());

    CollectionComparator(IObjectCollection one, IObjectCollection another, String[] logicKey, Handler inited, Handler added, Handler modified, Handler deleted) {
        this.one = one;
        this.another = another;
        this.logicKey = logicKey;
        this.inited = inited;
        this.added = added;
        this.modified = modified;
        this.deleted = deleted;
    }

    void execute() {
        if (this.initAndIsNeedCompare()) {
            this.compare();
        }
    }

    private void compare() {
        SortedSet<Entry> tail;
        Iterator i;
        SortedSet<Entry> head;
        Iterator<Entry> ite = this.setOne.iterator();
        Entry from = null;
        Entry to = null;
        if (ite.hasNext() && (head = this.setAnother.headSet(from = ite.next())) != null) {
            i = head.iterator();
            while (i.hasNext()) {
                this.deleted.process(((Entry)i.next()).value, null);
            }
        }
        if (from == null) {
            Iterator<Entry> i2 = this.setAnother.iterator();
            while (i2.hasNext()) {
                this.deleted.process(i2.next().value, null);
            }
            return;
        }
        while (ite.hasNext()) {
            to = ite.next();
            SortedSet<Entry> sub = this.setAnother.subSet(from, to);
            if (sub != null) {
                i = sub.iterator();
                if (this.setAnother.contains(from)) {
                    this.modified.process(from.value, ((Entry)i.next()).value);
                } else {
                    this.added.process(from.value, null);
                }
                while (i.hasNext()) {
                    this.deleted.process(((Entry)i.next()).value, null);
                }
            }
            from = to;
        }
        if (to == null) {
            to = from;
        }
        if (to != null && (tail = this.setAnother.tailSet(to)) != null) {
            Iterator i3 = tail.iterator();
            if (this.setAnother.contains(to)) {
                this.modified.process(to.value, ((Entry)i3.next()).value);
            } else {
                this.added.process(to.value, null);
            }
            while (i3.hasNext()) {
                this.deleted.process(((Entry)i3.next()).value, null);
            }
        }
    }

    private boolean initAndIsNeedCompare() {
        Entry e;
        IObjectValue v;
        int i;
        if (this.one == this.another) {
            int size = this.one.size();
            for (int i2 = 0; i2 < size; ++i2) {
                this.modified.process(this.one.getObject(i2), null);
            }
            return false;
        }
        boolean isSameContent = this.one.size() == this.another.size();
        ArrayList<IObjectValue[]> lstModified = new ArrayList<IObjectValue[]>();
        int size = this.one.size();
        for (i = 0; i < size; ++i) {
            v = this.one.getObject(i);
            this.inited.process(v, null);
            e = new Entry(v, this.logicKey);
            if (e.isValid()) {
                this.setOne.add(e);
            } else {
                isSameContent = false;
                this.added.process(v, null);
            }
            if (!isSameContent) continue;
            IObjectValue v2 = this.another.getObject(i);
            Entry e2 = new Entry(v2, this.logicKey);
            if (!e2.isValid()) {
                isSameContent = false;
                continue;
            }
            isSameContent = e2.key.equals(e.key);
            if (!isSameContent) continue;
            lstModified.add(new IObjectValue[]{e.value, e2.value});
        }
        if (isSameContent) {
            int size2 = lstModified.size();
            for (int i3 = 0; i3 < size2; ++i3) {
                IObjectValue[] vs = (IObjectValue[])lstModified.get(i3);
                this.modified.process(vs[0], vs[1]);
            }
            return false;
        }
        size = this.another.size();
        for (i = 0; i < size; ++i) {
            v = this.another.getObject(i);
            e = new Entry(v, this.logicKey);
            if (!e.isValid()) continue;
            this.setAnother.add(e);
        }
        return true;
    }

    static interface Handler {
        public void process(IObjectValue var1, IObjectValue var2);
    }

    static class Entry {
        final String key;
        final IObjectValue value;

        Entry(IObjectValue data, String[] logicKey) {
            String tmp = null;
            boolean invalid = false;
            for (int i = 0; i < logicKey.length; ++i) {
                Object obj = data.get(logicKey[i]);
                if (obj != null) {
                    if (i == 0) {
                        tmp = obj.toString();
                        continue;
                    }
                    tmp = tmp + "$" + obj.toString();
                    continue;
                }
                invalid = true;
                break;
            }
            this.key = invalid ? null : tmp;
            this.value = data;
        }

        boolean isValid() {
            return this.key != null;
        }
    }

    static class EntryComparator
    implements Comparator<Entry> {
        EntryComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            return this.compareKey(o1.key, o2.key);
        }

        private int compareKey(String thisObj, String anotherObj) {
            int anotherVal;
            if (thisObj == anotherObj) {
                return 0;
            }
            int thisVal = thisObj.hashCode();
            if (thisVal < (anotherVal = anotherObj.hashCode())) {
                return -1;
            }
            if (thisVal > anotherVal) {
                return 1;
            }
            if (thisObj.equals(anotherObj)) {
                return 0;
            }
            return thisObj.compareTo(anotherObj);
        }
    }
}

