/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.impl.batch.AccessValue;
import com.kingdee.bos.dao.ormapping.impl.batch.Executable;
import com.kingdee.bos.dao.ormapping.impl.batch.IBatchAccess;
import com.kingdee.bos.dao.ormapping.impl.batch.Path;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class CompositeBatchAccess4Updater
implements IBatchAccess {
    private static final long serialVersionUID = -7186526647161640101L;
    private final IBatchAccess create;
    private final IBatchAccess update;
    private final IBatchAccess remove;
    private final CompositeHandler handler;

    CompositeBatchAccess4Updater(IBatchAccess create, IBatchAccess update, IBatchAccess remove, CompositeHandler handler) {
        this.create = create;
        this.update = update;
        this.remove = remove;
        this.handler = handler;
    }

    @Override
    public Executable[] execute(AccessValue value) throws BOSException {
        int i;
        AccessValues avs = this.handler.execute(value);
        String prop = this.handler.getPropName();
        Path path = null;
        if (prop != null) {
            Path parent = (Path)value.get("path");
            if (parent == null) {
                path = new Path(prop);
            } else {
                path = new Path(parent);
                path.append(prop);
            }
        }
        ArrayList<Executable> exes = new ArrayList<Executable>();
        int size = avs.toCreate.size();
        for (i = 0; i < size; ++i) {
            this.addExecutors(exes, this.create, this.handleSubAccessValue(avs.toCreate.get(i), path));
        }
        size = avs.toUpate.size();
        for (i = 0; i < size; ++i) {
            this.addExecutors(exes, this.update, this.handleSubAccessValue(avs.toUpate.get(i), path));
        }
        size = avs.toDelete.size();
        for (i = 0; i < size; ++i) {
            this.addExecutors(exes, this.remove, this.handleSubAccessValue(avs.toDelete.get(i), path));
        }
        return exes.toArray(new Executable[0]);
    }

    private AccessValue handleSubAccessValue(AccessValue value, Path path) {
        if (value != null && path != null) {
            value.put("path", path);
        }
        return value;
    }

    private void addExecutors(List<Executable> exes, IBatchAccess queue, AccessValue value) throws BOSException {
        if (queue == null) {
            return;
        }
        Executable[] es = queue.execute(value);
        if (es != null) {
            for (int i = 0; i < es.length; ++i) {
                exes.add(es[i]);
            }
        }
    }

    @Override
    public int getType() {
        return 9;
    }

    static class AccessValues {
        final List<AccessValue> toUpate = new ArrayList<AccessValue>();
        final List<AccessValue> toCreate = new ArrayList<AccessValue>();
        final List<AccessValue> toDelete = new ArrayList<AccessValue>();

        AccessValues() {
        }
    }

    static interface CompositeHandler
    extends Serializable {
        public AccessValues execute(AccessValue var1) throws BOSException;

        public String getPropName();
    }
}

