/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.impl.batch;

import com.kingdee.bos.dao.ormapping.impl.SQLStringBuffer;
import com.kingdee.bos.dao.ormapping.impl.batch.AbstractSqlGenerator;
import com.kingdee.bos.dao.ormapping.impl.batch.SqlGenerateException;
import com.kingdee.bos.dao.ormapping.impl.batch.SqlParam;
import com.kingdee.util.StringUtils;

class UpdateSqlGenerator
extends AbstractSqlGenerator {
    private final SqlInfo sqlInfo;

    UpdateSqlGenerator(String tableName, SqlInfo sqlInfo) {
        super(tableName);
        this.sqlInfo = sqlInfo;
    }

    @Override
    public String getSql() throws SqlGenerateException {
        int filtersCount = this.sqlInfo.filter.items.size();
        if (filtersCount == 0) {
            throw new SqlGenerateException("update sql must have condition.");
        }
        if (this.sqlInfo.updateColumns.size() == 0) {
            return "";
        }
        SQLStringBuffer sql = new SQLStringBuffer();
        sql.append("UPDATE ");
        sql.append(this.tableName.toUpperCase());
        sql.append(" SET ");
        int len = this.sqlInfo.updateColumns.size();
        for (int i = 0; i < len; ++i) {
            sql.append(this.sqlInfo.updateColumns.get(i).toUpperCase()).append("=?");
            if (i >= len - 1) continue;
            sql.append(",");
        }
        sql.append(" where ");
        String format = this.sqlInfo.filter.filterFormat;
        if (format != null) {
            format = "(" + format + ")";
            for (int i = filtersCount - 1; i >= 0; --i) {
                format = StringUtils.replace((String)format, (String)("#" + i), (String)("~9^Nz" + i + "~9^Nz"));
            }
        }
        for (int i = 0; i < filtersCount; ++i) {
            AbstractSqlGenerator.FilterItemInfo item = this.sqlInfo.filter.items.get(i);
            String filter = item.columnName.toUpperCase() + item.compareExpression + " ?";
            if (format == null) {
                sql.append(filter);
                if (i >= filtersCount - 1) continue;
                sql.append(" and ");
                continue;
            }
            format = StringUtils.replace((String)format, (String)("~9^Nz" + i + "~9^Nz"), (String)filter);
        }
        if (format != null) {
            sql.append(format);
        }
        return sql.toString();
    }

    static class SqlInfo {
        final SqlParam.MiniList<String> updateColumns = new SqlParam.MiniList();
        final AbstractSqlGenerator.FilterInfo filter;

        SqlInfo(AbstractSqlGenerator.FilterInfo filter) {
            this.filter = filter;
        }
    }
}

