/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping.lazyload;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoader;
import com.kingdee.bos.dao.ormapping.lazyload.IObjectValueLazyLoaderClient;
import com.kingdee.bos.dao.ormapping.lazyload.Utils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class ObjectValueLazyLoader
extends AbstractBOSObject
implements IObjectValueLazyLoader,
IObjectValueLazyLoaderClient {
    private static final Logger logger = Logger.getLogger(ObjectValueLazyLoader.class);

    public ObjectValueLazyLoader(Context ctx) {
        super(ctx);
        this.registerInterface(IObjectValueLazyLoader.class, this);
    }

    public ObjectValueLazyLoader() {
        this.registerInterface(IObjectValueLazyLoader.class, this);
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public Object getProperty(IObjectValue objVal, String propName) throws DataAccessException {
        assert (propName != null && propName.length() > 0);
        if (Utils.isLoaded(objVal, propName)) {
            return objVal.get(propName);
        }
        BOSObjectType type = objVal.getBOSType();
        if (type == null) {
            throw new IllegalArgumentException("Unknown BOSType.");
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext()).getEntity(type);
        PropertyCollection props = entity.getInheritedNoDuplicatedPropertiesRuntime();
        boolean existsPropName = false;
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            if (!props.get(i).getName().equals(propName)) continue;
            existsPropName = true;
            break;
        }
        if (!existsPropName) {
            logger.warn((Object)("Property" + propName + " not defined in BO " + entity.getFullName()));
            return null;
        }
        this.fillValue(objVal);
        return objVal.get(propName);
    }

    @Override
    public IObjectValue fillProperty(IObjectValue objVal, String propName) throws DataAccessException {
        this.getProperty(objVal, propName);
        return objVal;
    }

    @Override
    public void fillValue(IObjectValue objVal) throws DataAccessException {
        assert (this.getContext() != null);
        objVal.setDefaultLocale(this.getContext().getLocale());
        BOSObjectType type = objVal.getBOSType();
        if (type == null) {
            throw new IllegalArgumentException("Unknown BOSType.");
        }
        EntityObjectInfo entity = MetaDataLoaderFactory.getMetaDataLoader((Context)this.getContext()).getEntity(type);
        IObjectPK pk = com.kingdee.bos.dao.ormapping.Utils.getObjectPK(entity, objVal);
        if (pk == null) {
            return;
        }
        if (!this.objectExists(type, pk)) {
            Enumeration e = objVal.keys();
            while (e.hasMoreElements()) {
                String pName = (String)e.nextElement();
                Utils.setLoaded(objVal, pName);
            }
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        boolean existsProp = false;
        PropertyCollection props = entity.getInheritedNoDuplicatedPropertiesRuntime();
        int n = props.size();
        for (int i = 0; i < n; ++i) {
            if (Utils.isLoaded(objVal, props.get(i).getName())) continue;
            this.addSelector(selector, entity, props.get(i));
        }
        if (!existsProp) {
            // empty if block
        }
        if (selector.size() == 0) {
            return;
        }
        IObjectValue objVal1 = this.getValue(type, pk, selector);
        Enumeration e = objVal1.keys();
        while (e.hasMoreElements()) {
            String pName = (String)e.nextElement();
            if (Utils.isLoaded(objVal, pName)) continue;
            objVal.put(pName, objVal1.get(pName));
            Utils.setLoaded(objVal, pName);
        }
    }

    private boolean objectExists(BOSObjectType type, IObjectPK pk) throws DataAccessException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(this.getContext());
            IORMappingDAO dao = ORMappingDAO.getInstance(type, this.getContext(), cn);
            boolean bl = dao.exists(pk);
            return bl;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private IObjectValue getValue(BOSObjectType type, IObjectPK pk, SelectorItemCollection selector) throws DataAccessException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(this.getContext());
            IORMappingDAO dao = ORMappingDAO.getInstance(type, this.getContext(), cn);
            IObjectValue iObjectValue = dao.getValue(pk, selector);
            return iObjectValue;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    private void addSelector(SelectorItemCollection selector, EntityObjectInfo entity, PropertyInfo prop) {
        if (prop instanceof OwnPropertyInfo) {
            selector.add(prop.getName());
        } else if (prop instanceof LinkPropertyInfo) {
            EntityObjectInfo linkEntity = ((LinkPropertyInfo)prop).getRelationship().getChildObject(entity);
            PropertyCollection keyProps = linkEntity.getLogicalKeyPropertiesRuntime();
            int n = keyProps.size();
            for (int i = 0; i < n; ++i) {
                selector.add(prop.getName() + "." + keyProps.get(i).getName());
            }
        } else assert (false);
    }
}

