/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.ast;

import com.kingdee.bos.dao.ormapping_ex.ast.AbstractDataQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.AbstractTableSource;
import com.kingdee.bos.dao.ormapping_ex.ast.CaseItem;
import com.kingdee.bos.dao.ormapping_ex.ast.DistinctOption;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByItem;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByMode;
import com.kingdee.bos.dao.ormapping_ex.ast.SelectItem;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AggregateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BetweenExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BinaryOpExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CaseExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.InListExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.LiteralExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.MethodInvokeExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NotExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NullExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ObjectCreateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.VarRefExpr;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.util.TODOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataQuery
extends AbstractDataQuery
implements Serializable {
    private DistinctOption distinctOption;
    private int top;
    private final List selectList = new ArrayList();
    private Set lockingHints = new HashSet();
    private Map optionMap = null;
    private Set queryHints = new HashSet();
    private ExprNode where;
    private List groupByItemList;
    private ExprNode having;
    private AbstractTableSource tableSource;

    public DistinctOption getDistinctOption() {
        return this.distinctOption;
    }

    public void setDistinctOption(DistinctOption distinctOption) {
        this.distinctOption = distinctOption;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public ExprNode getFilterCondition() {
        return this.where;
    }

    public void setFilterCondition(ExprNode where) {
        this.where = where;
    }

    public Set getLockingHints() {
        return this.lockingHints;
    }

    @Override
    public List getOrderByItemList() {
        return this.orderByItemList;
    }

    public Set getQueryHints() {
        return this.queryHints;
    }

    public void populateLiteral(Collection literalCollection, Collection assignToCollection) {
        this.populateConditionLiteral(literalCollection, assignToCollection, true);
    }

    public void populateConditionLiteral(Collection literalCollection, Collection assignToCollection, boolean replace) {
        if (literalCollection == null) {
            throw new IllegalArgumentException("identCollection");
        }
        this.where = this.populateLiteral(this.where, literalCollection, assignToCollection, replace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExprNode populateLiteral(ExprNode expr, Collection identCollection, Collection assignToCollection, boolean replace) {
        if (expr == null) {
            return expr;
        }
        if (expr instanceof LiteralExpr) {
            LiteralExpr literalExpr = (LiteralExpr)expr;
            if (literalExpr instanceof NullExpr) return expr;
            identCollection.add(literalExpr.getValue());
            if (!replace) return expr;
            expr = new VarRefExpr("?");
            assignToCollection.add(null);
            return expr;
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            if ((binaryOpExpr.left instanceof IdentifierExpr || binaryOpExpr.left instanceof PropertyExpr) && binaryOpExpr.right instanceof LiteralExpr) {
                assignToCollection.add(binaryOpExpr.left.toString());
                LiteralExpr literalExpr = (LiteralExpr)binaryOpExpr.right;
                identCollection.add(literalExpr.getValue());
                binaryOpExpr.right = new VarRefExpr("?");
                return expr;
            } else {
                binaryOpExpr.left = this.populateLiteral(binaryOpExpr.left, identCollection, assignToCollection, replace);
                binaryOpExpr.right = this.populateLiteral(binaryOpExpr.right, identCollection, assignToCollection, replace);
            }
            return expr;
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (int i = 0; i < methodInvokeExpr.parameters.size(); ++i) {
                ExprNode pramExpr = (ExprNode)methodInvokeExpr.parameters.get(i);
                pramExpr = this.populateLiteral(pramExpr, identCollection, assignToCollection, replace);
                methodInvokeExpr.parameters.set(i, pramExpr);
            }
            return expr;
        } else if (expr instanceof AggregateExpr) {
            AggregateExpr aggregateExpr = (AggregateExpr)expr;
            for (int i = 0; i < aggregateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)aggregateExpr.paramList.get(i);
                pramExpr = this.populateLiteral(pramExpr, identCollection, assignToCollection, replace);
                aggregateExpr.paramList.set(i, pramExpr);
            }
            return expr;
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (int i = 0; i < objCreateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)objCreateExpr.paramList.get(i);
                pramExpr = this.populateLiteral(pramExpr, identCollection, assignToCollection, replace);
                objCreateExpr.paramList.set(i, pramExpr);
            }
            return expr;
        } else if (expr instanceof CaseExpr) {
            CaseExpr caseExpr = (CaseExpr)expr;
            caseExpr.valueExpr = this.populateLiteral(caseExpr.valueExpr, identCollection, assignToCollection, replace);
            for (CaseItem caseItem : caseExpr.itemList) {
                caseItem.conditionExpr = this.populateLiteral(caseItem.conditionExpr, identCollection, assignToCollection, replace);
                caseItem.valueExpr = this.populateLiteral(caseItem.valueExpr, identCollection, assignToCollection, replace);
            }
            this.populateLiteral(caseExpr.elseExpr, identCollection, assignToCollection, replace);
            return expr;
        } else if (expr instanceof BetweenExpr) {
            BetweenExpr betweenExpr = (BetweenExpr)expr;
            betweenExpr.testExpr = this.populateLiteral(betweenExpr.testExpr, identCollection, assignToCollection, replace);
            betweenExpr.beginExpr = this.populateLiteral(betweenExpr.beginExpr, identCollection, assignToCollection, replace);
            betweenExpr.endExpr = this.populateLiteral(betweenExpr.endExpr, identCollection, assignToCollection, replace);
            return expr;
        } else if (expr instanceof InListExpr) {
            InListExpr inListExpr = (InListExpr)expr;
            if (!(inListExpr.expr instanceof IdentifierExpr) && !(inListExpr.expr instanceof PropertyExpr)) throw new TODOException();
            for (int i = 0; i < inListExpr.targetList.size(); ++i) {
                ExprNode targetExpr = (ExprNode)inListExpr.targetList.get(i);
                if (targetExpr instanceof LiteralExpr) {
                    LiteralExpr literalExpr = (LiteralExpr)targetExpr;
                    assignToCollection.add(inListExpr.expr.toString());
                    identCollection.add(literalExpr.getValue());
                    targetExpr = new VarRefExpr("?");
                } else {
                    targetExpr = this.populateLiteral(targetExpr, identCollection, assignToCollection, replace);
                }
                inListExpr.targetList.set(i, targetExpr);
            }
            return expr;
        } else {
            if (!(expr instanceof NotExpr)) return expr;
            NotExpr notExpr = (NotExpr)expr;
            notExpr.expr = this.populateLiteral(notExpr.expr, identCollection, assignToCollection, replace);
        }
        return expr;
    }

    public void populateIdentifier(Collection identCollection) {
        this.populateIdentifier(identCollection, true);
    }

    public void populateIdentifier(Collection identCollection, boolean includeSelect) {
        if (identCollection == null) {
            throw new IllegalArgumentException("identCollection");
        }
        if (includeSelect && this.selectList != null) {
            for (ExprNode expr : this.selectList) {
                this.computeIdent(expr, identCollection);
            }
        }
        this.computeIdent(this.where, identCollection);
        if (this.orderByItemList != null) {
            for (OrderByItem orderByItem : this.orderByItemList) {
                this.computeIdent(orderByItem.expr, identCollection);
            }
        }
    }

    private void computeIdent(ExprNode expr, Collection identCollection) {
        if (expr == null) {
            return;
        }
        if (expr instanceof IdentifierExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof PropertyExpr) {
            identCollection.add(expr.toString());
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            this.computeIdent(binaryOpExpr.left, identCollection);
            this.computeIdent(binaryOpExpr.right, identCollection);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (ExprNode pramExpr : methodInvokeExpr.parameters) {
                this.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof AggregateExpr) {
            AggregateExpr aggregateExpr = (AggregateExpr)expr;
            for (ExprNode pramExpr : aggregateExpr.paramList) {
                this.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (ExprNode pramExpr : objCreateExpr.paramList) {
                this.computeIdent(pramExpr, identCollection);
            }
        } else if (expr instanceof CaseExpr) {
            CaseExpr caseExpr = (CaseExpr)expr;
            this.computeIdent(caseExpr.valueExpr, identCollection);
            for (CaseItem caseItem : caseExpr.itemList) {
                this.computeIdent(caseItem.conditionExpr, identCollection);
                this.computeIdent(caseItem.valueExpr, identCollection);
            }
            this.computeIdent(caseExpr.elseExpr, identCollection);
        } else if (expr instanceof BetweenExpr) {
            BetweenExpr betweenExpr = (BetweenExpr)expr;
            this.computeIdent(betweenExpr.testExpr, identCollection);
            this.computeIdent(betweenExpr.beginExpr, identCollection);
            this.computeIdent(betweenExpr.endExpr, identCollection);
        } else if (expr instanceof InListExpr) {
            InListExpr inListExpr = (InListExpr)expr;
            this.computeIdent(inListExpr.expr, identCollection);
            for (ExprNode targetExpr : inListExpr.targetList) {
                this.computeIdent(targetExpr, identCollection);
            }
        } else if (expr instanceof NotExpr) {
            NotExpr notExpr = (NotExpr)expr;
            this.computeIdent(notExpr.expr, identCollection);
        }
    }

    private static ExprNode buildExpr(String ident) {
        ExprNode rtnVal = null;
        if (ident.indexOf(46) > 0) {
            String[] strArray = ident.split("\\.");
            for (int i = 0; i < strArray.length; ++i) {
                rtnVal = i == 0 ? new IdentifierExpr(strArray[i]) : new PropertyExpr(rtnVal, strArray[i]);
            }
        } else {
            rtnVal = new IdentifierExpr(ident);
        }
        return rtnVal;
    }

    public void replaceFilterAndSorterIdent(Map identMap) {
        if (identMap == null) {
            throw new IllegalArgumentException("identCollection");
        }
        this.where = DataQuery.replaceIdent(this.where, identMap);
        if (this.orderByItemList != null) {
            for (OrderByItem orderByItem : this.orderByItemList) {
                orderByItem.expr = DataQuery.replaceIdent(orderByItem.expr, identMap);
            }
        }
    }

    public void replaceSelectListIdent(Map identMap) {
        if (identMap == null) {
            throw new IllegalArgumentException("identCollection");
        }
        if (this.selectList != null) {
            for (int i = 0; i < this.selectList.size(); ++i) {
                ExprNode expr = (ExprNode)this.selectList.get(i);
                expr = DataQuery.replaceIdent(expr, identMap);
                this.selectList.set(i, expr);
            }
        }
    }

    private static ExprNode replaceIdent(ExprNode expr, Map identMap) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof IdentifierExpr) {
            String ident = expr.toString();
            Object val = identMap.get(ident);
            if (val instanceof String) {
                String valStr = (String)val;
                return DataQuery.buildExpr(valStr);
            }
            if (val instanceof ExprNode) {
                return (ExprNode)val;
            }
            throw new TODOException();
        }
        if (expr instanceof PropertyExpr) {
            String ident = expr.toString();
            Object val = identMap.get(ident);
            if (val != null) {
                if (val instanceof String) {
                    String valStr = (String)val;
                    return DataQuery.buildExpr(valStr);
                }
                if (val instanceof ExprNode) {
                    return (ExprNode)val;
                }
                throw new TODOException();
            }
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            binaryOpExpr.left = DataQuery.replaceIdent(binaryOpExpr.left, identMap);
            binaryOpExpr.right = DataQuery.replaceIdent(binaryOpExpr.right, identMap);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (int i = 0; i < methodInvokeExpr.parameters.size(); ++i) {
                ExprNode pramExpr = (ExprNode)methodInvokeExpr.parameters.get(i);
                pramExpr = DataQuery.replaceIdent(pramExpr, identMap);
                methodInvokeExpr.parameters.set(i, pramExpr);
            }
        } else if (expr instanceof AggregateExpr) {
            AggregateExpr aggregateExpr = (AggregateExpr)expr;
            for (int i = 0; i < aggregateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)aggregateExpr.paramList.get(i);
                pramExpr = DataQuery.replaceIdent(pramExpr, identMap);
                aggregateExpr.paramList.set(i, pramExpr);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (int i = 0; i < objCreateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)objCreateExpr.paramList.get(i);
                pramExpr = DataQuery.replaceIdent(pramExpr, identMap);
                objCreateExpr.paramList.set(i, pramExpr);
            }
        } else if (expr instanceof CaseExpr) {
            CaseExpr caseExpr = (CaseExpr)expr;
            caseExpr.valueExpr = DataQuery.replaceIdent(caseExpr.valueExpr, identMap);
            for (CaseItem caseItem : caseExpr.itemList) {
                caseItem.conditionExpr = DataQuery.replaceIdent(caseItem.conditionExpr, identMap);
                caseItem.valueExpr = DataQuery.replaceIdent(caseItem.valueExpr, identMap);
            }
            caseExpr.elseExpr = DataQuery.replaceIdent(caseExpr.elseExpr, identMap);
        } else if (expr instanceof BetweenExpr) {
            BetweenExpr betweenExpr = (BetweenExpr)expr;
            betweenExpr.testExpr = DataQuery.replaceIdent(betweenExpr.testExpr, identMap);
            betweenExpr.beginExpr = DataQuery.replaceIdent(betweenExpr.beginExpr, identMap);
            betweenExpr.endExpr = DataQuery.replaceIdent(betweenExpr.endExpr, identMap);
        } else if (expr instanceof InListExpr) {
            InListExpr inListExpr = (InListExpr)expr;
            inListExpr.expr = DataQuery.replaceIdent(inListExpr.expr, identMap);
            for (int i = 0; i < inListExpr.targetList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)inListExpr.targetList.get(i);
                pramExpr = DataQuery.replaceIdent(pramExpr, identMap);
                inListExpr.targetList.set(i, pramExpr);
            }
        } else if (expr instanceof NotExpr) {
            NotExpr notExpr = (NotExpr)expr;
            notExpr.expr = DataQuery.replaceIdent(notExpr.expr, identMap);
        }
        return expr;
    }

    @Override
    public void output(StringBuffer buff) {
        Iterator iter;
        boolean flag;
        if (!(this.selectList == null && this.top == -1 && this.distinctOption.equals(DistinctOption.All) || this.selectList == null)) {
            buff.append("SELECT ");
            if (this.distinctOption != null && this.distinctOption.equals(DistinctOption.Distinct)) {
                buff.append("DISTINCT ");
            }
            if (this.top > 0) {
                buff.append("TOP ");
                buff.append(this.top);
                buff.append(' ');
            }
            flag = false;
            iter = this.selectList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    buff.append(", ");
                }
                SelectItem selectItem = (SelectItem)iter.next();
                ExprNode expr = selectItem.expr;
                String alias = selectItem.alias;
                expr.output(buff, null);
                if (alias != null) {
                    buff.append(" ");
                    buff.append(alias);
                }
                flag = true;
            }
            if (flag) {
                buff.append(' ');
            } else {
                buff.append("* ");
            }
        }
        if (this.lockingHints != null && this.lockingHints.size() != 0) {
            throw new TODOException();
        }
        if (this.tableSource != null) {
            buff.append("FROM ");
            this.tableSource.output(buff, null);
            buff.append(' ');
        }
        if (this.where != null) {
            buff.append("WHERE ");
            this.where.output(buff, null);
            buff.append(' ');
        }
        if (this.groupByItemList != null && this.groupByItemList.size() != 0) {
            buff.append("GROUP BY ");
            for (int i = 0; i < this.groupByItemList.size(); ++i) {
                if (i != 0) {
                    buff.append(", ");
                }
                ExprNode groupByItem = (ExprNode)this.groupByItemList.get(i);
                groupByItem.output(buff, null);
            }
            buff.append(' ');
        }
        if (this.having != null) {
            buff.append("HAVING ");
            this.having.output(buff, null);
            buff.append(' ');
        }
        if (this.orderByItemList != null && this.orderByItemList.size() != 0) {
            buff.append("ORDER BY ");
            flag = false;
            iter = this.orderByItemList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    buff.append(", ");
                }
                OrderByItem orderByItem = (OrderByItem)iter.next();
                orderByItem.expr.output(buff, null);
                if (orderByItem.mode == OrderByMode.Asc) {
                    buff.append(" ASC");
                } else {
                    buff.append(" DESC");
                }
                flag = true;
            }
            if (flag) {
                buff.append(' ');
            } else {
                buff.append("* ");
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public EntityViewInfo buildEntityViewInfo() throws ParserException {
        String oql = this.toString();
        EntityViewInfo rtnVal = new EntityViewInfo(oql);
        return rtnVal;
    }

    public List getSelectList() {
        return this.selectList;
    }

    public void addLockHints(String hints) {
        if (this.lockingHints == null) {
            this.lockingHints = new HashSet();
        }
        this.lockingHints.add(hints);
    }

    public List getGroupByItemList() {
        if (this.groupByItemList == null) {
            this.groupByItemList = new ArrayList();
        }
        return this.groupByItemList;
    }

    public void setGroupByItemList(List groupByItemList) {
        this.groupByItemList = groupByItemList;
    }

    public synchronized Map getOptionMap() {
        if (this.optionMap == null) {
            this.optionMap = new HashMap();
        }
        return this.optionMap;
    }

    public ExprNode getHaving() {
        return this.having;
    }

    public void setHaving(ExprNode having) {
        this.having = having;
    }

    public AbstractTableSource getTableSource() {
        return this.tableSource;
    }

    public void setTableSource(AbstractTableSource tableSource) {
        this.tableSource = tableSource;
    }
}

