/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.ast;

import com.kingdee.bos.dao.ormapping_ex.OQLException;
import com.kingdee.bos.dao.ormapping_ex.ast.AbstractQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.CaseItem;
import com.kingdee.bos.dao.ormapping_ex.ast.DistinctOption;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByItem;
import com.kingdee.bos.dao.ormapping_ex.ast.OrderByMode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AggregateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BetweenExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BinaryOpExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CaseExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.InListExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.LiteralExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.MethodInvokeExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NotExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NullExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ObjectCreateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.VarRefExpr;
import com.kingdee.bos.dao.ormapping_ex.parser.ExprParser;
import com.kingdee.bos.dao.ormapping_ex.parser.KeyWord;
import com.kingdee.bos.dao.ormapping_ex.parser.Lexer;
import com.kingdee.bos.dao.ormapping_ex.parser.OQLParserException;
import com.kingdee.bos.dao.ormapping_ex.parser.Token;
import com.kingdee.bos.dao.ormapping_ex.parser.TokenList;
import com.kingdee.bos.dao.ormapping_ex.runtime.QueryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.util.TODOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectQuery
extends AbstractQuery
implements Serializable {
    protected static final String[] KEYWORDS = new String[]{"AND", "OR"};
    private String entityName;
    private String alias;
    private DistinctOption distinctOption;
    private int top;
    private final List selectList;
    private Set lockingHints;
    private Set queryHints;
    private ExprNode where;
    private List orderByItemList;
    private Map entriesFilter;

    public ObjectQuery(String entityName, String oql) throws OQLException {
        this.entityName = entityName;
        this.selectList = new ArrayList();
        this.orderByItemList = new ArrayList();
        this.lockingHints = new HashSet();
        this.queryHints = new HashSet();
        if (oql == null || oql.length() == 0) {
            oql = "select *";
        }
        this.parse(oql);
    }

    public ObjectQuery(String oql) throws OQLException {
        this(null, oql);
    }

    public ObjectQuery(String entityName, EntityViewInfo entityViewInfo) throws OQLParserException {
        this.selectList = new ArrayList();
        this.entityName = entityName;
        String oql = entityViewInfo.toString();
        this.parse(oql);
    }

    private void parse(String oql) throws OQLParserException {
        KeyWord keyword = new KeyWord(KEYWORDS);
        Lexer lexer = new Lexer(keyword, oql);
        TokenList tokList = new TokenList(lexer);
        if (tokList.lookup((int)0).value.equalsIgnoreCase("SELECT")) {
            this.parseSelectList(tokList);
        }
        if (tokList.lookup((int)0).value.equalsIgnoreCase("FROM")) {
            tokList.match();
            this.entityName = tokList.lookup((int)0).value;
            tokList.match();
        }
        if (tokList.lookup((int)0).value.equalsIgnoreCase("WHERE")) {
            this.parseFilterCondition(tokList);
        }
        if (tokList.lookup((int)0).value.equalsIgnoreCase("ENTRYWHERE")) {
            this.parseEntryFilterCondition(tokList);
        }
        if (tokList.lookup((int)0).value.equalsIgnoreCase("ORDER")) {
            this.parseSorterList(tokList);
        }
    }

    private void parseSelectList(TokenList tokList) throws OQLParserException {
        tokList.match();
        if (tokList.lookup((int)0).value.equalsIgnoreCase("WHERE")) {
            return;
        }
        ExprParser exprParser = new ExprParser(tokList);
        if (tokList.lookup((int)0).value.equalsIgnoreCase("DISTINCT")) {
            tokList.match();
            this.distinctOption = DistinctOption.Distinct;
        } else if (tokList.lookup((int)0).value.equalsIgnoreCase("ALL")) {
            this.distinctOption = DistinctOption.All;
        }
        if (tokList.lookup((int)0).value.equalsIgnoreCase("TOP")) {
            int topNumber;
            tokList.match();
            String topText = tokList.lookup((int)0).value;
            this.top = topNumber = Integer.parseInt(topText);
            tokList.match();
        }
        exprParser.exprList(this.selectList);
    }

    private void parseEntryFilterCondition(TokenList tokList) throws OQLParserException {
        do {
            tokList.match();
            ExprParser exprParser = new ExprParser(tokList);
            ExprNode expr = exprParser.expr();
            tokList.match(1, "ON", true);
            ExprNode entriesNameExpr = exprParser.expr();
            String entriesName = entriesNameExpr.toString();
            if (this.entriesFilter == null) {
                this.entriesFilter = new HashMap();
            }
            this.entriesFilter.put(entriesName, expr);
        } while (tokList.lookup((int)0).value.equalsIgnoreCase("ENTRYWHERE"));
    }

    private void parseFilterCondition(TokenList tokList) throws OQLParserException {
        tokList.match();
        ExprParser exprParser = new ExprParser(tokList);
        this.where = exprParser.expr();
    }

    private void parseSorterList(TokenList tokList) throws OQLParserException {
        ExprNode expr;
        tokList.match();
        if (!tokList.lookup((int)0).value.equalsIgnoreCase("BY")) {
            throw new OQLParserException("after 'ORDER' must 'BY'");
        }
        tokList.match();
        ExprParser exprParser = new ExprParser(tokList);
        OrderByItem orderByItem = new OrderByItem();
        orderByItem.expr = expr = exprParser.expr();
        if (tokList.lookup((int)0).value.equalsIgnoreCase("ASC")) {
            orderByItem.mode = OrderByMode.Asc;
            tokList.match();
        } else if (tokList.lookup((int)0).value.equalsIgnoreCase("DESC")) {
            orderByItem.mode = OrderByMode.Desc;
            tokList.match();
        }
        this.orderByItemList.add(orderByItem);
        while (tokList.lookup(0).equals(Token.CommaToken)) {
            tokList.match();
            orderByItem = new OrderByItem();
            orderByItem.expr = expr = exprParser.expr();
            if (tokList.lookup((int)0).value.equalsIgnoreCase("ASC")) {
                orderByItem.mode = OrderByMode.Asc;
                tokList.match();
            } else if (tokList.lookup((int)0).value.equalsIgnoreCase("DESC")) {
                orderByItem.mode = OrderByMode.Desc;
                tokList.match();
            }
            this.orderByItemList.add(orderByItem);
        }
    }

    public DistinctOption getDistinctOption() {
        return this.distinctOption;
    }

    public void setDistinctOption(DistinctOption distinctOption) {
        this.distinctOption = distinctOption;
    }

    public int getTop() {
        return this.top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public ExprNode getFilterCondition() {
        return this.where;
    }

    public void setFilterCondition(ExprNode where) {
        this.where = where;
    }

    public Set getLockingHints() {
        return this.lockingHints;
    }

    public List getOrderByItemList() {
        return this.orderByItemList;
    }

    public Set getQueryHints() {
        return this.queryHints;
    }

    public void populateLiteral(Collection literalCollection, Collection assignToCollection) {
        this.populateConditionLiteral(literalCollection, assignToCollection, true);
    }

    public void populateConditionLiteral(Collection literalCollection, Collection assignToCollection, boolean replace) {
        if (literalCollection == null) {
            throw new IllegalArgumentException("identCollection");
        }
        this.where = this.populateLiteral(this.where, literalCollection, assignToCollection, replace);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExprNode populateLiteral(ExprNode expr, Collection identCollection, Collection assignToCollection, boolean replace) {
        if (expr == null) {
            return expr;
        }
        if (expr instanceof LiteralExpr) {
            LiteralExpr literalExpr = (LiteralExpr)expr;
            if (literalExpr instanceof NullExpr) return expr;
            identCollection.add(literalExpr.getValue());
            if (!replace) return expr;
            expr = new VarRefExpr("?");
            assignToCollection.add(null);
            return expr;
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            if ((binaryOpExpr.left instanceof IdentifierExpr || binaryOpExpr.left instanceof PropertyExpr) && binaryOpExpr.right instanceof LiteralExpr) {
                assignToCollection.add(binaryOpExpr.left.toString());
                LiteralExpr literalExpr = (LiteralExpr)binaryOpExpr.right;
                identCollection.add(literalExpr.getValue());
                binaryOpExpr.right = new VarRefExpr("?");
                return expr;
            } else {
                binaryOpExpr.left = this.populateLiteral(binaryOpExpr.left, identCollection, assignToCollection, replace);
                binaryOpExpr.right = this.populateLiteral(binaryOpExpr.right, identCollection, assignToCollection, replace);
            }
            return expr;
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (int i = 0; i < methodInvokeExpr.parameters.size(); ++i) {
                ExprNode pramExpr = (ExprNode)methodInvokeExpr.parameters.get(i);
                pramExpr = this.populateLiteral(pramExpr, identCollection, assignToCollection, replace);
                methodInvokeExpr.parameters.set(i, pramExpr);
            }
            return expr;
        } else if (expr instanceof AggregateExpr) {
            AggregateExpr aggregateExpr = (AggregateExpr)expr;
            for (int i = 0; i < aggregateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)aggregateExpr.paramList.get(i);
                pramExpr = this.populateLiteral(pramExpr, identCollection, assignToCollection, replace);
                aggregateExpr.paramList.set(i, pramExpr);
            }
            return expr;
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (int i = 0; i < objCreateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)objCreateExpr.paramList.get(i);
                pramExpr = this.populateLiteral(pramExpr, identCollection, assignToCollection, replace);
                objCreateExpr.paramList.set(i, pramExpr);
            }
            return expr;
        } else if (expr instanceof CaseExpr) {
            CaseExpr caseExpr = (CaseExpr)expr;
            caseExpr.valueExpr = this.populateLiteral(caseExpr.valueExpr, identCollection, assignToCollection, replace);
            for (CaseItem caseItem : caseExpr.itemList) {
                caseItem.conditionExpr = this.populateLiteral(caseItem.conditionExpr, identCollection, assignToCollection, replace);
                caseItem.valueExpr = this.populateLiteral(caseItem.valueExpr, identCollection, assignToCollection, replace);
            }
            this.populateLiteral(caseExpr.elseExpr, identCollection, assignToCollection, replace);
            return expr;
        } else if (expr instanceof BetweenExpr) {
            BetweenExpr betweenExpr = (BetweenExpr)expr;
            betweenExpr.testExpr = this.populateLiteral(betweenExpr.testExpr, identCollection, assignToCollection, replace);
            betweenExpr.beginExpr = this.populateLiteral(betweenExpr.beginExpr, identCollection, assignToCollection, replace);
            betweenExpr.endExpr = this.populateLiteral(betweenExpr.endExpr, identCollection, assignToCollection, replace);
            return expr;
        } else if (expr instanceof InListExpr) {
            InListExpr inListExpr = (InListExpr)expr;
            if (!(inListExpr.expr instanceof IdentifierExpr) && !(inListExpr.expr instanceof PropertyExpr)) throw new TODOException();
            for (int i = 0; i < inListExpr.targetList.size(); ++i) {
                ExprNode targetExpr = (ExprNode)inListExpr.targetList.get(i);
                if (targetExpr instanceof LiteralExpr) {
                    LiteralExpr literalExpr = (LiteralExpr)targetExpr;
                    assignToCollection.add(inListExpr.expr.toString());
                    identCollection.add(literalExpr.getValue());
                    targetExpr = new VarRefExpr("?");
                } else {
                    targetExpr = this.populateLiteral(targetExpr, identCollection, assignToCollection, replace);
                }
                inListExpr.targetList.set(i, targetExpr);
            }
            return expr;
        } else {
            if (!(expr instanceof NotExpr)) return expr;
            NotExpr notExpr = (NotExpr)expr;
            notExpr.expr = this.populateLiteral(notExpr.expr, identCollection, assignToCollection, replace);
        }
        return expr;
    }

    public void populateIdentifier(Collection identCollection) {
        this.populateIdentifier(identCollection, true);
    }

    public void populateIdentifier(Collection identCollection, boolean includeSelect) {
        if (identCollection == null) {
            throw new IllegalArgumentException("identCollection");
        }
        if (includeSelect && this.selectList != null) {
            for (ExprNode expr : this.selectList) {
                QueryUtil.computeIdent(expr, identCollection);
            }
        }
        QueryUtil.computeIdent(this.where, identCollection);
        if (this.orderByItemList != null) {
            for (OrderByItem orderByItem : this.orderByItemList) {
                QueryUtil.computeIdent(orderByItem.expr, identCollection);
            }
        }
        if (this.entriesFilter != null) {
            for (ExprNode filterExpr : this.entriesFilter.values()) {
                QueryUtil.computeIdent(filterExpr, identCollection);
            }
        }
    }

    private static ExprNode buildExpr(String ident) {
        ExprNode rtnVal = null;
        if (ident.indexOf(46) > 0) {
            String[] strArray = ident.split("\\.");
            for (int i = 0; i < strArray.length; ++i) {
                rtnVal = i == 0 ? new IdentifierExpr(strArray[i]) : new PropertyExpr(rtnVal, strArray[i]);
            }
        } else {
            rtnVal = new IdentifierExpr(ident);
        }
        return rtnVal;
    }

    public void replaceFilterAndSorterIdent(Map identMap) {
        if (identMap == null) {
            throw new IllegalArgumentException("identCollection");
        }
        this.where = ObjectQuery.replaceIdent(this.where, identMap);
        if (this.orderByItemList != null) {
            for (OrderByItem orderByItem : this.orderByItemList) {
                orderByItem.expr = ObjectQuery.replaceIdent(orderByItem.expr, identMap);
            }
        }
    }

    public void replaceSelectListIdent(Map identMap) {
        if (identMap == null) {
            throw new IllegalArgumentException("identCollection");
        }
        if (this.selectList != null) {
            for (int i = 0; i < this.selectList.size(); ++i) {
                ExprNode expr = (ExprNode)this.selectList.get(i);
                expr = ObjectQuery.replaceIdent(expr, identMap);
                this.selectList.set(i, expr);
            }
        }
    }

    private static ExprNode replaceIdent(ExprNode expr, Map identMap) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof IdentifierExpr) {
            String ident = expr.toString();
            Object val = identMap.get(ident);
            if (val instanceof String) {
                String valStr = (String)val;
                return ObjectQuery.buildExpr(valStr);
            }
            if (val instanceof ExprNode) {
                return (ExprNode)val;
            }
            throw new TODOException();
        }
        if (expr instanceof PropertyExpr) {
            String ident = expr.toString();
            Object val = identMap.get(ident);
            if (val != null) {
                if (val instanceof String) {
                    String valStr = (String)val;
                    return ObjectQuery.buildExpr(valStr);
                }
                if (val instanceof ExprNode) {
                    return (ExprNode)val;
                }
                throw new TODOException();
            }
        } else if (expr instanceof BinaryOpExpr) {
            BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
            binaryOpExpr.left = ObjectQuery.replaceIdent(binaryOpExpr.left, identMap);
            binaryOpExpr.right = ObjectQuery.replaceIdent(binaryOpExpr.right, identMap);
        } else if (expr instanceof MethodInvokeExpr) {
            MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
            for (int i = 0; i < methodInvokeExpr.parameters.size(); ++i) {
                ExprNode pramExpr = (ExprNode)methodInvokeExpr.parameters.get(i);
                pramExpr = ObjectQuery.replaceIdent(pramExpr, identMap);
                methodInvokeExpr.parameters.set(i, pramExpr);
            }
        } else if (expr instanceof AggregateExpr) {
            AggregateExpr aggregateExpr = (AggregateExpr)expr;
            for (int i = 0; i < aggregateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)aggregateExpr.paramList.get(i);
                pramExpr = ObjectQuery.replaceIdent(pramExpr, identMap);
                aggregateExpr.paramList.set(i, pramExpr);
            }
        } else if (expr instanceof ObjectCreateExpr) {
            ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
            for (int i = 0; i < objCreateExpr.paramList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)objCreateExpr.paramList.get(i);
                pramExpr = ObjectQuery.replaceIdent(pramExpr, identMap);
                objCreateExpr.paramList.set(i, pramExpr);
            }
        } else if (expr instanceof CaseExpr) {
            CaseExpr caseExpr = (CaseExpr)expr;
            caseExpr.valueExpr = ObjectQuery.replaceIdent(caseExpr.valueExpr, identMap);
            for (CaseItem caseItem : caseExpr.itemList) {
                caseItem.conditionExpr = ObjectQuery.replaceIdent(caseItem.conditionExpr, identMap);
                caseItem.valueExpr = ObjectQuery.replaceIdent(caseItem.valueExpr, identMap);
            }
            caseExpr.elseExpr = ObjectQuery.replaceIdent(caseExpr.elseExpr, identMap);
        } else if (expr instanceof BetweenExpr) {
            BetweenExpr betweenExpr = (BetweenExpr)expr;
            betweenExpr.testExpr = ObjectQuery.replaceIdent(betweenExpr.testExpr, identMap);
            betweenExpr.beginExpr = ObjectQuery.replaceIdent(betweenExpr.beginExpr, identMap);
            betweenExpr.endExpr = ObjectQuery.replaceIdent(betweenExpr.endExpr, identMap);
        } else if (expr instanceof InListExpr) {
            InListExpr inListExpr = (InListExpr)expr;
            inListExpr.expr = ObjectQuery.replaceIdent(inListExpr.expr, identMap);
            for (int i = 0; i < inListExpr.targetList.size(); ++i) {
                ExprNode pramExpr = (ExprNode)inListExpr.targetList.get(i);
                pramExpr = ObjectQuery.replaceIdent(pramExpr, identMap);
                inListExpr.targetList.set(i, pramExpr);
            }
        } else if (expr instanceof NotExpr) {
            NotExpr notExpr = (NotExpr)expr;
            notExpr.expr = ObjectQuery.replaceIdent(notExpr.expr, identMap);
        }
        return expr;
    }

    @Override
    public void output(StringBuffer buff) {
        Iterator iter;
        boolean flag;
        if (this.selectList != null || this.top != -1 || !this.distinctOption.equals(DistinctOption.All)) {
            buff.append("SELECT ");
            if (this.distinctOption != null && this.distinctOption.equals(DistinctOption.Distinct)) {
                buff.append("DISTINCT ");
            }
            if (this.top > 0) {
                buff.append("TOP ");
                buff.append(this.top);
                buff.append(' ');
            }
            flag = false;
            iter = this.selectList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    buff.append(", ");
                }
                ExprNode expr = (ExprNode)iter.next();
                expr.output(buff, null);
                flag = true;
            }
            if (flag) {
                buff.append(' ');
            } else {
                buff.append("* ");
            }
        }
        if (this.lockingHints != null && this.lockingHints.size() != 0) {
            throw new TODOException();
        }
        if (this.entityName != null) {
            buff.append("FROM ");
            buff.append(this.entityName);
            buff.append(' ');
        }
        if (this.where != null) {
            buff.append("WHERE ");
            this.where.output(buff, null);
        }
        if (this.entriesFilter != null) {
            Iterator iter2 = this.entriesFilter.entrySet().iterator();
            while (iter2.hasNext()) {
                buff.append(' ');
                Map.Entry entry = iter2.next();
                String entryName = (String)entry.getKey();
                ExprNode entryFilter = (ExprNode)entry.getValue();
                buff.append("entryWHERE ");
                entryFilter.output(buff);
                buff.append(" ON ");
                buff.append(entryName);
            }
        }
        if (this.orderByItemList != null && this.orderByItemList.size() != 0) {
            buff.append(" ORDER BY ");
            flag = false;
            iter = this.orderByItemList.iterator();
            while (iter.hasNext()) {
                if (flag) {
                    buff.append(", ");
                }
                OrderByItem orderByItem = (OrderByItem)iter.next();
                orderByItem.expr.output(buff, null);
                if (orderByItem.mode == OrderByMode.Asc) {
                    buff.append(" ASC");
                } else {
                    buff.append(" DESC");
                }
                flag = true;
            }
            if (flag) {
                buff.append(' ');
            } else {
                buff.append("* ");
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public EntityViewInfo buildEntityViewInfo() throws ParserException {
        String oql = this.toString();
        EntityViewInfo rtnVal = new EntityViewInfo(oql);
        return rtnVal;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public List getSelectList() {
        return this.selectList;
    }

    public Map getEntriesFilter() {
        if (this.entriesFilter == null) {
            this.entriesFilter = new HashMap();
        }
        return this.entriesFilter;
    }

    public Map getEntriesFilterDirect() {
        return this.entriesFilter;
    }

    public void setEntriesFilter(Map entriesFilter) {
        this.entriesFilter = entriesFilter;
    }
}

