/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.parser;

import com.kingdee.bos.dao.ormapping_ex.ast.AbstractDataQuery;
import com.kingdee.bos.dao.ormapping_ex.ast.CaseItem;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AggregateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AllColumnExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BetweenExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BinaryOpExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CaseExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.DateTimeExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.DoubleExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExistsExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.InListExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.InSubQueryExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IntExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.MethodInvokeExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NCharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NullExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ObjectCreateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.VarRefExpr;
import com.kingdee.bos.dao.ormapping_ex.parser.DataQueryParser;
import com.kingdee.bos.dao.ormapping_ex.parser.Lexer;
import com.kingdee.bos.dao.ormapping_ex.parser.OQLParserException;
import com.kingdee.bos.dao.ormapping_ex.parser.Token;
import com.kingdee.bos.dao.ormapping_ex.parser.TokenList;
import com.kingdee.util.TODOException;
import java.util.Collection;

public class ExprParser {
    private final TokenList _tokenList;

    public ExprParser(TokenList tokList) {
        this._tokenList = tokList;
    }

    public ExprParser(Lexer lexer) throws OQLParserException {
        this._tokenList = new TokenList(lexer);
    }

    public ExprParser(String text) throws OQLParserException {
        Lexer lexer = new Lexer(text);
        this._tokenList = new TokenList(lexer);
    }

    public final ExprNode expr() throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.MulToken)) {
            this._tokenList.match();
            return new AllColumnExpr();
        }
        ExprNode expr = this.unary();
        if (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            return expr;
        }
        return this.exprRest(expr);
    }

    public final ExprNode exprRest(ExprNode expr) throws OQLParserException {
        expr = this.multiplicativeRest(expr);
        expr = this.additiveRest(expr);
        expr = this.inRest(expr);
        expr = this.relationalRest(expr);
        expr = this.equalityRest(expr);
        expr = this.andRest(expr);
        expr = this.orRest(expr);
        return expr;
    }

    public final void exprList(Collection exprCol) throws OQLParserException {
        if (exprCol == null) {
            throw new IllegalArgumentException("exprCol");
        }
        if (this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
            return;
        }
        if (this._tokenList.lookup(0).equals(Token.EOFToken)) {
            return;
        }
        ExprNode expr = this.expr();
        exprCol.add(expr);
        while (this._tokenList.lookup(0).equals(Token.CommaToken)) {
            this._tokenList.match();
            expr = this.expr();
            exprCol.add(expr);
        }
    }

    public final ExprNode unary() throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.MinusToken)) {
            if (this._tokenList.lookup((int)1).type == 8) {
                IntExpr intExpr = new IntExpr("-" + this._tokenList.lookup((int)1).value);
                this._tokenList.match();
                this._tokenList.match();
                return intExpr;
            }
            if (this._tokenList.lookup((int)1).type == 11 || this._tokenList.lookup((int)1).type == 10) {
                DoubleExpr doubleExpr = new DoubleExpr("-" + this._tokenList.lookup((int)1).value);
                this._tokenList.match();
                this._tokenList.match();
                return doubleExpr;
            }
        }
        return this.primary();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ExprNode primary() throws OQLParserException {
        ExprNode sql_expr = null;
        if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
            this._tokenList.match();
            sql_expr = this.expr();
            this._tokenList.match(Token.CloseBraceToken);
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup(0).equals(Token.New)) {
            this._tokenList.match();
            StringBuffer typeNameBuffer = new StringBuffer();
            typeNameBuffer.append(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            while (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
                this._tokenList.match();
                typeNameBuffer.append('.');
                typeNameBuffer.append(this._tokenList.lookup((int)0).value);
                this._tokenList.match();
            }
            this._tokenList.match(Token.OpenBraceToken);
            ObjectCreateExpr newExpr = new ObjectCreateExpr(typeNameBuffer.toString());
            this.exprList(newExpr.paramList);
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = newExpr;
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup((int)0).type == 8) {
            sql_expr = new IntExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup((int)0).type == 10) {
            sql_expr = new DoubleExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup((int)0).type == 6) {
            sql_expr = new CharExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup((int)0).type == 7) {
            sql_expr = new NCharExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup((int)0).type == 2) {
            sql_expr = new VarRefExpr(this._tokenList.lookup((int)0).value);
            this._tokenList.match();
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup(0).equals(Token.CaseToken)) {
            CaseExpr caseExpr = new CaseExpr();
            this._tokenList.match();
            if (!this._tokenList.lookup(0).equals(Token.WhenToken)) {
                caseExpr.valueExpr = this.expr();
            }
            this._tokenList.match(Token.WhenToken);
            ExprNode testExpr = this.expr();
            this._tokenList.match(Token.ThenToken);
            ExprNode valueExpr = this.expr();
            CaseItem caseItem = new CaseItem(testExpr, valueExpr);
            caseExpr.itemList.add(caseItem);
            while (this._tokenList.lookup(0).equals(Token.WhenToken)) {
                this._tokenList.match();
                testExpr = this.expr();
                this._tokenList.match(Token.ThenToken);
                valueExpr = this.expr();
                caseItem = new CaseItem(testExpr, valueExpr);
                caseExpr.itemList.add(caseItem);
            }
            if (this._tokenList.lookup(0).equals(Token.ElseToken)) {
                this._tokenList.match();
                caseExpr.elseExpr = this.expr();
            }
            this._tokenList.match(Token.EndToken);
            sql_expr = caseExpr;
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup(0).equals(Token.ExistsToken)) {
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            DataQueryParser selectParser = new DataQueryParser(this._tokenList);
            AbstractDataQuery subQuery = selectParser.select();
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = new ExistsExpr(subQuery);
            return this.primaryRest(sql_expr);
        } else if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            this._tokenList.match();
            if (!this._tokenList.lookup(0).equals(Token.ExistsToken)) throw new TODOException();
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            DataQueryParser selectParser = new DataQueryParser(this._tokenList);
            AbstractDataQuery subQuery = selectParser.select();
            this._tokenList.match(Token.CloseBraceToken);
            sql_expr = new ExistsExpr(subQuery, true);
            return this.primaryRest(sql_expr);
        } else {
            if (this._tokenList.lookup(0).equals(Token.AllToken)) {
                throw new TODOException();
            }
            if (this._tokenList.lookup(0).equals(Token.LeftToken)) {
                sql_expr = new IdentifierExpr("LEFT");
                this._tokenList.match();
                return this.primaryRest(sql_expr);
            } else if (this._tokenList.lookup(0).equals(Token.RightToken)) {
                sql_expr = new IdentifierExpr("RIGHT");
                this._tokenList.match();
                return this.primaryRest(sql_expr);
            } else if (this._tokenList.lookup(0).equals(Token.ConvertToken)) {
                sql_expr = new IdentifierExpr("CONVERT");
                this._tokenList.match();
                return this.primaryRest(sql_expr);
            } else if (this._tokenList.lookup(0).equals(Token.NullIfToken)) {
                sql_expr = new IdentifierExpr("NULLIF");
                this._tokenList.match();
                return this.primaryRest(sql_expr);
            } else {
                if (this._tokenList.lookup(0).equals(Token.AnyToken)) {
                    throw new TODOException();
                }
                if (this._tokenList.lookup(0).equals(Token.SomeToken)) {
                    throw new TODOException();
                }
                if (this._tokenList.lookup(0).equals(Token.NullToken)) {
                    this._tokenList.match();
                    sql_expr = NullExpr.instance;
                    return this.primaryRest(sql_expr);
                } else {
                    if (this._tokenList.lookup(0).equals(Token.OpenCurlyBraceToken)) {
                        return this.parseDatetimeExpr();
                    }
                    if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
                        throw new TODOException();
                    }
                    if (this._tokenList.lookup((int)0).type != 1) throw new OQLParserException("ERROR. " + this._tokenList.lookup((int)0).value, 0, 0);
                    sql_expr = new IdentifierExpr(this._tokenList.lookup((int)0).value);
                    this._tokenList.match();
                }
            }
        }
        return this.primaryRest(sql_expr);
    }

    private final DateTimeExpr parseDatetimeExpr() throws OQLParserException {
        this._tokenList.match(Token.OpenCurlyBraceToken);
        DateTimeExpr expr = new DateTimeExpr();
        if (this._tokenList.lookup((int)0).type == 8) {
            String yearStr = this._tokenList.lookup((int)0).value;
            this._tokenList.match(8);
            int year = Integer.parseInt(yearStr);
            expr.setYear(year);
            this._tokenList.match(Token.MinusToken);
            String monthStr = this._tokenList.lookup((int)0).value;
            this._tokenList.match(8);
            int month = Integer.parseInt(monthStr);
            expr.setMonth(month);
            this._tokenList.match(Token.MinusToken);
            String dateStr = this._tokenList.lookup((int)0).value;
            this._tokenList.match(8);
            int date = Integer.parseInt(dateStr);
            expr.setDate(date);
            if (this._tokenList.lookup(0).equals(Token.CloseCurlyBraceToken)) {
                this._tokenList.match(Token.CloseCurlyBraceToken);
            } else {
                String hourStr = this._tokenList.lookup((int)0).value;
                this._tokenList.match(8);
                int hour = Integer.parseInt(hourStr);
                expr.setHour(hour);
                this._tokenList.match(Token.ColonToken);
                String minuteStr = this._tokenList.lookup((int)0).value;
                this._tokenList.match(8);
                int minute = Integer.parseInt(minuteStr);
                expr.setMinute(minute);
                this._tokenList.match(Token.ColonToken);
                String secondStr = this._tokenList.lookup((int)0).value;
                this._tokenList.match(8);
                int second = Integer.parseInt(secondStr);
                expr.setSecond(second);
                this._tokenList.match(Token.CloseCurlyBraceToken);
            }
        } else if (this._tokenList.lookup((int)0).type == 1 && this._tokenList.lookup((int)0).value.equalsIgnoreCase("ts")) {
            this._tokenList.match();
            String dateChar = this._tokenList.lookup((int)0).value;
            this._tokenList.match(6);
            Lexer lexer = new Lexer(dateChar);
            TokenList charTokList = new TokenList(lexer);
            String yearStr = charTokList.lookup((int)0).value;
            charTokList.match(8);
            int year = Integer.parseInt(yearStr);
            expr.setYear(year);
            charTokList.match(Token.MinusToken);
            String monthStr = charTokList.lookup((int)0).value;
            charTokList.match(8);
            int month = Integer.parseInt(monthStr);
            expr.setMonth(month);
            charTokList.match(Token.MinusToken);
            String dateStr = charTokList.lookup((int)0).value;
            charTokList.match(8);
            int date = Integer.parseInt(dateStr);
            expr.setDate(date);
            if (charTokList.lookup(0).equals(Token.EOFToken)) {
                charTokList.match();
            } else {
                String hourStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int hour = Integer.parseInt(hourStr);
                expr.setHour(hour);
                charTokList.match(Token.ColonToken);
                String minuteStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int minute = Integer.parseInt(minuteStr);
                expr.setMinute(minute);
                charTokList.match(Token.ColonToken);
                String secondStr = charTokList.lookup((int)0).value;
                charTokList.match(8);
                int second = Integer.parseInt(secondStr);
                expr.setSecond(second);
            }
            this._tokenList.match(Token.CloseCurlyBraceToken);
        } else {
            throw new OQLParserException("Error DateTime Formate.");
        }
        return expr;
    }

    public final ExprNode primaryRest(ExprNode expr) throws OQLParserException {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this._tokenList.lookup(0).equals(Token.PeriodToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.MulToken)) {
                this._tokenList.match();
                expr = new PropertyExpr(expr, "*");
            } else if (this._tokenList.lookup(1).equals(Token.OpenBraceToken)) {
                String methodName = this._tokenList.lookup((int)0).value;
                this._tokenList.match();
                this._tokenList.match(Token.OpenBraceToken);
                MethodInvokeExpr methodInvokeExpr = new MethodInvokeExpr(methodName);
                if (this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                    this._tokenList.match();
                } else {
                    this.exprList(methodInvokeExpr.parameters);
                    this._tokenList.match(Token.CloseBraceToken);
                }
                expr = methodInvokeExpr;
            } else {
                expr = new PropertyExpr(expr, this._tokenList.lookup((int)0).value);
                this._tokenList.match(1);
            }
            expr = this.primaryRest(expr);
        } else {
            if (this._tokenList.lookup(0).equals(Token.OpenBraceToken)) {
                if (expr.type == 4) {
                    IdentifierExpr identExpr = (IdentifierExpr)expr;
                    String method_name = identExpr.value;
                    this._tokenList.match();
                    if (this._tokenList.lexer._keywords.isAggreateFunction(method_name)) {
                        AggregateExpr aggregateExpr;
                        if (this._tokenList.lookup(0).equals(Token.AllToken)) {
                            aggregateExpr = new AggregateExpr(method_name, 1);
                            this._tokenList.match();
                        } else if (this._tokenList.lookup(0).equals(Token.DistinctToken)) {
                            aggregateExpr = new AggregateExpr(method_name, 0);
                            this._tokenList.match();
                        } else {
                            aggregateExpr = new AggregateExpr(method_name, 1);
                        }
                        if (!this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                            this.exprList(aggregateExpr.paramList);
                        }
                        this._tokenList.match(Token.CloseBraceToken);
                        return aggregateExpr;
                    }
                    MethodInvokeExpr methodInvokeExpr = new MethodInvokeExpr(method_name);
                    if (!this._tokenList.lookup(0).equals(Token.CloseBraceToken)) {
                        this.exprList(methodInvokeExpr.parameters);
                    }
                    this._tokenList.match(Token.CloseBraceToken);
                    return this.primaryRest(methodInvokeExpr);
                }
                throw new OQLParserException("not support expression:" + expr, 0, 0);
            }
            if (this._tokenList.lookup(0).equals(Token.InToken)) {
                expr = this.inRest(expr);
            }
        }
        return expr;
    }

    public final ExprNode equality() throws OQLParserException {
        ExprNode expr = this.relational();
        return this.equalityRest(expr);
    }

    public final ExprNode equalityRest(ExprNode expr) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.EqualToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.relational();
            rightExp = this.equalityRest(rightExp);
            expr = new BinaryOpExpr(expr, 10, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.NotEqualToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.relational();
            rightExp = this.equalityRest(rightExp);
            expr = new BinaryOpExpr(expr, 23, rightExp);
        }
        return expr;
    }

    public final ExprNode inRest(ExprNode expr) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.InToken)) {
            this._tokenList.match();
            this._tokenList.match(Token.OpenBraceToken);
            if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
                DataQueryParser selectParser = new DataQueryParser(this._tokenList);
                AbstractDataQuery select = selectParser.select();
                InSubQueryExpr inExpr = new InSubQueryExpr(expr, select);
                expr = inExpr;
            } else {
                InListExpr inListExpr = new InListExpr(expr);
                this.exprList(inListExpr.targetList);
                expr = inListExpr;
            }
            this._tokenList.match(Token.CloseBraceToken);
        }
        expr = this.andRest(expr);
        expr = this.orRest(expr);
        return expr;
    }

    public final ExprNode additive() throws OQLParserException {
        ExprNode expr = this.multiplicative();
        return this.additiveRest(expr);
    }

    public final ExprNode additiveRest(ExprNode expr) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.PlusToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.multiplicative();
            if (expr instanceof CharExpr || expr instanceof NCharExpr || rightExp instanceof CharExpr || rightExp instanceof NCharExpr) {
                throw new OQLParserException("Error. additive operator can not use add Char Or NChar");
            }
            expr = new BinaryOpExpr(expr, 0, rightExp);
            expr = this.additiveRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.ConcatOpToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.multiplicative();
            expr = new BinaryOpExpr(expr, 42, rightExp);
            expr = this.additiveRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.MinusToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.multiplicative();
            if (expr instanceof CharExpr || expr instanceof NCharExpr || rightExp instanceof CharExpr || rightExp instanceof NCharExpr) {
                throw new OQLParserException("Error. minus operator can not use add Char Or NChar");
            }
            expr = new BinaryOpExpr(expr, 26, rightExp);
            expr = this.additiveRest(expr);
        }
        return expr;
    }

    public final ExprNode multiplicative() throws OQLParserException {
        ExprNode expr = this.unary();
        return this.multiplicativeRest(expr);
    }

    public final ExprNode multiplicativeRest(ExprNode expr) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.MulToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.unary();
            expr = new BinaryOpExpr(expr, 22, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.DivToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.unary();
            expr = new BinaryOpExpr(expr, 9, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this._tokenList.lookup(0).equals(Token.ModToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.unary();
            expr = new BinaryOpExpr(expr, 21, rightExp);
            expr = this.multiplicativeRest(expr);
        }
        return expr;
    }

    public final ExprNode and() throws OQLParserException {
        ExprNode expr = this.equality();
        return this.andRest(expr);
    }

    public final ExprNode andRest(ExprNode expr) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.AndToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.equality();
            expr = new BinaryOpExpr(expr, 7, rightExp);
            expr = this.andRest(expr);
        }
        return expr;
    }

    public final ExprNode or() throws OQLParserException {
        ExprNode expr = this.and();
        return this.orRest(expr);
    }

    public final ExprNode orRest(ExprNode expr) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.OrToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.and();
            expr = new BinaryOpExpr(expr, 8, rightExp);
            expr = this.orRest(expr);
        }
        return expr;
    }

    public final ExprNode relational() throws OQLParserException {
        ExprNode expr = this.additive();
        return this.relationalRest(expr);
    }

    public final ExprNode relationalRest(ExprNode expr) throws OQLParserException {
        if (this._tokenList.lookup(0).equals(Token.LessThanToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 14, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LessThanOrEqualToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 15, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.GreaterThanToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 11, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.GreaterThanOrEqualToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 12, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.NotLessThanToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 24, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.NotGreaterThanToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 25, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LessThanOrGreaterThanToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 16, rightExp);
        } else if (this._tokenList.lookup(0).equals(Token.LikeToken)) {
            this._tokenList.match();
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, 18, rightExp);
            if (this._tokenList.lookup(0).equals(Token.EscapeToken)) {
                this._tokenList.match();
                rightExp = this.expr();
                expr = new BinaryOpExpr(expr, 43, rightExp);
            }
        } else if (this._tokenList.lookup(0).equals(Token.NotToken)) {
            if (!this._tokenList.lookup(1).equals(Token.LikeToken)) {
                if (this._tokenList.lookup(1).equals(Token.InToken)) {
                    this._tokenList.match();
                    this._tokenList.match();
                    this._tokenList.match(Token.OpenBraceToken);
                    if (this._tokenList.lookup(0).equals(Token.SelectToken)) {
                        DataQueryParser selectParser = new DataQueryParser(this._tokenList);
                        AbstractDataQuery select = selectParser.select();
                        InSubQueryExpr inExpr = new InSubQueryExpr(expr, select, true);
                        expr = inExpr;
                    } else {
                        InListExpr inListExpr = new InListExpr(expr, true);
                        this.exprList(inListExpr.targetList);
                        expr = inListExpr;
                    }
                    this._tokenList.match(Token.CloseBraceToken);
                    expr = this.relationalRest(expr);
                    return expr;
                }
                if (this._tokenList.lookup(1).equals(Token.BetweenToken)) {
                    this._tokenList.match();
                    this._tokenList.match();
                    ExprNode beginExpr = this.primary();
                    this._tokenList.match(Token.AndToken);
                    ExprNode endExpr = this.primary();
                    expr = new BetweenExpr(expr, beginExpr, endExpr, true);
                    expr = this.relationalRest(expr);
                    return expr;
                }
                if (this._tokenList.lookup(1).equals(Token.NullToken)) {
                    return expr;
                }
                throw new OQLParserException("not support token:" + this._tokenList.lookup(1));
            }
            this._tokenList.match();
            this._tokenList.match();
            int opType = 40;
            ExprNode rightExp = this.additive();
            rightExp = this.relationalRest(rightExp);
            expr = new BinaryOpExpr(expr, opType, rightExp);
            if ((opType == 18 || opType == 40) && this._tokenList.lookup(0).equals(Token.EscapeToken)) {
                this._tokenList.match();
                rightExp = this.expr();
                expr = new BinaryOpExpr(expr, 43, rightExp);
            }
        } else if (this._tokenList.lookup(0).equals(Token.BetweenToken)) {
            this._tokenList.match();
            ExprNode beginExpr = this.primary();
            this._tokenList.match(Token.AndToken);
            ExprNode endExpr = this.primary();
            expr = new BetweenExpr(expr, beginExpr, endExpr);
        } else if (this._tokenList.lookup(0).equals(Token.IsToken)) {
            this._tokenList.match();
            if (this._tokenList.lookup(0).equals(Token.NotToken)) {
                this._tokenList.match();
                this._tokenList.match(Token.NullToken);
                expr = new BinaryOpExpr(expr, 41, NullExpr.instance);
            } else {
                this._tokenList.match(Token.NullToken);
                expr = new BinaryOpExpr(expr, 13, NullExpr.instance);
            }
        }
        return expr;
    }
}

