/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.parser;

import com.kingdee.bos.dao.ormapping_ex.parser.KeyWord;
import com.kingdee.bos.dao.ormapping_ex.parser.OQLParserException;
import com.kingdee.bos.dao.ormapping_ex.parser.StringReader;
import com.kingdee.bos.dao.ormapping_ex.parser.Token;

public class Lexer {
    final KeyWord _keywords;
    private final StringReader _reader;
    private int _col = 1;
    private int _line = 1;
    private int _ptr;
    private boolean _skipComment = true;

    public Lexer(KeyWord keyword, StringReader _reader) {
        this._keywords = keyword;
        this._reader = _reader;
    }

    public Lexer(StringReader reader) {
        this._ptr = reader._ptr;
        this._keywords = KeyWord.instance;
        this._reader = reader;
    }

    public Lexer(String text) {
        this(KeyWord.instance, text, true);
    }

    public Lexer(KeyWord keyword, String text) {
        this(keyword, text, true);
    }

    public Lexer(KeyWord keyword, String text, boolean skipComment) {
        this._skipComment = skipComment;
        if (text == null) {
            throw new IllegalArgumentException("text");
        }
        this._keywords = KeyWord.instance;
        this._reader = new StringReader(text);
    }

    public final Token next() throws OQLParserException {
        while (!this._reader.eos()) {
            String text;
            char ch = this._reader.next();
            if (Character.isWhitespace(ch)) {
                ++this._col;
                if (ch != '\n') continue;
                ++this._line;
                this._col = 1;
                continue;
            }
            this._ptr = this._reader._ptr;
            if (ch == 'N' || ch == 'n') {
                ++this._col;
                if (this._reader.eos()) {
                    return new Token("N", 1, this._line, this._col, this._ptr);
                }
                if (this._reader.next() == '\'') {
                    ch = '\'';
                    return new Token(this.readChar(), 7, this._line, this._col, this._ptr);
                }
                this._reader.unget();
            }
            if (ch == '\'') {
                if (this._reader.eos()) {
                    throw new OQLParserException("unexpected input end");
                }
                text = this.readChar();
                return new Token(text, 6, this._line, this._col, this._ptr);
            }
            if (ch == '\"') {
                text = this.readAlias();
                return new Token(text, 1, this._line, this._col, this._ptr);
            }
            if (ch == '[') {
                text = this.readAlias_ex();
                return new Token(text, 1, this._line, this._col, this._ptr);
            }
            if (Character.isLetter(ch) || ch == '_' || ch == '#') {
                int x = this._col;
                int y = this._line;
                String text2 = this.readIdent(ch);
                if (this._keywords.isKeyWord(text2)) {
                    return new Token(text2.toUpperCase(), 3, y, x, this._ptr);
                }
                return new Token(text2, 1, y, x, this._ptr);
            }
            if (ch == '@' || ch == ':') {
                char nextChar;
                int x = this._col;
                int y = this._line;
                if (ch == ':' && (nextChar = this._reader.lookup(0)) >= '0' && nextChar < '9') {
                    return new Token(":", 5, y, x, this._ptr);
                }
                String text3 = this.readIdent(ch);
                return new Token(text3, 2, y, x, this._ptr);
            }
            if (ch == '?') {
                ++this._col;
                return new Token("?", 2, this._line, this._col, this._ptr);
            }
            if (Character.isDigit(ch)) {
                return this.readDigit(ch, this._col);
            }
            if (ch == '/' && this._reader.peek() == '/') {
                ++this._col;
                this._reader.skip();
                text = this.readlineComment();
                if (this._skipComment) continue;
                return new Token(text, 0, this._line, this._col, this._ptr);
            }
            if (ch == '-' && this._reader.peek() == '-') {
                ++this._col;
                this._reader.skip();
                text = this.readlineComment();
                if (this._skipComment) continue;
                return new Token(text, 0, this._line, this._col, this._ptr);
            }
            if (ch == '/' && this._reader.peek() == '*') {
                this._reader.skip();
                StringBuffer comment = new StringBuffer();
                while (true) {
                    if ((ch = this._reader.next()) == '*' && this._reader.peek() == '/') break;
                    comment.append(ch);
                }
                this._reader.skip();
                if (this._skipComment) continue;
                return new Token(comment.toString(), 14, this._line, this._col, this._ptr);
            }
            Token token = this.readOperator(ch);
            if (token != null) {
                return token;
            }
            token = this.readPunctuation(ch);
            if (token != null) {
                return token;
            }
            if (ch == '$') {
                ch = this._reader.peek();
                ++this._col;
                if (Character.isDigit(ch)) {
                    return this.readDigit(ch, this._col);
                }
            }
            String message = "Error: Unknowen char not read at (";
            throw new OQLParserException(message, this._line, this._col);
        }
        return new Token("", 12, this._line, this._col, this._ptr);
    }

    private final String readIdent(char c) throws OQLParserException {
        StringBuffer s = new StringBuffer();
        s.append(c);
        ++this._col;
        while (!this._reader.eos()) {
            c = this._reader.next();
            if (!Character.isLetterOrDigit(c) && c != '_' && c != '#') {
                this._reader.unget();
                break;
            }
            s.append(c);
            ++this._col;
        }
        return s.toString();
    }

    private final Token readDigit(char ch, int x) throws OQLParserException {
        int y = this._line;
        ++this._col;
        boolean isdouble = false;
        StringBuffer text = new StringBuffer();
        text.append(ch);
        while (Character.isDigit(this._reader.peek())) {
            text.append(this._reader.next());
            ++this._col;
        }
        if (this._reader.peek() == '.') {
            isdouble = true;
            text.append(this._reader.next());
            ++this._col;
            while (Character.isDigit(this._reader.peek())) {
                text.append(this._reader.next());
                ++this._col;
            }
        }
        if (isdouble) {
            return new Token(text.toString(), 10, y, x, this._ptr);
        }
        return new Token(text.toString(), 8, y, x, this._ptr);
    }

    private final String readChar() throws OQLParserException {
        int ch = 0;
        StringBuffer text = new StringBuffer();
        while (!this._reader.eos()) {
            char c = this._reader.next();
            ch = c;
            if (c == '\'') {
                if (this._reader.eos()) {
                    return text.toString();
                }
                if (this._reader.next() == '\'') {
                    text.append('\'');
                    text.append('\'');
                    continue;
                }
                this._reader.unget();
                ch = 39;
                break;
            }
            ++this._col;
            if (ch == 10) {
                ++this._line;
                this._col = 1;
            }
            text.append((char)ch);
        }
        if (ch != 39) {
            String message = "End of File before String terminated at (";
            throw new OQLParserException(message, this._line, this._col);
        }
        return text.toString();
    }

    private final String readAlias_ex() throws OQLParserException {
        char ch = '\u0000';
        StringBuffer text = new StringBuffer();
        while (!this._reader.eos()) {
            char c = this._reader.next();
            ch = c;
            if (c == ']') break;
            ++this._col;
            if (ch == '\n') {
                ++this._line;
                this._col = 1;
            }
            text.append(ch);
        }
        if (ch != ']') {
            String message = "End of File before String terminated at (";
            throw new OQLParserException(message, this._line, this._col);
        }
        return text.toString();
    }

    private final String readAlias() throws OQLParserException {
        int ch = 0;
        StringBuffer text = new StringBuffer();
        text.append('\"');
        while (!this._reader.eos()) {
            char c = this._reader.next();
            ch = c;
            if (c == '\"') {
                if (this._reader.eos()) {
                    text.append('\"');
                    return text.toString();
                }
                if (this._reader.next() == '\"') {
                    text.append('\"');
                    continue;
                }
                this._reader.unget();
                ch = 34;
                text.append('\"');
                break;
            }
            ++this._col;
            if (ch == 10) {
                ++this._line;
                this._col = 1;
            }
            text.append((char)ch);
        }
        if (ch != 34) {
            String message = "End of File before String terminated at (";
            throw new OQLParserException(message, this._line, this._col);
        }
        return text.toString();
    }

    private final String readlineComment() throws OQLParserException {
        if (this._reader.eos()) {
            return "";
        }
        StringBuffer comment = new StringBuffer();
        char ch = this._reader.next();
        while (ch != '\n' && !this._reader.eos()) {
            comment.append(ch);
            ch = this._reader.next();
        }
        return comment.toString();
    }

    private final Token readOperator(char ch) throws OQLParserException {
        int x = this._col++;
        int y = this._line;
        switch (ch) {
            case '+': {
                if (this._reader.eos()) {
                    return new Token("+", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '+': {
                        ++this._col;
                        throw new OQLParserException("ERROR");
                    }
                    case '=': {
                        ++this._col;
                        throw new OQLParserException("ERROR");
                    }
                }
                this._reader.unget();
                return new Token("+", 4, y, x, this._ptr);
            }
            case '-': {
                if (this._reader.eos()) {
                    return new Token("-", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '-': {
                        ++this._col;
                        throw new OQLParserException("ERROR");
                    }
                    case '=': {
                        ++this._col;
                        throw new OQLParserException("ERROR");
                    }
                    case '>': {
                        ++this._col;
                        throw new OQLParserException("ERROR");
                    }
                }
                this._reader.unget();
                char peek = this._reader.peek();
                if (this._col > 0 && peek >= '0' && peek <= '9') {
                    char p;
                    int i = -2;
                    while (Character.isWhitespace(p = this._reader.lookup(i)) && this._col + --i > 1) {
                    }
                    if (p == ',' || p == '(' || this.isOperator(p)) {
                        return this.readDigit('-', this._col - 1);
                    }
                    return new Token("-", 4, y, x, this._ptr);
                }
                return new Token("-", 4, y, x, this._ptr);
            }
            case '*': {
                if (this._reader.eos()) {
                    return new Token("*", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("*=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("*", 4, y, x, this._ptr);
            }
            case '/': {
                if (this._reader.eos()) {
                    return new Token("/", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("/=", 4, y, x, this._ptr);
                    }
                    case '*': {
                        throw new OQLParserException("not support operator:* ");
                    }
                }
                this._reader.unget();
                return new Token("/", 4, y, x, this._ptr);
            }
            case '%': {
                if (this._reader.eos()) {
                    return new Token("%", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("%=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("%", 4, y, x, this._ptr);
            }
            case '&': {
                if (this._reader.eos()) {
                    return new Token("&", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '&': {
                        ++this._col;
                        return new Token("&&", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("&=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("&", 4, y, x, this._ptr);
            }
            case '|': {
                if (this._reader.eos()) {
                    return new Token("|", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '|': {
                        ++this._col;
                        return new Token("||", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("|=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("|", 4, y, x, this._ptr);
            }
            case '^': {
                if (this._reader.eos()) {
                    return new Token("^", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("^=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("^", 4, y, x, this._ptr);
            }
            case '!': {
                if (this._reader.eos()) {
                    return new Token("!", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("!=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("!", 4, y, x, this._ptr);
            }
            case '~': {
                return new Token("~", 4, y, x, this._ptr);
            }
            case '=': {
                if (this._reader.eos()) {
                    return new Token("=", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '=': {
                        ++this._col;
                        return new Token("==", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("=", 4, y, x, this._ptr);
            }
            case '<': {
                if (this._reader.eos()) {
                    return new Token("<", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '<': {
                        switch (this._reader.next()) {
                            case '=': {
                                this._col += 2;
                                return new Token("<<=", 4, y, x, this._ptr);
                            }
                        }
                        ++this._col;
                        this._reader.unget();
                        return new Token("<<", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token("<=", 4, y, x, this._ptr);
                    }
                    case '>': {
                        ++this._col;
                        return new Token("<>", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token("<", 4, y, x, this._ptr);
            }
            case '>': {
                if (this._reader.eos()) {
                    return new Token(">", 4, y, x, this._ptr);
                }
                switch (this._reader.next()) {
                    case '>': {
                        switch (this._reader.next()) {
                            case '=': {
                                this._col += 2;
                                return new Token(">>=", 4, y, x, this._ptr);
                            }
                        }
                        ++this._col;
                        this._reader.unget();
                        return new Token(">>", 4, y, x, this._ptr);
                    }
                    case '=': {
                        ++this._col;
                        return new Token(">=", 4, y, x, this._ptr);
                    }
                }
                this._reader.unget();
                return new Token(">", 4, y, x, this._ptr);
            }
        }
        --this._col;
        return null;
    }

    private final Token readPunctuation(char ch) throws OQLParserException {
        int x = this._col++;
        int y = this._line;
        switch (ch) {
            case ';': {
                return new Token(";", 5, y, x, this._ptr);
            }
            case ':': {
                return new Token(":", 5, y, x, this._ptr);
            }
            case ',': {
                return new Token(",", 5, y, x, this._ptr);
            }
            case '.': {
                if (Character.isDigit(this._reader.peek())) {
                    this._reader.unget();
                    this._col -= 2;
                    return this.readDigit('0', this._col + 1);
                }
                return new Token(".", 5, y, x, this._ptr);
            }
            case ')': {
                return new Token(")", 5, y, x, this._ptr);
            }
            case '(': {
                return new Token("(", 5, y, x, this._ptr);
            }
            case ']': {
                return new Token("]", 5, y, x, this._ptr);
            }
            case '[': {
                return new Token("[", 5, y, x, this._ptr);
            }
            case '}': {
                return new Token("}", 5, y, x, this._ptr);
            }
            case '{': {
                return new Token("{", 5, y, x, this._ptr);
            }
        }
        --this._col;
        return null;
    }

    private final boolean isOperator(char c) {
        switch (c) {
            case '!': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '=': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }
}

