/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.parser;

import com.kingdee.bos.dao.ormapping_ex.parser.TokenType;

public class Token {
    public int type;
    public String value;
    public int beginLine;
    public int endLine;
    public int beginColumn;
    public int endColumn;
    public int position;
    public static final Token EqualToken = new Token("=", 4, 0, 0);
    public static final Token NotEqualToken = new Token("!=", 4, 0, 0);
    public static final Token LessThanToken = new Token("<", 4, 0, 0);
    public static final Token LessThanOrEqualToken = new Token("<=", 4, 0, 0);
    public static final Token GreaterThanToken = new Token(">", 4, 0, 0);
    public static final Token GreaterThanOrEqualToken = new Token(">=", 4, 0, 0);
    public static final Token NotLessThanToken = new Token("!<", 4, 0, 0);
    public static final Token NotGreaterThanToken = new Token("!>", 4, 0, 0);
    public static final Token LessThanOrGreaterThanToken = new Token("<>", 4, 0, 0);
    public static final Token PlusToken = new Token("+", 4, 0, 0);
    public static final Token MinusToken = new Token("-", 4, 0, 0);
    public static final Token MulToken = new Token("*", 4, 0, 0);
    public static final Token DivToken = new Token("/", 4, 0, 0);
    public static final Token ModToken = new Token("%", 4, 0, 0);
    public static final Token BitwiseAndToken = new Token("&", 4, 0, 0);
    public static final Token BitwiseOrToken = new Token("|", 4, 0, 0);
    public static final Token ConcatOpToken = new Token("||", 4, 0, 0);
    public static final Token OpenCurlyBraceToken = new Token("{", 5, 0, 0);
    public static final Token CloseCurlyBraceToken = new Token("}", 5, 0, 0);
    public static final Token OpenBraceToken = new Token("(", 5, 0, 0);
    public static final Token CloseBraceToken = new Token(")", 5, 0, 0);
    public static final Token OpenSquareBraceToken = new Token("[", 5, 0, 0);
    public static final Token CloseSquareBraceToken = new Token("]", 5, 0, 0);
    public static final Token PeriodToken = new Token(".", 5, 0, 0);
    public static final Token CommaToken = new Token(",", 5, 0, 0);
    public static final Token ColonToken = new Token(":", 5, 0, 0);
    public static final Token SemicolonToken = new Token(";", 5, 0, 0);
    public static final Token EOFToken = new Token("", 12, 0, 0);
    public static final Token AddToken = new Token("ADD", 1, 0, 0);
    public static final Token AllToken = new Token("ALL", 1, 0, 0);
    public static final Token AndToken = new Token("AND", 3, 0, 0);
    public static final Token AnyToken = new Token("ANY", 1, 0, 0);
    public static final Token AsToken = new Token("AS", 1, 0, 0);
    public static final Token AscToken = new Token("ASC", 3, 0, 0);
    public static final Token BeginToken = new Token("BEGIN", 1, 0, 0);
    public static final Token BetweenToken = new Token("BETWEEN", 1, 0, 0);
    public static final Token BreakToken = new Token("BREAK", 1, 0, 0);
    public static final Token ByToken = new Token("BY", 1, 0, 0);
    public static final Token CaseToken = new Token("CASE", 1, 0, 0);
    public static final Token ContainsToken = new Token("CONTAINS", 1, 0, 0);
    public static final Token ContinueToken = new Token("CONTINUE", 1, 0, 0);
    public static final Token ConvertToken = new Token("CONVERT", 1, 0, 0);
    public static final Token DescToken = new Token("DESC", 3, 0, 0);
    public static final Token DeleteToken = new Token("DELETE", 3, 0, 0);
    public static final Token DistinctToken = new Token("DISTINCT", 1, 0, 0);
    public static final Token DropToken = new Token("DROP", 1, 0, 0);
    public static final Token ElseToken = new Token("ELSE", 1, 0, 0);
    public static final Token EndToken = new Token("END", 1, 0, 0);
    public static final Token EscapeToken = new Token("ESCAPE", 1, 0, 0);
    public static final Token ExistsToken = new Token("EXISTS", 1, 0, 0);
    public static final Token ExitToken = new Token("EXIT", 1, 0, 0);
    public static final Token FalseToken = new Token("FALSE", 3, 0, 0);
    public static final Token ForToken = new Token("FOR", 1, 0, 0);
    public static final Token FromToken = new Token("FROM", 1, 0, 0);
    public static final Token GroupToken = new Token("GROUP", 1, 0, 0);
    public static final Token HavingToken = new Token("HAVING", 1, 0, 0);
    public static final Token HoldLockToken = new Token("HOLDLOCK", 1, 0, 0);
    public static final Token IfToken = new Token("IF", 1, 0, 0);
    public static final Token InToken = new Token("IN", 3, 0, 0);
    public static final Token IndexToken = new Token("INDEX", 1, 0, 0);
    public static final Token InnerToken = new Token("INNER", 1, 0, 0);
    public static final Token IntoToken = new Token("INTO", 1, 0, 0);
    public static final Token IsToken = new Token("IS", 3, 0, 0);
    public static final Token JoinToken = new Token("JOIN", 1, 0, 0);
    public static final Token LeftToken = new Token("LEFT", 1, 0, 0);
    public static final Token LikeToken = new Token("LIKE", 3, 0, 0);
    public static final Token NotToken = new Token("NOT", 3, 0, 0);
    public static final Token NullToken = new Token("NULL", 3, 0, 0);
    public static final Token NullIfToken = new Token("NULLIF", 1, 0, 0);
    public static final Token OnToken = new Token("ON", 1, 0, 0);
    public static final Token OptionToken = new Token("OPTION", 1, 0, 0);
    public static final Token OrToken = new Token("OR", 3, 0, 0);
    public static final Token OrderToken = new Token("ORDER", 1, 0, 0);
    public static final Token PercentToken = new Token("PERCENT", 1, 0, 0);
    public static final Token PlanToken = new Token("PLAN", 1, 0, 0);
    public static final Token RightToken = new Token("RIGHT", 1, 0, 0);
    public static final Token SelectToken = new Token("SELECT", 1, 0, 0);
    public static final Token SomeToken = new Token("SOME", 1, 0, 0);
    public static final Token TopToken = new Token("TOP", 1, 0, 0);
    public static final Token ThenToken = new Token("THEN", 1, 0, 0);
    public static final Token TrueToken = new Token("TRUE", 3, 0, 0);
    public static final Token UnionToken = new Token("UNION", 1, 0, 0);
    public static final Token WhereToken = new Token("WHERE", 1, 0, 0);
    public static final Token WhenToken = new Token("WHEN", 1, 0, 0);
    public static final Token WithToken = new Token("WITH", 1, 0, 0);
    public static final Token New = new Token("NEW", 1, 0, 0);
    public static final Token UpdateToken = new Token("UPDATE", 1, 0, 0);
    public static final Token ComputeToken = new Token("COMPUTE", 1, 0, 0);
    public static final Token OuterToken = new Token("OUTER", 1, 0, 0);
    public static final Token FullToken = new Token("FULL", 1, 0, 0);
    public static final Token CrossToken = new Token("CROSS", 1, 0, 0);
    public static final Token SetToken = new Token("SET", 1, 0, 0);
    public static final Token ConnectToken = new Token("CONNECT", 1, 0, 0);

    public Token() {
    }

    public Token(int type, String value) {
        this.value = value;
        this.type = type;
    }

    public Token(String value, int type, int line, int col) {
        this.value = value;
        this.type = type;
        this.beginLine = line;
        this.beginColumn = col;
    }

    public Token(String value, int type, int line, int col, int ptr) {
        this.value = value;
        this.type = type;
        this.beginLine = line;
        this.beginColumn = col;
        this.position = ptr;
    }

    public final String toString() {
        StringBuffer buff = new StringBuffer();
        this.output(buff);
        return buff.toString();
    }

    public final void output(StringBuffer buff) {
        if (this.type == 6) {
            buff.append('\'');
            buff.append(this.value);
            buff.append('\'');
        } else if (this.type == 7) {
            buff.append("N'");
            buff.append(this.value);
            buff.append('\'');
        } else {
            buff.append(this.value);
        }
    }

    public final boolean equals(Token tok) {
        if (tok == null) {
            return false;
        }
        if (tok.type != this.type) {
            return false;
        }
        switch (tok.type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.value == tok.value;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return this.value.compareToIgnoreCase(tok.value) == 0;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.value.compareToIgnoreCase(tok.value) == 0;
            }
            case 12: {
                return true;
            }
            case 13: {
                return false;
            }
        }
        return false;
    }

    public final String typename() {
        return TokenType.typename(this.type);
    }
}

