/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.dataquery;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping_ex.ast.CaseItem;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AggregateExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.AllColumnExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.BinaryOpExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CaseExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.CharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.DoubleExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExistsExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.ExprNode;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IdentifierExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.InSubQueryExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.IntExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.LiteralExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.MethodInvokeExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.NCharExpr;
import com.kingdee.bos.dao.ormapping_ex.ast.expr.PropertyExpr;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.DataQueryContext;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.DataQueryEngine;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.InternalDataQueryResult;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.InternalSqlExprBuildResult;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.TypeInfo;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ORMUtils;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.dom.SqlCaseItem;
import com.kingdee.bos.sql.dom.expr.SqlAggregateExpr;
import com.kingdee.bos.sql.dom.expr.SqlAllColumnExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCaseExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.util.TODOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DataQueryUtil {
    public static InternalSqlExprBuildResult[] buildSqlExpr(DataQueryContext queryCtx, ExprNode expr) throws BOSException {
        if (expr instanceof IdentifierExpr) {
            return DataQueryUtil.buildSqlExpr_PropExpr(queryCtx, expr);
        }
        if (expr instanceof PropertyExpr) {
            return DataQueryUtil.buildSqlExpr_PropExpr(queryCtx, expr);
        }
        if (expr instanceof AllColumnExpr) {
            return DataQueryUtil.buildSqlExpr_PropExpr(queryCtx, expr);
        }
        if (expr instanceof BinaryOpExpr) {
            return DataQueryUtil.buildSqlExpr_BinaryOpExpr(queryCtx, (BinaryOpExpr)expr);
        }
        if (expr instanceof LiteralExpr) {
            InternalSqlExprBuildResult literalResult = DataQueryUtil.buildSqlExpr_Literal((LiteralExpr)expr);
            return new InternalSqlExprBuildResult[]{literalResult};
        }
        if (expr instanceof MethodInvokeExpr) {
            return DataQueryUtil.buildSqlExpr_MethodInvokeExpr(queryCtx, (MethodInvokeExpr)expr);
        }
        if (expr instanceof CaseExpr) {
            return DataQueryUtil.buildSqlExpr_CaseExpr(queryCtx, (CaseExpr)expr);
        }
        if (expr instanceof ExistsExpr) {
            return DataQueryUtil.buildSqlExpr_Exsits(queryCtx, (ExistsExpr)expr);
        }
        if (expr instanceof InSubQueryExpr) {
            return DataQueryUtil.buildSqlExpr_InSubQuery(queryCtx, (InSubQueryExpr)expr);
        }
        if (expr instanceof AggregateExpr) {
            return DataQueryUtil.buildSqlExpr_AggregateExpr(queryCtx, (AggregateExpr)expr);
        }
        throw new TODOException(expr.getClass().getName());
    }

    public static InternalSqlExprBuildResult[] buildSqlExpr_InSubQuery(DataQueryContext queryCtx, InSubQueryExpr expr) throws BOSException {
        String name;
        DataQueryEngine engine = new DataQueryEngine(queryCtx.getBosContext());
        DataQueryContext subCtx = new DataQueryContext(queryCtx);
        InternalDataQueryResult subResult = engine.buildInternalResult(expr.subQuery, subCtx);
        InternalSqlExprBuildResult[] tempArray = DataQueryUtil.buildSqlExpr(queryCtx, expr.expr);
        assert (tempArray.length == 1);
        SqlInSubQueryExpr sqlExpr = new SqlInSubQueryExpr();
        sqlExpr.subQuery = subResult.getSqlSelect();
        sqlExpr.not = expr.not;
        sqlExpr.expr = tempArray[0].sqlExpr;
        String alias = name = expr.toString();
        TypeInfo typeInfo = new TypeInfo(name, alias, DataType.BOOLEAN, 16);
        InternalSqlExprBuildResult rtnVal = new InternalSqlExprBuildResult();
        rtnVal.typeInfo = typeInfo;
        rtnVal.srcExpr = expr;
        rtnVal.sqlExpr = sqlExpr;
        return new InternalSqlExprBuildResult[]{rtnVal};
    }

    public static InternalSqlExprBuildResult[] buildSqlExpr_Exsits(DataQueryContext queryCtx, ExistsExpr expr) throws BOSException {
        String name;
        DataQueryEngine engine = new DataQueryEngine(queryCtx.getBosContext());
        DataQueryContext subCtx = new DataQueryContext(queryCtx);
        InternalDataQueryResult subResult = engine.buildInternalResult(expr.subQuery, subCtx);
        SqlExistsExpr sqlExpr = new SqlExistsExpr();
        sqlExpr.subQuery = subResult.getSqlSelect();
        sqlExpr.not = expr.not;
        String alias = name = expr.toString();
        TypeInfo typeInfo = new TypeInfo(name, alias, DataType.BOOLEAN, 16);
        InternalSqlExprBuildResult rtnVal = new InternalSqlExprBuildResult();
        rtnVal.typeInfo = typeInfo;
        rtnVal.srcExpr = expr;
        rtnVal.sqlExpr = sqlExpr;
        return new InternalSqlExprBuildResult[]{rtnVal};
    }

    public static InternalSqlExprBuildResult buildSqlExpr_Literal(LiteralExpr expr) {
        String name;
        SqlCharExpr sqlExpr;
        String val;
        int sqlType;
        DataType dataType;
        if (expr instanceof CharExpr) {
            dataType = DataType.CHAR;
            sqlType = 12;
            val = (String)expr.getValue();
            sqlExpr = new SqlCharExpr(val.toString().replaceAll("'", "''"));
        } else if (expr instanceof NCharExpr) {
            dataType = DataType.CHAR;
            sqlType = 12;
            val = (String)expr.getValue();
            sqlExpr = new SqlNCharExpr(val.toString().replaceAll("'", "''"));
        } else if (expr instanceof IntExpr) {
            dataType = DataType.INTEGER;
            sqlType = 4;
            sqlExpr = new SqlIntExpr((Integer)expr.getValue());
        } else if (expr instanceof DoubleExpr) {
            dataType = DataType.DECIMAL;
            sqlType = 3;
            sqlExpr = new SqlDoubleExpr(((Double)expr.getValue()).toString());
        } else {
            throw new TODOException();
        }
        String alias = name = expr.toString();
        TypeInfo typeInfo = new TypeInfo(name, alias, dataType, sqlType);
        InternalSqlExprBuildResult rtnVal = new InternalSqlExprBuildResult();
        rtnVal.typeInfo = typeInfo;
        rtnVal.srcExpr = expr;
        rtnVal.sqlExpr = sqlExpr;
        return rtnVal;
    }

    public static InternalSqlExprBuildResult[] buildSqlExpr_CaseExpr(DataQueryContext queryCtx, CaseExpr expr) throws BOSException {
        String name;
        SqlCaseExpr sqlCaseExpr = new SqlCaseExpr();
        TypeInfo refTypeInfo = null;
        ExprNode valExpr = expr.valueExpr;
        if (valExpr != null) {
            InternalSqlExprBuildResult[] tempArray = DataQueryUtil.buildSqlExpr(queryCtx, valExpr);
            assert (tempArray.length == 1);
            sqlCaseExpr.valueExpr = tempArray[0].sqlExpr;
        }
        int size = expr.itemList.size();
        for (int i = 0; i < size; ++i) {
            ExprNode conditionExpr;
            InternalSqlExprBuildResult[] tempArray;
            CaseItem caseItem = (CaseItem)expr.itemList.get(i);
            SqlCaseItem sqlCaseItem = new SqlCaseItem();
            ExprNode valExpr2 = caseItem.valueExpr;
            if (valExpr2 != null) {
                tempArray = DataQueryUtil.buildSqlExpr(queryCtx, valExpr2);
                assert (tempArray.length == 1);
                sqlCaseItem.valueExpr = tempArray[0].sqlExpr;
                if (refTypeInfo == null) {
                    refTypeInfo = tempArray[0].typeInfo;
                }
            }
            if ((conditionExpr = caseItem.conditionExpr) != null) {
                tempArray = DataQueryUtil.buildSqlExpr(queryCtx, conditionExpr);
                assert (tempArray.length == 1);
                sqlCaseItem.conditionExpr = tempArray[0].sqlExpr;
            }
            sqlCaseExpr.itemList.add(sqlCaseItem);
        }
        assert (refTypeInfo != null);
        ExprNode elseExpr = expr.elseExpr;
        if (elseExpr != null) {
            InternalSqlExprBuildResult[] tempArray = DataQueryUtil.buildSqlExpr(queryCtx, elseExpr);
            assert (tempArray.length == 1);
            sqlCaseExpr.elseExpr = tempArray[0].sqlExpr;
        }
        String alias = name = expr.toString();
        TypeInfo typeInfo = new TypeInfo(name, alias, refTypeInfo.getDataType(), refTypeInfo.getSqlType());
        InternalSqlExprBuildResult rtnVal = new InternalSqlExprBuildResult();
        rtnVal.sqlExpr = sqlCaseExpr;
        rtnVal.srcExpr = expr;
        rtnVal.typeInfo = typeInfo;
        return new InternalSqlExprBuildResult[]{rtnVal};
    }

    public static InternalSqlExprBuildResult[] buildSqlExpr_AggregateExpr(DataQueryContext queryCtx, AggregateExpr expr) throws BOSException {
        String name;
        String methodName = expr.methodName;
        DataType dataType = null;
        SqlAggregateExpr sqlExpr = null;
        int sqlType = KSqlUtil.getSqlType((String)methodName);
        if (sqlExpr == null) {
            SqlAggregateExpr sqlMethodInvokeExpr = new SqlAggregateExpr(methodName);
            if (sqlMethodInvokeExpr.paramList == null) {
                sqlMethodInvokeExpr.paramList = new ArrayList();
            }
            int size = expr.paramList.size();
            for (int i = 0; i < size; ++i) {
                ExprNode pramExpr = (ExprNode)expr.paramList.get(i);
                InternalSqlExprBuildResult[] tempArray = DataQueryUtil.buildSqlExpr(queryCtx, pramExpr);
                assert (tempArray.length == 1);
                sqlMethodInvokeExpr.paramList.add(tempArray[0].sqlExpr);
            }
            sqlExpr = sqlMethodInvokeExpr;
        }
        if (dataType == null) {
            switch (sqlType) {
                case -2: {
                    dataType = DataType.BYTEARRAY;
                    break;
                }
                case 1: {
                    dataType = DataType.CHAR;
                    break;
                }
                case 91: {
                    dataType = DataType.DATE;
                    break;
                }
                case 3: {
                    dataType = DataType.DECIMAL;
                    break;
                }
                case 8: {
                    dataType = DataType.DOUBLE;
                    break;
                }
                case 4: {
                    dataType = DataType.INTEGER;
                    break;
                }
                case 2: {
                    dataType = DataType.DECIMAL;
                    break;
                }
                case 7: {
                    dataType = DataType.DECIMAL;
                    break;
                }
                case 5: {
                    dataType = DataType.SHORT;
                    break;
                }
                case 93: {
                    dataType = DataType.TIMESTAMP;
                    break;
                }
                case -3: {
                    dataType = DataType.BYTEARRAY;
                    break;
                }
                case 12: {
                    dataType = DataType.CHAR;
                }
            }
        }
        String alias = name = expr.toString();
        TypeInfo typeInfo = new TypeInfo(name, alias, dataType, sqlType);
        InternalSqlExprBuildResult rtnVal = new InternalSqlExprBuildResult();
        rtnVal.sqlExpr = sqlExpr;
        rtnVal.srcExpr = expr;
        rtnVal.typeInfo = typeInfo;
        return new InternalSqlExprBuildResult[]{rtnVal};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InternalSqlExprBuildResult[] buildSqlExpr_MethodInvokeExpr(DataQueryContext queryCtx, MethodInvokeExpr expr) throws BOSException {
        String name;
        int sqlType;
        ExprNode firstPramExpr;
        String methodName = expr.methodName;
        DataType dataType = null;
        SqlAllColumnExpr sqlExpr = null;
        if (methodName.equalsIgnoreCase("count") && expr.parameters.size() == 1 && expr.parameters.get(0) instanceof AllColumnExpr) {
            sqlExpr = new SqlAllColumnExpr();
            dataType = DataType.INTEGER;
        }
        if (methodName.equalsIgnoreCase("convert")) {
            if (expr.parameters.size() <= 1) {
                throw new BOSException("convert funcition's parameter size must greater than 1.");
            }
            firstPramExpr = (ExprNode)expr.parameters.get(0);
            if (!(firstPramExpr instanceof CharExpr)) {
                throw new BOSException("invalid convert function use");
            }
            String typeName = ((CharExpr)firstPramExpr).text;
            if (typeName.equalsIgnoreCase("char") || typeName.equalsIgnoreCase("varchar") || typeName.equalsIgnoreCase("nchar") || typeName.equalsIgnoreCase("nvarchar")) {
                sqlType = 12;
            } else if (typeName.equalsIgnoreCase("int")) {
                sqlType = 4;
            } else if (typeName.equalsIgnoreCase("smallint")) {
                sqlType = 5;
            } else if (typeName.equalsIgnoreCase("datetime")) {
                sqlType = 93;
            } else if (typeName.equalsIgnoreCase("number") || typeName.equalsIgnoreCase("decimal")) {
                sqlType = 3;
            } else if (typeName.equalsIgnoreCase("clob") || typeName.equalsIgnoreCase("nclob")) {
                sqlType = 2005;
            } else if (typeName.equalsIgnoreCase("blob")) {
                sqlType = 2004;
            } else {
                if (!typeName.equalsIgnoreCase("binary")) throw new TODOException();
                sqlType = -2;
            }
        } else if (methodName.equalsIgnoreCase("nullif") || methodName.equalsIgnoreCase("isnull")) {
            if (expr.parameters.size() != 2) {
                throw new BOSException("convert funcition's parameter size must be 2");
            }
            firstPramExpr = (ExprNode)expr.parameters.get(0);
            InternalSqlExprBuildResult[] tempArray = DataQueryUtil.buildSqlExpr(queryCtx, firstPramExpr);
            assert (tempArray.length == 1);
            if (tempArray[0].typeInfo.getDataType() != null) {
                dataType = tempArray[0].typeInfo.getDataType();
            } else {
                ExprNode secondPramExpr = (ExprNode)expr.parameters.get(1);
                tempArray = DataQueryUtil.buildSqlExpr(queryCtx, secondPramExpr);
                assert (tempArray.length == 1);
                dataType = tempArray[0].typeInfo.getDataType();
            }
            sqlType = dataType.getSQLType(false).getSQLType();
        } else {
            sqlType = KSqlUtil.getSqlType((String)methodName);
        }
        if (sqlExpr == null) {
            SqlMethodInvokeExpr sqlMethodInvokeExpr = new SqlMethodInvokeExpr(methodName);
            if (expr.parameters.size() > 0) {
                if (sqlMethodInvokeExpr.parameters == null) {
                    sqlMethodInvokeExpr.parameters = new ArrayList();
                }
                int size = expr.parameters.size();
                for (int i = 0; i < size; ++i) {
                    ExprNode pramExpr = (ExprNode)expr.parameters.get(i);
                    InternalSqlExprBuildResult[] tempArray = DataQueryUtil.buildSqlExpr(queryCtx, pramExpr);
                    assert (tempArray.length == 1);
                    sqlMethodInvokeExpr.parameters.add(tempArray[0].sqlExpr);
                }
            }
            sqlExpr = sqlMethodInvokeExpr;
        }
        if (dataType == null) {
            switch (sqlType) {
                case -2: {
                    dataType = DataType.BYTEARRAY;
                    break;
                }
                case 1: {
                    dataType = DataType.CHAR;
                    break;
                }
                case 91: {
                    dataType = DataType.DATE;
                    break;
                }
                case 3: {
                    dataType = DataType.DECIMAL;
                    break;
                }
                case 8: {
                    dataType = DataType.DOUBLE;
                    break;
                }
                case 4: {
                    dataType = DataType.INTEGER;
                    break;
                }
                case 2: {
                    dataType = DataType.DECIMAL;
                    break;
                }
                case 7: {
                    dataType = DataType.DECIMAL;
                    break;
                }
                case 5: {
                    dataType = DataType.SHORT;
                    break;
                }
                case 93: {
                    dataType = DataType.TIMESTAMP;
                    break;
                }
                case -3: {
                    dataType = DataType.BYTEARRAY;
                    break;
                }
                case 12: {
                    dataType = DataType.CHAR;
                }
            }
        }
        String alias = name = expr.toString();
        TypeInfo typeInfo = new TypeInfo(name, alias, dataType, sqlType);
        InternalSqlExprBuildResult rtnVal = new InternalSqlExprBuildResult();
        rtnVal.sqlExpr = sqlExpr;
        rtnVal.srcExpr = expr;
        rtnVal.typeInfo = typeInfo;
        return new InternalSqlExprBuildResult[]{rtnVal};
    }

    public static InternalSqlExprBuildResult[] buildSqlExpr_BinaryOpExpr(DataQueryContext queryCtx, BinaryOpExpr expr) throws BOSException {
        String name;
        int sqlBinaryOpType;
        InternalSqlExprBuildResult[] leftReturnValArray = DataQueryUtil.buildSqlExpr(queryCtx, expr.left);
        InternalSqlExprBuildResult[] rightReturnValArray = DataQueryUtil.buildSqlExpr(queryCtx, expr.right);
        if (leftReturnValArray.length != 1) {
            throw new BOSException("Fatal Error.");
        }
        if (rightReturnValArray.length != 1) {
            throw new BOSException("Fatal Error.");
        }
        InternalSqlExprBuildResult leftReturnVal = leftReturnValArray[0];
        InternalSqlExprBuildResult rightReturnVal = rightReturnValArray[0];
        DataType dataType = null;
        switch (expr.operator) {
            case 0: {
                sqlBinaryOpType = 0;
                break;
            }
            case 2: {
                sqlBinaryOpType = 2;
                break;
            }
            case 3: {
                sqlBinaryOpType = 3;
                break;
            }
            case 4: {
                sqlBinaryOpType = 4;
                break;
            }
            case 5: {
                sqlBinaryOpType = 5;
                break;
            }
            case 6: {
                sqlBinaryOpType = 6;
                break;
            }
            case 7: {
                sqlBinaryOpType = 7;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 8: {
                sqlBinaryOpType = 8;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 42: {
                sqlBinaryOpType = 42;
                dataType = DataType.STRING;
                break;
            }
            case 9: {
                sqlBinaryOpType = 9;
                break;
            }
            case 10: {
                sqlBinaryOpType = 10;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 43: {
                sqlBinaryOpType = 43;
                break;
            }
            case 11: {
                sqlBinaryOpType = 11;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 12: {
                sqlBinaryOpType = 12;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 13: {
                sqlBinaryOpType = 13;
                break;
            }
            case 41: {
                sqlBinaryOpType = 41;
                break;
            }
            case 17: {
                sqlBinaryOpType = 17;
                break;
            }
            case 14: {
                sqlBinaryOpType = 14;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 15: {
                sqlBinaryOpType = 15;
                break;
            }
            case 16: {
                sqlBinaryOpType = 16;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 18: {
                sqlBinaryOpType = 18;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 21: {
                sqlBinaryOpType = 21;
                break;
            }
            case 22: {
                sqlBinaryOpType = 22;
                break;
            }
            case 23: {
                sqlBinaryOpType = 23;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 25: {
                sqlBinaryOpType = 25;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 24: {
                sqlBinaryOpType = 24;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 40: {
                sqlBinaryOpType = 40;
                dataType = DataType.BOOLEAN;
                break;
            }
            case 19: {
                sqlBinaryOpType = 19;
                break;
            }
            case 26: {
                sqlBinaryOpType = 26;
                break;
            }
            case 27: {
                sqlBinaryOpType = 27;
                break;
            }
            default: {
                throw new TODOException();
            }
        }
        String alias = name = expr.toString();
        TypeInfo typeInfo = null;
        if (leftReturnVal.typeInfo.getDataType().equals((Object)rightReturnVal.typeInfo.getDataType())) {
            typeInfo = leftReturnVal.typeInfo;
        } else {
            if (dataType == null) {
                throw new TODOException();
            }
            typeInfo = new TypeInfo(name, alias, dataType, dataType.getSQLType(false).getSQLType());
        }
        InternalSqlExprBuildResult rtnVal = new InternalSqlExprBuildResult();
        rtnVal.sqlExpr = new SqlBinaryOpExpr(leftReturnVal.sqlExpr, sqlBinaryOpType, rightReturnVal.sqlExpr);
        rtnVal.srcExpr = expr;
        rtnVal.typeInfo = typeInfo;
        return new InternalSqlExprBuildResult[]{rtnVal};
    }

    public static InternalSqlExprBuildResult[] buildSqlExpr_PropExpr(DataQueryContext queryCtx, ExprNode expr) throws BOSException {
        if (!DataQueryUtil.isSimplePropExpr(expr)) {
            throw new TODOException();
        }
        ArrayList<InternalSqlExprBuildResult> list = new ArrayList<InternalSqlExprBuildResult>();
        String ident = expr.toString();
        String[] itemArray = ident.split("\\.");
        Object tabSrc = null;
        Object currentObj = null;
        Object prefObject = null;
        String entityIdent = "";
        DataQueryContext currentCtx = queryCtx;
        for (int i = 0; i < itemArray.length; ++i) {
            String propName = itemArray[i];
            if (i == 0) {
                tabSrc = queryCtx.getEntityMap().get(propName);
                if (tabSrc == null) {
                    DataQueryContext tempCtx = currentCtx;
                    while (tempCtx.getParentContext() != null && (tempCtx = tempCtx.getParentContext()).getEntityMap().size() != 0) {
                        tabSrc = tempCtx.getEntityMap().get(propName);
                        if (tabSrc == null) continue;
                        currentCtx = tempCtx;
                        break;
                    }
                }
                if (tabSrc != null) {
                    prefObject = currentObj;
                    currentObj = tabSrc;
                    entityIdent = entityIdent + propName;
                    if (itemArray.length != 1) continue;
                    EntityObjectInfo preEntity = (EntityObjectInfo)prefObject;
                    EntityObjectInfo entity = (EntityObjectInfo)currentObj;
                    DataQueryUtil.buildPropExprResult(queryCtx, list, tabSrc, currentObj, entityIdent, currentCtx, preEntity, entity, propName);
                    continue;
                }
                if (tabSrc == null && queryCtx.getEntityMap().size() != 0) {
                    Map.Entry mapEntry = queryCtx.getEntityMap().entrySet().iterator().next();
                    entityIdent = entityIdent + (String)mapEntry.getKey();
                    tabSrc = mapEntry.getValue();
                    if (tabSrc == null) {
                        throw new TODOException();
                    }
                } else {
                    throw new TODOException();
                }
            }
            if (tabSrc instanceof EntityObjectInfo) {
                EntityObjectInfo entity = (EntityObjectInfo)tabSrc;
                if (propName.equals("*")) {
                    PropertyCollection properties = entity.getPropertiesRuntime();
                    int size = properties.size();
                    for (int j = 0; j < size; ++j) {
                        PropertyInfo propInfo = properties.get(j);
                        if (!(propInfo instanceof OwnPropertyInfo)) continue;
                        OwnPropertyInfo lastPropInfo = (OwnPropertyInfo)propInfo;
                        InternalSqlExprBuildResult exprResult = new InternalSqlExprBuildResult();
                        exprResult.typeInfo = DataQueryUtil.getTypeInfo(lastPropInfo);
                        ColumnInfo columnInfo = lastPropInfo.getMappingField();
                        columnInfo = ORMUtils.ensureColumnLoaded(queryCtx.getBosContext(), columnInfo, entity, (PropertyInfo)lastPropInfo);
                        String columnName = columnInfo.getName();
                        if (columnInfo.isMultilingual()) {
                            columnName = columnName + "_" + queryCtx.getBosContext().getLocale().toString();
                        }
                        EntityObjectInfo propEntity = ORMUtils.getEntity(entity, lastPropInfo.getName());
                        DataTableInfo tabInfo = propEntity.getTable();
                        String tabName = tabInfo.getName();
                        String tabAliasKey = entityIdent + "." + tabName;
                        String tabAlias = (String)currentCtx.getTabAliasMap().get(tabAliasKey);
                        if (tabAlias == null) {
                            tabAlias = currentCtx.getAliasTabPrefix() + currentCtx.getTabAliasMap().size();
                            queryCtx.getTabAliasMap().put(tabAliasKey, tabAlias);
                        }
                        exprResult.sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
                        currentCtx.getIdentEntityMap().put(entityIdent, tabSrc);
                        list.add(exprResult);
                    }
                    if (i == itemArray.length - 1) break;
                    throw new TODOException();
                }
                PropertyInfo propInfo = entity.getPropertyByNameRuntime(propName);
                if (propInfo == null) {
                    DataQueryContext tempCtx = currentCtx;
                    while (tempCtx.getParentContext() != null && (tempCtx = tempCtx.getParentContext()).getEntityMap().size() != 0) {
                        Map.Entry mapEntry = tempCtx.getEntityMap().entrySet().iterator().next();
                        Object entryVal = mapEntry.getValue();
                        if (!(entryVal instanceof EntityObjectInfo) || (propInfo = entity.getPropertyByNameRuntime(propName)) == null) continue;
                        currentCtx = tempCtx;
                        break;
                    }
                }
                if (propInfo == null) {
                    throw new BOSException("property not found. '" + propName + "'");
                }
                if (propInfo instanceof LinkPropertyInfo) {
                    LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)propInfo;
                    RelationshipInfo relationship = linkPropInfo.getRelationship();
                    EntityObjectInfo propEntity = relationship.getChildObject(entity);
                    prefObject = currentObj;
                    currentObj = propEntity;
                    tabSrc = propEntity;
                    if (!entityIdent.endsWith(".")) {
                        entityIdent = entityIdent + ".";
                    }
                    entityIdent = entityIdent + linkPropInfo.getName();
                } else if (propInfo instanceof OwnPropertyInfo) {
                    prefObject = currentObj;
                    currentObj = propInfo;
                } else {
                    throw new TODOException();
                }
                if (i != itemArray.length - 1) continue;
                DataQueryUtil.buildPropExprResult(queryCtx, list, tabSrc, currentObj, entityIdent, currentCtx, (EntityObjectInfo)prefObject, entity, propName);
                continue;
            }
            if (tabSrc instanceof InternalDataQueryResult) {
                InternalDataQueryResult subResult = (InternalDataQueryResult)tabSrc;
                String tabAliasKey = entityIdent;
                String tabAlias = (String)currentCtx.getTabAliasMap().get(tabAliasKey);
                if (tabAlias == null) {
                    tabAlias = currentCtx.getAliasTabPrefix() + currentCtx.getTabAliasMap().size();
                    queryCtx.getTabAliasMap().put(tabAliasKey, tabAlias);
                }
                currentCtx.getIdentEntityMap().put(entityIdent, tabSrc);
                if (propName.equals("*")) {
                    TypeInfo[] typeInfoArray = subResult.getTypeInfoArray();
                    for (int j = 0; j < typeInfoArray.length; ++j) {
                        TypeInfo subTypeInfo = typeInfoArray[j];
                        String subSqlAlias = subTypeInfo.getSqlAlias();
                        TypeInfo typeInfo = new TypeInfo(subTypeInfo.getName(), subTypeInfo.getAlias(), subTypeInfo.getDataType(), subTypeInfo.getSqlType(), subTypeInfo.getEnumMetaDataRef());
                        InternalSqlExprBuildResult exprResult = new InternalSqlExprBuildResult();
                        exprResult.typeInfo = typeInfo;
                        exprResult.srcExpr = expr;
                        exprResult.sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(subSqlAlias));
                        list.add(exprResult);
                    }
                    continue;
                }
                throw new TODOException();
            }
            throw new TODOException(tabSrc.getClass().getName());
        }
        InternalSqlExprBuildResult[] rtnVal = new InternalSqlExprBuildResult[list.size()];
        list.toArray(rtnVal);
        return rtnVal;
    }

    private static void buildPropExprResult(DataQueryContext queryCtx, List list, Object tabSrc, Object currentObj, String entityIdent, DataQueryContext currentCtx, EntityObjectInfo prefEntity, EntityObjectInfo entity, String propName) throws BOSException {
        if (currentObj instanceof EntityObjectInfo) {
            PropertyCollection properties;
            EntityObjectInfo lastEntity = (EntityObjectInfo)currentObj;
            if (queryCtx.state == 0) {
                properties = lastEntity.getPropertiesRuntime();
            } else {
                if (prefEntity != null) {
                    LinkPropertyInfo linkPropInfo = (LinkPropertyInfo)prefEntity.getPropertyByNameRuntime(propName);
                    ColumnInfo columnInfo = linkPropInfo.getMappingField();
                    columnInfo = ORMUtils.ensureColumnLoaded(queryCtx.getBosContext(), columnInfo, prefEntity, (PropertyInfo)linkPropInfo);
                    String columnName = columnInfo.getName();
                    InternalSqlExprBuildResult exprResult = new InternalSqlExprBuildResult();
                    exprResult.typeInfo = new TypeInfo(null, null, DataType.BOOLEAN, 16);
                    EntityObjectInfo propEntity = ORMUtils.getEntity(prefEntity, linkPropInfo.getName());
                    DataTableInfo tabInfo = propEntity.getTable();
                    String tabName = tabInfo.getName();
                    entityIdent = entityIdent.substring(0, entityIdent.lastIndexOf(46));
                    String tabAliasKey = entityIdent + "." + tabName;
                    String tabAlias = (String)currentCtx.getTabAliasMap().get(tabAliasKey);
                    if (tabAlias == null) {
                        tabAlias = currentCtx.getAliasTabPrefix() + currentCtx.getTabAliasMap().size();
                        queryCtx.getTabAliasMap().put(tabAliasKey, tabAlias);
                    }
                    exprResult.sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
                    currentCtx.getIdentEntityMap().put(entityIdent, lastEntity);
                    list.add(exprResult);
                    return;
                }
                LogicalKeyInfo logicalKey = lastEntity.getLogicalKey();
                properties = logicalKey.getKeyPropertys();
            }
            properties = lastEntity.getLogicalKey().getKeyPropertys();
            int size = properties.size();
            for (int j = 0; j < size; ++j) {
                PropertyInfo item = properties.get(j);
                if (!(item instanceof OwnPropertyInfo)) continue;
                OwnPropertyInfo keyPropInfo = (OwnPropertyInfo)properties.get(j);
                InternalSqlExprBuildResult exprResult = new InternalSqlExprBuildResult();
                exprResult.typeInfo = DataQueryUtil.getTypeInfo(keyPropInfo);
                ColumnInfo columnInfo = keyPropInfo.getMappingField();
                columnInfo = ORMUtils.ensureColumnLoaded(queryCtx.getBosContext(), columnInfo, lastEntity, (PropertyInfo)keyPropInfo);
                String columnName = columnInfo.getName();
                if (columnInfo.isMultilingual()) {
                    columnName = columnName + "_" + queryCtx.getBosContext().getLocale().toString();
                }
                EntityObjectInfo propEntity = ORMUtils.getEntity(lastEntity, keyPropInfo.getName());
                DataTableInfo tabInfo = propEntity.getTable();
                String tabName = tabInfo.getName();
                String tabAliasKey = entityIdent + "." + tabName;
                String tabAlias = (String)currentCtx.getTabAliasMap().get(tabAliasKey);
                if (tabAlias == null) {
                    tabAlias = currentCtx.getAliasTabPrefix() + currentCtx.getTabAliasMap().size();
                    queryCtx.getTabAliasMap().put(tabAliasKey, tabAlias);
                }
                exprResult.sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
                currentCtx.getIdentEntityMap().put(entityIdent, lastEntity);
                list.add(exprResult);
            }
        } else if (currentObj instanceof OwnPropertyInfo) {
            OwnPropertyInfo lastPropInfo = (OwnPropertyInfo)currentObj;
            InternalSqlExprBuildResult exprResult = new InternalSqlExprBuildResult();
            exprResult.typeInfo = DataQueryUtil.getTypeInfo(lastPropInfo);
            ColumnInfo columnInfo = lastPropInfo.getMappingField();
            columnInfo = ORMUtils.ensureColumnLoaded(queryCtx.getBosContext(), columnInfo, entity, (PropertyInfo)lastPropInfo);
            String columnName = columnInfo.getName();
            if (columnInfo.isMultilingual()) {
                columnName = columnName + "_" + queryCtx.getBosContext().getLocale().toString();
            }
            EntityObjectInfo propEntity = ORMUtils.getEntity(entity, lastPropInfo.getName());
            DataTableInfo tabInfo = propEntity.getTable();
            String tabName = tabInfo.getName();
            String tabAliasKey = entityIdent + "." + tabName;
            String tabAlias = (String)currentCtx.getTabAliasMap().get(tabAliasKey);
            if (tabAlias == null) {
                tabAlias = currentCtx.getAliasTabPrefix() + currentCtx.getTabAliasMap().size();
                queryCtx.getTabAliasMap().put(tabAliasKey, tabAlias);
            }
            exprResult.sqlExpr = new SqlBinaryOpExpr((SqlExpr)new SqlIdentifierExpr(tabAlias), 20, (SqlExpr)new SqlIdentifierExpr(columnName));
            currentCtx.getIdentEntityMap().put(entityIdent, tabSrc);
            list.add(exprResult);
        } else {
            throw new BOSException("Fatal Error.");
        }
    }

    public static boolean isSimplePropExpr(ExprNode expr) {
        if (expr instanceof IdentifierExpr || expr instanceof AllColumnExpr) {
            return true;
        }
        if (expr instanceof PropertyExpr) {
            PropertyExpr propExpr = (PropertyExpr)expr;
            if (DataQueryUtil.isSimplePropExpr(propExpr.owner)) {
                return true;
            }
        }
        return false;
    }

    public static TypeInfo getTypeInfo(OwnPropertyInfo propInfo) throws BOSException {
        TypeInfo rtnVal;
        DataType dataType = propInfo.getDataType();
        if (dataType.equals((Object)DataType.ENUM)) {
            SQLType sqlType = dataType.getSQLType(propInfo.isMultilingual());
            String enumMetaDataRef = propInfo.getMetaDataRef();
            rtnVal = new TypeInfo(propInfo.getName(), propInfo.getAlias(), dataType, sqlType != null ? sqlType.getSQLType() : 4, enumMetaDataRef);
        } else {
            rtnVal = new TypeInfo(propInfo.getName(), propInfo.getAlias(), dataType, dataType.getSQLType(propInfo.isMultilingual()).getSQLType());
        }
        return rtnVal;
    }
}

