/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.management.SolutionInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectQueryContext {
    private final SolutionInfo solution;
    private final String langId;
    private final EntityObjectInfo entity;
    private Context bosCtx;
    private ObjectQueryContext parentCtx;
    private final List propList;
    private final List propEntityList;
    private final List entityList;
    private final List entityPrefixList;
    private final List fieldList;
    private final int level;
    private final String entityPrefix;
    private final LinkPropertyInfo linkProp;
    private final Map tableAliasMap = new HashMap();
    private Map columnMap = new HashMap();
    private final EntityObjectInfo rootEntity;

    public List getFieldList() {
        return this.fieldList;
    }

    public ObjectQueryContext(Context bosCtx, EntityObjectInfo entity, String entityPrefix, LinkPropertyInfo linkProp) {
        this.level = 0;
        this.bosCtx = bosCtx;
        this.entity = entity;
        this.rootEntity = entity;
        this.entityPrefix = entityPrefix;
        this.linkProp = linkProp;
        this.propList = new ArrayList();
        this.propEntityList = new ArrayList();
        this.entityList = new ArrayList();
        this.entityPrefixList = new ArrayList();
        this.fieldList = new ArrayList();
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)bosCtx);
        this.solution = loader.getSolution();
        this.langId = bosCtx.getLocale().toString();
    }

    public ObjectQueryContext(ObjectQueryContext parentCtx, EntityObjectInfo entity, String entityPrefix, LinkPropertyInfo linkProp) {
        this.parentCtx = parentCtx;
        this.entity = entity;
        this.entityPrefix = entityPrefix;
        this.linkProp = linkProp;
        this.propList = new ArrayList();
        this.propEntityList = new ArrayList();
        this.entityList = new ArrayList();
        this.entityPrefixList = new ArrayList();
        this.fieldList = new ArrayList();
        if (parentCtx != null) {
            this.bosCtx = parentCtx.bosCtx;
            this.level = parentCtx.level + 1;
            this.rootEntity = parentCtx.rootEntity;
            this.solution = parentCtx.solution;
            this.langId = parentCtx.langId;
        } else {
            this.bosCtx = null;
            this.level = 0;
            this.rootEntity = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.bosCtx);
            this.solution = loader.getSolution();
            this.langId = null;
        }
    }

    public Context getBosCtx() {
        return this.bosCtx;
    }

    public ObjectQueryContext getParentCtx() {
        return this.parentCtx;
    }

    public List getEntityList() {
        return this.entityList;
    }

    public List getEntityPrefixList() {
        return this.entityPrefixList;
    }

    public List getPropEntityList() {
        return this.propEntityList;
    }

    public List getPropList() {
        return this.propList;
    }

    public EntityObjectInfo getCurrentEntity() {
        return this.entity;
    }

    public String getLangId() {
        return this.langId;
    }

    public SolutionInfo getSolution() {
        return this.solution;
    }

    public String getCurrentEntityPrefix() {
        return this.entityPrefix;
    }

    public LinkPropertyInfo getCurrentLinkProp() {
        return this.linkProp;
    }

    public Map getTableAliasMap() {
        return this.tableAliasMap;
    }

    public EntityObjectInfo getRootEntity() {
        return this.rootEntity;
    }

    public Map getColumnMap() {
        return this.columnMap;
    }
}

