/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.TypelessObjectValue;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecutePlan;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.ExecuteStep;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.IPlanExecutor;
import com.kingdee.bos.dao.ormapping_ex.runtime.objectquery.SelectItemInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.LogicalKeyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TODOException;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractPlanExecutor
implements IPlanExecutor {
    private static final Logger logger = Logger.getLogger(AbstractPlanExecutor.class);

    protected abstract void buildSql(Context var1, ExecutePlan var2, StringBuffer var3, List var4, List var5) throws BOSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IObjectCollection getCollection(Context ctx, Connection conn, ExecutePlan plan, List assignToList, List literalValList) throws BOSException {
        if (assignToList.size() != literalValList.size()) {
            throw new BOSException("Fatal Error.");
        }
        StringBuffer buff = new StringBuffer();
        this.buildSql(ctx, plan, buff, assignToList, literalValList);
        String sql = buff.toString();
        IObjectCollection objCol = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int rsIndex = 0;
        try {
            stmt = conn.prepareStatement(sql);
            this.setPreparedStmt(plan, assignToList, literalValList, stmt);
            stmt.execute();
            do {
                if ((rs = stmt.getResultSet()) == null) continue;
                try {
                    rs = stmt.getResultSet();
                    if (rs == null) {
                        stmt.getMoreResults();
                        break;
                    }
                    if (rsIndex == 0) {
                        objCol = this.buildObjectCollection(ctx, plan, rs);
                    } else {
                        this.fillObjectCollection(ctx, plan, rsIndex, rs, objCol);
                    }
                    ++rsIndex;
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs);
                }
            } while (stmt.getMoreResults() || stmt.getUpdateCount() != -1);
        }
        catch (SQLException ex) {
            throw new BOSException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt);
        }
        if (objCol == null) {
            throw new BOSException("Fatal Error.");
        }
        return objCol;
    }

    protected void setPreparedStmt(ExecutePlan plan, List assignToList, List literalValList, PreparedStatement stmt) throws SQLException, BOSException {
        int size = assignToList.size();
        for (int i = 0; i < size; ++i) {
            SerializableByteArrayInputStream in;
            byte[] bytesTemp;
            Object val;
            SQLType sqlType;
            OwnPropertyInfo ownPropInfo;
            DataType dataType;
            String assignTo = (String)assignToList.get(i);
            Object literalVal = literalValList.get(i);
            if (assignTo == null) {
                stmt.setObject(i + 1, literalVal);
                continue;
            }
            PropertyInfo propInfo = null;
            String[] propNameArray = assignTo.split("\\.");
            EntityObjectInfo propEntity = plan.getEntity();
            for (int j = 0; j < propNameArray.length; ++j) {
                String itemPropName = propNameArray[j];
                propInfo = propEntity.getPropertyByNameRuntime(itemPropName);
                if (j >= propNameArray.length - 1) continue;
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                RelationshipInfo relationship = linkProp.getRelationship();
                propEntity = relationship.getChildObject(propEntity);
            }
            if (!(propInfo instanceof OwnPropertyInfo)) {
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propInfo;
                if (linkProp == null) {
                    throw new BOSException("Fatal Error. prop is null.");
                }
                RelationshipInfo relationship = linkProp.getRelationship();
                EntityObjectInfo childEntity = relationship.getChildObject(propEntity);
                LogicalKeyInfo logicalKey = childEntity.getLogicalKey();
                PropertyCollection keyPropCol = logicalKey.getKeyPropertys();
                if (keyPropCol.size() != 1) {
                    throw new TODOException();
                }
                OwnPropertyInfo keyProp = (OwnPropertyInfo)keyPropCol.get(0);
                propInfo = keyProp;
            }
            if ((dataType = (ownPropInfo = (OwnPropertyInfo)propInfo).getDataType()).equals((Object)DataType.BOSUUID) && literalVal instanceof String) {
                BOSUuid boId = BOSUuid.read((String)((String)literalVal));
                literalVal = boId;
            }
            if ((sqlType = ownPropInfo.getMappingField().getTypeName()).equals((Object)SQLType.CHAR)) {
                if (literalVal == null) {
                    stmt.setNull(i + 1, 1);
                    continue;
                }
                val = TypeConversionUtils.objToString(literalVal);
                bytesTemp = ((String)val).getBytes();
                in = new SerializableByteArrayInputStream(bytesTemp);
                stmt.setAsciiStream(i + 1, (InputStream)in, bytesTemp.length);
                continue;
            }
            if (sqlType.equals((Object)SQLType.VARCHAR)) {
                if (literalVal == null) {
                    stmt.setNull(i + 1, 12);
                    continue;
                }
                val = TypeConversionUtils.objToString(literalVal);
                bytesTemp = ((String)val).getBytes();
                in = new SerializableByteArrayInputStream(bytesTemp);
                stmt.setAsciiStream(i + 1, (InputStream)in, bytesTemp.length);
                continue;
            }
            if (sqlType.equals((Object)SQLType.NCHAR)) {
                if (literalVal == null) {
                    stmt.setNull(i + 1, 1);
                    continue;
                }
                val = TypeConversionUtils.objToString(literalVal);
                stmt.setString(i + 1, (String)val);
                continue;
            }
            if (sqlType.equals((Object)SQLType.NVARCHAR)) {
                if (literalVal == null) {
                    stmt.setNull(i + 1, 12);
                    continue;
                }
                val = TypeConversionUtils.objToString(literalVal);
                stmt.setString(i + 1, (String)val);
                continue;
            }
            if (sqlType.equals((Object)SQLType.DATETIME)) {
                if (literalVal == null) {
                    stmt.setNull(i + 1, 93);
                    continue;
                }
                val = TypeConversionUtils.objToTimestamp(literalVal);
                stmt.setTimestamp(i + 1, (Timestamp)val);
                continue;
            }
            if (sqlType.equals((Object)SQLType.INT)) {
                if (literalVal == null) {
                    stmt.setNull(i + 1, 4);
                    continue;
                }
                int val2 = TypeConversionUtils.objToInt(literalVal);
                stmt.setInt(i + 1, val2);
                continue;
            }
            throw new TODOException(sqlType.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readFromResultSet(SQLType sqlType, ResultSet rs, int i) throws SQLException {
        Object sqlVal;
        if (sqlType.equals((Object)SQLType.CHAR) || sqlType.equals((Object)SQLType.NCHAR) || sqlType.equals((Object)SQLType.VARCHAR) || sqlType.equals((Object)SQLType.NVARCHAR)) {
            sqlVal = rs.getString(i + 1);
        } else if (sqlType.equals((Object)SQLType.INT)) {
            sqlVal = rs.getInt(i + 1);
        } else if (sqlType.equals((Object)SQLType.DATETIME)) {
            sqlVal = rs.getTimestamp(i + 1);
        } else if (sqlType.equals((Object)SQLType.NUMERIC)) {
            sqlVal = rs.getBigDecimal(i + 1);
        } else if (sqlType.equals((Object)SQLType.NCLOB)) {
            sqlVal = rs.getString(i + 1);
        } else if (sqlType.equals((Object)SQLType.CLOB)) {
            sqlVal = rs.getString(i + 1);
        } else if (sqlType.equals((Object)SQLType.BLOB)) {
            InputStream in = null;
            try {
                in = rs.getBinaryStream(i + 1);
                if (in == null) {
                    sqlVal = null;
                }
                int blockSize = 1024;
                byte[] block = new byte[1024];
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                int len = -1;
                do {
                    try {
                        len = in.read(block);
                    }
                    catch (IOException e1) {
                        throw new SQLException(e1.getMessage());
                    }
                    if (len <= 0) continue;
                    byteOut.write(block, 0, len);
                } while (len == 1024);
                sqlVal = byteOut.toByteArray();
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        } else {
            throw new TODOException(sqlType.getName());
        }
        return sqlVal;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getValue(Object sqlVal, PropertyInfo propInfo) throws BOSException {
        Enum enumVal;
        Class<?> type;
        boolean convert = false;
        if (!convert) {
            return sqlVal;
        }
        if (!(propInfo instanceof OwnPropertyInfo)) throw new TODOException();
        OwnPropertyInfo ownPropInfo = (OwnPropertyInfo)propInfo;
        DataType dataType = ownPropInfo.getDataType();
        if (sqlVal == null) {
            return null;
        }
        if (dataType.equals((Object)DataType.BOSUUID)) {
            if (!(sqlVal instanceof String)) throw new TODOException();
            BOSUuid boId = BOSUuid.read((String)((String)sqlVal));
            return boId;
        }
        if (dataType.equals((Object)DataType.INTEGER)) {
            if (!(sqlVal instanceof Integer)) throw new TODOException();
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.STRING)) {
            if (!(sqlVal instanceof String)) throw new TODOException(sqlVal.getClass().toString());
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.DATE)) {
            if (sqlVal instanceof Date) {
                Date dataVal = (Date)sqlVal;
                long time = dataVal.getTime();
                long tuncatedTime = time / 1000L * 1000L;
                return new Timestamp(tuncatedTime);
            }
            if (!(sqlVal instanceof Timestamp)) return TypeConversionUtils.objToDate((Object)sqlVal);
            Timestamp timestampVal = (Timestamp)sqlVal;
            long time = timestampVal.getTime();
            long tuncatedTime = time / 1000L * 1000L;
            timestampVal = new Timestamp(tuncatedTime);
            return timestampVal;
        }
        if (dataType.equals((Object)DataType.BOOLEAN)) {
            boolean booleanVal = TypeConversionUtils.objToBoolean((Object)sqlVal);
            if (!(sqlVal instanceof Boolean)) return booleanVal ? Boolean.TRUE : Boolean.FALSE;
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.DECIMAL)) {
            if (!(sqlVal instanceof BigDecimal)) return TypeConversionUtils.objToBigDecimal((Object)sqlVal);
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.TIMESTAMP)) {
            if (!(sqlVal instanceof Timestamp)) return TypeConversionUtils.objToTimestamp((Object)sqlVal);
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.BYTEARRAY)) {
            if (!(sqlVal instanceof byte[])) return TypeConversionUtils.objToBytes((Object)sqlVal);
            return sqlVal;
        }
        if (dataType.equals((Object)DataType.DOUBLE)) {
            if (sqlVal instanceof Double) {
                return sqlVal;
            }
            double doubleVal = TypeConversionUtils.objToDouble((Object)sqlVal);
            return new Double(doubleVal);
        }
        if (dataType.equals((Object)DataType.FLOAT)) {
            if (sqlVal instanceof Float) {
                return sqlVal;
            }
            float floatVal = TypeConversionUtils.objToFloat((Object)sqlVal);
            return new Float(floatVal);
        }
        if (!dataType.equals((Object)DataType.ENUM)) throw new TODOException(dataType.getName());
        String metaDataRef = ownPropInfo.getMetaDataRef();
        try {
            type = Class.forName(metaDataRef);
        }
        catch (ClassNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (IntEnum.class.isAssignableFrom(type)) {
            int intVal = TypeConversionUtils.objToInt((Object)sqlVal);
            try {
                Method method = type.getMethod("getEnum", Integer.TYPE);
                enumVal = (Enum)method.invoke(null, intVal);
                return enumVal;
            }
            catch (SecurityException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (!StringEnum.class.isAssignableFrom(type)) throw new TODOException();
        String strVal = TypeConversionUtils.objToString((Object)sqlVal);
        try {
            Method method = type.getMethod("getEnum", String.class);
            enumVal = (Enum)method.invoke(null, strVal);
            return enumVal;
        }
        catch (SecurityException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void putObjectPropertyValue(IObjectValue obj, Object sqlVal, PropertyInfo propInfo, String localLangId, String propLangId) throws BOSException {
        Object val = this.getValue(sqlVal, propInfo);
        if (propInfo instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownPropInfo = (OwnPropertyInfo)propInfo;
            String propName = ownPropInfo.getName();
            if (ownPropInfo.isMultilingual()) {
                obj.put(propName + "_" + propLangId, val);
                if (localLangId.equalsIgnoreCase(propLangId)) {
                    obj.put(propName, val);
                }
            } else {
                obj.put(propName, val);
            }
        } else {
            throw new TODOException(propInfo.getClass().toString());
        }
    }

    protected IObjectCollection buildObjectCollection(Context ctx, ExecutePlan plan, ResultSet rs) throws BOSException {
        EntityObjectInfo entity = plan.getEntity();
        IObjectCollection objCol = Utils.newObjectCollectionInstance(entity);
        ExecuteStep step = (ExecuteStep)plan.getSteps().get(0);
        List selectItemList = step.getSelectItemList();
        int columnSize = selectItemList.size();
        SelectItemInfo[] selectItemArray = new SelectItemInfo[columnSize];
        selectItemList.toArray(selectItemArray);
        String localLangId = ctx.getLocale().toString();
        try {
            while (rs.next()) {
                int i;
                IObjectValue obj = AbstractPlanExecutor.newObjectValueInstance(entity);
                for (i = 0; i < columnSize; ++i) {
                    SQLType sqlType = selectItemArray[i].getColumnInfo().getTypeName();
                    Object sqlVal = this.readFromResultSet(sqlType, rs, i);
                    String ident = selectItemArray[i].getIdent();
                    String[] propNameArray = ident.split("\\.");
                    String propLangId = selectItemArray[i].getLangId();
                    PropertyInfo propInfo = selectItemArray[i].getPropInfo();
                    if (propNameArray.length == 1) {
                        this.putObjectPropertyValue(obj, sqlVal, propInfo, localLangId, propLangId);
                        continue;
                    }
                    IObjectValue parentObj = null;
                    EntityObjectInfo parentEntity = null;
                    LinkPropertyInfo parentLinkProp = null;
                    PropertyInfo curPropInfo = null;
                    for (int j = 0; j < propNameArray.length; ++j) {
                        if (j == 0) {
                            parentObj = obj;
                            parentEntity = entity;
                        } else {
                            if (!(curPropInfo instanceof LinkPropertyInfo)) {
                                throw new BOSException("Fatal Error.");
                            }
                            parentLinkProp = (LinkPropertyInfo)curPropInfo;
                            parentEntity = parentLinkProp.getRelationship().getChildObject(parentEntity);
                        }
                        curPropInfo = parentEntity.getPropertyByNameRuntime(propNameArray[j]);
                        String propName = curPropInfo.getName();
                        if (j < propNameArray.length - 1) {
                            IObjectValue objVal = (IObjectValue)parentObj.get(propName);
                            if (objVal != null) continue;
                            parentLinkProp = (LinkPropertyInfo)curPropInfo;
                            EntityObjectInfo curEntity = parentLinkProp.getRelationship().getChildObject(parentEntity);
                            objVal = AbstractPlanExecutor.newObjectValueInstance(curEntity);
                            parentObj.put(propName, (Object)objVal);
                            continue;
                        }
                        String linkPropName = parentLinkProp.getName();
                        IObjectValue objVal = (IObjectValue)parentObj.get(linkPropName);
                        this.putObjectPropertyValue(objVal, sqlVal, propInfo, localLangId, propLangId);
                    }
                }
                for (i = 0; i < columnSize; ++i) {
                    String ident = selectItemArray[i].getIdent();
                    String[] propNameArray = ident.split("\\.");
                    PropertyInfo propInfo = selectItemArray[i].getPropInfo();
                    if (propNameArray.length <= 1) continue;
                    IObjectValue parentObj = null;
                    EntityObjectInfo parentEntity = null;
                    LinkPropertyInfo parentLinkProp = null;
                    PropertyInfo curPropInfo = null;
                    for (int j = 0; j < propNameArray.length; ++j) {
                        Object keyPropVal;
                        IObjectValue objVal;
                        if (j == 0) {
                            parentObj = obj;
                            parentEntity = entity;
                        } else {
                            if (!(curPropInfo instanceof LinkPropertyInfo)) {
                                throw new BOSException("Fatal Error.");
                            }
                            parentLinkProp = (LinkPropertyInfo)curPropInfo;
                            parentEntity = parentLinkProp.getRelationship().getChildObject(parentEntity);
                        }
                        curPropInfo = parentEntity.getPropertyByNameRuntime(propNameArray[j]);
                        String curPropName = curPropInfo.getName();
                        if (j >= propNameArray.length - 1 || (objVal = (IObjectValue)parentObj.get(curPropName)) == null) continue;
                        String pkField = objVal.getPKField();
                        String lastPropName = propInfo.getName();
                        if (!lastPropName.equals(pkField) || (keyPropVal = objVal.get(pkField)) != null) continue;
                        parentObj.setNull(curPropName);
                    }
                }
                objCol.addObject(obj);
            }
        }
        catch (SQLException ex) {
            throw new BOSException(ex.getMessage(), (Throwable)ex);
        }
        return objCol;
    }

    protected void fillObjectCollection(Context ctx, ExecutePlan plan, int stepIndex, ResultSet rs, IObjectCollection objCol) throws BOSException {
        ExecuteStep step = (ExecuteStep)plan.getSteps().get(stepIndex);
        EntityObjectInfo entity = step.getEntity();
        LinkPropertyInfo linkProp = step.getLinkProperty();
        String propName = linkProp.getName();
        String prefix = step.getEntityPrefix();
        List selectItemList = step.getSelectItemList();
        int columnSize = selectItemList.size();
        SelectItemInfo[] selectItemArray = new SelectItemInfo[columnSize];
        selectItemList.toArray(selectItemArray);
        String localLangId = ctx.getLocale().toString();
        ArrayList<SelectItemInfo> parentKeySelectItemList = new ArrayList<SelectItemInfo>();
        for (int i = stepIndex - 1; i >= 0; --i) {
            ExecuteStep preStep = (ExecuteStep)plan.getSteps().get(i);
            EntityObjectInfo parentEntity = preStep.getEntity();
            LogicalKeyInfo parentLogicalKey = parentEntity.getLogicalKey();
            if (parentLogicalKey.getKeyPropertys().size() != 1) {
                throw new TODOException();
            }
            OwnPropertyInfo parentKeyProp = (OwnPropertyInfo)parentLogicalKey.getKeyPropertys().get(0);
            String parentPrefix = preStep.getEntityPrefix();
            if (parentPrefix != null && !prefix.startsWith(parentPrefix)) continue;
            String ident = parentPrefix == null ? parentKeyProp.getName() : parentPrefix + "." + parentKeyProp.getName();
            SelectItemInfo selectItem = null;
            List prefSelectItemList = preStep.getSelectItemList();
            int itemSize = prefSelectItemList.size();
            for (int j = 0; j < itemSize; ++j) {
                SelectItemInfo item = (SelectItemInfo)prefSelectItemList.get(j);
                if (!item.getIdent().equalsIgnoreCase(ident)) continue;
                selectItem = item;
                break;
            }
            if (selectItem == null) {
                throw new TODOException();
            }
            parentKeySelectItemList.add(selectItem);
        }
        try {
            while (rs.next()) {
                int size;
                int i;
                IObjectValue entry = AbstractPlanExecutor.newObjectValueInstance(entity);
                for (i = 0; i < columnSize; ++i) {
                    SQLType sqlType = selectItemArray[i].getColumnInfo().getTypeName();
                    Object sqlVal = this.readFromResultSet(sqlType, rs, i);
                    String propLangId = selectItemArray[i].getLangId();
                    String ident = selectItemArray[i].getIdent();
                    ident = ident.substring(prefix.length() + 1);
                    String[] propNameArray = ident.split("\\.");
                    PropertyInfo propInfo = selectItemArray[i].getPropInfo();
                    if (propNameArray.length == 1) {
                        this.putObjectPropertyValue(entry, sqlVal, propInfo, localLangId, propLangId);
                        continue;
                    }
                    IObjectValue parentObj = null;
                    EntityObjectInfo parentEntity = null;
                    LinkPropertyInfo parentLinkProp = null;
                    PropertyInfo curPropInfo = null;
                    for (int j = 0; j < propNameArray.length; ++j) {
                        if (j == 0) {
                            parentObj = entry;
                            parentEntity = entity;
                        } else {
                            if (!(curPropInfo instanceof LinkPropertyInfo)) {
                                throw new BOSException("Fatal Error.");
                            }
                            parentLinkProp = (LinkPropertyInfo)curPropInfo;
                            parentEntity = parentLinkProp.getRelationship().getChildObject(parentEntity);
                        }
                        curPropInfo = parentEntity.getPropertyByNameRuntime(propNameArray[j]);
                        String entryPropName = curPropInfo.getName();
                        if (j < propNameArray.length - 1) {
                            IObjectValue objVal = (IObjectValue)parentObj.get(entryPropName);
                            if (objVal != null) continue;
                            parentLinkProp = (LinkPropertyInfo)curPropInfo;
                            EntityObjectInfo curEntity = parentLinkProp.getRelationship().getChildObject(parentEntity);
                            objVal = AbstractPlanExecutor.newObjectValueInstance(curEntity);
                            parentObj.put(entryPropName, (Object)objVal);
                            continue;
                        }
                        String linkPropName = parentLinkProp.getName();
                        IObjectValue objVal = (IObjectValue)parentObj.get(linkPropName);
                        this.putObjectPropertyValue(objVal, sqlVal, propInfo, localLangId, propLangId);
                    }
                }
                for (i = 0; i < columnSize; ++i) {
                    String ident = selectItemArray[i].getIdent().substring(step.getEntityPrefix().length() + 1);
                    String[] propNameArray = ident.split("\\.");
                    PropertyInfo propInfo = selectItemArray[i].getPropInfo();
                    if (propNameArray.length <= 1) continue;
                    IObjectValue parentObj = null;
                    EntityObjectInfo parentEntity = null;
                    LinkPropertyInfo parentLinkProp = null;
                    PropertyInfo curPropInfo = null;
                    for (int j = 0; j < propNameArray.length; ++j) {
                        Object keyPropVal;
                        IObjectValue objVal;
                        if (j == 0) {
                            parentObj = entry;
                            parentEntity = entity;
                        } else {
                            if (!(curPropInfo instanceof LinkPropertyInfo)) {
                                throw new BOSException("Fatal Error.");
                            }
                            parentLinkProp = (LinkPropertyInfo)curPropInfo;
                            parentEntity = parentLinkProp.getRelationship().getChildObject(parentEntity);
                        }
                        curPropInfo = parentEntity.getPropertyByNameRuntime(propNameArray[j]);
                        String curPropName = curPropInfo.getName();
                        if (j >= propNameArray.length - 1 || (objVal = (IObjectValue)parentObj.get(curPropName)) == null) continue;
                        String pkField = objVal.getPKField();
                        String lastPropName = propInfo.getName();
                        if (!lastPropName.equals(pkField) || (keyPropVal = objVal.get(pkField)) != null) continue;
                        parentObj.setNull(curPropName);
                    }
                }
                IObjectCollection parentCol = null;
                IObjectValue parentObj = null;
                for (int i2 = size = columnSize + parentKeySelectItemList.size() - 1; i2 >= columnSize; --i2) {
                    SelectItemInfo parentKeyItem = (SelectItemInfo)parentKeySelectItemList.get(i2 - columnSize);
                    PropertyInfo parentKeyPropInfo = parentKeyItem.getPropInfo();
                    SQLType sqlType = parentKeyItem.getColumnInfo().getTypeName();
                    Object sqlVal = this.readFromResultSet(sqlType, rs, i2);
                    Object val = this.getValue(sqlVal, parentKeyPropInfo);
                    if (val == null) {
                        throw new TODOException();
                    }
                    if (i2 == size) {
                        parentCol = objCol;
                    } else {
                        String ident = parentKeyItem.getIdent();
                        String[] propNameArray = ident.split("\\.");
                        if (propNameArray.length < 2) {
                            throw new TODOException();
                        }
                        String entriesName = propNameArray[propNameArray.length - 2];
                        parentCol = (IObjectCollection)parentObj.get(entriesName);
                    }
                    parentObj = parentCol.getObject(val);
                    if (parentObj != null) continue;
                    throw new TODOException();
                }
                if (parentObj == null) {
                    throw new TODOException();
                }
                Object parentPropVal = parentObj.get(propName);
                if (parentPropVal != null && !(parentPropVal instanceof IObjectCollection)) {
                    throw new TODOException();
                }
                IObjectCollection entryCol = (IObjectCollection)parentPropVal;
                if (entryCol == null) {
                    entryCol = Utils.newObjectCollectionInstance(entity);
                    parentObj.put(propName, (Object)entryCol);
                }
                entryCol.addObject(entry);
            }
        }
        catch (SQLException ex) {
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
            throw new BOSException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static IObjectValue newObjectValueInstance(EntityObjectInfo entity) throws InvalidDAOMetaDataException {
        TypelessObjectValue obj;
        assert (entity != null);
        if (entity == null || StringUtils.isEmpty((String)entity.getObjectValueClassRuntime())) {
            obj = new TypelessObjectValue();
        } else {
            try {
                obj = (IObjectValue)Class.forName(entity.getObjectValueClassRuntime()).newInstance();
            }
            catch (Exception e) {
                throw new InvalidDAOMetaDataException("create object by objectValueClass error. entity name:" + entity.getName() + "\n" + e.getMessage(), (Throwable)e);
            }
        }
        return obj;
    }
}

