/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.IVirtualModeDataAccess;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.dao.query.server.VirtualModeDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.util.List;
import org.apache.log4j.Logger;

public class EntityExecutor
implements IDataProvider {
    private static final int ZERO = 0;
    private final Context ctx;
    private final Context objectCtx;
    private final IMetaDataPK pk;
    private EntityViewInfo view;
    protected final QueryExecuteOption option;
    private static final Logger logger = Logger.getLogger(EntityExecutor.class);

    public EntityExecutor(IMetaDataPK pk) {
        this(null, pk);
    }

    public EntityExecutor(IMetaDataPK pk, Context objectCtx) {
        this.ctx = null;
        if (objectCtx != null) {
            objectCtx.put((Object)"IS_OBJECT_CONTEXT", (Object)"true");
        }
        this.objectCtx = objectCtx;
        this.pk = pk;
        this.view = new EntityViewInfo();
        this.option = new QueryExecuteOption();
    }

    public EntityExecutor(Context ctx, IMetaDataPK pk) {
        this.ctx = ctx;
        this.objectCtx = null;
        this.pk = pk;
        this.view = new EntityViewInfo();
        this.option = new QueryExecuteOption();
    }

    @Override
    public QueryExecuteOption option() {
        return this.option;
    }

    @Override
    public EntityViewInfo getObjectView() {
        return this.view;
    }

    @Override
    public void setObjectView(EntityViewInfo view) {
        this.view = view;
    }

    @Override
    public void setObjectView(String oql) throws BOSException {
        try {
            this.view = new EntityViewInfo(oql);
        }
        catch (ParserException e) {
            logger.error((Object)"parser oql error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public String getSQL() throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getEntitySql(this.pk, this.view);
    }

    @Override
    public boolean hasResult() throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.hasResultByEntity(this.pk, this.getObjectView(), this.option);
    }

    @Override
    public int getRowCount() throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowCountByEntity(this.pk, this.getObjectView(), this.option);
    }

    @Override
    public int getRowCountByFields(String[] countFields) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowCountByEntity(this.pk, this.getObjectView(), this.option, countFields);
    }

    @Override
    public IRowSet executeQuery() throws BOSException {
        return this.executeQuery(0, Integer.MAX_VALUE);
    }

    @Override
    public IRowSet executeQuery(List keyList) throws BOSException {
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowSet(this.pk, MetaDataTypeList.ENTITY, (List<String>)keyList, this.view, null, this.option);
    }

    @Override
    public IRowSet executeQuery(int start, int length) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getEntityRowSet(this.pk, this.getObjectView(), this.option, start, length);
    }

    @Override
    public IRowSet executeQuery(Uuid querySessionID, int start, int length) throws BOSException {
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowSet(querySessionID, this.pk, MetaDataTypeList.ENTITY, this.view, null, null, this.option, start, length);
    }

    @Override
    public Uuid openQuery() throws BOSException {
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.openQuery(this.pk, MetaDataTypeList.ENTITY, this.getObjectView(), null, null, this.option);
    }

    @Override
    public List getQueryKeys(Uuid querySessionID) throws BOSException {
        return this.getQueryKeys(querySessionID, 0);
    }

    @Override
    public List getQueryKeys(Uuid querySessionID, int length) throws BOSException {
        return this.getQueryKeys(querySessionID, 0, length);
    }

    @Override
    public List getQueryKeys(Uuid querySessionID, int start, int length) throws BOSException {
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getQueryPKList(querySessionID, this.pk, MetaDataTypeList.ENTITY, this.view, null, null, this.option, start, length);
    }

    @Override
    public void releaseQueryCache(Uuid querySessionID) {
        try {
            IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
            qda.closeQuery(querySessionID);
        }
        catch (BOSException e) {
            logger.error((Object)"releaseQueryCache(querySessionID) occur error: ", (Throwable)e);
        }
    }

    @Override
    public int getRowCount(Uuid querySessionID) throws BOSException {
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowCount(querySessionID, this.pk, MetaDataTypeList.ENTITY, this.view, null, null, this.option);
    }

    @Override
    public int getRowCountByFields(Uuid querySessionID, String[] fields) throws BOSException {
        IVirtualModeDataAccess qda = VirtualModeDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowCount(querySessionID, this.pk, MetaDataTypeList.ENTITY, this.view, null, null, this.option, fields);
    }

    @Override
    public IRowSet executeQueryForRealPage(int start, int length) throws BOSException {
        IQueryDataAccess qda = QueryDataAccessFactory.getInstance(this.ctx, this.objectCtx);
        return qda.getRowSetForRealPage(this.pk, this.getObjectView(), null, this.option, start, length);
    }
}

