/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.CachedQueryMonitor;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.SqlAndParam;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.orm.IORMModel;
import com.kingdee.bos.orm.ORMCoreException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class QueryDataAccessInterceptor
implements IQueryDataAccess {
    private final IQueryDataAccess qda;
    private final ICacheService cacheSvc;
    private static HashSet monitorSet = new HashSet();

    public static void addMonitor(CachedQueryMonitor monitor) {
        monitorSet.add(monitor);
    }

    public static void removeMonitor(CachedQueryMonitor monitor) {
        monitorSet.remove(monitor);
    }

    public static void notifyMonitorSet(String remoteInterface, String method, long timespan) {
        for (CachedQueryMonitor monitor : monitorSet) {
            monitor.passCachedQueryInfo(remoteInterface, method, timespan);
        }
    }

    public QueryDataAccessInterceptor(IQueryDataAccess qda) {
        this.qda = qda;
        this.cacheSvc = CacheServiceFactory.getInstance();
    }

    @Override
    public IRowSet getEntityRowSet(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option, int start, int length) throws BOSException {
        Object[] args = new Object[]{entityPK, view, option, start, length};
        MultiParamKey key = MultiParamKey.create((Object[])(args = QueryDataAccessInterceptor.processArgumentsForKeyGenerator(args, null, false)));
        if (ActionCache.containsKey((Object)key)) {
            return (IRowSet)ActionCache.get((Object)key);
        }
        BOSObjectType type = Utils.getBOSTypeFromEntityPK((IMetaDataPK)entityPK);
        return this.qda.getEntityRowSet(entityPK, view, option, start, length);
    }

    public IRowSet getRowSet(IMetaDataPK queryPK, EntityViewInfo view, Map parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        Object[] args = new Object[]{queryPK, view, this.getParametersString(parameters), option, start, length};
        args = QueryDataAccessInterceptor.processArgumentsForKeyGenerator(args, null, false);
        MultiParamKey key = null;
        try {
            Method method = IQueryDataAccess.class.getMethod("getRowSet", IMetaDataPK.class, EntityViewInfo.class, Map.class, QueryExecuteOption.class, Integer.TYPE, Integer.TYPE);
            key = MultiParamKey.create(IQueryDataAccess.class, (Method)method, (Object[])args);
        }
        catch (NoSuchMethodException e) {
            key = MultiParamKey.create((Object[])args);
        }
        if (ActionCache.containsKey((Object)(key == null ? null : key.toString()))) {
            return (IRowSet)ActionCache.get((Object)(key == null ? null : key.toString()));
        }
        return this.qda.getRowSet(queryPK, view, (Map<Integer, Object>)parameters, option, start, length);
    }

    public IRowSet getRowSet(IMetaDataPK queryPK, Map views, Map parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        Object[] args = new Object[]{queryPK, this.getEntityViewsString(views), this.getParametersString(parameters), option, start, length};
        args = QueryDataAccessInterceptor.processArgumentsForKeyGenerator(args, null, false);
        MultiParamKey key = null;
        try {
            Method method = IQueryDataAccess.class.getMethod("getRowSet", IMetaDataPK.class, EntityViewInfo.class, Map.class, QueryExecuteOption.class, Integer.TYPE, Integer.TYPE);
            key = MultiParamKey.create(IQueryDataAccess.class, (Method)method, (Object[])args);
        }
        catch (NoSuchMethodException e) {
            key = MultiParamKey.create((Object[])args);
        }
        if (ActionCache.containsKey((Object)(key == null ? null : key.toString()))) {
            return (IRowSet)ActionCache.get((Object)(key == null ? null : key.toString()));
        }
        return this.qda.getRowSet(queryPK, views, (Map<Integer, Object>)parameters, option, start, length);
    }

    private String getParametersString(Map parameters) {
        if (parameters == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry entry : parameters.entrySet()) {
            Integer index = (Integer)entry.getKey();
            Object value = entry.getValue();
            sbuf.append(index.toString());
            sbuf.append(":");
            sbuf.append(value == null ? "null" : value.toString());
            sbuf.append("!");
        }
        return sbuf.toString();
    }

    private String getEntityViewsString(Map views) {
        if (views == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        for (Map.Entry entry : views.entrySet()) {
            String objName = (String)entry.getKey();
            EntityViewInfo ev = (EntityViewInfo)entry.getValue();
            sbuf.append(objName);
            sbuf.append(":");
            sbuf.append(ev.toString());
            sbuf.append("!");
        }
        return sbuf.toString();
    }

    private IRowSet toRowSet(Object rowset) {
        if (rowset == null) {
            return null;
        }
        assert (rowset instanceof IRowSet);
        IRowSet rs = (IRowSet)rowset;
        try {
            rs.beforeFirst();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rs;
    }

    @Override
    public String getEntitySql(IMetaDataPK entityPK, EntityViewInfo view) throws BOSException {
        return this.qda.getEntitySql(entityPK, view);
    }

    @Override
    public String getQuerySql(IMetaDataPK queryPK, EntityViewInfo view, QueryExecuteOption option) throws BOSException {
        return this.qda.getQuerySql(queryPK, view, option);
    }

    public String getQuerySql(IMetaDataPK queryPK, Map views, QueryExecuteOption option) throws BOSException {
        return this.qda.getQuerySql(queryPK, views, option);
    }

    @Override
    public String getQuerySql(IMetaDataPK queryPK, EntityViewInfo view) throws BOSException {
        return this.qda.getQuerySql(queryPK, view);
    }

    public String getQuerySql(IMetaDataPK queryPK, Map views) throws BOSException {
        return this.qda.getQuerySql(queryPK, views);
    }

    public boolean hasResult(IMetaDataPK queryPK, EntityViewInfo view, Map parameters, QueryExecuteOption option) throws BOSException {
        return this.qda.hasResult(queryPK, view, (Map<Integer, Object>)parameters, option);
    }

    public boolean hasResult(IMetaDataPK queryPK, Map views, Map parameters, QueryExecuteOption option) throws BOSException {
        return this.qda.hasResult(queryPK, views, (Map<Integer, Object>)parameters, option);
    }

    @Override
    public boolean hasResultByEntity(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option) throws BOSException {
        return this.qda.hasResultByEntity(entityPK, view, option);
    }

    @Override
    public boolean isDefineLogicalKey(IMetaDataPK pk) throws BOSException {
        return this.qda.isDefineLogicalKey(pk);
    }

    public Context getContext() {
        return this.qda.getContext();
    }

    public String getName() {
        return this.qda.getName();
    }

    public BOSObjectType getType() {
        return this.qda.getType();
    }

    public IORMModel queryInterface(Class type) throws ORMCoreException {
        return this.qda.queryInterface(type);
    }

    public int getRowCount(IMetaDataPK pk, Map views, Map parameters, QueryExecuteOption option) throws BOSException {
        return this.qda.getRowCount(pk, views, (Map<Integer, Object>)parameters, option);
    }

    public int getRowCount(IMetaDataPK pk, Map views, Map parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.qda.getRowCount(pk, views, (Map<Integer, Object>)parameters, option, countFields);
    }

    public int getRowCount(IMetaDataPK pk, EntityViewInfo views, Map parameters, QueryExecuteOption option) throws BOSException {
        return this.qda.getRowCount(pk, views, (Map<Integer, Object>)parameters, option);
    }

    public int getRowCount(IMetaDataPK pk, EntityViewInfo views, Map parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.qda.getRowCount(pk, views, (Map<Integer, Object>)parameters, option, countFields);
    }

    @Override
    public int getRowCountByEntity(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option) throws BOSException {
        return this.qda.getRowCountByEntity(entityPK, view, option);
    }

    @Override
    public int getRowCountByEntity(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.qda.getRowCountByEntity(entityPK, view, option, countFields);
    }

    public IRowSet sum(String queryCacheid, IMetaDataPK queryPK, Map views, Map parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.qda.sum(queryCacheid, queryPK, views, (Map<Integer, Object>)parameters, option, countFields);
    }

    public IRowSet sum(String queryCacheid, IMetaDataPK queryPK, EntityViewInfo views, Map parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.qda.sum(queryCacheid, queryPK, views, (Map<Integer, Object>)parameters, option, countFields);
    }

    public static Object[] processArgumentsForKeyGenerator(Object[] args, Object[] appendArgs) {
        return QueryDataAccessInterceptor.processArgumentsForKeyGenerator(args, appendArgs, true);
    }

    public static Object[] processArgumentsForKeyGenerator(Object[] args, Object[] appendArgs, boolean isVirtualMode) {
        if (args == null && appendArgs == null) {
            return null;
        }
        int size = args == null ? 0 : args.length;
        int appendSize = appendArgs == null ? 0 : appendArgs.length;
        Object[] tmpObjs = null;
        int totalSize = size + appendSize;
        if (totalSize <= 0) {
            return null;
        }
        if (args == null) {
            tmpObjs = appendArgs;
        } else if (appendSize > 0) {
            tmpObjs = new Object[totalSize];
            System.arraycopy(args, 0, tmpObjs, 0, args.length);
            System.arraycopy(appendArgs, 0, tmpObjs, args.length, appendArgs.length);
        } else {
            tmpObjs = args;
        }
        Object[] realObjs = null;
        if (isVirtualMode && tmpObjs.length > 0) {
            totalSize = tmpObjs.length - 1;
            realObjs = new Object[totalSize];
            System.arraycopy(tmpObjs, 1, realObjs, 0, tmpObjs.length - 1);
        } else {
            realObjs = tmpObjs;
        }
        for (int i = 0; i < totalSize; ++i) {
            Object val = realObjs[i];
            if (val instanceof EntityViewInfo) {
                realObjs[i] = ((EntityViewInfo)val).encode();
                continue;
            }
            if (val instanceof Map) {
                Map map = (Map)val;
                HashMap tmpMap = new HashMap(map.size());
                for (Object keyVal : map.keySet()) {
                    Object objVal = map.get(keyVal);
                    if (objVal instanceof EntityViewInfo) {
                        String strVal = ((EntityViewInfo)objVal).encode();
                        tmpMap.put(keyVal, strVal);
                        continue;
                    }
                    tmpMap.put(keyVal, (String)objVal);
                }
                realObjs[i] = tmpMap;
                continue;
            }
            realObjs[i] = val;
        }
        return realObjs;
    }

    public static Object[] processArgumentsForKeyGenerator(Object[] args) {
        return QueryDataAccessInterceptor.processArgumentsForKeyGenerator(args, null);
    }

    public IRowSet getRowSetForRealPage(IMetaDataPK queryPK, EntityViewInfo view, Map parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        Object[] args = new Object[]{queryPK, view, this.getParametersString(parameters), option, start, length};
        args = QueryDataAccessInterceptor.processArgumentsForKeyGenerator(args, null, false);
        MultiParamKey key = null;
        try {
            Method method = IQueryDataAccess.class.getMethod("getRowSetForRealPage", IMetaDataPK.class, EntityViewInfo.class, Map.class, QueryExecuteOption.class, Integer.TYPE, Integer.TYPE);
            key = MultiParamKey.create(IQueryDataAccess.class, (Method)method, (Object[])args);
        }
        catch (NoSuchMethodException e) {
            key = MultiParamKey.create((Object[])args);
        }
        if (ActionCache.containsKey((Object)(key == null ? null : key.toString()))) {
            return (IRowSet)ActionCache.get((Object)(key == null ? null : key.toString()));
        }
        return this.qda.getRowSetForRealPage(queryPK, view, (Map<Integer, Object>)parameters, option, start, length);
    }

    public IRowSet getRowSetForRealPage(IMetaDataPK queryPK, Map views, Map parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        Object[] args = new Object[]{queryPK, this.getEntityViewsString(views), this.getParametersString(parameters), option, start, length};
        args = QueryDataAccessInterceptor.processArgumentsForKeyGenerator(args, null, false);
        MultiParamKey key = null;
        try {
            Method method = IQueryDataAccess.class.getMethod("getRowSetForRealPage", IMetaDataPK.class, EntityViewInfo.class, Map.class, QueryExecuteOption.class, Integer.TYPE, Integer.TYPE);
            key = MultiParamKey.create(IQueryDataAccess.class, (Method)method, (Object[])args);
        }
        catch (NoSuchMethodException e) {
            key = MultiParamKey.create((Object[])args);
        }
        if (ActionCache.containsKey((Object)(key == null ? null : key.toString()))) {
            return (IRowSet)ActionCache.get((Object)(key == null ? null : key.toString()));
        }
        return this.qda.getRowSetForRealPage(queryPK, views, (Map<Integer, Object>)parameters, option, start, length);
    }

    public IRowSet getRowSetForRealPage(String sql, Map parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        return this.qda.getRowSetForRealPage(sql, parameters, option, start, length);
    }

    public int getRowCount(String sql, Map parameters, QueryExecuteOption option) throws BOSException {
        return this.qda.getRowCount(sql, parameters, option);
    }

    @Override
    public int getRowCount(SqlAndParam parameters, QueryExecuteOption option) throws BOSException {
        return this.qda.getRowCount(parameters, option);
    }

    public IRowSet groupbyAndAgg(IMetaDataPK pk, EntityViewInfo view, Map views, Map parameters, QueryExecuteOption option, QueryFieldInfo[] selectorFields, QueryFieldInfo[] aggFields, String[] aggFuns, QueryFieldInfo[] groupbyFields) throws BOSException {
        return this.qda.groupbyAndAgg(pk, view, views, parameters, option, selectorFields, aggFields, aggFuns, groupbyFields);
    }

    public IRowSet groupbyTime(IMetaDataPK pk, EntityViewInfo view, Map views, Map parameters, QueryExecuteOption option, QueryFieldInfo[] aggFields, String[] aggFuns, QueryFieldInfo timeField, int[] timeSegments, int rowCount) throws BOSException {
        return this.qda.groupbyTime(pk, view, views, parameters, option, aggFields, aggFuns, timeField, timeSegments, rowCount);
    }
}

