/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.asistant;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.dao.query.asistant.IGetSqlPlanFile;
import com.kingdee.bos.util.BOSObjectType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class GetSqlPlanFile
extends AbstractBOSObject
implements IGetSqlPlanFile {
    private static Logger logger = Logger.getLogger(GetSqlPlanFile.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"GSPF");

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] zip2(List<File> files) {
        if (files.size() == 0) {
            return null;
        }
        ZipOutputStream out = null;
        try {
            byte[] buf = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            out = new ZipOutputStream(baos);
            for (int i = 0; i < files.size(); ++i) {
                FileInputStream in = null;
                File file = null;
                try {
                    int len;
                    file = files.get(i);
                    in = new FileInputStream(file);
                    out.putNextEntry(new ZipEntry(files.get(i).getName()));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e);
                    continue;
                }
                finally {
                    try {
                        if (out != null) {
                            out.closeEntry();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    try {
                        if (file != null) {
                            file.delete();
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
            byte[] i = baos.toByteArray();
            return i;
        }
        catch (Exception ex) {
            logger.error((Object)("create zip file exception : " + ex));
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File zip(List<File> files) {
        File zipfile = new File(System.getProperty("EAS_SERVERWORKSPACE") + File.separator + "sqlplan-tmpzip" + File.separator + "tmp" + System.currentTimeMillis() + ".zip");
        if (!zipfile.getParentFile().exists()) {
            zipfile.getParentFile().mkdirs();
        }
        ZipOutputStream out = null;
        Object zipInputStream = null;
        try {
            byte[] buf = new byte[1024];
            out = new ZipOutputStream(new FileOutputStream(zipfile));
            for (int i = 0; i < files.size(); ++i) {
                FileInputStream in = null;
                File file = null;
                try {
                    int len;
                    file = files.get(i);
                    in = new FileInputStream(file);
                    out.putNextEntry(new ZipEntry(files.get(i).getName()));
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    continue;
                }
                finally {
                    try {
                        if (out != null) {
                            out.closeEntry();
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        logger.error((Object)e);
                    }
                    try {
                        file.delete();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)("create zip file exception : " + ex.getMessage()));
            File file = null;
            return file;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        return zipfile;
    }

    @Override
    public byte[] getSqlPlanZipFile(List<String> sqlPlanIdList) {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < sqlPlanIdList.size(); ++i) {
            String sqlPlanId = sqlPlanIdList.get(i);
            File file = new File(System.getProperty("EAS_SERVERWORKSPACE") + File.separator + "tmp-sqlplan-files" + File.separator + "sqlplan" + sqlPlanId + ".log");
            if (!file.exists()) continue;
            list.add(file);
        }
        return this.zip2(list);
    }

    @Override
    public void deleteSqlPlanFiles(List<String> sqlPlanIdList) {
        for (int i = 0; i < sqlPlanIdList.size(); ++i) {
            String sqlPlanId = sqlPlanIdList.get(i);
            File file = new File(System.getProperty("EAS_SERVERWORKSPACE") + File.separator + "tmp-sqlplan-files" + File.separator + "sqlplan" + sqlPlanId + ".log");
            if (!file.exists()) continue;
            try {
                file.delete();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public void setSqlPlanTimeLimit(String miliSeconds) {
        System.setProperty("sqlPlanTimeLimit", miliSeconds);
    }
}

