/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.asistant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class LockMap {
    private ConcurrentHashMap<String, AtomicInteger> lockMap = new ConcurrentHashMap();
    private String fileLock;
    private static Logger logger = Logger.getLogger(LockMap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LockMap() {
        String deploy = System.getProperty("eas.properties.dir");
        String perfLog = deploy + File.separator + "performRecordSrv.properties";
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(perfLog);
            prop.load(in);
        }
        catch (Exception ex) {
            logger.error((Object)ex, (Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"close url conn inputStream error!", (Throwable)e);
            }
        }
        String propVal = prop.getProperty("fileLock");
        this.fileLock = propVal == null ? "3" : propVal;
        logger.info((Object)("\u521d\u59cb\u5316\u6587\u4ef6\u8ba1\u6570\u9501\u4e3a :" + this.fileLock));
    }

    public String getFileLocks() {
        return this.fileLock;
    }

    public void setFileLocks(String count) {
        this.fileLock = count;
    }

    public static final LockMap getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public boolean getLock(String actionName) {
        if (actionName == null || actionName.trim().isEmpty()) {
            return false;
        }
        if (this.lockMap.get(actionName) == null) {
            this.lockMap.putIfAbsent(actionName, new AtomicInteger(Integer.valueOf(this.fileLock)));
            return true;
        }
        if (this.lockMap.get(actionName).decrementAndGet() > 0) {
            return true;
        }
        this.lockMap.remove(actionName);
        return false;
    }

    private static class SingletonHolder {
        private static final LockMap INSTANCE = new LockMap();

        private SingletonHolder() {
        }
    }
}

