/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.dao.query.server.Item;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.bos.dao.query.server.QueryContext;
import com.kingdee.bos.dao.query.server.SeqTableManager;
import com.kingdee.util.Uuid;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;

public class CloseQueryUtil {
    private static final Logger logger = Logger.getLogger(CloseQueryThread.class);
    private static CloseQueryThread closeQueryThread = new CloseQueryThread("CloseQueryThread");

    public static void closeQuery(Uuid querySessionID, String sessionID, String caller) {
        closeQueryThread.add(new Item(querySessionID, sessionID, caller));
    }

    static {
        closeQueryThread.start();
    }

    private static class CloseQueryThread
    extends Thread {
        private BlockingQueue<Item> queue = new LinkedBlockingQueue<Item>();

        public CloseQueryThread(String name) {
            super(name);
        }

        public void add(Item item) {
            try {
                this.queue.put(item);
            }
            catch (InterruptedException e) {
                logger.error((Object)e);
            }
        }

        @Override
        public void run() {
            Uuid querySessionID = null;
            String sessionID = null;
            while (true) {
                Item item = null;
                try {
                    item = this.queue.take();
                    querySessionID = item.getQuerySessionID();
                    sessionID = item.getSessionID();
                    QueryCacheManager.getInstance().destroyObject(querySessionID);
                    SeqTableManager.unRegisterInUserSession(querySessionID, sessionID);
                    if (item.getCaller() == null) {
                        QueryContext.removePermViewCache(querySessionID.toString());
                        continue;
                    }
                    QueryContext.removePermViewCache(querySessionID.toString() + item.getCaller());
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("fail to closequery :" + querySessionID), (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

