/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import bos.org.apache.commons.bos.MySqlDBUtils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.FetchedTooManyRecordsException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.AbstractSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.dao.query.server.SeqTableData;
import com.kingdee.bos.dao.query.server.SeqTableManager;
import com.kingdee.bos.db.RWSplitingManager;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MySqlSeqTableAcuquire
extends AbstractSeqTableAcuquire {
    private static final Logger logger = Logger.getLogger(MySqlSeqTableAcuquire.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map acquire(Context context, Uuid querySessionID, QueryDele query, EntityViewInfo view, Map views, Map params, QueryExecuteOption option, String sql) throws BOSException {
        HashMap<String, String> hashMap;
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        Connection cn = null;
        Connection mysqlCn = null;
        PreparedStatement ps = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        SeqTableData seqTableData = new SeqTableData();
        int txIsolation = -1;
        Context fakeCtx = new Context((IObjectPK)new ObjectUuidPK(), context.getSolution(), RWSplitingManager.getReadAis(context), context.getLocale());
        seqTableData.setContext(fakeCtx);
        seqTableData.setQuerySessionID(querySessionID);
        seqTableData.setView(view);
        seqTableData.setViews(views);
        try {
            cn = QueryConnectionProvider.getConnection(context);
            int dbtype = KSqlUtil.getDbType((Connection)cn);
            seqTableData.setTableName("QUERY_SEQTABLE");
            seqTableData.setLogicPKInfo(MySqlSeqTableAcuquire.getLogicPKInfo(query, sql));
            String createTableSQL = MySqlSeqTableAcuquire.buildCreateTableSQL(context, seqTableData, query);
            String comment = "Query: " + query.getFullName();
            QueryCacheManager.getInstance().putObject(querySessionID, seqTableData);
            String tableName = MySqlSeqTableAcuquire.acquireTableNew(context, cn, createTableSQL, comment);
            seqTableData.setTableName(tableName);
            String selectSQL = MySqlSeqTableAcuquire.buildSelectSQL(sqlMap, seqTableData, option, sql, dbtype);
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            ps = BaseDataAccess.prepareStatement(cn, selectSQL);
            ps.setFetchSize(100);
            if (params != null) {
                for (Object keyValue : params.keySet()) {
                    if (keyValue == null) continue;
                    int index = (Integer)keyValue;
                    Object[] val = (Object[])params.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR)) {
                        ps.setString(index, val[1].toString());
                        continue;
                    }
                    if (val[0].equals(SQLType.CHAR)) {
                        ps.setString(index, val[1].toString());
                        continue;
                    }
                    if (val[0].equals(SQLType.INT)) {
                        if (val[1] instanceof Integer) {
                            ps.setInt(index, (Integer)val[1]);
                            continue;
                        }
                        ps.setInt(index, Integer.parseInt(val[1].toString()));
                        continue;
                    }
                    ps.setObject(index, val[1]);
                }
            }
            rs = ps.executeQuery();
            String insertSQL = MySqlSeqTableAcuquire.buildInsertSQLForMySql(seqTableData, option, sql);
            mysqlCn = MySqlDBUtils.getdataSource().getConnection();
            stmt = mysqlCn.prepareStatement(insertSQL);
            int k = 0;
            int rc = 0;
            int idListSize = MySqlSeqTableAcuquire.getCriticalIDSize();
            int pkSize = seqTableData.getLogicPKInfo().keySet().size();
            while (rs.next()) {
                ++k;
                if (idListSize != 0 && ++rc > idListSize) {
                    throw new FetchedTooManyRecordsException(FetchedTooManyRecordsException.buildMessage(idListSize, 0));
                }
                for (int i = 0; i < pkSize; ++i) {
                    if (rs.getObject(i + 1) != null) {
                        stmt.setObject(i + 1, rs.getObject(i + 1));
                        continue;
                    }
                    stmt.setNull(i + 1, 12);
                }
                stmt.addBatch();
                if (k != 10000) continue;
                stmt.executeBatch();
                k = 0;
            }
            if (k > 0) {
                stmt.executeBatch();
            }
            seqTableData.setRowCount(rc);
            hashMap = sqlMap;
        }
        catch (Throwable e) {
            try {
                if (e.getCause() != null && ("com.mysql.jdbc.CommunicationsException".equals(e.getCause().getClass().getName()) || "bos.org.apache.commons.dbcp.SQLNestedException".equals(e.getCause().getClass().getName()))) {
                    SeqTableManager.getInstance().setMysql(false);
                    QueryCacheManager.getInstance().destroyObject(querySessionID);
                    throw new BOSException("mysql is down");
                }
                seqTableData.setThrowable(e);
                logger.error((Object)"createTable() occur error: ", e);
                throw new BOSException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e2) {
                    logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e2);
                }
                catch (Throwable t) {
                    logger.error((Object)"acquire()'s setTransactionIsolation throw a Throwble not SQLException:", t);
                }
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                SQLUtils.cleanup(stmt, mysqlCn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e);
        }
        catch (Throwable t) {
            logger.error((Object)"acquire()'s setTransactionIsolation throw a Throwble not SQLException:", t);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        SQLUtils.cleanup((Statement)stmt, (Connection)mysqlCn);
        return hashMap;
    }

    private static String buildInsertSQLForMySql(SeqTableData seqTableData, QueryExecuteOption option, String sql) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        StringBuffer Valuebuffer = new StringBuffer();
        Set<String> keySelectItems = seqTableData.getLogicPKInfo().keySet();
        buffer.append("INSERT INTO ").append(seqTableData.getTableName());
        buffer.append(" (");
        Valuebuffer.append("VALUES (");
        int size = keySelectItems.size();
        int index = 0;
        for (String queryFiledName : keySelectItems) {
            if (index == size - 1) {
                buffer.append(queryFiledName);
                Valuebuffer.append("?");
            } else {
                buffer.append(queryFiledName).append(",");
                Valuebuffer.append("?").append(",");
            }
            ++index;
        }
        buffer.append(") ");
        Valuebuffer.append(") ");
        buffer.append(Valuebuffer);
        return buffer.toString();
    }

    private static String getRealCreateSQL(String realTableName, String createSQL) {
        String newConstraintName = MySqlSeqTableAcuquire.getConstraintName(realTableName);
        String sql = StringUtils.replace((String)createSQL, (String)"QUERY_SEQTABLE", (String)realTableName);
        sql = StringUtils.replace((String)sql, (String)"QUERY_SEQ_CONS", (String)newConstraintName);
        return sql;
    }

    private static String getConstraintName(String realTableName) {
        String newConstraintName = realTableName.substring(realTableName.length() - 16);
        newConstraintName = "ZC" + newConstraintName;
        return newConstraintName;
    }

    private static String acquireTableNew(Context ctx, Connection cn, String createSQL, String comment) throws Exception {
        TempTablePool pool = TempTablePool.getInstanceForOutMySql();
        return pool.createTempTable(createSQL, "QUERY_SEQTABLE");
    }
}

