/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.DataQueryEngine;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.InternalDataQueryResult;
import com.kingdee.bos.dao.ormapping_ex.runtime.dataquery.TypeInfo;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.dao.query.server.IOQLDataAccess;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OQLDataAccess
extends BaseDataAccess
implements IOQLDataAccess {
    private static final Logger logger = Logger.getLogger(OQLDataAccess.class);
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"OQLQ");

    public OQLDataAccess() {
        this.registerInterface(IOQLDataAccess.class, this);
    }

    public OQLDataAccess(Context ctx) {
        super(ctx);
        this.registerInterface(IOQLDataAccess.class, this);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQL(String oql) throws BOSException {
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "getSQL", null);
        }
        try {
            InternalDataQueryResult result = this.getDataQueryResult(oql);
            String string = result.getSql();
            return string;
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private InternalDataQueryResult getDataQueryResult(String oql) throws BOSException {
        DataQueryEngine engine = new DataQueryEngine(this.getContext());
        return engine.buildInternalResult(oql);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRowSet getRowSet(String oql, QueryExecuteOption option, int start, int length) throws BOSException {
        DynamicRowSet dynamicRowSet;
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "getRowSet", null);
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        try {
            if (start < 0) {
                throw new IllegalArgumentException("getRowSet: start = " + start);
            }
            if (length < 0) {
                throw new IllegalArgumentException("getRowSet: length = " + length);
            }
            LowTimer t = new LowTimer();
            t.reset();
            InternalDataQueryResult result = this.getDataQueryResult(oql);
            sql = result.getSql();
            sql = this.processSQLLockHints(sql, option.lockingHints);
            TypeInfo[] types = result.getTypeInfoArray();
            DynamicRowSet drs = this.createRowSet(types, option);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRowSet()'s sql:\n" + sql));
            }
            cn = this.getConnection();
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = cn.prepareStatement(sql);
            if (option.fetchSize != 0) {
                // empty if block
            }
            rs = this.excuteSQL(stmt, null);
            int startPos = 0;
            int rowCount = 0;
            int colCount = drs.getMetaData().getColumnCount();
            HashMap enumCache = new HashMap();
            while (rs.next()) {
                if (++startPos <= start) continue;
                drs.moveToInsertRow();
                for (int i = 1; i <= colCount; ++i) {
                    this.populateRowSetCell(drs, rs, i, option, enumCache);
                }
                drs.insertRow();
                if (++rowCount != length) continue;
            }
            drs.beforeFirst();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("___________________________execQDA\t" + t.msValue()));
            }
            t.reset();
            dynamicRowSet = drs;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("getRowSet() sql: " + sql));
                logger.error((Object)"getRowSet() occur error: ", (Throwable)sqle);
                sqle.setNextException(new SQLException("The query sql is:" + sql));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                if (ProfileConfig.getInstance().logQuery) {
                    ThreadProfileContext.getInstance().exit();
                }
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().exit();
        }
        return dynamicRowSet;
    }

    private ColInfo getColumn(TypeInfo type, QueryExecuteOption option) {
        ColInfo col = new ColInfo();
        col.columnName = type.getName();
        col.columnLabel = type.getAlias();
        col.colType = option.isAutoTranslateEnum && type.getType() == 1 ? 2000 : type.getSqlType();
        col.extendedProperties().put("TypeInfo", type);
        return col;
    }

    private DynamicRowSet createRowSet(TypeInfo[] types, QueryExecuteOption option) throws SQLException {
        DynamicRowSet drs = new DynamicRowSet(types.length);
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            drs.setColInfo(i + 1, this.getColumn(types[i], option));
        }
        return drs;
    }

    protected void populateRowSetCell(DynamicRowSet rowset, ResultSet rs, int col, QueryExecuteOption option, Map cache) throws SQLException, BOSException {
        DataType tp = DataType.OBJECTVALUE;
        Map map = rowset.getRowSetMetaData().getExtendedProperties(col);
        TypeInfo type = (TypeInfo)map.get("TypeInfo");
        tp = type.getDataType();
        if (tp.equals((Object)DataType.STRING)) {
            String colVal = rs.getString(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else {
                rowset.updateString(col, colVal);
            }
        } else if (tp.equals((Object)DataType.BOOLEAN)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else {
                int i = TypeConversionUtils.objToInt((Object)colVal);
                if (option.isAutoTranslateBoolean) {
                    rowset.updateBoolean(col, i != 0);
                } else {
                    rowset.updateInt(col, i);
                }
            }
        } else if (tp.equals((Object)DataType.INTEGER)) {
            Object colVal = rs.getObject(col);
            if (colVal instanceof BigDecimal) {
                colVal = ((BigDecimal)colVal).intValue();
            }
            if (colVal instanceof Integer) {
                int i = (Integer)colVal;
                if (option.isAutoIgnoreZero && i == 0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateInt(col, i);
                }
            } else if (colVal instanceof Byte) {
                byte b = (Byte)colVal;
                if (option.isAutoIgnoreZero && b == 0) {
                    rowset.updateNull(col);
                } else {
                    rowset.updateByte(col, b);
                }
            }
        } else if (tp.equals((Object)DataType.LONG)) {
            long colVal = rs.getLong(col);
            if (option.isAutoIgnoreZero && colVal == 0L) {
                rowset.updateNull(col);
            } else {
                rowset.updateLong(col, colVal);
            }
        } else if (tp.equals((Object)DataType.SHORT)) {
            short colVal = rs.getShort(col);
            if (option.isAutoIgnoreZero && colVal == 0) {
                rowset.updateNull(col);
            } else {
                rowset.updateShort(col, colVal);
            }
        } else if (tp.equals((Object)DataType.DECIMAL)) {
            BigDecimal colVal = rs.getBigDecimal(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (option.isAutoIgnoreZero && colVal.equals(new BigDecimal(0.0))) {
                rowset.updateNull(col);
            } else {
                rowset.updateBigDecimal(col, colVal);
            }
        } else if (tp.equals((Object)DataType.FLOAT)) {
            float colVal = rs.getFloat(col);
            if (option.isAutoIgnoreZero && colVal == 0.0f) {
                rowset.updateNull(col);
            } else {
                rowset.updateFloat(col, colVal);
            }
        } else if (tp.equals((Object)DataType.DOUBLE)) {
            double colVal = rs.getDouble(col);
            if (option.isAutoIgnoreZero && colVal == 0.0) {
                rowset.updateNull(col);
            } else {
                rowset.updateDouble(col, colVal);
            }
        } else if (tp.equals((Object)DataType.DATE)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Date) {
                Date da = (Date)colVal;
                rowset.updateDate(col, da);
            } else if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                rowset.updateTime(col, ti);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)DataType.TIME)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Time) {
                Time ti = (Time)colVal;
                rowset.updateTime(col, ti);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)DataType.TIMESTAMP)) {
            Object colVal = rs.getObject(col);
            if (colVal == null) {
                rowset.updateNull(col);
            } else if (colVal instanceof Timestamp) {
                Timestamp ts = (Timestamp)colVal;
                rowset.updateTimestamp(col, ts);
            } else {
                rowset.updateObject(col, colVal);
            }
        } else if (tp.equals((Object)DataType.ENUM)) {
            Object colVal = rs.getObject(col);
            String metadataRef = type.getEnumMetaDataRef();
            if (!StringUtils.isEmpty((String)metadataRef)) {
                String className = MetaDataUtils.getClassName((String)metadataRef);
                String packageName = MetaDataUtils.getPackageName((String)metadataRef);
                BizEnumInfo bizenum = this.getBizEnum(MetaDataPK.create((String)packageName, (String)className));
                String key = type.getName() + colVal.toString();
                Object enumValue = cache.get(key);
                if (enumValue == null) {
                    if (colVal instanceof String) {
                        enumValue = QueryHelper.getAliasFromEnumValue(bizenum, colVal.toString());
                    } else if (colVal instanceof Integer) {
                        enumValue = QueryHelper.getAliasFromEnumValue(bizenum, (Integer)colVal);
                    } else if (colVal instanceof Long) {
                        enumValue = QueryHelper.getAliasFromEnumValue(bizenum, (Long)colVal);
                    } else if (colVal instanceof Double) {
                        enumValue = QueryHelper.getAliasFromEnumValue(bizenum, (Double)colVal);
                    } else if (colVal instanceof Float) {
                        enumValue = QueryHelper.getAliasFromEnumValue(bizenum, ((Float)colVal).floatValue());
                    }
                    cache.put(key, enumValue);
                }
                if (enumValue != null) {
                    rowset.updateObject(col, enumValue);
                } else {
                    rowset.updateObject(col, colVal);
                }
            } else {
                rowset.updateObject(col, colVal);
            }
        } else {
            rowset.updateObject(col, rs.getObject(col));
        }
    }
}

