/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.QueryDataAccess;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class PagingHelper {
    private static final String TOP_SELECT = "SELECT TOP ";
    private static final String DISTINCT_SELECT = "SELECT DISTINCT ";
    private static final String TOP_STRING = "TOP ";
    private static final String SELECT = "SELECT ";
    private static final String BLANK = " ";
    private static final Logger logger = Logger.getLogger(PagingHelper.class);
    private ParamData paramData;
    private boolean isLimitForPG = true;

    public PagingHelper() {
    }

    public PagingHelper(boolean isLimitForPG) {
        this.isLimitForPG = isLimitForPG;
    }

    public ParamData getParamData() {
        return this.paramData;
    }

    public String getPagingSql(Context ctx, int dbType, String sql, int start, int length) {
        String sql2;
        int startOfSelect;
        int top = start + length;
        sql = sql.trim();
        boolean hasDistinct = false;
        if (dbType == 1) {
            startOfSelect = sql.toUpperCase(Locale.ENGLISH).indexOf(SELECT);
            int endOfSelect = startOfSelect + SELECT.length();
            sql2 = sql.substring(endOfSelect);
        } else {
            startOfSelect = 0;
            if (sql.toUpperCase(Locale.ENGLISH).startsWith(TOP_SELECT)) {
                int endOfSelect = startOfSelect + TOP_SELECT.length();
                sql2 = sql.substring(endOfSelect);
                int startOfTop = sql2.indexOf(BLANK);
                sql2 = sql2.substring(startOfTop);
            } else if (sql.toUpperCase(Locale.ENGLISH).startsWith(DISTINCT_SELECT)) {
                int endOfSelect = startOfSelect + DISTINCT_SELECT.length();
                sql2 = sql.substring(endOfSelect);
                hasDistinct = true;
            } else if (sql.toUpperCase(Locale.ENGLISH).startsWith(SELECT)) {
                int endOfSelect = startOfSelect + SELECT.length();
                sql2 = sql.substring(endOfSelect);
            } else {
                return sql;
            }
        }
        sql = sql2;
        if (!StringUtils.isEmpty((String)sql)) {
            if (dbType != 1) {
                sql = hasDistinct ? "SELECT DISTINCT TOP " : TOP_SELECT;
                sql = dbType == 3 ? sql + "2147483647 " + sql2 : sql + top + BLANK + sql2;
            } else {
                sql = SELECT + sql;
            }
        }
        try {
            sql = KSqlUtil.optimize((String)sql);
            QueryDataAccess.LimitInfo limit = this.getLimitForRealPage(ctx, dbType, sql, start, top);
            sql = limit.sql;
        }
        catch (SqlTranslateException e) {
            logger.error((Object)("paging translate sql eroor: =" + sql));
        }
        catch (BOSException e) {
            logger.error((Object)("paging error sql is =" + sql));
        }
        return sql;
    }

    public String getPagingSql(int dbType, String sql, int start, int length) {
        return this.getPagingSql(null, dbType, sql, start, length);
    }

    public String getPagingSqlNoOptmize(Context ctx, String sql, int start, int length) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection(ctx);
            String string = this.getPagingSqlNoOptmize(ctx, KSqlUtil.getDbType((Connection)cn), sql.toString(), start, length);
            return string;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public String getPagingSqlNoOptmize(Context ctx, int dbType, String sql, int start, int length) {
        String sql2;
        int startOfSelect;
        int top = start + length;
        sql = sql.trim();
        boolean hasDistinct = false;
        if (dbType == 1) {
            startOfSelect = sql.toUpperCase(Locale.ENGLISH).indexOf(SELECT);
            int endOfSelect = startOfSelect + SELECT.length();
            sql2 = sql.substring(endOfSelect);
        } else {
            startOfSelect = 0;
            if (sql.toUpperCase(Locale.ENGLISH).startsWith(TOP_SELECT)) {
                int endOfSelect = startOfSelect + TOP_SELECT.length();
                sql2 = sql.substring(endOfSelect);
                int startOfTop = sql2.indexOf(BLANK);
                sql2 = sql2.substring(startOfTop);
            } else if (sql.toUpperCase(Locale.ENGLISH).startsWith(DISTINCT_SELECT)) {
                int endOfSelect = startOfSelect + DISTINCT_SELECT.length();
                sql2 = sql.substring(endOfSelect);
                hasDistinct = true;
            } else if (sql.toUpperCase(Locale.ENGLISH).startsWith(SELECT)) {
                int endOfSelect = startOfSelect + SELECT.length();
                sql2 = sql.substring(endOfSelect);
            } else {
                return sql;
            }
        }
        sql = sql2;
        if (!StringUtils.isEmpty((String)sql)) {
            if (dbType != 1) {
                sql = hasDistinct ? "SELECT DISTINCT TOP " : TOP_SELECT;
                sql = sql + top + BLANK + sql2;
            } else {
                sql = SELECT + sql;
            }
        }
        try {
            QueryDataAccess.LimitInfo limit = this.getLimitForRealPage(ctx, dbType, sql, start, top);
            sql = limit.sql;
        }
        catch (SqlTranslateException e) {
            logger.error((Object)("paging translate sql eroor: =" + sql));
        }
        catch (BOSException e) {
            logger.error((Object)("paging error sql is =" + sql));
        }
        return sql;
    }

    public String getPagingSqlNoOptmize(int dbType, String sql, int start, int length) {
        return this.getPagingSqlNoOptmize(null, dbType, sql, start, length);
    }

    private QueryDataAccess.LimitInfo getLimitForRealPage(Context ctx, int dbType, String sql, int start, int top) throws BOSException, SqlTranslateException {
        if (ctx != null) {
            this.paramData = new ParamData(ctx);
            sql = TransUtil.translate((String)sql, (int)dbType, null, (ParamData)this.paramData);
        } else {
            sql = TransUtil.translate((String)sql, (int)dbType, (FormatOptions)new FormatOptions());
            this.paramData = null;
        }
        if (dbType == 7 || dbType == 8 || dbType == 2) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append("/*dialect*/").append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(top).toString();
            return new QueryDataAccess.LimitInfo(sqlLimit.toString(), 0, top - start);
        }
        if (dbType == 11) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append("/*dialect*/").append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(top).toString();
            return new QueryDataAccess.LimitInfo(sqlLimit.toString(), 0, top - start);
        }
        if (dbType == 3) {
            return this.getLimitStringForMSSqlSrv(sql, start, top);
        }
        if (dbType == 1 || dbType == 9) {
            return this.getLimitStringForDB2(sql, start, top);
        }
        if (dbType == 5 || dbType == 12) {
            sql = sql.substring(0, sql.lastIndexOf(" LIMIT "));
            StringBuffer sqlLimit = new StringBuffer();
            if (dbType == 12 || this.isLimitForPG) {
                sqlLimit.append("/*dialect*/").append(sql).append(" LIMIT ").append(top - start).append("  offset ").append(start);
            } else {
                sqlLimit.append("/*dialect*/").append(sql);
            }
            return new QueryDataAccess.LimitInfo(sqlLimit.toString(), 0, top - start);
        }
        return new QueryDataAccess.LimitInfo(sql, 0, top - start);
    }

    private QueryDataAccess.LimitInfo getLimitStringForMSSqlSrv(String sql, int start, int top) throws ParserException, FormaterException {
        StringBuffer Sqllimit = new StringBuffer();
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0) {
            int selectIndex;
            String orderby = sql.substring(orderByIndex);
            int topIndex = sql.toLowerCase().indexOf(" top ");
            if (topIndex < 0 && (selectIndex = sql.toLowerCase().indexOf("select ")) >= 0) {
                sql = new StringBuffer(sql).insert("select ".length(), " top 2147483647 ").toString();
            }
            String orderbycolumns = orderby.substring(orderby.toUpperCase(Locale.ENGLISH).indexOf("ORDER BY") + 8);
            String[] columns = orderbycolumns.split(",");
            StringBuffer t1orderby = new StringBuffer();
            StringBuffer t2orderby = new StringBuffer();
            StringBuffer t3orderby = new StringBuffer();
            for (String each : columns) {
                String eachStr;
                if (t1orderby.length() > 0) {
                    t1orderby.append(" ,");
                    t2orderby.append(" ,");
                    t3orderby.append(" ,");
                }
                if ((eachStr = each.trim()).indexOf("\".\"") > 0) {
                    String tempStr = eachStr.substring(0, eachStr.indexOf(".") + 1);
                    if (tempStr.toUpperCase(Locale.ENGLISH).indexOf("T0") > 0) {
                        int fromend;
                        int index;
                        String tempsql;
                        int indexend;
                        String[] splitStr = eachStr.trim().split(BLANK);
                        eachStr = splitStr[0].toUpperCase(Locale.ENGLISH);
                        String orderdesc = "";
                        if (splitStr.length > 1) {
                            orderdesc = splitStr[splitStr.length - 1];
                        }
                        if ((indexend = (tempsql = sql.toUpperCase(Locale.ENGLISH)).indexOf(",", index = tempsql.indexOf(eachStr.toUpperCase(Locale.ENGLISH)))) > (fromend = tempsql.indexOf("FROM", index))) {
                            indexend = fromend;
                        }
                        String[] alias = tempsql.substring(index, indexend).trim().split(BLANK);
                        eachStr = alias[alias.length - 1] + BLANK + orderdesc;
                    } else {
                        eachStr = eachStr.substring(eachStr.indexOf(".") + 1);
                    }
                }
                t1orderby.append("T1.").append(eachStr).append(BLANK);
                t2orderby.append("T2.").append(eachStr).append(BLANK);
                t3orderby.append("T3.").append(eachStr).append(BLANK);
            }
            String t2orderbyStr = this.formatRflexOrder(t2orderby.toString());
            Sqllimit.append("SELECT * FROM (").append("select *,row_number()over(order by tempcolumn)temprownumber ").append(" FROM (").append("SELECT *,tempcolumn=0 from (").append(sql).append(") AS T1 ").append(") AS T2 ").append(" ) AS T3 ").append(" where temprownumber BETWEEN ").append(start + 1).append(" AND ").append(top).append(BLANK);
            return new QueryDataAccess.LimitInfo("/*dialect*/" + Sqllimit, 0, top - start);
        }
        Sqllimit.append("SELECT * FROM (").append("select *,row_number()over(order by tempcolumn)temprownumber ").append(" FROM (").append("SELECT *,tempcolumn=0 from (").append(sql).append(") AS T1 ").append(") AS T2 ").append(" ) AS T3 ").append(" where temprownumber BETWEEN ").append(start + 1).append(" AND ").append(top).append(BLANK);
        return new QueryDataAccess.LimitInfo("/*dialect*/" + Sqllimit, 0, top - start);
    }

    private QueryDataAccess.LimitInfo getLimitStringForDB2(String sql, int start, int top) {
        int startOfSelect = sql.toLowerCase().indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append("SELECT * from ( SELECT tableA.*,").append(this.getRowNumberForDB2(sql));
        if (PagingHelper.hasDistinct(sql)) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(")AS tableA) as temp_ where rownumber_ ");
        pagingSelect.append("between ");
        pagingSelect.append(start);
        pagingSelect.append("+1 and ");
        pagingSelect.append(top);
        return new QueryDataAccess.LimitInfo("/*dialect*/" + pagingSelect, 0, top - start);
    }

    private String getRowNumberForDB2(String sql) {
        StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0 && !PagingHelper.hasDistinct(sql)) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_ FROM (SELECT");
        return rownumber.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.toLowerCase().indexOf("select distinct") >= 0;
    }

    private String formatRflexOrder(String OrderSql) {
        String regEx1 = " ASC";
        Pattern pat1 = Pattern.compile(regEx1);
        Matcher mat1 = pat1.matcher(OrderSql);
        String s1 = mat1.replaceAll("#RlexAC#");
        String regEx2 = " DESC";
        Pattern pat2 = Pattern.compile(regEx2);
        Matcher mat2 = pat2.matcher(s1);
        String s2 = mat2.replaceAll(" ASC");
        String regEx3 = "#RlexAC#";
        Pattern pat3 = Pattern.compile(regEx3);
        Matcher mat3 = pat3.matcher(s2);
        String s3 = mat3.replaceAll(" DESC");
        return s3;
    }
}

