/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.dao.query.server.QueryContext;
import com.kingdee.bos.dao.query.server.RTQuerySqlAccess;
import com.kingdee.bos.dao.query.server.SqlAndParam;
import com.kingdee.bos.dao.query.server.analysis.AggInfo;
import com.kingdee.bos.dao.query.server.analysis.HeaderCounter;
import com.kingdee.bos.dao.query.server.analysis.TimeAnalysis;
import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataClearListener;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.PropertyUnitDele;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.SubObjectDele;
import com.kingdee.bos.metadata.query.util.QueryDeleUtil;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.metadata.query.util.QueryUtil;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.privacy.ParamData;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSelectLimit;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.expr.SqlAllColumnExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlMethodInvokeExpr;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.formater.FormaterException;
import com.kingdee.bos.sql.formater.MSTransactSQLFormater;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.MultiParamKeyString;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class QueryDataAccess
extends BaseDataAccess
implements IQueryDataAccess {
    private static final String TOP_SELECT = "SELECT TOP ";
    private static final String DISTINCT_SELECT = "SELECT DISTINCT ";
    private static final String SELECT = "SELECT ";
    private static final String BLANK = " ";
    private static final String SUBTABLEALIAS = "TABLE_BOS";
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"QRYQ");
    private static final Logger logger = Logger.getLogger(QueryDataAccess.class);
    private static CustomCacheService enumRsCache = new CustomCacheService("cache.enumRsCache");
    private static CustomCacheService realPageSqlCache = new CustomCacheService("cache.realPageSqlCache");

    public QueryDataAccess(Context ctx) {
        super(ctx);
        this.registerInterface(IQueryDataAccess.class, this);
    }

    public QueryDataAccess() {
        this.registerInterface(IQueryDataAccess.class, this);
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    @Override
    public boolean isDefineLogicalKey(IMetaDataPK pk) throws BOSException {
        return super.isDefineLogicalKey(pk);
    }

    @Override
    public String getQuerySql(IMetaDataPK queryPK, EntityViewInfo view, QueryExecuteOption option) throws BOSException {
        QueryContext ctx = QueryContext.getInstance(view, option);
        ctx.init(this.getContext(), null, queryPK, MetaDataTypeList.BASEQUERY);
        String rtn = this.getRuntimeSql(ctx);
        return rtn;
    }

    @Override
    public String getQuerySql(IMetaDataPK queryPK, EntityViewInfo view) throws BOSException {
        return this.getQuerySql(queryPK, view, new QueryExecuteOption());
    }

    @Override
    public String getQuerySql(IMetaDataPK queryPK, Map<String, EntityViewInfo> views, QueryExecuteOption option) throws BOSException {
        QueryContext ctx = QueryContext.getInstance(views, option);
        ctx.init(this.getContext(), null, queryPK, MetaDataTypeList.BASEQUERY);
        String rtn = this.getRuntimeSql(ctx);
        return rtn;
    }

    @Override
    public String getQuerySql(IMetaDataPK queryPK, Map<String, EntityViewInfo> views) throws BOSException {
        return this.getQuerySql(queryPK, views, new QueryExecuteOption());
    }

    @Override
    public String getEntitySql(IMetaDataPK entityPK, EntityViewInfo view) throws BOSException {
        QueryContext ctx = QueryContext.getInstance(view, new QueryExecuteOption());
        ctx.init(this.getContext(), null, entityPK, MetaDataTypeList.ENTITY);
        String rtn = this.getRuntimeSql(ctx);
        return rtn;
    }

    @Override
    public boolean hasResult(IMetaDataPK queryPK, EntityViewInfo view, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        return this.innerHasResult(queryPK, MetaDataTypeList.BASEQUERY, view, null, parameters, option);
    }

    @Override
    public boolean hasResult(IMetaDataPK queryPK, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        return this.innerHasResult(queryPK, MetaDataTypeList.BASEQUERY, null, views, parameters, option);
    }

    @Override
    public boolean hasResultByEntity(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option) throws BOSException {
        return this.innerHasResult(entityPK, MetaDataTypeList.ENTITY, view, null, null, option);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean innerHasResult(IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        boolean bl;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        QueryContext ctx = QueryContext.getInstance(view, views, option, 1, parameters);
        try {
            LowTimer t = new LowTimer();
            t.reset();
            ctx.init(this.getContext(), null, pk, type);
            Map<Integer, Object> paramMap = null;
            Map<Integer, Object> paramMap4Qsa = ctx.getParameters4Qsa();
            ctx.setBParaType(true);
            ctx.setParameters(new HashMap<Integer, Object>(1));
            sql = this.getRuntimeSql(ctx);
            paramMap = ctx.getParameters();
            int n = paramMap4Qsa.size();
            for (int i = 0; i < n; ++i) {
                paramMap.put(paramMap.size() + 1, paramMap4Qsa.get(i + 1));
            }
            sql = KSqlUtil.optimize((String)sql);
            sql = this.processSQLLockHints(sql, option.lockingHints);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRowSet()'s sql:\n" + sql));
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = cn.prepareStatement(sql);
            rs = this.excuteSQL(stmt, paramMap);
            boolean result = rs.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("____execQDA\t" + t.msValue()));
            }
            t.reset();
            bl = result;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)"innerHasResult() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerHasResult() occur error: The query sql is:" + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)"innerHasResult() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return bl;
    }

    @Override
    public int getRowCount(IMetaDataPK queryPK, EntityViewInfo view, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        return this.innerGetRowCount(queryPK, MetaDataTypeList.BASEQUERY, view, null, parameters, option);
    }

    @Override
    public int getRowCount(IMetaDataPK queryPK, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        return this.innerGetRowCount(queryPK, MetaDataTypeList.BASEQUERY, null, views, parameters, option);
    }

    @Override
    public int getRowCount(IMetaDataPK queryPK, EntityViewInfo view, Map<Integer, Object> parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.innerGetRowCount(queryPK, MetaDataTypeList.BASEQUERY, view, null, parameters, option, countFields);
    }

    @Override
    public int getRowCount(IMetaDataPK queryPK, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.innerGetRowCount(queryPK, MetaDataTypeList.BASEQUERY, null, views, parameters, option, countFields);
    }

    @Override
    public int getRowCountByEntity(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option) throws BOSException {
        return this.innerGetRowCount(entityPK, MetaDataTypeList.ENTITY, view, null, null, option);
    }

    @Override
    public int getRowCountByEntity(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.innerGetRowCount(entityPK, MetaDataTypeList.ENTITY, view, null, null, option, countFields);
    }

    @Override
    public IRowSet sum(String queryCacheUid, IMetaDataPK queryPK, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.innerGetSum(queryCacheUid, queryPK, MetaDataTypeList.BASEQUERY, null, views, parameters, option, countFields);
    }

    @Override
    public IRowSet sum(String queryCacheid, IMetaDataPK queryPK, EntityViewInfo view, Map<Integer, Object> parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        return this.innerGetSum(queryCacheid, queryPK, MetaDataTypeList.BASEQUERY, view, null, parameters, option, countFields);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int innerGetRowCount(IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        int n;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        HashMap<String, String> fieldMap = null;
        if (countFields != null && countFields.length > 0) {
            fieldMap = new HashMap<String, String>();
            for (int i = 0; i < countFields.length; ++i) {
                fieldMap.put(countFields[i], null);
            }
        }
        QueryContext ctx = QueryContext.getInstance(view, views, option, fieldMap, parameters);
        try {
            ctx.init(this.getContext(), null, pk, type);
            Map<Integer, Object> paramMap = null;
            Map<Integer, Object> paramMap4Qsa = ctx.getParameters4Qsa();
            ctx.setBParaType(true);
            ctx.setParameters(new HashMap<Integer, Object>(1));
            sql = this.getRuntimeSql(ctx);
            paramMap = ctx.getParameters();
            int n2 = paramMap4Qsa.size();
            for (int i = 0; i < n2; ++i) {
                paramMap.put(paramMap.size() + 1, paramMap4Qsa.get(i + 1));
            }
            sql = KSqlUtil.optimize((String)sql);
            sql = this.processGetRowCountSQL(sql, fieldMap);
            sql = StringUtils.replace((String)sql, (String)"COUNT(1)", (String)"COUNT(*)");
            sql = this.processSQLLockHints(sql, option.lockingHints);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetRowCount()'s sql:\n" + sql));
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = this.excuteSQL(stmt, paramMap);
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("COUNT");
            }
            n = count;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerGetRowCount() pk: " + pk));
                logger.error((Object)("innerGetRowCount() sql: " + sql));
                logger.error((Object)"innerGetRowCount() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowCount error! The query sql is:" + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("innerGetRowCount() pk: " + pk));
                    logger.error((Object)("innerGetRowCount() sql: " + sql));
                    logger.error((Object)"innerGetRowCount() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int innerGetRowCount(IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        int n;
        Object[] args = new Object[]{pk, type, view, views, this.getParametersString(parameters), option, this.getContext().getLocale()};
        String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
        QueryContext ctx = QueryContext.getInstance(view, views, option, null, parameters);
        ctx.init(this.getContext(), key, pk, type);
        Map<Integer, Object> paramMap = null;
        Map<Integer, Object> paramMap4Qsa = ctx.getParameters4Qsa();
        ctx.setBParaType(true);
        ctx.setParameters(new HashMap<Integer, Object>(1));
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        try {
            cn = QueryConnectionProvider.getConnection(this.getContext());
            int dbType = KSqlUtil.getDbType((Connection)cn);
            SqlAndParam sqlAndParam = (SqlAndParam)realPageSqlCache.get(key);
            if (sqlAndParam != null) {
                sql = sqlAndParam.getSql(key);
            }
            if (!StringUtils.isEmpty((String)sql)) {
                sql = SELECT + sql;
                paramMap = sqlAndParam.getParams();
            } else {
                ctx.setAddOrder2Selector(true);
                sql = this.getRuntimeSql(ctx);
                paramMap = ctx.getParameters();
                int n2 = paramMap4Qsa.size();
                for (int i = 0; i < n2; ++i) {
                    paramMap.put(paramMap.size() + 1, paramMap4Qsa.get(i + 1));
                }
                int startOfSelect = (sql = KSqlUtil.optimize((String)sql)).indexOf(DISTINCT_SELECT);
                if (startOfSelect != 0) {
                    startOfSelect = sql.indexOf(SELECT);
                    int endOfSelect = startOfSelect + SELECT.length();
                    HashMap<String, String> sqlMap = new HashMap<String, String>();
                    sqlMap.put(key, sql.substring(endOfSelect));
                    realPageSqlCache.put(key, (Object)new SqlAndParam(sqlMap, paramMap));
                }
            }
            sql = this.processGetRowCountSQL(sql);
            sql = StringUtils.replace((String)sql, (String)"COUNT(1)", (String)"COUNT(*)");
            sql = this.processSQLLockHints(sql, option.lockingHints);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetRowCount()'s sql:\n" + sql));
            }
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = this.excuteSQL(stmt, paramMap);
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("COUNT");
            }
            n = count;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerGetRowCount() pk: " + pk));
                logger.error((Object)("innerGetRowCount() sql: " + sql));
                logger.error((Object)"innerGetRowCount() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowCount error! The query sql is:" + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("innerGetRowCount() pk: " + pk));
                    logger.error((Object)("innerGetRowCount() sql: " + sql));
                    logger.error((Object)"innerGetRowCount() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return n;
    }

    private void setHeadSumFields(QueryDele query, String[] countFields, Map<String, FieldAlias> fieldMap, DynamicRowSet drs, String sql, QueryExecuteOption option) throws BOSException {
        this.setHeadSumFields(query, countFields, fieldMap, drs, sql, option, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHeadSumFields(QueryDele query, String[] countFields, Map<String, FieldAlias> fieldMap, DynamicRowSet drs, String sql, QueryExecuteOption option, Map<Integer, Object> paramMap) throws BOSException {
        ArrayList<String> headSumFields = new ArrayList<String>();
        PropertyUnitDele field = null;
        for (int i = 0; i < countFields.length; ++i) {
            field = QueryDeleUtil.getQueryFieldByName((QueryDele)query, (String)countFields[i]);
            if (field == null) continue;
            ArrayList<SubObjectDele> ls = new ArrayList<SubObjectDele>();
            ls.add(query.getMainObject());
            if (!QueryDeleUtil.checkQueryFieldRefSubObjectInList((QueryDele)query, ls, (PropertyUnitDele)field)) continue;
            headSumFields.add(field.getName());
        }
        if (headSumFields.size() == 0) {
            return;
        }
        HashMap<String, FieldAlias> headFieldMap = new HashMap<String, FieldAlias>();
        for (String key : fieldMap.keySet()) {
            if (!headSumFields.contains(key)) continue;
            headFieldMap.put(key, fieldMap.get(key));
        }
        sql = this.innerProcessGetSumSQL(sql, headFieldMap, true);
        sql = this.processSQLLockHints(sql, option.lockingHints);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("innerGetSum()'s sql:\n" + sql));
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            drs.beforeFirst();
            cn = QueryConnectionProvider.getConnection(this.getContext());
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = paramMap != null ? this.excuteSQL(stmt, paramMap) : stmt.executeQuery();
            if (rs.next() && drs.next()) {
                Object fa = null;
                int size = headSumFields.size();
                for (int i = 0; i < size; ++i) {
                    String key = ((String)headSumFields.get(i)).toString();
                    PropertyUnitDele fld = QueryDeleUtil.getQueryFieldByName((QueryDele)query, (String)key);
                    ColInfo colInfo = QueryDeleUtil.getColumn((PropertyUnitDele)fld, (boolean)option.isAutoTranslateEnum);
                    if (colInfo == null) continue;
                    drs.updateObject(colInfo.columnName, rs.getObject(key));
                }
            }
            drs.beforeFirst();
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerHeadGetSum() pk: " + query.getFullName()));
                logger.error((Object)("innerHeadGetSum() sql: " + sql));
                logger.error((Object)"innerHeadGetSum() occur error: ", (Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet innerGetSum(String queryCacheUid, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        DynamicRowSet dynamicRowSet;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        String tableName = null;
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        try {
            LowTimer t = new LowTimer();
            t.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getQuery: " + t.msValue()));
                t.reset();
            }
            ctx.init(this.getContext(), queryCacheUid, pk, type);
            Map<Integer, Object> paramMap = null;
            Map<Integer, Object> paramMap4Qsa = ctx.getParameters4Qsa();
            ctx.setBParaType(true);
            ctx.setParameters(new HashMap<Integer, Object>(1));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("initSqlAccessInstance: " + t.msValue()));
                t.reset();
            }
            HashMap fieldMap = null;
            HashMap<String, List<String>> fieldPkMap = null;
            HashMap fieldPkMapAlias = null;
            ArrayList<String> fieldPkList = null;
            if (countFields != null && countFields.length > 0) {
                fieldMap = new HashMap();
                fieldPkMap = new HashMap<String, List<String>>();
                fieldPkMapAlias = new HashMap();
                fieldPkList = new ArrayList<String>();
                String field = null;
                String enrtyPkField = null;
                for (int i = 0; i < countFields.length; ++i) {
                    field = countFields[i];
                    enrtyPkField = QueryDeleUtil.getQueryFieldByName((QueryDele)ctx.getQuerySqlAccess().query, (String)countFields[i]).getExtendedProperty("PkNameGroupBy");
                    if (!StringUtils.isEmpty((String)enrtyPkField)) {
                        List<String> l = null;
                        if (fieldPkMap.containsKey(enrtyPkField)) {
                            l = (List)fieldPkMap.get(enrtyPkField);
                        } else {
                            l = new ArrayList();
                            fieldPkMap.put(enrtyPkField, l);
                            fieldPkMapAlias.put(enrtyPkField, null);
                        }
                        l.add(field);
                    } else {
                        fieldPkList.add(field);
                    }
                    fieldMap.put(field, null);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("initSqlAccessInstance2: " + t.msValue()));
                t.reset();
            }
            ctx.setCountFields(fieldMap);
            ctx.setCountFieldPks(fieldPkMapAlias);
            sql = this.getRuntimeSql(ctx);
            paramMap = ctx.getParameters();
            int n = paramMap4Qsa.size();
            for (int i = 0; i < n; ++i) {
                paramMap.put(paramMap.size() + 1, paramMap4Qsa.get(i + 1));
            }
            sql = KSqlUtil.optimize((String)sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRuntimeSql: " + t.msValue()));
                t.reset();
            }
            HashMap<String, FieldAlias> fieldMap2 = null;
            HashMap<String, FieldAlias> fieldPkMapAlias2 = null;
            if (countFields != null && countFields.length > 0) {
                fieldMap2 = new HashMap<String, FieldAlias>();
                fieldPkMapAlias2 = new HashMap<String, FieldAlias>();
                String fieldAlias = null;
                String fieldUnit = null;
                String fieldName = null;
                for (int i = 0; i < countFields.length; ++i) {
                    fieldUnit = QueryDeleUtil.getUnitString((PropertyUnitDele)QueryDeleUtil.getQueryFieldByName((QueryDele)ctx.getQuerySqlAccess().query, (String)countFields[i])).replaceAll("&", "||");
                    fieldName = countFields[i];
                    fieldAlias = (String)fieldMap.get(fieldName);
                    fieldMap2.put(fieldName, new FieldAlias(fieldAlias, fieldUnit));
                }
                if (fieldPkMapAlias.size() > 0) {
                    ArrayList selectorList = ctx.getQuerySqlAccess().select.getSelector();
                    int len = selectorList.size();
                    for (int i = 0; i < len; ++i) {
                        PropertyUnitDele qfi = (PropertyUnitDele)selectorList.get(i);
                        if (!fieldPkMapAlias.containsKey(qfi.getName())) continue;
                        fieldUnit = QueryDeleUtil.getUnitString((PropertyUnitDele)qfi).replaceAll("&", "||");
                        fieldName = qfi.getName();
                        fieldAlias = (String)fieldPkMapAlias.get(fieldName);
                        fieldPkMapAlias2.put(fieldName, new FieldAlias(fieldAlias, fieldUnit));
                    }
                }
            }
            String headFieldSumSQL = sql;
            if (fieldPkMapAlias == null || fieldPkMapAlias.size() == 0) {
                sql = this.processGetSumSQL(sql, fieldMap2);
            } else {
                sql = this.processGetSumSQL(sql, fieldMap2, fieldPkMap, fieldPkMapAlias2, fieldPkList, paramMap);
                tableName = sql.substring(sql.lastIndexOf(BLANK) + 1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("processGetSumSQL: " + t.msValue()));
                t.reset();
            }
            sql = this.processSQLLockHints(sql, option.lockingHints);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetSum()'s sql:\n" + sql));
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = fieldPkMapAlias == null || fieldPkMapAlias.size() == 0 ? this.excuteSQL(stmt, paramMap) : this.excuteSQL(stmt, null);
            ResultSetMetaData rsMeta = rs.getMetaData();
            DynamicRowSet drs = new DynamicRowSet(fieldMap.size());
            String fa = null;
            Object key = null;
            int size = rsMeta.getColumnCount();
            for (int i = 1; i <= size; ++i) {
                Iterator iter = fieldMap.keySet().iterator();
                while (iter.hasNext() && !(fa = (String)fieldMap.get(key = (Object)iter.next())).equalsIgnoreCase(rsMeta.getColumnName(i))) {
                }
                PropertyUnitDele fld = QueryDeleUtil.getQueryFieldByName((QueryDele)ctx.getQuerySqlAccess().query, (String)key.toString());
                drs.setColInfo(i, QueryDeleUtil.getColumn((PropertyUnitDele)fld, (boolean)option.isAutoTranslateEnum));
            }
            int rowCount = 0;
            int colCount = drs.getMetaData().getColumnCount();
            int idListSize = this.getCriticalIDSize();
            HashMap<String, BizEnumValueInfo> enumCache = new HashMap<String, BizEnumValueInfo>();
            HashMap<String, Boolean> enumPkCache = (HashMap<String, Boolean>)enumRsCache.get(pk.getFullName());
            boolean firstPop = false;
            if (enumPkCache == null) {
                enumPkCache = new HashMap<String, Boolean>();
                firstPop = true;
            }
            while (rs.next()) {
                drs.moveToInsertRow();
                for (int i = 1; i <= colCount; ++i) {
                    this.populateRowSetCell(pk, drs, rs, i, ctx.getOption(), enumCache, enumPkCache);
                    if (!firstPop || i != colCount) continue;
                    enumRsCache.put(pk.getFullName(), enumPkCache);
                    firstPop = false;
                }
                drs.insertRow();
                if (idListSize == 0 || ++rowCount <= idListSize) continue;
                try {
                    throw new FetchedTooMuchRowsException(rowCount);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            drs.beforeFirst();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("executeQuery and populate rowSet: " + t.msValue()));
                t.reset();
            }
            try {
                this.setHeadSumFields(ctx.getQuerySqlAccess().query, countFields, fieldMap2, drs, headFieldSumSQL, option, paramMap);
            }
            catch (Exception ee) {
                logger.error((Object)"innerGetSum() occur error: ", (Throwable)ee);
            }
            drs.beforeFirst();
            dynamicRowSet = drs;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerGetSum() pk: " + pk));
                logger.error((Object)("innerGetSum() sql: " + sql));
                logger.error((Object)"innerGetSum() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetSum() sql: " + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("innerGetSum() pk: " + pk));
                    logger.error((Object)("innerGetSum() sql: " + sql));
                    logger.error((Object)"innerGetSum() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                    if (tableName != null) {
                        TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
            if (tableName != null) {
                TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
    }

    private String processGetRowCountSQL(String sql, Map<String, String> fieldMap) throws BOSException {
        if (fieldMap == null || fieldMap.size() == 0) {
            return this.processGetRowCountSQL(sql);
        }
        return this._innerProcessGetRowCountSQL(sql, fieldMap);
    }

    private String processGetSumSQL(String sql, Map<String, FieldAlias> fieldMap) throws BOSException {
        if (fieldMap != null && fieldMap.size() > 0) {
            return this.innerProcessGetSumSQL(sql, fieldMap, false);
        }
        return null;
    }

    private String processGetSumSQL(String sql, Map<String, FieldAlias> fieldMap, Map<String, List<String>> fieldPkMap, Map<String, FieldAlias> fieldPkMapAlias, List<String> fieldPkList, Map<Integer, Object> paramMap) throws BOSException {
        if (fieldMap != null && fieldMap.size() > 0) {
            return this.innerProcessGetSumSQL(sql, fieldMap, fieldPkMap, fieldPkMapAlias, fieldPkList, paramMap);
        }
        return null;
    }

    private String _innerProcessGetRowCountSQL(String sql, Map<String, String> fieldMap) throws BOSException {
        ArrayList<SqlSelectItem> seletorAliasList = new ArrayList<SqlSelectItem>();
        for (Map.Entry<String, String> entry : fieldMap.entrySet()) {
            String key = entry.getKey();
            String seletorAlias = entry.getValue();
            if (seletorAlias == null) {
                throw new BOSException((Throwable)new IllegalArgumentException("Cannot find seletor alais for queryfield:" + key));
            }
            SqlIdentifierExpr _expr = new SqlIdentifierExpr(seletorAlias);
            SqlSelectItem _item = new SqlSelectItem((SqlExpr)_expr, null);
            seletorAliasList.add(_item);
        }
        StringBuffer buffer = new StringBuffer();
        try {
            SqlSubQueryTableSource sqlSubQueryTableSource;
            SqlMethodInvokeExpr countSqlMethodInvokeExpr = new SqlMethodInvokeExpr("COUNT");
            countSqlMethodInvokeExpr.parameters.add(new SqlIdentifierExpr("1"));
            SqlSelectItem countSqlSelectItem = new SqlSelectItem((SqlExpr)countSqlMethodInvokeExpr, "\"COUNT\"");
            SelectParser selectParser = new SelectParser(sql);
            SqlSelectBase sqlSelectBase = selectParser.select();
            SqlSelect innerSQL = null;
            if (sqlSelectBase instanceof SqlSelect) {
                SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
                sqlSelect.orderBy.clear();
                if (sqlSelect.groupBy != null && sqlSelect.groupBy.size() > 0 || sqlSelect.distinct != 0) {
                    innerSQL = new SqlSelect();
                    innerSQL.selectList.addAll(seletorAliasList);
                    innerSQL.distinct = 1;
                    sqlSubQueryTableSource = new SqlSubQueryTableSource();
                    sqlSubQueryTableSource.subQuery = sqlSelect;
                    sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                    innerSQL.tableSource = sqlSubQueryTableSource;
                } else {
                    innerSQL = sqlSelect;
                    innerSQL.selectList.clear();
                    innerSQL.selectList.addAll(seletorAliasList);
                    innerSQL.distinct = 1;
                }
            } else if (sqlSelectBase instanceof SqlUnionSelect) {
                innerSQL = new SqlSelect();
                SqlUnionSelect sqlUnionSelect = (SqlUnionSelect)sqlSelectBase;
                innerSQL.selectList.addAll(seletorAliasList);
                sqlSubQueryTableSource = new SqlSubQueryTableSource();
                sqlSubQueryTableSource.subQuery = sqlUnionSelect;
                sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                innerSQL.tableSource = sqlSubQueryTableSource;
            }
            SqlSelect result = new SqlSelect();
            result.selectList.add(countSqlSelectItem);
            sqlSubQueryTableSource = new SqlSubQueryTableSource();
            sqlSubQueryTableSource.subQuery = innerSQL;
            sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
            result.tableSource = sqlSubQueryTableSource;
            result = innerSQL;
            QuerySQLFormater formater = new QuerySQLFormater(buffer);
            formater.formatSelectBase((SqlSelectBase)result);
        }
        catch (ParserException e) {
            logger.error((Object)"processGetRowCountSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (FormaterException e) {
            logger.error((Object)"processGetRowCountSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return buffer.toString();
    }

    private String innerProcessGetSumSQL(String sql, Map fieldMap, boolean isHeadSum) throws BOSException {
        ArrayList<SqlSelectItem> seletorAliasList = new ArrayList<SqlSelectItem>();
        ArrayList<SqlSelectItem> sumList = new ArrayList<SqlSelectItem>();
        FieldAlias fa = null;
        for (Map.Entry entry : fieldMap.entrySet()) {
            fa = (FieldAlias)entry.getValue();
            String seletorAlias = fa.getFieldAliasName();
            String selectorItem = fa.getFieldName() + " AS \"" + seletorAlias + "\"";
            String sumItem = "SUM(\"" + seletorAlias + "\") AS \"" + seletorAlias + "\"";
            if (seletorAlias == null) {
                throw new BOSException((Throwable)new IllegalArgumentException("Cannot find seletor alais for queryfield:" + (String)entry.getKey()));
            }
            SqlIdentifierExpr _expr = new SqlIdentifierExpr(selectorItem);
            SqlSelectItem _item = new SqlSelectItem((SqlExpr)_expr, null);
            seletorAliasList.add(_item);
            SqlIdentifierExpr sum_expr = new SqlIdentifierExpr(sumItem);
            SqlSelectItem sum_item = new SqlSelectItem((SqlExpr)sum_expr, null);
            sumList.add(sum_item);
        }
        StringBuffer buffer = new StringBuffer();
        SqlSelectItem idSelectItem = null;
        try {
            SelectParser selectParser = new SelectParser(sql);
            SqlSelectBase sqlSelectBase = selectParser.select();
            SqlSelect innerSQL = null;
            if (sqlSelectBase instanceof SqlSelect) {
                SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
                if (isHeadSum) {
                    int size = sqlSelect.selectList.size();
                    for (int i = 0; i < size; ++i) {
                        if (sqlSelect.selectList.get(i) == null || StringUtils.isEmpty((String)((SqlSelectItem)sqlSelect.selectList.get((int)i)).alias) || !((SqlSelectItem)sqlSelect.selectList.get((int)i)).alias.equalsIgnoreCase("\"ID\"")) continue;
                        idSelectItem = (SqlSelectItem)sqlSelect.selectList.get(i);
                    }
                }
                sqlSelect.orderBy.clear();
                if (sqlSelect.groupBy != null && sqlSelect.groupBy.size() > 0 || sqlSelect.distinct != 0) {
                    innerSQL = sqlSelect;
                } else {
                    innerSQL = sqlSelect;
                    innerSQL.selectList.clear();
                    innerSQL.selectList.addAll(seletorAliasList);
                }
                if (isHeadSum && idSelectItem != null) {
                    innerSQL.distinct = 1;
                    if (!innerSQL.selectList.contains(idSelectItem)) {
                        innerSQL.selectList.add(idSelectItem);
                    }
                }
            } else if (sqlSelectBase instanceof SqlUnionSelect) {
                innerSQL = new SqlSelect();
                SqlUnionSelect sqlUnionSelect = (SqlUnionSelect)sqlSelectBase;
                innerSQL.selectList.addAll(seletorAliasList);
                SqlSubQueryTableSource sqlSubQueryTableSource = new SqlSubQueryTableSource();
                sqlSubQueryTableSource.subQuery = sqlUnionSelect;
                sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                innerSQL.tableSource = sqlSubQueryTableSource;
            }
            SqlSelect result = new SqlSelect();
            result.selectList.addAll(sumList);
            SqlSubQueryTableSource sqlSubQueryTableSource = new SqlSubQueryTableSource();
            StringBuffer sqlBuffer = new StringBuffer();
            QuerySQLFormater sqlFormater = new QuerySQLFormater(sqlBuffer);
            sqlFormater.formatSelectBase((SqlSelectBase)innerSQL);
            String sqls = null;
            try {
                sqls = KSqlUtil.optimize((String)sqlBuffer.toString());
                selectParser = new SelectParser(sqls);
                sqlSelectBase = selectParser.select();
                innerSQL = (SqlSelect)sqlSelectBase;
            }
            catch (SqlTranslateException e) {
                throw new BOSException((Throwable)e);
            }
            sqlSubQueryTableSource.subQuery = innerSQL;
            sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
            result.tableSource = sqlSubQueryTableSource;
            QuerySQLFormater formater = new QuerySQLFormater(buffer);
            formater.formatSelectBase((SqlSelectBase)result);
        }
        catch (ParserException e) {
            logger.error((Object)"processGetSumSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (FormaterException e) {
            logger.error((Object)"processGetSumSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return buffer.toString();
    }

    private String innerProcessGetSumSQL_insertSql(String sql, String tableName, Map<String, FieldAlias> fieldMap, List<FieldAlias> groupby) throws BOSException {
        ArrayList<SqlSelectItem> seletorAliasList = new ArrayList<SqlSelectItem>();
        ArrayList<SqlSelectItem> seletorAliasList2 = new ArrayList<SqlSelectItem>();
        FieldAlias fa = null;
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("INSERT INTO ").append(tableName).append(" (");
        boolean isFirst = true;
        for (Map.Entry<String, FieldAlias> entry : fieldMap.entrySet()) {
            String key = entry.getKey();
            fa = entry.getValue();
            String seletorAlias = fa.getFieldAliasName();
            if (seletorAlias.indexOf(46) > 0) {
                seletorAlias = StringUtils.replace((String)seletorAlias, (String)".", (String)"_");
            }
            if (!isFirst) {
                insertSql.append(",");
            }
            insertSql.append("\"" + seletorAlias.toUpperCase(Locale.ENGLISH) + "\"");
            isFirst = false;
            String selectorItem = null;
            selectorItem = groupby == null || groupby.size() == 0 ? fa.getFieldName() + " AS \"" + seletorAlias + "\"" : "AVG(" + fa.getFieldName() + ") AS \"" + seletorAlias + "\"";
            if (seletorAlias == null) {
                throw new BOSException((Throwable)new IllegalArgumentException("Cannot find seletor alais for queryfield:" + key));
            }
            SqlIdentifierExpr _expr = new SqlIdentifierExpr(selectorItem);
            SqlSelectItem _item = new SqlSelectItem((SqlExpr)_expr, null);
            seletorAliasList.add(_item);
            _expr = groupby == null || groupby.size() == 0 ? new SqlIdentifierExpr(seletorAlias) : new SqlIdentifierExpr("AVG(\"" + seletorAlias + "\") AS \"" + seletorAlias + "\"");
            _item = new SqlSelectItem((SqlExpr)_expr, null);
            seletorAliasList2.add(_item);
        }
        insertSql.append(") ");
        StringBuffer buffer = new StringBuffer();
        try {
            SqlSubQueryTableSource sqlSubQueryTableSource;
            SelectParser selectParser = new SelectParser(sql);
            SqlSelectBase sqlSelectBase = selectParser.select();
            SqlSelect innerSQL = null;
            if (sqlSelectBase instanceof SqlSelect) {
                SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
                sqlSelect.orderBy.clear();
                if (sqlSelect.groupBy != null && sqlSelect.groupBy.size() > 0 || sqlSelect.distinct != 0) {
                    innerSQL = new SqlSelect();
                    innerSQL.selectList.addAll(seletorAliasList2);
                    sqlSubQueryTableSource = new SqlSubQueryTableSource();
                    sqlSubQueryTableSource.subQuery = sqlSelect;
                    sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                    innerSQL.tableSource = sqlSubQueryTableSource;
                } else {
                    innerSQL = sqlSelect;
                    innerSQL.selectList.clear();
                    innerSQL.selectList.addAll(seletorAliasList);
                }
            } else if (sqlSelectBase instanceof SqlUnionSelect) {
                innerSQL = new SqlSelect();
                SqlUnionSelect sqlUnionSelect = (SqlUnionSelect)sqlSelectBase;
                innerSQL.selectList.addAll(seletorAliasList);
                sqlSubQueryTableSource = new SqlSubQueryTableSource();
                sqlSubQueryTableSource.subQuery = sqlUnionSelect;
                sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                innerSQL.tableSource = sqlSubQueryTableSource;
            }
            if (groupby != null && groupby.size() != 0) {
                innerSQL.groupBy.clear();
                int len = groupby.size();
                for (int i = 0; i < len; ++i) {
                    SqlIdentifierExpr _expr = new SqlIdentifierExpr(groupby.get(i).getFieldName());
                    innerSQL.groupBy.add(_expr);
                }
            }
            QuerySQLFormater formater = new QuerySQLFormater(buffer);
            formater.formatSelectBase((SqlSelectBase)innerSQL);
            insertSql.append(buffer);
        }
        catch (ParserException e) {
            logger.error((Object)"innerProcessGetSumSQL_insertSql() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (FormaterException e) {
            logger.error((Object)"innerProcessGetSumSQL_insertSql() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return insertSql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String innerProcessGetSumSQL(String sql, Map<String, FieldAlias> fieldMap, Map<String, List<String>> fieldPkMap, Map<String, FieldAlias> fieldPkMapAlias, List<String> fieldPkList, Map<Integer, Object> parameters) throws BOSException {
        StringBuffer selectorSql = new StringBuffer();
        StringBuffer createTempTableSql = new StringBuffer("CREATE TABLE QUERY_SEQTABLE (");
        FieldAlias fa = null;
        String tableName = null;
        boolean isFirst = true;
        for (Map.Entry<String, FieldAlias> entry : fieldMap.entrySet()) {
            fa = entry.getValue();
            String seletorAlias = fa.getFieldAliasName();
            String columnName = seletorAlias;
            if (columnName.indexOf(46) > 0) {
                columnName = StringUtils.replace((String)columnName, (String)".", (String)"_");
            }
            if (!isFirst) {
                createTempTableSql.append(",");
                selectorSql.append(",");
            }
            createTempTableSql.append(columnName).append(" DECIMAL(20,10) DEFAULT 0");
            selectorSql.append("SUM(").append(columnName).append(") AS \"").append(seletorAlias).append("\"");
            isFirst = false;
        }
        createTempTableSql.append(")");
        Connection cn = null;
        try {
            Context context = this.getContext();
            cn = QueryConnectionProvider.getConnection(this.getContext());
            tableName = TempTablePool.getInstance(context).createTempTable(createTempTableSql.toString());
            HashMap<String, FieldAlias> map = new HashMap<String, FieldAlias>();
            ArrayList<FieldAlias> list = new ArrayList<FieldAlias>();
            int len = fieldPkList.size();
            for (int i = 0; i < len; ++i) {
                String fieldName = fieldPkList.get(i);
                map.put(fieldPkList.get(i), fieldMap.get(fieldName));
            }
            if (map.size() != 0) {
                String insert_sql = this.innerProcessGetSumSQL_insertSql(sql, tableName, map, null);
                PreparedStatement stmt = null;
                try {
                    stmt = cn.prepareStatement(insert_sql);
                    if (parameters != null) {
                        for (Integer keyValue : parameters.keySet()) {
                            if (keyValue == null) continue;
                            int index = keyValue;
                            Object[] val = (Object[])parameters.get(keyValue);
                            if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                                if (val[1] == null) {
                                    stmt.setNull(index, ((SQLType)val[0]).getSQLType());
                                    continue;
                                }
                                stmt.setString(index, val[1].toString());
                                continue;
                            }
                            stmt.setObject(index, val[1]);
                        }
                    }
                    stmt.execute();
                }
                finally {
                    SQLUtils.cleanup((Statement)stmt);
                }
            }
            Iterator<String> iter = fieldPkMap.keySet().iterator();
            while (iter.hasNext()) {
                map.clear();
                list.clear();
                String fieldName = iter.next();
                list.add(fieldPkMapAlias.get(fieldName));
                List<String> l2 = fieldPkMap.get(fieldName);
                int len2 = l2.size();
                for (int i = 0; i < len2; ++i) {
                    String fieldName2 = l2.get(i);
                    map.put(fieldName2, fieldMap.get(fieldName2));
                }
                if (map.size() == 0) continue;
                String insert_sql = this.innerProcessGetSumSQL_insertSql(sql, tableName, map, list);
                PreparedStatement stmt = null;
                try {
                    stmt = cn.prepareStatement(insert_sql);
                    if (parameters != null) {
                        for (Integer keyValue : parameters.keySet()) {
                            if (keyValue == null) continue;
                            int index = keyValue;
                            Object[] val = (Object[])parameters.get(keyValue);
                            if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                                if (val[1] == null) {
                                    stmt.setNull(index, ((SQLType)val[0]).getSQLType());
                                    continue;
                                }
                                stmt.setString(index, val[1].toString());
                                continue;
                            }
                            stmt.setObject(index, val[1]);
                        }
                    }
                    stmt.execute();
                }
                finally {
                    SQLUtils.cleanup((Statement)stmt);
                }
            }
            if (cn == null) return SELECT + selectorSql + " FROM " + tableName;
        }
        catch (Exception e) {
            try {
                logger.error((Object)"innerProcessGetSumSQL() occur error. ", (Throwable)e);
                if (cn == null) return SELECT + selectorSql + " FROM " + tableName;
            }
            catch (Throwable throwable) {
                if (cn == null) throw throwable;
                SQLUtils.cleanup(cn);
                throw throwable;
            }
            SQLUtils.cleanup((Connection)cn);
            return SELECT + selectorSql + " FROM " + tableName;
        }
        SQLUtils.cleanup((Connection)cn);
        return SELECT + selectorSql + " FROM " + tableName;
    }

    private String processGetRowCountSQL(String sql) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        try {
            SqlMethodInvokeExpr countSqlMethodInvokeExpr = new SqlMethodInvokeExpr("COUNT");
            countSqlMethodInvokeExpr.parameters.add(new SqlIdentifierExpr("1"));
            SqlSelectItem countSqlSelectItem = new SqlSelectItem((SqlExpr)countSqlMethodInvokeExpr, "\"COUNT\"");
            SelectParser selectParser = new SelectParser(sql);
            SqlSelectBase sqlSelectBase = selectParser.select();
            SqlSelect result = null;
            if (sqlSelectBase instanceof SqlSelect) {
                SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
                sqlSelect.orderBy.clear();
                if (sqlSelect.groupBy != null && sqlSelect.groupBy.size() > 0 || sqlSelect.distinct != 0) {
                    result = new SqlSelect();
                    result.selectList.add(countSqlSelectItem);
                    SqlSubQueryTableSource sqlSubQueryTableSource = new SqlSubQueryTableSource();
                    sqlSubQueryTableSource.subQuery = sqlSelect;
                    sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                    result.tableSource = sqlSubQueryTableSource;
                } else {
                    result = sqlSelect;
                    result.selectList.clear();
                    result.selectList.add(countSqlSelectItem);
                }
            } else if (sqlSelectBase instanceof SqlUnionSelect) {
                result = new SqlSelect();
                SqlUnionSelect sqlUnionSelect = (SqlUnionSelect)sqlSelectBase;
                result.selectList.add(countSqlSelectItem);
                SqlSubQueryTableSource sqlSubQueryTableSource = new SqlSubQueryTableSource();
                sqlSubQueryTableSource.subQuery = sqlUnionSelect;
                sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                result.tableSource = sqlSubQueryTableSource;
            }
            QuerySQLFormater formater = new QuerySQLFormater(buffer);
            formater.formatSelectBase((SqlSelectBase)result);
        }
        catch (ParserException e) {
            logger.error((Object)"processGetRowCountSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (FormaterException e) {
            logger.error((Object)"processGetRowCountSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return buffer.toString();
    }

    @Override
    public IRowSet getRowSet(IMetaDataPK queryPK, EntityViewInfo view, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        return this.innerGetRowSet(queryPK, MetaDataTypeList.BASEQUERY, view, null, parameters, option, start, length);
    }

    @Override
    public IRowSet getRowSet(IMetaDataPK queryPK, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        return this.innerGetRowSet(queryPK, MetaDataTypeList.BASEQUERY, null, views, parameters, option, start, length);
    }

    @Override
    public IRowSet getEntityRowSet(IMetaDataPK entityPK, EntityViewInfo view, QueryExecuteOption option, int start, int length) throws BOSException {
        return this.innerGetRowSet(entityPK, MetaDataTypeList.ENTITY, view, null, null, option, start, length);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet innerGetRowSet(IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        DynamicRowSet drs;
        Map<Integer, Object> paramMap;
        int top;
        boolean textIndexUsed;
        LowTimer t;
        int txIsolation;
        String sql;
        ResultSet rs;
        PreparedStatement stmt;
        Connection cn;
        block31: {
            cn = null;
            stmt = null;
            rs = null;
            sql = "";
            txIsolation = -1;
            if (start < 0) {
                throw new IllegalArgumentException("getRowSet: start = " + start);
            }
            if (length < 0) {
                throw new IllegalArgumentException("getRowSet: length = " + length);
            }
            t = new LowTimer();
            t.reset();
            textIndexUsed = this.textIndexPrepare(view, option);
            top = start + length;
            QueryContext ctx = null;
            cn = QueryConnectionProvider.getConnection(this.getContext());
            int dbType = KSqlUtil.getDbType((Connection)cn);
            ctx = 5 != dbType ? QueryContext.getInstance(view, views, option, top, parameters) : QueryContext.getInstance(view, views, option, 0, parameters);
            ctx.init(this.getContext(), null, pk, type);
            paramMap = null;
            Map<Integer, Object> paramMap4Qsa = ctx.getParameters4Qsa();
            ctx.setBParaType(true);
            ctx.setParameters(new HashMap<Integer, Object>(1));
            drs = null;
            sql = this.getRuntimeSql(ctx);
            paramMap = ctx.getParameters();
            int n = paramMap4Qsa.size();
            for (int i = 0; i < n; ++i) {
                paramMap.put(paramMap.size() + 1, paramMap4Qsa.get(i + 1));
            }
            drs = ctx.getQuerySqlAccess().createRowSet(option);
            if (top != 0) break block31;
            DynamicRowSet i = drs;
            try {
                if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                    cn.setTransactionIsolation(txIsolation);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
            }
            SQLUtils.cleanup(rs, stmt, (Connection)cn);
            return i;
        }
        if (top == Integer.MAX_VALUE) {
            top = 0;
        }
        sql = KSqlUtil.optimize((String)sql);
        sql = this.processSQLLockHints(sql, option.lockingHints);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
        }
        if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
            txIsolation = cn.getTransactionIsolation();
            cn.setTransactionIsolation(option.transactionIsolation);
        }
        if (textIndexUsed) {
            sql = this.getSqlForTextIndex(sql);
        }
        stmt = cn.prepareStatement(sql);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
        }
        rs = this.excuteSQL(stmt, paramMap);
        int startPos = 0;
        int rowCount = 0;
        int colCount = drs.getMetaData().getColumnCount();
        assert (colCount != 0);
        int idListSize = this.getCriticalIDSize();
        HashMap<String, BizEnumValueInfo> enumCache = new HashMap<String, BizEnumValueInfo>();
        HashMap<String, Boolean> enumPkCache = (HashMap<String, Boolean>)enumRsCache.get(pk.toString());
        boolean firstPop = false;
        if (enumPkCache == null) {
            enumPkCache = new HashMap<String, Boolean>();
            firstPop = true;
        }
        while (rs.next()) {
            if (++startPos <= start) continue;
            drs.moveToInsertRow();
            for (int i = 1; i <= colCount; ++i) {
                this.populateRowSetCell(pk, drs, rs, i, option, enumCache, enumPkCache);
                if (!firstPop || i != colCount) continue;
                enumRsCache.put(pk.toString(), enumPkCache);
                firstPop = false;
            }
            drs.insertRow();
            if (idListSize != 0 && ++rowCount > idListSize) {
                try {
                    throw new FetchedTooMuchRowsException(rowCount);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            if (rowCount != length) continue;
        }
        drs.beforeFirst();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("____execQDA\t" + t.msValue()));
        }
        t.reset();
        DynamicRowSet dynamicRowSet = drs;
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerGetRowSet() pk: " + pk));
                logger.error((Object)("innerGetRowSet() sql: " + sql));
                logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowSet() occur error,The query sql is:" + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("innerGetRowSet() pk: " + pk));
                    logger.error((Object)("innerGetRowSet() sql: " + sql));
                    logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
    }

    @Override
    public IRowSet getRowSetForRealPage(IMetaDataPK queryPK, EntityViewInfo view, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        return this.innerGetRowSetForRealPage(queryPK, MetaDataTypeList.BASEQUERY, view, null, parameters, option, start, length);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet innerGetRowSetForRealPage(IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        Map<Integer, Object> paramMap;
        int dbType;
        DynamicRowSet drs;
        int top;
        LowTimer t;
        String sql;
        int txIsolation;
        ResultSet rs;
        PreparedStatement stmt;
        Connection cn;
        block35: {
            Object sql2;
            cn = null;
            stmt = null;
            rs = null;
            txIsolation = -1;
            sql = "";
            if (start < 0) {
                throw new IllegalArgumentException("getRowSet: start = " + start);
            }
            if (length < 0) {
                throw new IllegalArgumentException("getRowSet: length = " + length);
            }
            t = new LowTimer();
            t.reset();
            top = start + length;
            drs = null;
            cn = QueryConnectionProvider.getConnection(this.getContext());
            dbType = KSqlUtil.getDbType((Connection)cn);
            Object[] args = new Object[]{pk, type, view, views, this.getParametersString(parameters), option, this.getContext().getLocale()};
            String key = Utils.transMD5((String)MultiParamKeyString.toString(null, (Object[])args));
            QueryContext ctx = QueryContext.getInstance(view, views, option, 0, null);
            ctx.init(this.getContext(), key, pk, type);
            paramMap = null;
            Map<Integer, Object> paramMap4Qsa = ctx.getParameters4Qsa();
            ctx.setBParaType(true);
            ctx.setParameters(new HashMap<Integer, Object>(1));
            RTQuerySqlAccess qsa = ctx.getQuerySqlAccess();
            SqlAndParam sqlAndParam = (SqlAndParam)realPageSqlCache.get(key);
            if (sqlAndParam != null) {
                sql = SELECT + sqlAndParam.getSql(key);
            }
            if (!StringUtils.isEmpty((String)sql)) {
                if (5 != dbType) {
                    sql = this.processTopAndOrderBy(sql, top);
                }
                qsa.state.set(view, views);
                paramMap = sqlAndParam.getParams();
            } else {
                ctx.setAddOrder2Selector(true);
                sql = this.getRuntimeSql(ctx);
                paramMap = ctx.getParameters();
                int n = paramMap4Qsa.size();
                for (int i = 0; i < n; ++i) {
                    paramMap.put(paramMap.size() + 1, paramMap4Qsa.get(i + 1));
                }
                sql = KSqlUtil.optimize((String)sql);
                int startOfSelect = sql.indexOf(SELECT);
                int endOfSelect = startOfSelect + SELECT.length();
                sql2 = sql.substring(endOfSelect);
                HashMap<String, String> sqlMap = new HashMap<String, String>();
                sqlMap.put(key, (String)sql2);
                realPageSqlCache.put(key, (Object)new SqlAndParam(sqlMap, paramMap));
                if (5 != dbType) {
                    sql = this.processTopAndOrderBy(sql, top);
                }
            }
            drs = qsa.createRowSet(ctx.getOption());
            if (top != 0) break block35;
            sql2 = drs;
            try {
                if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                    cn.setTransactionIsolation(txIsolation);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
            }
            SQLUtils.cleanup(rs, stmt, (Connection)cn);
            return sql2;
        }
        if (top == Integer.MAX_VALUE) {
            top = 0;
        }
        sql = this.processSQLLockHints(sql, option.lockingHints);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
        }
        if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
            txIsolation = cn.getTransactionIsolation();
            cn.setTransactionIsolation(option.transactionIsolation);
        }
        LimitInfo limit = this.getLimitForRealPage(dbType, sql, start, top);
        sql = limit.sql;
        stmt = cn.prepareStatement(sql);
        ParamData.setParamDataToStatement((ParamData)limit.paramData, (PreparedStatement)stmt);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
        }
        rs = this.excuteSQL(stmt, paramMap);
        int startPos = 0;
        int rowCount = 0;
        int colCount = drs.getMetaData().getColumnCount();
        assert (colCount != 0);
        int idListSize = this.getCriticalIDSize();
        HashMap<String, BizEnumValueInfo> enumCache = new HashMap<String, BizEnumValueInfo>();
        HashMap<String, Boolean> enumPkCache = (HashMap<String, Boolean>)enumRsCache.get(pk.toString());
        boolean firstPop = false;
        if (enumPkCache == null) {
            enumPkCache = new HashMap<String, Boolean>();
            firstPop = true;
        }
        while (rs.next()) {
            if (++startPos <= limit.start) continue;
            drs.moveToInsertRow();
            for (int i = 1; i <= colCount; ++i) {
                this.populateRowSetCell(pk, drs, rs, i, option, enumCache, enumPkCache);
                if (!firstPop || i != colCount) continue;
                enumRsCache.put(pk.toString(), enumPkCache);
                firstPop = false;
            }
            drs.insertRow();
            if (idListSize != 0 && ++rowCount > idListSize) {
                try {
                    throw new FetchedTooMuchRowsException(rowCount);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            if (rowCount != limit.lenth) continue;
        }
        drs.beforeFirst();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("____execQDA\t" + t.msValue()));
        }
        t.reset();
        DynamicRowSet dynamicRowSet = drs;
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerGetRowSet() pk: " + pk));
                logger.error((Object)("innerGetRowSet() sql: " + sql));
                logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowSet() occur error,The RealPageQuery sql is:" + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("innerGetRowSet() pk: " + pk));
                    logger.error((Object)("innerGetRowSet() sql: " + sql));
                    logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
    }

    protected String processTopAndOrderBy(String sql, int top) throws BOSException {
        SqlSelect sqlSelect = null;
        SelectParser parser2 = null;
        StringBuffer buff = new StringBuffer();
        QuerySQLFormater formater = new QuerySQLFormater(buff);
        try {
            parser2 = new SelectParser(sql);
            SqlSelectBase selectBase = parser2.select();
            if (selectBase instanceof SqlSelect) {
                sqlSelect = (SqlSelect)selectBase;
                if (sqlSelect != null) {
                    SqlSelect newSqlSelect = new SqlSelect();
                    newSqlSelect.selectList.add(new SqlSelectItem((SqlExpr)new SqlAllColumnExpr(), null));
                    newSqlSelect.limit = new SqlSelectLimit(top);
                    newSqlSelect.orderBy = new ArrayList(sqlSelect.orderBy);
                    sqlSelect.limit = null;
                    sqlSelect.orderBy.clear();
                    SqlSubQueryTableSource subTabSrc = new SqlSubQueryTableSource();
                    subTabSrc.alias = SUBTABLEALIAS;
                    subTabSrc.subQuery = sqlSelect;
                    newSqlSelect.tableSource = subTabSrc;
                    formater.formatSelectBase((SqlSelectBase)newSqlSelect);
                } else {
                    throw new BOSException("Get SqlSelect failed!");
                }
            }
            return buff.toString();
        }
        catch (ParserException parseException) {
            throw new BOSException("parse sql error, sql = " + sql, (Throwable)parseException);
        }
        catch (FormaterException formaterExcption) {
            throw new BOSException("format sql error, sql = " + sql, (Throwable)formaterExcption);
        }
    }

    private LimitInfo getLimitForRealPage(int dbType, String sql, int start, int top) throws BOSException, SqlTranslateException {
        LimitInfo limitInfo;
        Context ctx = this.getContext();
        ParamData paramData = null;
        if (ctx != null) {
            paramData = new ParamData(ctx);
            sql = TransUtil.translate((String)sql, (int)dbType, null, (ParamData)paramData);
        } else {
            sql = TransUtil.translate((String)sql, (int)dbType, (FormatOptions)new FormatOptions());
        }
        if (dbType == 7 || dbType == 8 || dbType == 2) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append("/*dialect*/").append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(top).toString();
            limitInfo = new LimitInfo(sqlLimit.toString(), 0, top - start);
        } else if (dbType == 11) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append("/*dialect*/").append(" SELECT * FROM(SELECT tableA.*, ROWNUM RN  FROM ( ").append(sql).append(" )tableA )WHERE RN >").append(start).append(" AND RN <= ").append(top).toString();
            limitInfo = new LimitInfo(sqlLimit.toString(), 0, top - start);
        } else if (dbType == 3) {
            limitInfo = this.getLimitStringForMSSqlSrv(sql, start, top);
        } else if (dbType == 1 || dbType == 9) {
            limitInfo = this.getLimitStringForDB2(sql, start, top);
        } else if (dbType == 5 || dbType == 12) {
            StringBuffer sqlLimit = new StringBuffer();
            sqlLimit.append("/*dialect*/").append(" SELECT * FROM(").append(sql).append("  )tableA");
            if (dbType == 5) {
                limitInfo = new LimitInfo(sqlLimit.toString(), start, top - start);
            } else {
                sqlLimit.append(" LIMIT ").append(top - start).append("  offset ").append(start);
                limitInfo = new LimitInfo(sqlLimit.toString(), 0, top - start);
            }
        } else {
            limitInfo = new LimitInfo(sql, 0, top - start);
        }
        limitInfo.paramData = paramData;
        return limitInfo;
    }

    private LimitInfo getLimitStringForMSSqlSrv(String sql, int start, int top) {
        StringBuffer Sqllimit = new StringBuffer();
        int orderByIndex = sql.toLowerCase(Locale.ENGLISH).indexOf("order by");
        if (orderByIndex > 0) {
            String orderby;
            block11: {
                orderby = sql.substring(orderByIndex);
                int topIndex = sql.toLowerCase(Locale.ENGLISH).indexOf(" top ");
                if (topIndex < 0) {
                    try {
                        SelectParser bizSelectParser = new SelectParser(sql);
                        SqlSelect bizSqlSelect = (SqlSelect)bizSelectParser.select();
                        bizSqlSelect.limit = new SqlSelectLimit(Integer.MAX_VALUE);
                        StringBuffer selectBuffer = new StringBuffer();
                        MSTransactSQLFormater formater = new MSTransactSQLFormater(selectBuffer);
                        formater.formatSelectBase((SqlSelectBase)bizSqlSelect);
                        sql = selectBuffer.toString();
                    }
                    catch (Throwable e) {
                        logger.error((Object)"sql insert top fail!", e);
                        int selectIndex = sql.toLowerCase(Locale.ENGLISH).indexOf("select ");
                        if (selectIndex < 0) break block11;
                        sql = new StringBuffer(sql).insert("select ".length(), " top 2147483647 ").toString();
                    }
                }
            }
            String orderbycolumns = orderby.substring(orderby.toUpperCase(Locale.ENGLISH).indexOf("ORDER BY") + 8);
            String[] columns = orderbycolumns.split(",");
            StringBuffer t1orderby = new StringBuffer();
            StringBuffer t2orderby = new StringBuffer();
            StringBuffer t3orderby = new StringBuffer();
            for (String each : columns) {
                String eachStr;
                if (t1orderby.length() > 0) {
                    t1orderby.append(" ,");
                    t2orderby.append(" ,");
                    t3orderby.append(" ,");
                }
                if ((eachStr = each.trim()).indexOf("\".\"") > 0) {
                    String tempStr = eachStr.substring(0, eachStr.indexOf(".") + 1);
                    if (tempStr.toUpperCase(Locale.ENGLISH).indexOf("T0") > 0) {
                        int fromend;
                        int index;
                        String tempsql;
                        int indexend;
                        String[] splitStr = eachStr.trim().split(BLANK);
                        eachStr = splitStr[0].toUpperCase(Locale.ENGLISH);
                        String orderdesc = "";
                        if (splitStr.length > 1) {
                            orderdesc = splitStr[splitStr.length - 1];
                        }
                        if ((indexend = (tempsql = sql.toUpperCase(Locale.ENGLISH)).indexOf(",", index = tempsql.indexOf(eachStr.toUpperCase(Locale.ENGLISH)))) > (fromend = tempsql.indexOf("FROM", index))) {
                            indexend = fromend;
                        }
                        String[] alias = tempsql.substring(index, indexend).trim().split(BLANK);
                        eachStr = alias[alias.length - 1] + BLANK + orderdesc;
                    } else {
                        eachStr = eachStr.substring(eachStr.indexOf(".") + 1);
                    }
                }
                t1orderby.append("T1.").append(eachStr).append(BLANK);
                t2orderby.append("T2.").append(eachStr).append(BLANK);
                t3orderby.append("T3.").append(eachStr).append(BLANK);
            }
            String t2orderbyStr = this.formatRflexOrder(t2orderby.toString());
            Sqllimit.append("SELECT * FROM (").append("select *,row_number()over(order by tempcolumn)temprownumber ").append(" FROM (").append(TOP_SELECT).append(top).append(" *,tempcolumn=0 from (").append(sql).append(") AS T1 ").append(") AS T2 ").append(" ) AS T3 ").append(" where temprownumber>").append(start);
            return new LimitInfo("/*dialect*/" + Sqllimit, 0, top - start);
        }
        Sqllimit.append("SELECT * FROM (").append("select *,row_number()over(order by tempcolumn)temprownumber ").append(" FROM (").append(TOP_SELECT).append(top).append(" *,tempcolumn=0 from (").append(sql).append(") AS T1 ").append(") AS T2 ").append(" ) AS T3 ").append(" where temprownumber>").append(start);
        return new LimitInfo("/*dialect*/" + Sqllimit, 0, top - start);
    }

    private String formatRflexOrder(String OrderSql) {
        String regEx1 = " ASC";
        Pattern pat1 = Pattern.compile(regEx1);
        Matcher mat1 = pat1.matcher(OrderSql);
        String s1 = mat1.replaceAll("#RlexAC#");
        String regEx2 = " DESC";
        Pattern pat2 = Pattern.compile(regEx2);
        Matcher mat2 = pat2.matcher(s1);
        String s2 = mat2.replaceAll(" ASC");
        String regEx3 = "#RlexAC#";
        Pattern pat3 = Pattern.compile(regEx3);
        Matcher mat3 = pat3.matcher(s2);
        String s3 = mat3.replaceAll(" DESC");
        return s3;
    }

    private LimitInfo getLimitStringForDB2(String sql, int start, int top) {
        int startOfSelect = sql.toLowerCase(Locale.ENGLISH).indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append("SELECT * from ( SELECT tableA.*,").append(this.getRowNumberForDB2(sql));
        if (QueryDataAccess.hasDistinct(sql)) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(")AS tableA) as temp_ where rownumber_ ");
        pagingSelect.append("between ");
        pagingSelect.append(start);
        pagingSelect.append("+1 and ");
        pagingSelect.append(top);
        return new LimitInfo("/*dialect*/" + pagingSelect, 0, top - start);
    }

    private String getRowNumberForDB2(String sql) {
        StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
        int orderByIndex = sql.toLowerCase(Locale.ENGLISH).indexOf("order by");
        if (orderByIndex > 0 && !QueryDataAccess.hasDistinct(sql)) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_ FROM (SELECT");
        return rownumber.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.toLowerCase(Locale.ENGLISH).indexOf("select distinct") >= 0;
    }

    @Override
    public IRowSet getRowSetForRealPage(IMetaDataPK queryPK, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        return this.innerGetRowSetForRealPage(queryPK, MetaDataTypeList.BASEQUERY, null, views, parameters, option, start, length);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRowSet getRowSetForRealPage(String sql, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        DynamicRowSet dynamicRowSet;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int txIsolation = -1;
        try {
            if (start < 0) {
                throw new IllegalArgumentException("getRowSet: start = " + start);
            }
            if (length < 0) {
                throw new IllegalArgumentException("getRowSet: length = " + length);
            }
            LowTimer t = new LowTimer();
            t.reset();
            int top = start + length;
            DynamicRowSet drs = null;
            cn = QueryConnectionProvider.getConnection(this.getContext());
            int dbType = KSqlUtil.getDbType((Connection)cn);
            sql = this.processSQLLockHints(sql, option.lockingHints);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
            }
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            LimitInfo limit = this.getLimitForRealPage(dbType, sql, start, top);
            sql = limit.sql;
            stmt = cn.prepareStatement(sql);
            ParamData.setParamDataToStatement((ParamData)limit.paramData, (PreparedStatement)stmt);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
            }
            rs = this.excuteSQL(stmt, parameters);
            drs = this.createRowSet(rs);
            int startPos = 0;
            int rowCount = 0;
            int colCount = drs.getMetaData().getColumnCount();
            assert (colCount != 0);
            int idListSize = this.getCriticalIDSize();
            while (rs.next()) {
                if (++startPos <= limit.start) continue;
                drs.moveToInsertRow();
                for (int i = 1; i <= colCount; ++i) {
                    this.populateRowSetCell(drs, rs, i);
                }
                drs.insertRow();
                if (idListSize != 0 && ++rowCount > idListSize) {
                    try {
                        throw new FetchedTooMuchRowsException(rowCount);
                    }
                    catch (SQLException sqle) {
                        logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                        throw sqle;
                    }
                }
                if (rowCount != limit.lenth) continue;
            }
            drs.beforeFirst();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("____execQDA\t" + t.msValue()));
            }
            t.reset();
            dynamicRowSet = drs;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerGetRowSet() sql: " + sql));
                logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowSet() occur error,The RealPageQuery sql is:" + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("innerGetRowSet() sql: " + sql));
                    logger.error((Object)"innerGetRowSet() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int getRowCount(SqlAndParam paramMap, QueryExecuteOption option) throws BOSException {
        int count;
        block21: {
            int txIsolation;
            ResultSet rs;
            PreparedStatement ps;
            Connection cn;
            block20: {
                cn = null;
                ps = null;
                rs = null;
                count = 0;
                txIsolation = -1;
                String sql = paramMap.getSql("keySql");
                sql = StringUtils.replace((String)sql, (String)"COUNT(1)", (String)"COUNT(*)");
                sql = this.processSQLLockHints(sql, option.lockingHints);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("innerGetRowCount()'s sql:\n" + sql));
                }
                cn = QueryConnectionProvider.getConnection(this.getContext());
                if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                    txIsolation = cn.getTransactionIsolation();
                    cn.setTransactionIsolation(option.transactionIsolation);
                }
                ps = BaseDataAccess.prepareStatement(cn, sql);
                Map<Integer, Object> params = paramMap.getParams();
                if (params != null) {
                    for (Integer keyValue : params.keySet()) {
                        if (keyValue == null) continue;
                        int index = keyValue;
                        Object[] val = (Object[])params.get(keyValue);
                        if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                            ps.setString(index, val[1].toString());
                            continue;
                        }
                        if (val[0].equals(SQLType.INT)) {
                            if (val[1] instanceof Integer) {
                                ps.setInt(index, (Integer)val[1]);
                                continue;
                            }
                            ps.setInt(index, Integer.parseInt(val[1].toString()));
                            continue;
                        }
                        ps.setObject(index, val[1]);
                    }
                }
                if (!(rs = ps.executeQuery()).next()) break block20;
                count = rs.getInt("COUNT");
            }
            try {
                if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                    cn.setTransactionIsolation(txIsolation);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
            break block21;
            catch (SQLException sqle) {
                try {
                    logger.error((Object)"innerGetRowCount() occur error: ", (Throwable)sqle);
                }
                catch (Throwable throwable) {
                    try {
                        if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                            cn.setTransactionIsolation(txIsolation);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
                    }
                    SQLUtils.cleanup(rs, ps, cn);
                    throw throwable;
                }
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, ps, (Connection)cn);
            }
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getRowCount(String sql, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        int n;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int txIsolation = -1;
        try {
            sql = this.processGetRowCountSQL(sql, null);
            sql = this.processSQLLockHints(sql, option.lockingHints);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetRowCount()'s sql:\n" + sql));
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = this.excuteSQL(stmt, parameters);
            int count = 0;
            if (rs.next()) {
                count = rs.getInt("COUNT");
            }
            n = count;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("innerGetRowCount() sql: " + sql));
                logger.error((Object)"innerGetRowCount() occur error: ", (Throwable)sqle);
                throw new SQLDataException("innerGetRowCount error! The query sql is:" + sql, (Throwable)sqle);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerHasResult()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return n;
    }

    protected int getDBType() throws SQLException {
        Connection cn = QueryConnectionProvider.getConnection(this.getContext());
        try {
            int n = KSqlUtil.getDbType((Connection)cn);
            return n;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected boolean textIndexPrepare(EntityViewInfo view, QueryExecuteOption option) throws BOSException {
        if (StringUtils.isEmpty((String)option.prosAutoUseTextIndex)) {
            return false;
        }
        int dbType = 0;
        try {
            dbType = this.getDBType();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (dbType != 7 && dbType != 8 && dbType != 2) {
            return false;
        }
        if (view == null || view.getFilter() == null || view.getFilter().getFilterItems().size() == 0) {
            return false;
        }
        boolean textIndexUsed = false;
        String prosAutoUseTextIndex = option.prosAutoUseTextIndex.trim().toUpperCase(Locale.ENGLISH);
        for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
            String itemValue;
            Object oItemValue;
            FilterItemInfo item = view.getFilter().getFilterItems().get(i);
            String propertyName = item.getPropertyName();
            if ("".equals(propertyName = propertyName.trim().toUpperCase(Locale.ENGLISH)) || prosAutoUseTextIndex.indexOf(propertyName) < 0 || (oItemValue = item.getCompareValue()) == null || oItemValue.toString().equals("") || (itemValue = oItemValue.toString()).indexOf("%") != 0) continue;
            itemValue = itemValue.replaceAll("_", "");
            itemValue = itemValue.replaceAll("%", "");
            itemValue = itemValue.replaceAll("\\}", "}}");
            itemValue = itemValue.replaceAll("\\\\", "\\\\\\\\");
            itemValue = "{" + itemValue + "}";
            if (!itemValue.equals("")) {
                item.setCompareValue((Object)("{t}|" + itemValue));
            }
            textIndexUsed = true;
        }
        return textIndexUsed;
    }

    protected String getSqlForTextIndex(String sql) throws BOSException {
        Matcher m;
        try {
            sql = TransUtil.Translate((String)sql, (int)this.getDBType());
        }
        catch (SqlTranslateException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Pattern p = Pattern.compile("([\\( ])([^ \\(\\)]+) +LIKE +'\\{t\\}\\|([^ \\(\\)]+)'([\\) ]?)");
        while ((m = p.matcher(sql)).find()) {
            String newString = m.group(1) + "CONTAINS(" + m.group(2) + ",'" + m.group(3) + "')>0" + m.group(4);
            newString = newString.replace("\\", "\\\\");
            newString = newString.replace("$", "\\$");
            sql = m.replaceFirst(newString);
        }
        sql = "/*dialect*/ " + sql;
        return sql;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRowSet groupbyTime(IMetaDataPK pk, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, QueryFieldInfo[] aggFields, String[] aggFuns, QueryFieldInfo timeField, int[] timeSegments, int rowCount) throws BOSException {
        IRowSet iRowSet;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        String tableName = null;
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        try {
            LowTimer t = new LowTimer();
            t.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getQuery: " + t.msValue()));
                t.reset();
            }
            ctx.init(this.getContext(), null, pk, MetaDataTypeList.BASEQUERY);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("initQueryContext: " + t.msValue()));
                t.reset();
            }
            sql = this.getRuntimeSql(ctx);
            sql = KSqlUtil.optimize((String)sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRuntimeSql: " + t.msValue()));
                t.reset();
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = stmt.executeQuery();
            AggInfo[] aggInfos = new AggInfo[aggFields.length];
            for (int i = 0; i < aggInfos.length; ++i) {
                aggInfos[i] = new AggInfo();
                if (aggFields[i] != null) {
                    aggInfos[i].field = aggFields[i].getName();
                }
                aggInfos[i].function = aggFuns[i];
            }
            String timeFieldName = timeField.getName();
            TimeAnalysis ta = new TimeAnalysis(timeSegments, aggInfos, timeFieldName);
            ta.prepareData(rs);
            iRowSet = ta.getResult();
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("groupbyTime() pk: " + pk));
                logger.error((Object)("groupbyTime() sql: " + sql));
                logger.error((Object)"groupbyTime() occur error: ", (Throwable)sqle);
                throw new SQLDataException("groupbyTime() sql: " + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("groupbyTime() pk: " + pk));
                    logger.error((Object)("groupbyTime() sql: " + sql));
                    logger.error((Object)"groupbyTime() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                    if (tableName != null) {
                        TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"groupbyTime()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
            if (tableName != null) {
                TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"groupbyTime()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return iRowSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRowSet groupbyHeader(IMetaDataPK pk, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, QueryFieldInfo headerField, QueryFieldInfo[] groupbyFields) throws BOSException {
        IRowSet iRowSet;
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        String tableName = null;
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        try {
            LowTimer t = new LowTimer();
            t.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getQuery: " + t.msValue()));
                t.reset();
            }
            ctx.init(this.getContext(), null, pk, MetaDataTypeList.BASEQUERY);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("initQueryContext: " + t.msValue()));
                t.reset();
            }
            sql = this.getRuntimeSql(ctx);
            sql = KSqlUtil.optimize((String)sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRuntimeSql: " + t.msValue()));
                t.reset();
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = stmt.executeQuery();
            String header = headerField.getName();
            String[] groupbys = new String[groupbyFields.length];
            for (int i = 0; i < groupbys.length; ++i) {
                groupbys[i] = groupbyFields[i].getName();
            }
            HeaderCounter hc = new HeaderCounter(groupbys, header);
            hc.prepareData(rs);
            iRowSet = hc.getResult();
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("groupbyTime() pk: " + pk));
                logger.error((Object)("groupbyTime() sql: " + sql));
                logger.error((Object)"groupbyTime() occur error: ", (Throwable)sqle);
                throw new SQLDataException("groupbyTime() sql: " + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("groupbyTime() pk: " + pk));
                    logger.error((Object)("groupbyTime() sql: " + sql));
                    logger.error((Object)"groupbyTime() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                    if (tableName != null) {
                        TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"groupbyAndAgg()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
            if (tableName != null) {
                TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"groupbyAndAgg()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return iRowSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRowSet groupbyAndAgg(IMetaDataPK pk, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, QueryFieldInfo[] selectorFields, QueryFieldInfo[] aggFields, String[] aggFuns, QueryFieldInfo[] groupbyFields) throws BOSException {
        JdbcRowSet jdbcRowSet;
        if (aggFuns.length == 1 && aggFuns[0].equalsIgnoreCase("countHeader")) {
            return this.groupbyHeader(pk, view, views, parameters, option, aggFields[0], groupbyFields);
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        String tableName = null;
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        try {
            LowTimer t = new LowTimer();
            t.reset();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getQuery: " + t.msValue()));
                t.reset();
            }
            ctx.init(this.getContext(), null, pk, MetaDataTypeList.BASEQUERY);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("initQueryContext: " + t.msValue()));
                t.reset();
            }
            sql = this.getRuntimeSql(ctx);
            sql = KSqlUtil.optimize((String)sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRuntimeSql: " + t.msValue()));
                t.reset();
            }
            sql = this.innerGroupbyAndAggSQL(sql, selectorFields, aggFields, aggFuns, groupbyFields);
            sql = KSqlUtil.optimize((String)sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("groupbyAndAgg()'s sql:\n" + sql));
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = BaseDataAccess.prepareStatement(cn, sql);
            rs = stmt.executeQuery();
            JdbcRowSet rowSet = new JdbcRowSet();
            rowSet.populate(rs);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("executeQuery and populate rowSet: " + t.msValue()));
                t.reset();
            }
            jdbcRowSet = rowSet;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("groupbyAndAgg() pk: " + pk));
                logger.error((Object)("groupbyAndAgg() sql: " + sql));
                logger.error((Object)"groupbyAndAgg() occur error: ", (Throwable)sqle);
                throw new SQLDataException("groupbyAndAgg() sql: " + sql, (Throwable)sqle);
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("groupbyAndAgg() pk: " + pk));
                    logger.error((Object)("groupbyAndAgg() sql: " + sql));
                    logger.error((Object)"groupbyAndAgg() occur error: ", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                    if (tableName != null) {
                        TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"groupbyAndAgg()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, (Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
            if (tableName != null) {
                TempTablePool.getInstance(this.getContext()).releaseTable(tableName);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"groupbyAndAgg()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return jdbcRowSet;
    }

    private String innerGroupbyAndAggSQL(String sql, QueryFieldInfo[] selectorFields, QueryFieldInfo[] aggFields, String[] aggFuns, QueryFieldInfo[] groupbyFields) throws BOSException {
        SqlIdentifierExpr expr;
        String item;
        SqlSelectItem sitem;
        SqlIdentifierExpr expr2;
        String item2;
        String dfield;
        int i;
        ArrayList<SqlSelectItem> selectorList = new ArrayList<SqlSelectItem>();
        HashSet<QueryFieldInfo> unique = new HashSet<QueryFieldInfo>();
        ArrayList<SqlSelectItem> selectorList2 = new ArrayList<SqlSelectItem>();
        ArrayList<SqlSelectItem> aggList = new ArrayList<SqlSelectItem>();
        ArrayList<SqlIdentifierExpr> groupbyList = new ArrayList<SqlIdentifierExpr>();
        if (selectorFields != null && selectorFields.length > 0) {
            for (i = 0; i < selectorFields.length; ++i) {
                dfield = QueryUtil.getUnitString((PropertyUnitInfo)selectorFields[i]).replaceAll("&", "||");
                item2 = dfield + " as \"" + selectorFields[i].getName() + "\"";
                expr2 = new SqlIdentifierExpr(item2);
                sitem = new SqlSelectItem((SqlExpr)expr2, null);
                selectorList2.add(sitem);
                item2 = "\"" + selectorFields[i].getName() + "\" as \"" + selectorFields[i].getName() + "\"";
                expr2 = new SqlIdentifierExpr(item2);
                sitem = new SqlSelectItem((SqlExpr)expr2, null);
                selectorList.add(sitem);
                unique.add(selectorFields[i]);
            }
        }
        if (aggFields.length > 0) {
            if (aggFields.length != aggFuns.length) {
                throw new BOSException("aggFields.length must equals aggFuns.length.");
            }
            for (i = 0; i < aggFields.length; ++i) {
                if (aggFields[i] != null) {
                    dfield = QueryUtil.getUnitString((PropertyUnitInfo)aggFields[i]).replaceAll("&", "||");
                    item2 = aggFuns[i] + "(\"" + aggFields[i].getName() + "\") as \"" + aggFuns[i] + "_" + aggFields[i].getName() + "\"";
                    expr2 = new SqlIdentifierExpr(item2);
                    sitem = new SqlSelectItem((SqlExpr)expr2, null);
                    aggList.add(sitem);
                    if (unique.contains(aggFields[i])) continue;
                    item2 = dfield + " as \"" + aggFields[i].getName() + "\"";
                    expr2 = new SqlIdentifierExpr(item2);
                    sitem = new SqlSelectItem((SqlExpr)expr2, null);
                    selectorList2.add(sitem);
                    unique.add(aggFields[i]);
                    continue;
                }
                if (!aggFuns[i].equalsIgnoreCase("count")) {
                    throw new BOSException("aggFields[" + i + "] is null, aggFun must be count.");
                }
                item = "count(1) as \"count\"";
                expr = new SqlIdentifierExpr(item);
                SqlSelectItem sitem2 = new SqlSelectItem((SqlExpr)expr, null);
                aggList.add(sitem2);
            }
        }
        if (groupbyFields.length < 1) {
            throw new BOSException("groupbyFields.length must >0");
        }
        for (i = 0; i < groupbyFields.length; ++i) {
            item = "\"" + groupbyFields[i].getName() + "\"";
            expr = new SqlIdentifierExpr(item);
            groupbyList.add(expr);
            if (unique.contains(groupbyFields[i])) continue;
            String dfield2 = QueryUtil.getUnitString((PropertyUnitInfo)groupbyFields[i]).replaceAll("&", "||");
            expr = new SqlIdentifierExpr(dfield2);
            sitem = new SqlSelectItem((SqlExpr)expr, null);
            selectorList2.add(sitem);
            unique.add(groupbyFields[i]);
        }
        StringBuffer buffer = new StringBuffer();
        try {
            SqlSubQueryTableSource sqlSubQueryTableSource;
            SelectParser selectParser = new SelectParser(sql);
            SqlSelectBase sqlSelectBase = selectParser.select();
            SqlSelect innerSQL = null;
            if (sqlSelectBase instanceof SqlSelect) {
                SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
                sqlSelect.orderBy.clear();
                innerSQL = sqlSelect;
            } else if (sqlSelectBase instanceof SqlUnionSelect) {
                innerSQL = new SqlSelect();
                SqlUnionSelect sqlUnionSelect = (SqlUnionSelect)sqlSelectBase;
                innerSQL.selectList.addAll(selectorList2);
                sqlSubQueryTableSource = new SqlSubQueryTableSource();
                sqlSubQueryTableSource.subQuery = sqlUnionSelect;
                sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
                innerSQL.tableSource = sqlSubQueryTableSource;
            }
            SqlSelect result = new SqlSelect();
            result.selectList.addAll(selectorList);
            result.selectList.addAll(aggList);
            result.groupBy.addAll(groupbyList);
            sqlSubQueryTableSource = new SqlSubQueryTableSource();
            StringBuffer sqlBuffer = new StringBuffer();
            QuerySQLFormater sqlFormater = new QuerySQLFormater(sqlBuffer);
            sqlFormater.formatSelectBase((SqlSelectBase)innerSQL);
            String sqls = null;
            try {
                sqls = KSqlUtil.optimize((String)sqlBuffer.toString());
                selectParser = new SelectParser(sqls);
                sqlSelectBase = selectParser.select();
                innerSQL = (SqlSelect)sqlSelectBase;
            }
            catch (SqlTranslateException e) {
                throw new BOSException((Throwable)e);
            }
            sqlSubQueryTableSource.subQuery = innerSQL;
            sqlSubQueryTableSource.alias = QueryHelper.addMark(new UUTN().toString());
            result.tableSource = sqlSubQueryTableSource;
            QuerySQLFormater formater = new QuerySQLFormater(buffer);
            formater.formatSelectBase((SqlSelectBase)result);
        }
        catch (ParserException e) {
            logger.error((Object)"innerGroupbyAndAggSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (FormaterException e) {
            logger.error((Object)"innerGroupbyAndAggSQL() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return buffer.toString();
    }

    static {
        MetadataCleaner.registerListener((MetadataClearListener)new MetadataClearListener(){

            public void clear(String key) {
                if (key != null && key.indexOf("!") > 0) {
                    if (MetaDataTypeList.BIZENUM.toString().equals(key.substring(key.indexOf("!") + 1))) {
                        enumRsCache.removeAll();
                    } else if (MetaDataTypeList.BASEQUERY.toString().equals(key.substring(key.indexOf("!") + 1)) || MetaDataTypeList.JOINQUERY.toString().equals(key.substring(key.indexOf("!") + 1)) || MetaDataTypeList.UNIONQUERY.toString().equals(key.substring(key.indexOf("!") + 1))) {
                        realPageSqlCache.removeAll();
                    }
                }
            }

            public void clearAll() {
                enumRsCache.removeAll();
                realPageSqlCache.removeAll();
            }
        });
    }

    static class LimitInfo {
        String sql;
        int start;
        int lenth;
        ParamData paramData;

        LimitInfo(String sql, int start, int lenth) {
            this.sql = sql;
            this.start = start;
            this.lenth = lenth;
        }
    }

    private class FieldAlias {
        private String fieldAliasName;
        private String fieldName;

        public FieldAlias(String fieldAliasName, String fieldName) {
            this.fieldAliasName = fieldAliasName;
            this.fieldName = fieldName;
        }

        public String getFieldAliasName() {
            return this.fieldAliasName;
        }

        public String getFieldName() {
            return this.fieldName;
        }
    }
}

