/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.framework.DeployInfoManagerFactory;
import com.kingdee.bos.framework.IDeployInfoManager;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.LRUMap;
import com.kingdee.util.TypeConversionUtils;
import java.util.ArrayList;

public final class RowSetSqlCache {
    static final int DEFAULT_CACHE_SIZE = 0x1000000;
    private static final RowSetSqlCache instance = new RowSetSqlCache();
    private LRUMap cache = new LRUMap();

    private RowSetSqlCache() {
        this.cache.setMaxSize(this.getCacheMaxSize());
    }

    public static RowSetSqlCache getInstance() {
        if (instance == null) {
            throw new IllegalStateException("call createInstance(Context ctx) first.");
        }
        return instance;
    }

    private int getCacheMaxSize() {
        int maxSize = 0;
        IDeployInfoManager deploy = DeployInfoManagerFactory.getDeployInfoManager();
        ConfigurationItem debugOption = deploy.getConfigItem("DebugOptions");
        if (debugOption != null) {
            maxSize = TypeConversionUtils.objToInt((Object)debugOption.getProperty("selectCacheMaxSize"));
        }
        if (maxSize == 0) {
            maxSize = 0x1000000;
        }
        return maxSize;
    }

    public synchronized RowSetSqlDec getSql(String key) {
        return (RowSetSqlDec)this.cache.get((Object)key);
    }

    public synchronized RowSetSqlDec putSql(String key, RowSetSqlDec sql) {
        return (RowSetSqlDec)this.cache.put((Object)key, (Object)sql);
    }

    public synchronized int getCacheCount() {
        return this.cache.size();
    }

    public synchronized int getCacheSize() {
        return this.cache.getTotalSize();
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    private static class SQLDescSize
    implements LRUMap.IObjectSizeComputer {
        private SQLDescSize() {
        }

        public int sizeOf(Object obj) {
            if (obj == null) {
                return 8;
            }
            if (obj instanceof RowSetSqlDec) {
                return this.sizeOfRowSetSqlDec((RowSetSqlDec)obj);
            }
            if (obj instanceof String) {
                return SQLDescSize.sizeOfString((String)obj);
            }
            return 0;
        }

        private int sizeOfRowSetSqlDec(RowSetSqlDec selectDesc) {
            if (selectDesc == null) {
                return 8;
            }
            return 24 + SQLDescSize.sizeOfArrayListShell(selectDesc.getSelector()) + SQLDescSize.sizeOfString(selectDesc.getSelect().toString());
        }

        private static final int sizeOfString(String str) {
            if (str == null) {
                return 8;
            }
            return str.length() * 2 + 40;
        }

        private static final int sizeOfObjectArrayShell(int len) {
            return len * 4 + 16;
        }

        private static final int sizeOfStringArray(String[] aStr) {
            if (aStr == null) {
                return 8;
            }
            int size = 0;
            for (int i = 0; i < aStr.length; ++i) {
                size += SQLDescSize.sizeOfString(aStr[i]);
            }
            return size += SQLDescSize.sizeOfObjectArrayShell(aStr.length);
        }

        private static final int sizeOfArrayListShell(ArrayList list) {
            if (list == null) {
                return 8;
            }
            return SQLDescSize.sizeOfObjectArrayShell(list.size()) + 20;
        }
    }

    private static class StringSize
    implements LRUMap.IObjectSizeComputer {
        private StringSize() {
        }

        public int sizeOf(Object obj) {
            if (obj == null) {
                return 8;
            }
            return StringSize.sizeOfString((String)obj);
        }

        private static final int sizeOfString(String str) {
            return str.length() * 2 + 40;
        }
    }

    static class RowSetSqlDec {
        final SqlSelect bizSqlSelect;
        final ArrayList selector;

        public RowSetSqlDec(SqlSelect bizSqlSelect, ArrayList selector) {
            this.bizSqlSelect = bizSqlSelect;
            this.selector = selector;
        }

        public ArrayList getSelector() {
            return this.selector;
        }

        public SqlSelect getSelect() {
            return this.bizSqlSelect;
        }
    }
}

