/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.server.AbstractSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.dao.query.server.MemcacheSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.dao.query.server.SeqTableData;
import com.kingdee.bos.dao.query.server.seqtablecache.SeqTableCacheFactory;
import com.kingdee.bos.db.RWSplitingManager;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.QueryDele;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.util.FIFOSet;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SeqTableDiskCacheAcuquire
extends AbstractSeqTableAcuquire {
    private static final Logger logger = Logger.getLogger(MemcacheSeqTableAcuquire.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map acquire(Context context, Uuid querySessionID, QueryDele query, EntityViewInfo view, Map views, Map params, QueryExecuteOption option, String sql, int length, String keyFieldName) throws BOSException {
        HashMap<String, String> hashMap;
        HashMap<String, String> sqlMap = new HashMap<String, String>();
        Connection cn = null;
        PreparedStatement ps = null;
        Statement stmt = null;
        ResultSet rs = null;
        String selectSQL = null;
        SeqTableData seqTableData = new SeqTableData();
        int txIsolation = -1;
        Context fakeCtx = new Context((IObjectPK)new ObjectUuidPK(), context.getSolution(), RWSplitingManager.getReadAis(context), context.getLocale(), context.getContextID());
        seqTableData.setContext(fakeCtx);
        seqTableData.setQuerySessionID(querySessionID);
        seqTableData.setView(view);
        seqTableData.setViews(views);
        try {
            int keySize = query.getQueryPK().getKeyPropertys().size();
            cn = QueryConnectionProvider.getConnection(context);
            int dbtype = KSqlUtil.getDbType((Connection)cn);
            seqTableData.setLogicPKInfo(SeqTableDiskCacheAcuquire.getLogicPKInfo(query, sql));
            QueryCacheManager.getInstance().putObject(querySessionID, seqTableData);
            selectSQL = SeqTableDiskCacheAcuquire.buildSelectSQL(sqlMap, seqTableData, option, sql, dbtype);
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            ps = BaseDataAccess.prepareStatement(cn, selectSQL);
            ps.setFetchSize(100);
            if (params != null) {
                for (Object keyValue : params.keySet()) {
                    if (keyValue == null) continue;
                    int index = (Integer)keyValue;
                    Object[] val = (Object[])params.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                        ps.setString(index, val[1].toString());
                        continue;
                    }
                    if (val[0].equals(SQLType.INT)) {
                        if (val[1] instanceof Integer) {
                            ps.setInt(index, (Integer)val[1]);
                            continue;
                        }
                        ps.setInt(index, Integer.parseInt(val[1].toString()));
                        continue;
                    }
                    ps.setObject(index, val[1]);
                }
            }
            rs = ps.executeQuery();
            int columnCount = rs.getMetaData().getColumnCount();
            if (keyFieldName != null && keyFieldName.length() > 0) {
                boolean found = false;
                for (int i = 0; i < columnCount; ++i) {
                    String name = rs.getMetaData().getColumnName(i + 1);
                    if (!name.equalsIgnoreCase(keyFieldName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    keyFieldName = null;
                }
            }
            if (keyFieldName == null) {
                keyFieldName = rs.getMetaData().getColumnName(1);
            }
            int k = 0;
            int rc = 0;
            int pageNo = 0;
            int idListSize = SeqTableDiskCacheAcuquire.getCriticalIDSize();
            int idSetSize = SeqTableDiskCacheAcuquire.getCriticalSetSize();
            FIFOSet idSet = new FIFOSet();
            idSet.setMaxSize(idSetSize);
            boolean isBillCount = false;
            int pageRowCount = 500;
            Page page = new Page(pageRowCount);
            while (rs.next()) {
                if (rc > idListSize) {
                    logger.error((Object)("FetchedTooManyRecords,limit:" + idListSize));
                    break;
                }
                if (rc >= idSetSize && !isBillCount) {
                    sqlMap.put("keySQL", sql);
                    isBillCount = true;
                }
                if (keyFieldName != null && keyFieldName.length() > 0) {
                    String id = rs.getString(keyFieldName);
                    if (!idSet.contains((Object)id)) {
                        idSet.add((Object)id);
                        page.setBit(k);
                    }
                    if (k == 0) {
                        for (int m = 1; m <= columnCount; ++m) {
                            if (!keyFieldName.equalsIgnoreCase(rs.getMetaData().getColumnName(m))) continue;
                            page.setBillIdIndex(m - 1);
                        }
                    }
                }
                ++k;
                ++rc;
                Object[] objs = null;
                objs = keySize > columnCount ? new Object[keySize] : new Object[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    objs[i - 1] = rs.getObject(i);
                }
                page.addRow(objs);
                if (k != pageRowCount) continue;
                SeqTableDiskCacheAcuquire.putCache(seqTableData, context, querySessionID.toString() + ++pageNo, page);
                page = new Page(pageRowCount);
                k = 0;
            }
            if (k > 0) {
                SeqTableDiskCacheAcuquire.putCache(seqTableData, context, querySessionID.toString() + ++pageNo, page);
            }
            seqTableData.setRowCount(rc);
            seqTableData.setBillCount(idSet.size());
            seqTableData.setPageRowCount(pageRowCount);
            hashMap = sqlMap;
        }
        catch (Throwable e) {
            try {
                seqTableData.setThrowable(e);
                throw new BOSException("select key ID error. selectSQL is : " + selectSQL, e);
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e2) {
                    logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e2);
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup(stmt);
        SQLUtils.cleanup((Connection)cn);
        return hashMap;
    }

    static void putCache(SeqTableData seqTableData, Context context, String key, Page obj) {
        seqTableData.addCacheKey(key);
        SeqTableCacheFactory.instance.getCache(context).put(key, obj, 43200000);
    }

    public static Page get(Context context, String key) {
        return (Page)SeqTableCacheFactory.instance.getCache(context).get(key);
    }

    public static List<Object[]> getRowList(Context context, String key) {
        Page page = (Page)SeqTableCacheFactory.instance.getCache(context).get(key);
        return page.getRowList();
    }

    public static void release(Context context, SeqTableData seqTableData) {
        for (String key : seqTableData.cacheKeys) {
            SeqTableCacheFactory.instance.getCache(context).remove(key);
        }
    }

    public static List getBillIDList(Context context, SeqTableData seqTableData, int start, int length) {
        int pageRowCount = seqTableData.getPageRowCount();
        int rowCount = seqTableData.getRowCount();
        int pageCount = rowCount / pageRowCount + (rowCount % pageRowCount > 0 ? 1 : 0);
        ArrayList<Object> result = new ArrayList<Object>();
        int index = 0;
        for (int i = 0; i < pageCount; ++i) {
            Page page = SeqTableDiskCacheAcuquire.get(context, seqTableData.getQuerySessionID().toString() + (i + 1));
            int cd = page.billIdBitSet.cardinality();
            if (index + cd < start) {
                index += cd;
                continue;
            }
            for (int j = 0; j < page.billIdBitSet.size(); ++j) {
                if (page.billIdBitSet.get(j)) {
                    if (index < start) {
                        ++index;
                        continue;
                    }
                    Object[] row = page.getRowList().get(j);
                    result.add(row[page.billIdIndex]);
                    ++index;
                }
                if (index != start + length) continue;
                return result;
            }
        }
        return result;
    }

    public static void removeBillId(Context context, SeqTableData seqTableData, String billId) {
        int pageRowCount = seqTableData.getPageRowCount();
        int rowCount = seqTableData.getRowCount();
        int pageCount = rowCount / pageRowCount + (rowCount % pageRowCount > 0 ? 1 : 0);
        int index = 0;
        for (int i = 0; i < pageCount; ++i) {
            String key = seqTableData.getQuerySessionID().toString() + (i + 1);
            Page page = SeqTableDiskCacheAcuquire.get(context, key);
            for (int j = 0; j < page.billIdBitSet.size(); ++j) {
                if (!page.billIdBitSet.get(j)) continue;
                ++index;
                Object[] row = page.getRowList().get(j);
                if (!billId.equals(row[page.billIdIndex])) continue;
                page.billIdBitSet.clear(j);
                SeqTableCacheFactory.instance.getCache(context).put(key, page, 3600000);
                return;
            }
        }
    }

    public static int indexOfBillId(Context context, SeqTableData seqTableData, String billId) {
        return SeqTableDiskCacheAcuquire.indexOfBillId(context, seqTableData, billId, true);
    }

    public static int indexOfBillId(Context context, SeqTableData seqTableData, String billId, boolean isIndexOfListUI) {
        int pageRowCount = seqTableData.getPageRowCount();
        int rowCount = seqTableData.getRowCount();
        int pageCount = rowCount / pageRowCount + (rowCount % pageRowCount > 0 ? 1 : 0);
        int index = 0;
        for (int i = 0; i < pageCount; ++i) {
            Object[] row;
            int j;
            Page page = SeqTableDiskCacheAcuquire.get(context, seqTableData.getQuerySessionID().toString() + (i + 1));
            if (isIndexOfListUI) {
                for (j = 0; j < page.billIdBitSet.size(); ++j) {
                    if (!page.billIdBitSet.get(j)) continue;
                    ++index;
                    row = page.getRowList().get(j);
                    if (!billId.equals(row[page.billIdIndex])) continue;
                    return index - 1;
                }
                continue;
            }
            for (j = 0; j < page.rowCount; ++j) {
                ++index;
                row = page.getRowList().get(j);
                if (!billId.equals(row[page.billIdIndex])) continue;
                return index - 1;
            }
        }
        return -1;
    }

    public static class Page
    implements Serializable {
        int rowCount;
        BitSet billIdBitSet = new BitSet();
        int billIdIndex;
        private ArrayList<Object[]> rowList = new ArrayList();

        public Page(int rowCount) {
            this.rowList = new ArrayList(rowCount);
        }

        public void setBillIdIndex(int index) {
            this.billIdIndex = index;
        }

        public void addRow(Object[] row) {
            this.rowList.add(row);
            ++this.rowCount;
        }

        public void setBit(int index) {
            this.billIdBitSet.set(index);
        }

        public List<Object[]> getRowList() {
            return this.rowList;
        }
    }
}

