/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import bos.org.apache.commons.bos.MySqlDBUtils;
import bos.org.apache.commons.dbutils.QueryRunner;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.JDBCExceptionHandler;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryHelper;
import com.kingdee.bos.dao.query.server.AbstractSeqTableAcuquire;
import com.kingdee.bos.dao.query.server.BaseDataAccess;
import com.kingdee.bos.dao.query.server.CloseQueryUtil;
import com.kingdee.bos.dao.query.server.IQueryDataAccess;
import com.kingdee.bos.dao.query.server.IVirtualModeDataAccess;
import com.kingdee.bos.dao.query.server.LogicPKItem;
import com.kingdee.bos.dao.query.server.QueryCacheManager;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.dao.query.server.QueryContext;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.dao.query.server.QueryManagerTools;
import com.kingdee.bos.dao.query.server.RTQuerySqlAccess;
import com.kingdee.bos.dao.query.server.SQLTranslateUtil;
import com.kingdee.bos.dao.query.server.SeqTableData;
import com.kingdee.bos.dao.query.server.SeqTableDiskCacheAcuquire;
import com.kingdee.bos.dao.query.server.SeqTableManager;
import com.kingdee.bos.dao.query.server.SqlAndParam;
import com.kingdee.bos.dao.query.server.VirtualModeUtils;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.cache.CustomCacheService;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.QuerySQLFormater;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.rpcwrapper.IServerSession;
import com.kingdee.bos.rpcwrapper.ServerSessionContainer;
import com.kingdee.bos.sql.KSqlTools;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSelectLimit;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.parser.SelectParser;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.jdbc.rowset.FetchedTooMuchRowsException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.profile.ProfileConfig;
import com.kingdee.util.profile.ThreadProfileContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VirtualModeDataAccess
extends BaseDataAccess
implements IVirtualModeDataAccess {
    public static final BOSObjectType BOSTYPE = BOSObjectType.create((String)"VRMQ");
    private static final int WAIT_TIME = 50;
    private static final int DEFAULT_MAX_REQUEST_COUNT = 500;
    private static final int MS_SQL_Server_MAX_REQUEST_COUNT = 200;
    private int MAX_REQUEST_COUNT = 0;
    private static Logger logger = Logger.getLogger(VirtualModeDataAccess.class);
    private static CustomCacheService sqlcache = new CustomCacheService("cache.VirtualMode");
    private static CustomCacheService enumRsCache = new CustomCacheService("cache.enumRsCache");
    private static final String _TEMP_FIELDNAME = "tempFieldName";

    public VirtualModeDataAccess(Context ctx) {
        super(ctx);
        this.registerInterface(IVirtualModeDataAccess.class, this);
    }

    public VirtualModeDataAccess() {
        this.registerInterface(IVirtualModeDataAccess.class, this);
    }

    public int getMaxRequestCount() {
        if (this.MAX_REQUEST_COUNT == 0) {
            Integer dbTypeCode = -1;
            if (ConfigMDUtil.isClient()) {
                try {
                    dbTypeCode = (Integer)SysContext.getSysContext().getProperty((Object)"dbType");
                }
                catch (Exception e1) {
                    logger.error((Object)"getSysContext dbType error!", (Throwable)e1);
                }
            } else {
                Context ctx = ConfigMDUtil.getContext();
                if (ctx != null) {
                    dbTypeCode = (Integer)ctx.get((Object)"dbTypeCode");
                } else {
                    return 500;
                }
            }
            this.MAX_REQUEST_COUNT = dbTypeCode != null && 3 == dbTypeCode ? 200 : 500;
        }
        return this.MAX_REQUEST_COUNT;
    }

    public BOSObjectType getType() {
        return BOSTYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet excuteSQLWithLogicPK(PreparedStatement stmt, Map<Integer, Object> parameters) throws SQLException {
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "excuteSQLWithLogicPK", null);
        }
        try {
            if (parameters != null) {
                for (Integer keyValue : parameters.keySet()) {
                    if (keyValue == null) continue;
                    int index = keyValue;
                    Object[] val = (Object[])parameters.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                        if (val[1] == null) continue;
                        stmt.setString(index, val[1].toString());
                        continue;
                    }
                    stmt.setObject(index, val[1]);
                }
            }
            ResultSet resultSet = stmt.executeQuery();
            return resultSet;
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    @Override
    public Uuid openQuery(IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        return this.innerOpenQuery(ctx, null, pk, type);
    }

    private Uuid innerOpenQuery(QueryContext ctx, Uuid querySessionID, IMetaDataPK pk, BOSObjectType type) throws BOSException {
        return this.innerOpenQuery(ctx, querySessionID, pk, type, -1, null);
    }

    private Uuid innerOpenQuery(QueryContext ctx, Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, int length, String keyFieldName) throws BOSException {
        Uuid uuid;
        String idTmpTable;
        block19: {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().enter(this.getClass().getName(), "innerOpenQuery", null);
            }
            idTmpTable = null;
            try {
                if (querySessionID == null) {
                    querySessionID = Uuid.create();
                }
                QueryManagerTools.getInstance().invokeSQLGeneratorStart();
                EntityViewInfo view = ctx.getView();
                Map<String, EntityViewInfo> views = ctx.getViews();
                if (views == null || views.size() <= 0) {
                    QueryInfo getQuery = ctx.getQuery(this.getContext(), querySessionID.toString(), pk, type);
                    VirtualModeUtils.switchWFSpeacilFilter(view, getQuery);
                }
                ctx.init(this.getContext(), querySessionID.toString(), pk, type);
                String sql = null;
                String runtimeSql = null;
                Map<Integer, Object> paramMap = null;
                RTQuerySqlAccess qsa = ctx.getQuerySqlAccess();
                Map<Integer, Object> paramMap4Qsa = ctx.getParameters4Qsa();
                if (views != null && views.size() > 0) {
                    runtimeSql = this.getRuntimeSql(ctx);
                } else {
                    idTmpTable = this.idArray2TempTableFilter(view);
                    if (view != null && view.isRemoveEntry()) {
                        qsa.query.setIsDistinct(true);
                        ctx.getOption().isAutoIgnoreDuplicatedRow = true;
                    }
                    ctx.setBParaType(true);
                    ctx.setParameters(new HashMap<Integer, Object>(1));
                    runtimeSql = this.getRuntimeSql(ctx);
                    ctx.getQuerySqlAccess().query.getParameters().size();
                    paramMap = ctx.getParameters();
                    int n = paramMap4Qsa.size();
                    for (int i = 0; i < n; ++i) {
                        paramMap.put(paramMap.size() + 1, paramMap4Qsa.get(i + 1));
                    }
                }
                sql = runtimeSql;
                sql = VirtualModeUtils.getInitializeSql(qsa.query, sql, 0);
                sql = KSqlUtil.optimize((String)sql);
                sql = this.setHint(sql, ctx.getOption().queryHints);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("prepareQuery's sql: \n" + sql));
                }
                Map queryUuidSqlMap = SeqTableManager.getInstance().acquire(this.getContext(), querySessionID, qsa.query, view, views, paramMap, ctx.getOption(), sql, length, keyFieldName);
                queryUuidSqlMap.put("runtimesql", runtimeSql);
                sqlcache.put(querySessionID.toString(), (Object)new SqlAndParam(queryUuidSqlMap, paramMap));
                SeqTableManager.getInstance().registerSession(querySessionID);
                SeqTableManager.registerInUserSession(querySessionID);
                QueryManagerTools.getInstance().invokeSQLGeneratorEnd();
                uuid = querySessionID;
                if (!ProfileConfig.getInstance().logQuery) break block19;
            }
            catch (SqlTranslateException e) {
                try {
                    logger.error((Object)("innerOpenQuery() pk: " + pk));
                    logger.error((Object)"innerOpenQuery() occur error: ", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (ProfileConfig.getInstance().logQuery) {
                        ThreadProfileContext.getInstance().exit();
                    }
                    if (idTmpTable != null) {
                        try {
                            TempTablePool.getInstance(this.getContext()).releaseTable(idTmpTable);
                        }
                        catch (Exception e1) {
                            logger.error((Object)"release database system temp table error!", (Throwable)e1);
                        }
                    }
                    throw throwable;
                }
            }
            ThreadProfileContext.getInstance().exit();
        }
        if (idTmpTable != null) {
            try {
                TempTablePool.getInstance(this.getContext()).releaseTable(idTmpTable);
            }
            catch (Exception e1) {
                logger.error((Object)"release database system temp table error!", (Throwable)e1);
            }
        }
        return uuid;
    }

    private String setHint(String sql, List<String> hints) {
        if (hints == null || hints.isEmpty()) {
            return sql;
        }
        StringBuffer hint = new StringBuffer();
        if (hints != null && !hints.isEmpty()) {
            hint.append("/*+");
            for (int i = 0; i < hints.size(); ++i) {
                hint.append(" ").append(hints.get(i));
            }
            hint.append("*/");
        }
        return "SELECT " + hint.toString() + sql.substring(6);
    }

    @Override
    public Uuid openQuery(String sql, List<String> pkField, QueryExecuteOption option) throws BOSException {
        return this.innerOpenQuery(null, sql, pkField, option);
    }

    private Uuid innerOpenQuery(Uuid querySessionID, String sql, List<String> pkField, QueryExecuteOption option) throws BOSException {
        try {
            QueryManagerTools.getInstance().invokeSQLGeneratorStart();
            if (querySessionID == null) {
                querySessionID = Uuid.create();
            }
            sql = KSqlUtil.optimize((String)sql);
            SeqTableManager.getInstance().acquire(this.getContext(), querySessionID, option, sql, pkField);
            QueryManagerTools.getInstance().invokeSQLGeneratorEnd();
            SeqTableManager.getInstance().registerSession(querySessionID);
            Uuid uuid = querySessionID;
            return uuid;
        }
        catch (SqlTranslateException e) {
            logger.error((Object)("innerOpenQuery() sql: " + sql));
            logger.error((Object)"innerOpenQuery() occur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private SeqTableData getSeqTableData(Uuid querySessionID, String sql, List<String> pkField, QueryExecuteOption option) throws BOSException {
        LowTimer lowTimer = new LowTimer();
        try {
            while (QueryCacheManager.getInstance().getObject(querySessionID) == null) {
                if (SeqTableManager.getInstance().existSession(querySessionID)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Thread:" + Thread.currentThread().getName() + " wait"));
                    }
                    Thread.sleep(50L);
                    if (lowTimer.msValue() < 28800000L) continue;
                    throw new BOSException("query session is invalidation!");
                }
                this.innerOpenQuery(querySessionID, sql, pkField, option);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"getQueryPKList() ocuur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        SeqTableData seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(querySessionID);
        if (seqTableData != null && seqTableData.getThrowable() != null) {
            QueryCacheManager.getInstance().destroyObject(querySessionID);
            logger.error((Object)"getQueryPKList() ocuur error: ", seqTableData.getThrowable());
            throw new BOSException(seqTableData.getThrowable());
        }
        return seqTableData;
    }

    private SeqTableData getSeqTableData(QueryContext ctx, Uuid querySessionID, IMetaDataPK pk, BOSObjectType type) throws BOSException {
        LowTimer lowTimer = new LowTimer();
        try {
            while (QueryCacheManager.getInstance().getObject(querySessionID) == null) {
                if (SeqTableManager.getInstance().existSession(querySessionID)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Thread:" + Thread.currentThread().getName() + " wait"));
                    }
                    Thread.sleep(50L);
                    if (lowTimer.msValue() < 28800000L) continue;
                    throw new BOSException("query session is invalidation!");
                }
                this.innerOpenQuery(ctx, querySessionID, pk, type);
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"getQueryPKList() ocuur error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        SeqTableData seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(querySessionID);
        if (seqTableData != null && seqTableData.getThrowable() != null) {
            QueryCacheManager.getInstance().destroyObject(querySessionID);
            logger.error((Object)"getQueryPKList() ocuur error: ", seqTableData.getThrowable());
            throw new BOSException(seqTableData.getThrowable());
        }
        return seqTableData;
    }

    private SeqTableData getSeqTableDataAsyn(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        SeqTableData seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(querySessionID);
        if (seqTableData != null && seqTableData.getThrowable() != null) {
            QueryCacheManager.getInstance().destroyObject(querySessionID);
            logger.error((Object)"getQueryPKList() ocuur error: ", seqTableData.getThrowable());
            throw new BOSException(seqTableData.getThrowable());
        }
        return seqTableData;
    }

    @Override
    public List<Object[]> getQueryPKList(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        if (length < 0) {
            throw new IllegalArgumentException("getQueryPKList:  = " + length);
        }
        QueryManagerTools.getInstance().invokeQueryExecuteStart();
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        SeqTableData seqTableData = this.getSeqTableData(ctx, querySessionID, pk, type);
        List<Object[]> rs = this.getQueryPKListBySqlTable(querySessionID, seqTableData, null, option, start, length);
        QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        return rs;
    }

    private List<Object[]> getQueryPKListBySqlTable(Uuid querySessionID, SeqTableData seqTableData, List<Integer> val, QueryExecuteOption option, int start, int length) throws BOSException {
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "getQueryPKListBySqlTable", null);
        }
        try {
            ArrayList<Object[]> arrayList;
            if (length < 0) {
                throw new IllegalArgumentException("getQueryPKList:  = " + length);
            }
            ArrayList<Object> retValue = null;
            if (length != 0) {
                retValue = length <= this.getMaxRequestCount() ? new ArrayList(length) : new ArrayList();
            } else {
                length = Integer.MAX_VALUE;
                retValue = new ArrayList<Object[]>();
            }
            if (SeqTableManager.getInstance().isSeqTabInDiskCache()) {
                List<Object[]> p1;
                ArrayList<Object[]> retlist = new ArrayList<Object[]>();
                int pageRowCount = seqTableData.getPageRowCount();
                int p = start / pageRowCount;
                int md = start % pageRowCount;
                SeqTableDiskCacheAcuquire.Page page = null;
                page = SeqTableDiskCacheAcuquire.get(this.getContext(), querySessionID.toString() + (p + 1));
                if (page != null) {
                    p1 = page.getRowList();
                    int index = 0;
                    for (int i = md; i < p1.size() && index < length; ++i, ++index) {
                        retlist.add(p1.get(i));
                    }
                }
                while (retlist.size() < length && (page = SeqTableDiskCacheAcuquire.get(this.getContext(), querySessionID.toString() + (++p + 1))) != null) {
                    p1 = page.getRowList();
                    for (int i = 0; i < p1.size() && retlist.size() < length; ++i) {
                        retlist.add(p1.get(i));
                    }
                }
                if (retlist.size() > 0) {
                    // empty if block
                }
                p1 = retlist;
                return p1;
            }
            Context context = seqTableData.getContext();
            String tableName = seqTableData.getTableName();
            StringBuffer sql = new StringBuffer(100);
            sql.append("SELECT * FROM ").append(tableName).append(" WHERE ").append("KSQL_SEQ").append(" >= ? AND ").append("KSQL_SEQ").append(" <= ? ").append("ORDER BY ").append("KSQL_SEQ").append(" ASC");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetQueryPKList's sql: \n" + sql));
            }
            Connection cn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
                    QueryRunner queryRunner = new QueryRunner(MySqlDBUtils.getdataSource());
                    cn = queryRunner.getDataSource().getConnection();
                    ps = queryRunner.prepareStatement(cn, sql.toString());
                    queryRunner.fillStatement(ps, new Object[]{start + 1, start + length});
                } else {
                    cn = QueryConnectionProvider.getConnection(context);
                    ps = cn.prepareStatement(sql.toString());
                    ps.setInt(1, start + 1);
                    ps.setInt(2, start + length);
                }
                rs = ps.executeQuery();
                int columnCount = rs.getMetaData().getColumnCount();
                if (val != null) {
                    for (int i = 0; i < columnCount; ++i) {
                        val.add(rs.getMetaData().getColumnType(i + 1));
                    }
                }
                while (rs.next()) {
                    Object[] objs = new Object[columnCount - 1];
                    for (int i = 2; i <= columnCount; ++i) {
                        objs[i - 2] = rs.getObject(i);
                    }
                    retValue.add(objs);
                }
                arrayList = retValue;
            }
            catch (Throwable e) {
                try {
                    if (e.getCause() != null && ("com.mysql.jdbc.CommunicationsException".equals(e.getCause().getClass().getName()) || "bos.org.apache.commons.dbcp.SQLNestedException".equals(e.getCause().getClass().getName()))) {
                        QueryCacheManager.getInstance().destroyObject(querySessionID);
                        throw new BOSException("mysql is down");
                    }
                    logger.error((Object)("getQueryPKListBySqlTable() sql: " + sql));
                    logger.error((Object)"getQueryPKListBySqlTable() occur error: ", e);
                    throw new BOSException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)cn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
            return arrayList;
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRowSet getRowSet(IMetaDataPK pk, BOSObjectType type, List<String> keyList, EntityViewInfo view, Map<String, EntityViewInfo> views, QueryExecuteOption option) throws BOSException {
        DynamicRowSet dynamicRowSet;
        if (keyList == null || keyList.size() == 0) {
            throw new BOSException("Parameter's value is empty,please set parameter's value");
        }
        int idListSize = this.getCriticalIDSize();
        if (idListSize != 0 && keyList.size() > idListSize) {
            throw new BOSException("Parameter's number is overstep critical value!Critical Value: " + idListSize);
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String sql = "";
        int txIsolation = -1;
        try {
            LowTimer t = new LowTimer();
            QueryManagerTools.getInstance().invokeSQLGeneratorStart();
            DynamicRowSet drs = null;
            QueryContext ctx = QueryContext.getInstance(view, views, option, 0, null);
            ctx.init(this.getContext(), null, pk, type);
            if (option == null) {
                throw new BOSException("SessionID is losted,Can't get query object and option!");
            }
            sql = this.getRuntimeSql(ctx);
            drs = ctx.getQuerySqlAccess().createRowSet(option);
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            sql = KSqlUtil.optimize((String)VirtualModeUtils.getInitializeSql(ctx.getQuerySqlAccess().query, sql, keyList.size()));
            sql = this.processSQLLockHints(sql, option.lockingHints);
            QueryManagerTools.getInstance().invokeSQLGeneratorEnd();
            if (StringUtils.isEmpty((String)sql)) {
                throw new BOSException("The sql string is empty!");
            }
            stmt = cn.prepareStatement(sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("innerGetRowSet()'s sql:\n" + sql));
            }
            LinkedHashMap<Integer, Object> parameters = new LinkedHashMap<Integer, Object>();
            VirtualModeUtils.processParameter(ctx.getQuerySqlAccess().query, keyList, parameters);
            assert (parameters.size() != 0);
            QueryManagerTools.getInstance().invokeQueryExecuteStart();
            rs = this.excuteSQL(stmt, parameters);
            int colCount = drs.getMetaData().getColumnCount();
            assert (colCount != 0);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("______ExecuteSql\t" + t.msValue()));
            }
            HashMap<String, BizEnumValueInfo> enumCache = new HashMap<String, BizEnumValueInfo>();
            HashMap<String, Boolean> enumPkCache = (HashMap<String, Boolean>)enumRsCache.get(pk.getFullName());
            boolean firstPop = false;
            if (enumPkCache == null) {
                enumPkCache = new HashMap<String, Boolean>();
                firstPop = true;
            }
            int rsetSize = 0;
            while (rs.next()) {
                drs.moveToInsertRow();
                for (int i = 1; i <= colCount; ++i) {
                    this.populateRowSetCell(pk, drs, rs, i, option, enumCache, enumPkCache);
                    if (!firstPop || i != colCount) continue;
                    enumRsCache.put(pk.getFullName(), enumPkCache);
                    firstPop = false;
                }
                drs.insertRow();
                if (idListSize == 0 || ++rsetSize <= idListSize) continue;
                try {
                    throw new FetchedTooMuchRowsException(rsetSize);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            drs.beforeFirst();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("______GetRowSet\t" + t.msValue()));
            }
            QueryManagerTools.getInstance().invokeQueryExecuteEnd();
            t.reset();
            dynamicRowSet = drs;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("getRowSet() sql: " + sql));
                logger.error((Object)"getRowSet() ocuur error: ", (Throwable)sqle);
                throw new SQLDataException("The query sql is:" + sql, (Throwable)JDBCExceptionHandler.convertException((SQLException)sqle));
                catch (SqlTranslateException e) {
                    logger.error((Object)("getRowSet() sql: " + sql));
                    logger.error((Object)"getRowSet() ocuur error: ", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"innerGetRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
    }

    @Override
    public IRowSet getRowSet(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, int start, int length) throws BOSException {
        if (length < 0) {
            throw new IllegalArgumentException("getRowSet:  length = " + length);
        }
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        return this.innerGetRowSet(ctx, querySessionID, pk, type, start, length);
    }

    public IRowSet innerGetRowSet(QueryContext ctx, Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, int start, int length) throws BOSException {
        if (length < 0) {
            throw new IllegalArgumentException("getRowSet:  length = " + length);
        }
        LowTimer lowTimer = new LowTimer();
        QueryManagerTools.getInstance().invokeQueryExecuteStart();
        ctx.init(this.getContext(), querySessionID.toString(), pk, type);
        SeqTableData seqTableData = this.getSeqTableData(ctx, querySessionID, pk, type);
        IRowSet rs = this.getRowSetBySeqTable(ctx, pk, querySessionID, seqTableData, start, length);
        QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getRowSet() query: " + pk + "    " + lowTimer.msValue()));
        }
        return rs;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet getRowSetBySeqTable(QueryContext ctx, IMetaDataPK pk, Uuid querySessionID, SeqTableData seqTableData, int start, int length) throws BOSException {
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "getRowSetBySeqTable", null);
        }
        cn = null;
        stmt = null;
        rs = null;
        runtimeSql = null;
        queryUuidSqlMap = (SqlAndParam)VirtualModeDataAccess.sqlcache.get(querySessionID.toString());
        sql = "";
        if (queryUuidSqlMap != null && queryUuidSqlMap.getSql("runtimesql") != null) {
            runtimeSql = queryUuidSqlMap.getSql("runtimesql");
        }
        txIsolation = -1;
        try {
            block49: {
                block50: {
                    block48: {
                        if (start < 0) {
                            throw new IllegalArgumentException("getRowSet: start = " + start);
                        }
                        if (length < 0) {
                            throw new IllegalArgumentException("getRowSet: length = " + length);
                        }
                        qsa = ctx.getQuerySqlAccess();
                        if (length > this.getMaxRequestCount()) {
                            VirtualModeDataAccess.logger.error((Object)("getRowSetBySeqTable():   length=" + length + " ,  query: " + qsa.query.getFullName()));
                            ctx.getOption().pageCount = length = this.getMaxRequestCount();
                        }
                        t = new LowTimer();
                        drs = null;
                        if (qsa.query == null || ctx.getOption() == null) break block48;
                        if (runtimeSql == null) {
                            runtimeSql = this.getRuntimeSql(ctx);
                        } else {
                            qsa.select.setTop(ctx.getTop());
                            qsa.order.setIgnoreOrder(ctx.getOption().isIgnoreOrder);
                            qsa.select.setDistinct(ctx.getOption().isAutoIgnoreDuplicatedRow);
                            qsa.select.setAddOrder2Selector(ctx.isAddOrder2Selector());
                            qsa.state.set(seqTableData.getView(), seqTableData.getViews());
                        }
                        drs = qsa.createRowSet(ctx.getOption());
                        bizSelectParser = new SelectParser(runtimeSql);
                        bizSqlSelect = (SqlSelect)bizSelectParser.select();
                        option = ctx.getOption();
                        if (!option.isUseDbPage) break block49;
                        break block50;
                    }
                    throw new BOSException("SessionID is losted,Can't get query object and option!");
                }
                bizSqlSelect.limit = bizSelectLimit = new SqlSelectLimit(length, 0, start);
                selectBuffer = new StringBuffer();
                formater = new QuerySQLFormater(selectBuffer);
                formater.formatSelectBase((SqlSelectBase)bizSqlSelect);
                if (ctx.getOption().optimizeMode == 1) {
                    KSqlTools.optimize((int)1, (SqlSelectBase)bizSqlSelect);
                } else {
                    KSqlTools.optimize((int)2, (SqlSelectBase)bizSqlSelect);
                }
                realSql = selectBuffer.toString();
                cn = QueryConnectionProvider.getConnection(this.getContext());
                if (ctx.getOption().transactionIsolation != -1 && ctx.getOption().transactionIsolation != cn.getTransactionIsolation()) {
                    txIsolation = cn.getTransactionIsolation();
                    cn.setTransactionIsolation(ctx.getOption().transactionIsolation);
                }
                stmt = VirtualModeDataAccess.prepareStatement(cn, realSql);
                stmt.setFetchSize(100);
                rs = this.excuteSQL(stmt, queryUuidSqlMap.getParams());
                ** GOTO lbl154
            }
            keyList = this.getQueryPKListBySqlTable(querySessionID, seqTableData, null, ctx.getOption(), start, length);
            if (keyList == null || keyList.size() == 0) {
                selectBuffer = drs;
            }
            ** GOTO lbl-1000
        }
        catch (SQLException sqle) {
            try {
                VirtualModeDataAccess.logger.error((Object)("getRowSetBySeqTable() query: " + ctx.getQuerySqlAccess().query.getFullName()));
                VirtualModeDataAccess.logger.error((Object)("getRowSetBySeqTable() sql: " + sql));
                VirtualModeDataAccess.logger.error((Object)"getRowSetBySeqTable() occur error:", (Throwable)sqle);
                throw new SQLDataException(sqle.getMessage() + ". The query sql is:" + sql, (Throwable)JDBCExceptionHandler.convertException((SQLException)sqle));
                catch (SqlTranslateException sqlTranslateException) {
                    VirtualModeDataAccess.logger.error((Object)("getRowSetBySeqTable() query: " + ctx.getQuerySqlAccess().query.getFullName()));
                    VirtualModeDataAccess.logger.error((Object)("getRowSetBySeqTable() sql: " + sql));
                    VirtualModeDataAccess.logger.error((Object)"getRowSetBySeqTable() occur error:", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable var32_52) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    VirtualModeDataAccess.logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw var32_52;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            VirtualModeDataAccess.logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup(rs, stmt, (Connection)cn);
        return selectBuffer;
lbl-1000:
        // 1 sources

        {
            keyVec = qsa.query.getQueryPK().getKeyPropertys();
            nullbf = new StringBuffer("@");
            m = keyVec.size();
            for (i = 0; i < m; ++i) {
                existNull = false;
                n = keyList.size();
                for (j = 0; j < n; ++j) {
                    pkValues = keyList.get(j);
                    if (pkValues[i] != null) continue;
                    existNull = true;
                    break;
                }
                if (existNull) {
                    nullbf.append(1);
                    continue;
                }
                nullbf.append(0);
            }
            optimizesql = "optimizesql@" + String.valueOf(length) + nullbf.toString();
            if (keyList.size() == length && queryUuidSqlMap != null && queryUuidSqlMap.getSql(optimizesql) != null) {
                sql = queryUuidSqlMap.getSql(optimizesql);
            }
            if ("".equals(sql) || sql == null) {
                VirtualModeUtils.getSQLWithLogicPK(qsa.query, keyList, (SqlSelectBase)bizSqlSelect, ctx.getOption());
                if (ctx.getOption().optimizeMode == 1) {
                    KSqlTools.optimize((int)1, (SqlSelectBase)bizSqlSelect);
                } else {
                    KSqlTools.optimize((int)2, (SqlSelectBase)bizSqlSelect);
                }
                if (bizSqlSelect.distinct != 0 && bizSqlSelect.orderBy != null && bizSqlSelect.orderBy.size() > 0) {
                    orderSelectItems = new ArrayList<SqlSelectItem>();
                    size = bizSqlSelect.orderBy.size();
                    for (i = 0; i < size; ++i) {
                        sqlOrderByItem = (SqlOrderByItem)bizSqlSelect.orderBy.get(i);
                        exist = false;
                        size1 = bizSqlSelect.selectList.size();
                        for (j = 0; j < size1; ++j) {
                            sqlSelectItem = (SqlSelectItem)bizSqlSelect.selectList.get(j);
                            if (!sqlSelectItem.expr.toString().equals(sqlOrderByItem.expr.toString())) continue;
                            exist = true;
                            break;
                        }
                        if (exist) continue;
                        sqlSelectItem = new SqlSelectItem(sqlOrderByItem.expr, QueryHelper.addMark(new UUTN().toString()));
                        orderSelectItems.add(sqlSelectItem);
                    }
                    if (orderSelectItems.size() > 0) {
                        bizSqlSelect = SQLTranslateUtil.translateTopAndDistinctSQL(bizSqlSelect);
                    }
                }
                sqlBuffer = new StringBuffer();
                formater = new QuerySQLFormater(sqlBuffer);
                formater.formatSelectBase((SqlSelectBase)bizSqlSelect);
                sql = sqlBuffer.toString();
                sql = this.processSQLLockHints(sql, ctx.getOption().lockingHints);
                if (queryUuidSqlMap != null && queryUuidSqlMap.getSql(optimizesql) == null) {
                    queryUuidSqlMap.putSql(optimizesql, sql);
                    VirtualModeDataAccess.sqlcache.put(querySessionID.toString(), (Object)queryUuidSqlMap);
                }
                if (VirtualModeDataAccess.logger.isDebugEnabled()) {
                    VirtualModeDataAccess.logger.debug((Object)("getRowSetBySeqTable()'s sql:\n" + sql));
                }
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (ctx.getOption().transactionIsolation != -1 && ctx.getOption().transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(ctx.getOption().transactionIsolation);
            }
            stmt = cn.prepareStatement(sql);
            rs = this.excuteSQL(stmt, VirtualModeUtils.processLogicPKParameter(qsa.query, keyList, ctx.getOption()));
lbl154:
            // 2 sources

            rowCount = 0;
            colCount = drs.getMetaData().getColumnCount();
            if (!VirtualModeDataAccess.$assertionsDisabled && colCount == 0) {
                throw new AssertionError();
            }
            idListSize = this.getCriticalIDSize();
            enumCache = new HashMap<String, BizEnumValueInfo>();
            enumPkCache = (HashMap<String, Boolean>)VirtualModeDataAccess.enumRsCache.get(pk.getFullName());
            firstPop = false;
            if (enumPkCache == null) {
                enumPkCache = new HashMap<String, Boolean>();
                firstPop = true;
            }
            while (rs.next()) {
                drs.moveToInsertRow();
                for (i = 1; i <= colCount; ++i) {
                    this.populateRowSetCell(pk, drs, rs, i, ctx.getOption(), enumCache, enumPkCache);
                    if (!firstPop || i != colCount) continue;
                    VirtualModeDataAccess.enumRsCache.put(pk.getFullName(), enumPkCache);
                    firstPop = false;
                }
                drs.insertRow();
                if (++rowCount > this.getMaxRequestCount()) {
                    VirtualModeDataAccess.logger.error((Object)("DynamicRowSet->insertRow():   rowCount>" + this.getMaxRequestCount() + " ,  query: " + qsa.query.getFullName()));
                }
                if (idListSize == 0 || rowCount <= idListSize) continue;
                try {
                    throw new FetchedTooMuchRowsException(rowCount);
                }
                catch (SQLException sqle) {
                    VirtualModeDataAccess.logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            drs.beforeFirst();
            if (VirtualModeDataAccess.logger.isDebugEnabled()) {
                VirtualModeDataAccess.logger.debug((Object)("_________execQDA\t" + t.msValue()));
            }
            t.reset();
            var26_42 = drs;
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            VirtualModeDataAccess.logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return var26_42;
    }

    @Override
    public void closeQuery(Uuid queryID) {
        String sessionID = null;
        IServerSession serverSession = ServerSessionContainer.getCurrentSession();
        if (serverSession != null) {
            sessionID = (String)serverSession.get((Object)"bos_sessionid");
        }
        CloseQueryUtil.closeQuery(queryID, sessionID, this.getContext().getCaller() == null ? null : this.getContext().getCaller().toString());
    }

    @Override
    public int getRowCount(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option) throws BOSException {
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        SeqTableData seqTableData = this.getSeqTableData(ctx, querySessionID, pk, type);
        int rs = seqTableData.getRowCount();
        if (rs < 0) {
            QueryManagerTools.getInstance().invokeQueryExecuteStart();
            rs = this.getRowCountBySqlTable(seqTableData);
            QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        }
        return rs;
    }

    @Override
    public int getRowCount(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String[] countFields) throws BOSException {
        QueryManagerTools.getInstance().invokeQueryExecuteStart();
        QueryContext ctx = QueryContext.getInstance(view, views, option, 0, parameters);
        this.getSeqTableData(ctx, querySessionID, pk, type);
        int rs = this.getRowCountByFields(querySessionID, countFields);
        QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        return rs;
    }

    private int getRowCountBySqlTable(SeqTableData seqTableData) throws BOSException {
        int queryRunner2;
        String sql;
        ResultSet rs;
        PreparedStatement ps;
        Connection cn;
        block10: {
            Context context = seqTableData.getContext();
            String tableName = seqTableData.getTableName();
            StringBuffer sqlbf = new StringBuffer(100);
            if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
                sqlbf.append("SELECT ").append("KSQL_SEQ").append(" FROM ").append(tableName).append(" ORDER BY ").append("KSQL_SEQ").append(" DESC LIMIT 1");
            } else {
                sqlbf.append("SELECT TOP 1 ").append("KSQL_SEQ").append(" FROM ").append(tableName).append(" ORDER BY ").append("KSQL_SEQ").append(" DESC");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRowCountBySqlTable's sql: \n" + sqlbf));
            }
            cn = null;
            ps = null;
            rs = null;
            sql = sqlbf.toString();
            if (SeqTableManager.getInstance().isSeqTabInMysql()) {
                QueryRunner queryRunner2 = new QueryRunner(MySqlDBUtils.getdataSource());
                cn = queryRunner2.getDataSource().getConnection();
                ps = queryRunner2.prepareStatement(cn, sql.toString());
                queryRunner2.fillStatement(ps, null);
            } else {
                cn = QueryConnectionProvider.getConnection(context);
                ps = BaseDataAccess.prepareStatement(cn, sql.toString());
            }
            rs = ps.executeQuery();
            if (!rs.next()) break block10;
            int queryRunner2 = rs.getInt("KSQL_SEQ");
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
            return queryRunner2;
        }
        try {
            queryRunner2 = 0;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("getRowCountBySqlTable() sql: " + sql));
                logger.error((Object)"getRowCountBySqlTable() occur error: ", (Throwable)e);
                throw new BOSException((Throwable)JDBCExceptionHandler.convertException((SQLException)e));
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return queryRunner2;
    }

    public int getRowCountByFields(Uuid querySessionID, String[] fields, QueryExecuteOption option) throws BOSException {
        int queryRunner2;
        String sql;
        ResultSet rs;
        PreparedStatement ps;
        Connection cn;
        String tableName;
        block10: {
            SeqTableData seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(querySessionID);
            if (seqTableData == null) {
                return -1;
            }
            if (SeqTableManager.getInstance().isSeqTabInDiskCache() || option.isUseDbPage) {
                return this.getRowCountByFieldsAndSQL(querySessionID, seqTableData, fields);
            }
            tableName = seqTableData.getTableName();
            cn = null;
            ps = null;
            rs = null;
            sql = "select KSQL_COL_NAME from KSQL_USERCOLUMNS where KSQL_COL_TABNAME=?";
            sql = null;
            sql = fields != null && fields.length > 0 ? this._buildGetRowCountByFieldSQL(tableName, fields) : (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0 ? new StringBuffer().append("SELECT   ").append("KSQL_SEQ").append(" FROM ").append(tableName).append(" ORDER BY ").append("KSQL_SEQ").append(" DESC LIMIT 1").toString() : new StringBuffer().append("SELECT TOP 1 ").append("KSQL_SEQ").append(" FROM ").append(tableName).append(" ORDER BY ").append("KSQL_SEQ").append(" DESC").toString());
            if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
                QueryRunner queryRunner2 = new QueryRunner(MySqlDBUtils.getdataSource());
                cn = queryRunner2.getDataSource().getConnection();
                ps = queryRunner2.prepareStatement(cn, sql);
                queryRunner2.fillStatement(ps, null);
            } else {
                cn = QueryConnectionProvider.getConnection(this.getContext());
                ps = BaseDataAccess.prepareStatement(cn, sql);
            }
            rs = ps.executeQuery();
            if (!rs.next()) break block10;
            int queryRunner2 = rs.getInt(_TEMP_FIELDNAME);
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
            return queryRunner2;
        }
        try {
            queryRunner2 = 0;
        }
        catch (Exception e) {
            try {
                if (e.getCause() != null && ("com.mysql.jdbc.CommunicationsException".equals(e.getCause().getClass().getName()) || "bos.org.apache.commons.dbcp.SQLNestedException".equals(e.getCause().getClass().getName()))) {
                    QueryCacheManager.getInstance().destroyObject(querySessionID);
                    throw new BOSException("mysql is down");
                }
                logger.error((Object)("getRowCountByField() sql: " + sql + " ; tableName=" + tableName), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return queryRunner2;
    }

    @Override
    public int getRowCountByFields(Uuid querySessionID, String[] fields) throws BOSException {
        return this.getRowCountByFields(querySessionID, fields, null);
    }

    private int getRowCountByFieldsAndSQL(Uuid querySessionID, SeqTableData seqTableData, String[] fields) throws BOSException {
        int n;
        ResultSet rs;
        PreparedStatement ps;
        Connection cn;
        block16: {
            SqlAndParam sqlMap = (SqlAndParam)sqlcache.get(querySessionID.toString());
            String sql = null;
            if (sqlMap != null) {
                sql = sqlMap.getKeySQL();
            }
            if (StringUtils.isEmpty(sql)) {
                return seqTableData.getBillCount();
            }
            String keyFieldName = null;
            if (fields != null && fields.length > 0) {
                keyFieldName = fields[0];
            }
            try {
                SqlSelect countSqlSelect = (SqlSelect)new SelectParser(sql).select();
                countSqlSelect.selectList.clear();
                countSqlSelect.orderBy.clear();
                countSqlSelect.distinct = 1;
                Collection<LogicPKItem> valueLogicPKItems = seqTableData.getLogicPKInfo().values();
                for (LogicPKItem item : valueLogicPKItems) {
                    if (!keyFieldName.equals(item.fieldName)) continue;
                    countSqlSelect.selectList.add(item.selectItem);
                }
                StringBuffer sb = new StringBuffer();
                QuerySQLFormater formater = new QuerySQLFormater(sb);
                formater.formatSelectBase((SqlSelectBase)countSqlSelect);
                sql = "SELECT COUNT(*) AS COUNT FROM (" + sb.toString() + ") TMP_BILLCOUNT_ALIAS";
            }
            catch (Exception e) {
                logger.error((Object)"buildKeyCountSQL() occur error: ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            cn = null;
            ps = null;
            rs = null;
            cn = QueryConnectionProvider.getConnection(this.getContext());
            Map<Integer, Object> params = sqlMap.getParams();
            ps = BaseDataAccess.prepareStatement(cn, sql);
            if (params != null) {
                for (Integer keyValue : params.keySet()) {
                    if (keyValue == null) continue;
                    int index = keyValue;
                    Object[] val = (Object[])params.get(keyValue);
                    if (val[0].equals(SQLType.VARCHAR) || val[0].equals(SQLType.CHAR)) {
                        ps.setString(index, val[1].toString());
                        continue;
                    }
                    if (val[0].equals(SQLType.INT)) {
                        if (val[1] instanceof Integer) {
                            ps.setInt(index, (Integer)val[1]);
                            continue;
                        }
                        ps.setInt(index, Integer.parseInt(val[1].toString()));
                        continue;
                    }
                    ps.setObject(index, val[1]);
                }
            }
            if (!(rs = ps.executeQuery()).next()) break block16;
            int n2 = rs.getInt(1);
            SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"getRowCountByFieldsBySQL", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return n;
    }

    @Override
    public List<Object> getBillIDList(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo entityViewInfo, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String idFieldName, int start, int length) throws BOSException {
        if (StringUtils.isEmpty((String)idFieldName)) {
            throw new BOSException("idFieldName cannto be null");
        }
        ArrayList<Object> idList = new ArrayList<Object>(length);
        SeqTableData seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(querySessionID);
        idFieldName = AbstractSeqTableAcuquire.getColumnName(idFieldName);
        if (seqTableData == null) {
            logger.warn((Object)"query not open or querySessionID is invaild while getBillIDList,open a new querySession");
            QueryContext ctx = QueryContext.getInstance(entityViewInfo, views, option, 0, parameters);
            Uuid sessionID = this.innerOpenQuery(ctx, null, pk, type);
            seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(sessionID);
        }
        if (SeqTableManager.getInstance().isSeqTabInDiskCache()) {
            return SeqTableDiskCacheAcuquire.getBillIDList(this.getContext(), seqTableData, start, length);
        }
        String tableName = seqTableData.getTableName();
        Context context = seqTableData.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer buffer = new StringBuffer();
        int end = -1;
        if (start < 0) {
            start = 0;
        }
        if (length > 0) {
            end = start + length;
        }
        buffer.append("SELECT ");
        if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
            buffer.append(idFieldName).append(" FROM (SELECT ").append(idFieldName.toUpperCase()).append(", MIN(").append("KSQL_SEQ").append(") IX ").append(" FROM ").append(tableName).append(" GROUP BY ").append(idFieldName).append(" ORDER BY IX LIMIT ").append(end).append(") AS TEMP");
            if (end != -1) {
                buffer.append(" LIMIT ").append(end).append(" ");
            }
        } else {
            if (end != -1) {
                buffer.append("TOP ").append(end).append(" ");
            }
            buffer.append(idFieldName).append(" FROM (SELECT TOP ").append(end).append(" ").append(idFieldName.toUpperCase()).append(", MIN(").append("KSQL_SEQ").append(") IX ").append(" FROM ").append(tableName).append(" GROUP BY ").append(idFieldName).append(" ORDER BY IX ) AS TEMP");
        }
        try {
            QueryManagerTools.getInstance().invokeQueryExecuteStart();
            if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
                QueryRunner queryRunner = new QueryRunner(MySqlDBUtils.getdataSource());
                cn = queryRunner.getDataSource().getConnection();
                ps = queryRunner.prepareStatement(cn, buffer.toString());
                queryRunner.fillStatement(ps, null);
            } else {
                cn = QueryConnectionProvider.getConnection(context);
                ps = cn.prepareStatement(buffer.toString());
            }
            rs = ps.executeQuery();
            int i = 0;
            while (rs.next()) {
                if (i >= start) {
                    idList.add(rs.getObject(1));
                }
                ++i;
            }
            QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        }
        catch (Throwable e) {
            try {
                if (e.getCause() != null && ("com.mysql.jdbc.CommunicationsException".equals(e.getCause().getClass().getName()) || "bos.org.apache.commons.dbcp.SQLNestedException".equals(e.getCause().getClass().getName()))) {
                    SeqTableManager.getInstance().setMysql(false);
                    QueryCacheManager.getInstance().destroyObject(querySessionID);
                    throw new BOSException("mysql is down");
                }
                logger.error((Object)("getBillIDList error () sql: " + buffer.toString() + " ; tableName=" + tableName), e);
                throw new BOSException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return idList;
    }

    @Override
    public int indexOfBillID(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo entityViewInfo, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String idFieldName, BOSUuid billid) throws BOSException {
        if (querySessionID == null) {
            return -1;
        }
        if (StringUtils.isEmpty((String)idFieldName)) {
            throw new BOSException("idFieldName cannto be null");
        }
        idFieldName = AbstractSeqTableAcuquire.getColumnName(idFieldName);
        int index = -1;
        SeqTableData seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(querySessionID);
        if (seqTableData == null) {
            logger.warn((Object)"query not open or querySessionID is invaild while indexOfBillID,open a new querySession");
            QueryContext ctx = QueryContext.getInstance(entityViewInfo, views, option, 0, parameters);
            Uuid sessionID = this.innerOpenQuery(ctx, null, pk, type);
            seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(sessionID);
        }
        if (option.isUseDbPage) {
            if (entityViewInfo == null || entityViewInfo.get("INDEX_OF_LISTUI") == null) {
                // empty if block
            }
            return -1;
        }
        if (SeqTableManager.getInstance().isSeqTabInDiskCache()) {
            if (entityViewInfo == null || entityViewInfo.get("INDEX_OF_LISTUI") == null) {
                return SeqTableDiskCacheAcuquire.indexOfBillId(this.getContext(), seqTableData, billid.toString(), true);
            }
            return SeqTableDiskCacheAcuquire.indexOfBillId(this.getContext(), seqTableData, billid.toString(), false);
        }
        String tableName = seqTableData.getTableName();
        Context context = seqTableData.getContext();
        Connection cn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        StringBuffer buffer = new StringBuffer();
        if (entityViewInfo == null || entityViewInfo.get("INDEX_OF_LISTUI") == null) {
            buffer.append("SELECT COUNT(*) FROM (SELECT DISTINCT ").append(idFieldName).append(" FROM ").append(tableName).append(" WHERE ").append("KSQL_SEQ").append(" <=(SELECT MIN(").append("KSQL_SEQ").append(") FROM ").append(tableName).append(" WHERE ").append(idFieldName).append(" = '").append(billid).append("' GROUP BY ").append(idFieldName).append(" )) AS BillIDTemp");
        } else if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
            buffer.append("SELECT ").append("KSQL_SEQ").append(" FROM ").append(tableName).append(" WHERE ").append(idFieldName).append(" = '").append(billid.toString()).append("' limit 1 ");
        } else {
            buffer.append("SELECT TOP 1 ").append("KSQL_SEQ").append(" FROM ").append(tableName).append(" WHERE ").append(idFieldName).append(" = '").append(billid.toString()).append("' ");
        }
        try {
            QueryManagerTools.getInstance().invokeQueryExecuteStart();
            if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
                QueryRunner queryRunner = new QueryRunner(MySqlDBUtils.getdataSource());
                cn = queryRunner.getDataSource().getConnection();
                ps = queryRunner.prepareStatement(cn, buffer.toString());
                queryRunner.fillStatement(ps, null);
            } else {
                cn = QueryConnectionProvider.getConnection(context);
                ps = BaseDataAccess.prepareStatement(cn, buffer.toString());
            }
            rs = ps.executeQuery();
            if (rs.next()) {
                index = rs.getInt(1) - 1;
            }
            QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        }
        catch (Exception e) {
            try {
                if (e.getCause() != null && ("com.mysql.jdbc.CommunicationsException".equals(e.getCause().getClass().getName()) || "bos.org.apache.commons.dbcp.SQLNestedException".equals(e.getCause().getClass().getName()))) {
                    SeqTableManager.getInstance().setMysql(false);
                    QueryCacheManager.getInstance().destroyObject(querySessionID);
                    throw new BOSException("mysql is down");
                }
                logger.error((Object)("indexOfBillID error () sql: " + buffer.toString() + " ; tableName=" + tableName), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)cn);
        return index;
    }

    @Override
    public void removeBillID(Uuid querySessionID, IMetaDataPK pk, BOSObjectType type, EntityViewInfo entityViewInfo, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String idFieldName, BOSUuid billid) throws BOSException {
        if (StringUtils.isEmpty((String)idFieldName)) {
            throw new BOSException("idFieldName cannto be null");
        }
        idFieldName = AbstractSeqTableAcuquire.getColumnName(idFieldName);
        QueryContext ctx = QueryContext.getInstance(entityViewInfo, views, option, 0, parameters);
        SeqTableData seqTableData = this.getSeqTableData(ctx, querySessionID, pk, type);
        String tableName = seqTableData.getTableName();
        Context context = seqTableData.getContext();
        Connection cn = null;
        Statement statment = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("DELETE FROM ").append(tableName).append(" WHERE ").append(idFieldName).append(" = '").append(billid).append("'");
        try {
            QueryManagerTools.getInstance().invokeQueryExecuteStart();
            if (SeqTableManager.getInstance().isSeqTabInMysql() && seqTableData.getRowCount() >= 0) {
                QueryRunner queryRunner = new QueryRunner(MySqlDBUtils.getdataSource());
                cn = queryRunner.getDataSource().getConnection();
                queryRunner.update(cn, buffer.toString());
            } else if (SeqTableManager.getInstance().isSeqTabInDiskCache()) {
                SeqTableDiskCacheAcuquire.removeBillId(this.getContext(), seqTableData, billid.toString());
            } else {
                cn = QueryConnectionProvider.getConnection(context);
                statment = cn.createStatement();
                statment.executeUpdate(buffer.toString());
            }
            QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        }
        catch (Exception e) {
            try {
                if (e.getCause() != null && ("com.mysql.jdbc.CommunicationsException".equals(e.getCause().getClass().getName()) || "bos.org.apache.commons.dbcp.SQLNestedException".equals(e.getCause().getClass().getName()))) {
                    SeqTableManager.getInstance().setMysql(false);
                    QueryCacheManager.getInstance().destroyObject(querySessionID);
                    throw new BOSException("mysql is down");
                }
                logger.error((Object)("removeBillID error () sql: " + buffer.toString() + " ; tableName=" + tableName), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statment, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statment, (Connection)cn);
    }

    private String _buildGetRowCountByFieldSQL(String tableName, String[] fields) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT COUNT(*) AS ").append(_TEMP_FIELDNAME).append(" FROM (SELECT DISTINCT ");
        StringBuffer _temp = new StringBuffer();
        for (int i = 0; i < fields.length; ++i) {
            _temp.append(AbstractSeqTableAcuquire.getColumnName(fields[i]));
            if (i == fields.length - 1) continue;
            _temp.append(", ");
        }
        buffer.append(_temp).append(" FROM ").append(tableName).append(" GROUP BY ").append(_temp).append(") AS TEMP");
        return buffer.toString();
    }

    @Override
    public Map<String, Object> doAllQueryTask(Uuid uuid, int start, int length, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String[] fields, boolean isFirstTime) throws BOSException {
        return this.doAllQueryTask(uuid, start, length, pk, type, view, views, parameters, option, fields, isFirstTime, null);
    }

    @Override
    public Map<String, Object> doAllQueryTask(Uuid uuid, int start, int length, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, String[] fields, boolean isFirstTime, String keyFieldName) throws BOSException {
        QueryContext ctx;
        if (uuid != null) {
            this.closeQuery(uuid);
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(6);
        Uuid newUuid = null;
        if (view != null && views != null && views.size() != 0) {
            throw new BOSException("Can't set views and view at one time!");
        }
        if (views != null && views.size() != 0) {
            ctx = QueryContext.getInstance(null, views, option, 0, parameters);
        } else {
            if (view == null) {
                view = new EntityViewInfo();
            }
            ctx = QueryContext.getInstance(view, null, option, 0, parameters);
        }
        newUuid = this.innerOpenQuery(ctx, null, pk, MetaDataTypeList.BASEQUERY, length, keyFieldName);
        retMap.put("uuid", newUuid);
        ctx.setParameters(parameters);
        IRowSet rowSet = this.innerGetRowSet(ctx, newUuid, pk, MetaDataTypeList.BASEQUERY, start, length);
        retMap.put("rowSet", rowSet);
        SeqTableData seqTableData = (SeqTableData)QueryCacheManager.getInstance().getObject(newUuid);
        int rowCount = -1;
        if (seqTableData != null) {
            rowCount = seqTableData.getRowCount();
        }
        if (rowCount < 0) {
            QueryManagerTools.getInstance().invokeQueryExecuteStart();
            rowCount = this.getRowCountBySqlTable(seqTableData);
            QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        }
        retMap.put("rowCount", rowCount);
        if (!option.isIgnoreBillCount && newUuid != null && fields != null) {
            int billCount = this.getRowCountByFields(newUuid, fields, option);
            retMap.put("billCount", billCount);
        }
        retMap.put("getRealRowCount", this.isGetRealRowCount());
        return retMap;
    }

    @Override
    public List<Object[]> getQueryPKList(Uuid querySessionID, String sql, List<String> pkField, QueryExecuteOption option, int start, int length) throws BOSException {
        if (length < 0) {
            throw new IllegalArgumentException("getQueryPKList:  = " + length);
        }
        QueryManagerTools.getInstance().invokeQueryExecuteStart();
        SeqTableData seqTableData = this.getSeqTableData(querySessionID, sql, pkField, option);
        List<Object[]> rs = this.getQueryPKListBySqlTable(querySessionID, seqTableData, null, option, start, length);
        QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        return rs;
    }

    @Override
    public IRowSet getRowSet(Uuid querySessionID, String sql, List<String> pkField, QueryExecuteOption option, int start, int length) throws BOSException {
        if (length < 0) {
            throw new IllegalArgumentException("getQueryPKList:  = " + length);
        }
        LowTimer lowTimer = new LowTimer();
        QueryManagerTools.getInstance().invokeQueryExecuteStart();
        SeqTableData seqTableData = this.getSeqTableData(querySessionID, sql, pkField, option);
        IRowSet rs = this.getRowSetBySeqTable(querySessionID, sql, pkField, seqTableData, option, start, length);
        QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getRowSet() sql: " + sql + "    " + lowTimer.msValue()));
        }
        return rs;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IRowSet getRowSetBySeqTable(Uuid querySessionID, String sql, List<String> pkField, SeqTableData seqTableData, QueryExecuteOption option, int start, int length) throws BOSException {
        DynamicRowSet dynamicRowSet;
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "getRowSetBySeqTable", null);
        }
        Connection cn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        int txIsolation = -1;
        try {
            if (start < 0) {
                throw new IllegalArgumentException("getRowSet: start = " + start);
            }
            if (length < 0) {
                throw new IllegalArgumentException("getRowSet: length = " + length);
            }
            if (length > this.getMaxRequestCount()) {
                logger.error((Object)("getRowSetBySeqTable():   length=" + length + " ,  sql: " + sql));
                option.pageCount = length = this.getMaxRequestCount();
            }
            LowTimer t = new LowTimer();
            SelectParser bizSelectParser = new SelectParser(sql);
            SqlSelect bizSqlSelect = (SqlSelect)bizSelectParser.select();
            ArrayList<Integer> val = new ArrayList<Integer>();
            List<Object[]> keyList = this.getQueryPKListBySqlTable(querySessionID, seqTableData, val, option, start, length);
            this.getSQLWithLogicPK(pkField, keyList, (SqlSelectBase)bizSqlSelect, option);
            if (option.optimizeMode == 1) {
                KSqlTools.optimize((int)1, (SqlSelectBase)bizSqlSelect);
            } else {
                KSqlTools.optimize((int)2, (SqlSelectBase)bizSqlSelect);
            }
            if (bizSqlSelect.distinct != 0 && bizSqlSelect.orderBy != null && bizSqlSelect.orderBy.size() > 0) {
                ArrayList<SqlSelectItem> orderSelectItems = new ArrayList<SqlSelectItem>();
                int size = bizSqlSelect.orderBy.size();
                for (int i = 0; i < size; ++i) {
                    SqlOrderByItem sqlOrderByItem = (SqlOrderByItem)bizSqlSelect.orderBy.get(i);
                    boolean exist = false;
                    int size1 = bizSqlSelect.selectList.size();
                    for (int j = 0; j < size1; ++j) {
                        SqlSelectItem sqlSelectItem = (SqlSelectItem)bizSqlSelect.selectList.get(j);
                        if (!sqlSelectItem.expr.toString().equals(sqlOrderByItem.expr.toString())) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                    SqlSelectItem sqlSelectItem = new SqlSelectItem(sqlOrderByItem.expr, QueryHelper.addMark(new UUTN().toString()));
                    orderSelectItems.add(sqlSelectItem);
                }
                if (orderSelectItems.size() > 0) {
                    bizSqlSelect = SQLTranslateUtil.translateTopAndDistinctSQL(bizSqlSelect);
                }
            }
            StringBuffer sqlBuffer = new StringBuffer();
            QuerySQLFormater formater = new QuerySQLFormater(sqlBuffer);
            formater.formatSelectBase((SqlSelectBase)bizSqlSelect);
            sql = sqlBuffer.toString();
            sql = this.processSQLLockHints(sql, option.lockingHints);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getRowSetBySeqTable()'s sql:\n" + sql));
            }
            cn = QueryConnectionProvider.getConnection(this.getContext());
            if (option.transactionIsolation != -1 && option.transactionIsolation != cn.getTransactionIsolation()) {
                txIsolation = cn.getTransactionIsolation();
                cn.setTransactionIsolation(option.transactionIsolation);
            }
            stmt = cn.prepareStatement(sql);
            HashMap<Integer, Object> paramMap = new HashMap<Integer, Object>(1);
            this.processLogicPKParameter(pkField, keyList, val, paramMap, option);
            assert (paramMap.size() != 0);
            rs = this.excuteSQL(stmt, paramMap);
            DynamicRowSet drs = this.createRowSet(rs);
            int rowCount = 0;
            int colCount = drs.getMetaData().getColumnCount();
            assert (colCount != 0);
            int idListSize = this.getCriticalIDSize();
            while (rs.next()) {
                drs.moveToInsertRow();
                for (int i = 1; i <= colCount; ++i) {
                    this.populateRowSetCell(drs, rs, i);
                }
                drs.insertRow();
                if (++rowCount > this.getMaxRequestCount()) {
                    logger.error((Object)("DynamicRowSet->insertRow():   rowCount>" + this.getMaxRequestCount() + " ,  sql: " + sql));
                }
                if (idListSize == 0 || rowCount <= idListSize) continue;
                try {
                    throw new FetchedTooMuchRowsException(rowCount);
                }
                catch (SQLException sqle) {
                    logger.warn((Object)sqle.getMessage(), (Throwable)sqle);
                    throw sqle;
                }
            }
            drs.beforeFirst();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("_____execQDA\t" + t.msValue()));
            }
            t.reset();
            dynamicRowSet = drs;
        }
        catch (SQLException sqle) {
            try {
                logger.error((Object)("getRowSetBySeqTable() sql: " + sql));
                logger.error((Object)"getRowSetBySeqTable() occur error:", (Throwable)sqle);
                throw new SQLDataException(sqle.getMessage() + ". The query sql is:" + sql, (Throwable)JDBCExceptionHandler.convertException((SQLException)sqle));
                catch (SqlTranslateException sqlTranslateException) {
                    logger.error((Object)("getRowSetBySeqTable() sql: " + sql));
                    logger.error((Object)"getRowSetBySeqTable() occur error:", (Throwable)sqlTranslateException);
                    throw new BOSException((Throwable)sqlTranslateException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                        cn.setTransactionIsolation(txIsolation);
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
                }
                SQLUtils.cleanup(rs, stmt, cn);
                throw throwable;
            }
        }
        try {
            if (cn != null && txIsolation != -1 && txIsolation != cn.getTransactionIsolation()) {
                cn.setTransactionIsolation(txIsolation);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getRowSet()' finally ocuur error: ", (Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)cn);
        return dynamicRowSet;
    }

    private void getSQLWithLogicPK(List<String> pkField, List<Object[]> logicPKs, SqlSelectBase selectBase, QueryExecuteOption option) throws BOSException {
        if (ProfileConfig.getInstance().logQuery) {
            ThreadProfileContext.getInstance().enter(this.getClass().getName(), "getSQLWithLogicPK", null);
        }
        SqlSelect sqlSelect = null;
        try {
            if (selectBase instanceof SqlSelect) {
                SqlExpr expr;
                sqlSelect = (SqlSelect)selectBase;
                sqlSelect.condition = null;
                SqlExprParser exprParser = new SqlExprParser(this.buildLogicPKCondition(pkField, logicPKs, option));
                sqlSelect.condition = expr = exprParser.expr();
            }
        }
        catch (ParserException parseException) {
            logger.error((Object)"getSQLWithLogicPK() occur error: ", (Throwable)parseException);
            throw new BOSException((Throwable)parseException);
        }
        finally {
            if (ProfileConfig.getInstance().logQuery) {
                ThreadProfileContext.getInstance().exit();
            }
        }
    }

    private String buildLogicPKCondition(List<String> pkField, List<Object[]> logicPKs, QueryExecuteOption option) throws BOSException {
        int length;
        StringBuffer buff = new StringBuffer();
        int n = length = logicPKs.size() > option.pageCount ? logicPKs.size() : option.pageCount;
        if (logicPKs.size() > 0) {
            int i;
            int m = pkField.size();
            for (i = 0; i < m; ++i) {
                int j;
                String keyName = pkField.get(i);
                buff.append(" ( ");
                buff.append(keyName);
                buff.append(" in ( ");
                boolean existNull = false;
                int n2 = logicPKs.size();
                for (j = 0; j < n2; ++j) {
                    Object[] pkValues = logicPKs.get(j);
                    if (pkValues[i] != null) continue;
                    existNull = true;
                    break;
                }
                for (j = 0; j < length; ++j) {
                    buff.append("?");
                    if (j >= length - 1) continue;
                    buff.append(", ");
                }
                buff.append(" ) ");
                if (existNull) {
                    buff.append(" or ");
                    buff.append(keyName);
                    buff.append(" is null ");
                }
                buff.append(" ) and ");
            }
            buff.append(" ( ");
            for (i = 0; i < length; ++i) {
                buff.append("(");
                int n3 = pkField.size();
                for (int j = 0; j < n3; ++j) {
                    buff.append("(");
                    buff.append(pkField.get(j));
                    buff.append("=?");
                    buff.append(" or (");
                    buff.append(pkField.get(j));
                    buff.append(" is null and ?=1))");
                    if (j >= n3 - 1) continue;
                    buff.append(" and ");
                }
                buff.append(")");
                if (i >= length - 1) continue;
                buff.append(" or ");
            }
        }
        buff.append(" ) ");
        return buff.toString();
    }

    private SQLType getSQLTypeByTypes(int types) {
        SQLType rtn = SQLType.NVARCHAR;
        switch (types) {
            case 4: {
                rtn = SQLType.INT;
                break;
            }
            case 6: 
            case 8: {
                rtn = SQLType.NUMERIC;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                rtn = SQLType.DATETIME;
                break;
            }
            default: {
                rtn = SQLType.VARCHAR;
            }
        }
        return rtn;
    }

    private void processLogicPKParameter(List<String> pkField, List<Object[]> keyList, List<Integer> val, Map<Integer, Object> map, QueryExecuteOption option) throws BOSException {
        int i;
        int count = 1;
        Object[] objs = null;
        int length = keyList.size() > option.pageCount ? keyList.size() : option.pageCount;
        HashMap<SQLType, Object> notExistMap = new HashMap<SQLType, Object>();
        notExistMap.put(SQLType.CHAR, "NE");
        notExistMap.put(SQLType.DATETIME, new Timestamp(0L));
        notExistMap.put(SQLType.INT, Integer.MIN_VALUE);
        notExistMap.put(SQLType.NCHAR, "NE");
        notExistMap.put(SQLType.NUMERIC, Integer.MIN_VALUE);
        notExistMap.put(SQLType.NVARCHAR, "NE");
        notExistMap.put(SQLType.VARCHAR, "NE");
        int m = pkField.size();
        for (i = 0; i < m; ++i) {
            SQLType keyType = this.getSQLTypeByTypes(val.get(i));
            int keySize = keyList.size();
            for (int j = 0; j < length; ++j) {
                Object[] paramValueObj = new Object[2];
                paramValueObj[0] = keyType;
                if (j < keySize) {
                    objs = keyList.get(j);
                    paramValueObj[1] = objs[i];
                } else {
                    paramValueObj[1] = notExistMap.get(keyType);
                }
                map.put(count, paramValueObj);
                ++count;
            }
        }
        int keySize = keyList.size();
        for (i = 0; i < length; ++i) {
            int n;
            if (i < keySize) {
                objs = keyList.get(i);
            } else {
                objs = new Object[pkField.size()];
                n = pkField.size();
                for (int k = 0; k < n; ++k) {
                    objs[k] = notExistMap.get(this.getSQLTypeByTypes(val.get(k)));
                }
            }
            n = pkField.size();
            for (int j = 0; j < n; ++j) {
                Object[] paramValueObj = new Object[]{this.getSQLTypeByTypes(val.get(j)), objs[j]};
                map.put(count, paramValueObj);
                paramValueObj = new Object[]{SQLType.INT, objs[j] == null ? Integer.valueOf(1) : Integer.valueOf(0)};
                map.put(++count, paramValueObj);
                ++count;
            }
        }
    }

    @Override
    public int getRowCount(Uuid querySessionID, String sql, List<String> pkField, QueryExecuteOption option) throws BOSException {
        QueryManagerTools.getInstance().invokeQueryExecuteStart();
        SeqTableData seqTableData = this.getSeqTableData(querySessionID, sql, pkField, option);
        int rs = this.getRowCountBySqlTable(seqTableData);
        QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        return rs;
    }

    @Override
    public int getRowCount(Uuid querySessionID, String sql, List<String> pkField, QueryExecuteOption option, String[] countFields) throws BOSException {
        QueryManagerTools.getInstance().invokeQueryExecuteStart();
        this.getSeqTableData(querySessionID, sql, pkField, option);
        int rs = this.getRowCountByFields(querySessionID, countFields);
        QueryManagerTools.getInstance().invokeQueryExecuteEnd();
        return rs;
    }

    @Override
    public Map<String, Object> doAllQueryTask(Uuid uuid, int start, int length, String sql, List<String> pkField, QueryExecuteOption option, String[] fields, boolean isFirstTime) throws BOSException {
        if (uuid != null) {
            this.closeQuery(uuid);
        }
        HashMap<String, Object> retMap = new HashMap<String, Object>(4);
        Uuid newUuid = null;
        newUuid = this.openQuery(sql, pkField, option);
        retMap.put("uuid", newUuid);
        IRowSet rowSet = this.getRowSet(newUuid, sql, pkField, option, start, length);
        retMap.put("rowSet", rowSet);
        if (isFirstTime) {
            if (!option.isIgnoreRowCount) {
                int rowCount = this.getRowCount(newUuid, sql, pkField, option);
                retMap.put("realRowCount", "false");
                retMap.put("rowCount", rowCount);
            }
            if (!option.isIgnoreBillCount && newUuid != null && fields != null) {
                int billCount = this.getRowCountByFields(newUuid, fields);
                retMap.put("billCount", billCount);
            }
        }
        return retMap;
    }

    @Override
    public Map<String, Object> getRowCountAsyn(Uuid newUuid, IMetaDataPK pk, BOSObjectType type, EntityViewInfo view, Map<String, EntityViewInfo> views, Map<Integer, Object> parameters, QueryExecuteOption option, int rowCount, boolean isIgnoreRowCount) throws BOSException {
        HashMap<String, Object> retMap = new HashMap<String, Object>(2);
        if (!option.isIgnoreRowCount && !isIgnoreRowCount) {
            SeqTableData seqTableData = this.getSeqTableDataAsyn(newUuid, pk, type, view, views, parameters, option);
            if (seqTableData == null) {
                QueryContext ctx;
                if (view != null && views != null && views.size() != 0) {
                    throw new BOSException("Can't set views and view at one time!");
                }
                if (views != null && views.size() != 0) {
                    ctx = QueryContext.getInstance(null, views, option, 0, parameters);
                } else {
                    if (view == null) {
                        view = new EntityViewInfo();
                    }
                    ctx = QueryContext.getInstance(view, null, option, 0, parameters);
                }
                newUuid = this.innerOpenQuery(ctx, null, pk, MetaDataTypeList.BASEQUERY, 50, null);
                seqTableData = this.getSeqTableDataAsyn(newUuid, pk, type, view, views, parameters, option);
                rowCount = seqTableData.getRowCount();
                if (rowCount < 0) {
                    QueryManagerTools.getInstance().invokeQueryExecuteStart();
                    rowCount = this.getRowCountBySqlTable(seqTableData);
                    QueryManagerTools.getInstance().invokeQueryExecuteEnd();
                }
            }
            retMap.put("realRowCount", "true");
            if (rowCount >= option.topCount || option.topCount == Integer.MAX_VALUE) {
                if (this.isGetRealRowCount()) {
                    SqlAndParam sqlmap = (SqlAndParam)sqlcache.get(newUuid.toString());
                    IQueryDataAccess qda = QueryDataAccessFactory.getLocalInstance(this.getContext());
                    if (sqlmap != null) {
                        String realRc = sqlmap.getSql("realRowCount");
                        rowCount = option.isUseDbPage && realRc != null ? Integer.valueOf(realRc).intValue() : qda.getRowCount(sqlmap, option);
                    } else if (views.size() != 0) {
                        rowCount = qda.getRowCount(pk, views, parameters, option);
                    } else {
                        if (view == null) {
                            view = new EntityViewInfo();
                        }
                        rowCount = qda.getRowCount(pk, view, parameters, option);
                    }
                    retMap.put("rowCount", rowCount);
                } else {
                    retMap.put("realRowCount", "false");
                    retMap.put("rowCount", rowCount);
                }
            } else {
                retMap.put("rowCount", rowCount);
            }
        }
        return retMap;
    }

    /*
     * Loose catch block
     */
    private String idArray2TempTableFilter(EntityViewInfo view) throws BOSException {
        if (view == null || view.getFilter() == null || view.getFilter().getFilterItems().isEmpty()) {
            return null;
        }
        String idTmpTable = null;
        FilterItemCollection filterItems = view.getFilter().getFilterItems();
        for (int i = 0; i < filterItems.size(); ++i) {
            Object v;
            Set values;
            FilterItemInfo item = filterItems.get(i);
            if (item.getCompareType() != CompareType.INCLUDE || !(item.getCompareValue() instanceof Set) || (values = (Set)item.getCompareValue()).size() <= 200) continue;
            Iterator it = values.iterator();
            BOSUuid id = null;
            if (it.hasNext() && (v = it.next()) != null) {
                try {
                    id = BOSUuid.read((String)v.toString());
                }
                catch (Exception ex) {
                    logger.info((Object)"not BOSUuid!");
                }
            }
            if (id == null) continue;
            Connection cn = null;
            PreparedStatement st = null;
            try {
                idTmpTable = TempTablePool.getInstance(this.getContext()).createTempTable("create table t_virtualModeDataAccess(fid varchar(44))");
                cn = EJBFactory.getConnection(this.getContext());
                st = cn.prepareStatement("insert into " + idTmpTable + " values(?)");
                st.setString(1, id.toString());
                st.addBatch();
                while (it.hasNext()) {
                    st.setString(1, it.next().toString());
                    st.addBatch();
                }
                st.executeBatch();
                item.setCompareType(CompareType.INNER);
                item.setCompareValue((Object)("select fid from " + idTmpTable));
                SQLUtils.cleanup((Statement)st, (Connection)cn);
                break;
            }
            catch (UuidException ex) {
                logger.info((Object)"not bosuuid!");
                break;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                SQLUtils.cleanup(st, cn);
            }
        }
        return idTmpTable;
    }
}

