/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.IVirtualModeDataAccess;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.ICacheService;
import com.kingdee.bos.framework.cache.MultiParamKey;
import com.kingdee.bos.framework.cache.Utils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.util.Uuid;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class VirtualModeDataAccessInterceptor
implements InvocationHandler {
    private static final Logger logger = Logger.getLogger(VirtualModeDataAccessInterceptor.class);
    public static final HashMap<Uuid, Uuid> queryIdMap = new HashMap();
    private IVirtualModeDataAccess iVirtual;
    private ICacheService cacheSvc;
    private Context context;

    public VirtualModeDataAccessInterceptor(IVirtualModeDataAccess virtual) {
        this.iVirtual = virtual;
        this.cacheSvc = CacheServiceFactory.getInstance();
    }

    public VirtualModeDataAccessInterceptor(IVirtualModeDataAccess virtual, Context ctx) {
        this.iVirtual = virtual;
        this.cacheSvc = CacheServiceFactory.getInstance();
        this.context = ctx;
    }

    public IVirtualModeDataAccess bind() {
        IVirtualModeDataAccess proxyConn = (IVirtualModeDataAccess)Proxy.newProxyInstance(this.iVirtual.getClass().getClassLoader(), this.iVirtual.getClass().getInterfaces(), (InvocationHandler)this);
        return proxyConn;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object re = null;
        MultiParamKey responseKey = MultiParamKey.create(IVirtualModeDataAccess.class, (Method)method, (Object[])args);
        if (ActionCache.containsKey((Object)responseKey.toString())) {
            return ActionCache.get((Object)responseKey.toString());
        }
        try {
            re = "doAllQueryTask".equals(method.getName()) ? this.doAllQueryTask(proxy, method, args) : ("getRowCountAsyn".equals(method.getName()) ? this.getRowCountAsyn(proxy, method, args) : ("getRowSet".equals(method.getName()) && args[0] instanceof Uuid ? this.getRowSet(proxy, method, args) : ("getBillIDList".equals(method.getName()) ? this.getBillIDList(proxy, method, args) : ("indexOfBillID".equals(method.getName()) ? this.indexOfBillID(proxy, method, args) : ("closeQuery".equals(method.getName()) ? this.closeQuery(proxy, method, args) : ("removeBillID".equals(method.getName()) ? this.removeBillID(proxy, method, args) : method.invoke((Object)this.iVirtual, args)))))));
        }
        catch (IllegalAccessException illAccEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy invoke catch a IllegalAccessException", (Throwable)illAccEx);
            }
            throw illAccEx;
        }
        catch (IllegalArgumentException illArgEx) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Prxoy invoke catch a IllegalArgumentException", (Throwable)illArgEx);
            }
            throw illArgEx;
        }
        catch (InvocationTargetException ie) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Proxy Invoke catch a target Exception, process continue", (Throwable)ie);
            }
            Throwable t = ie.getCause();
            throw t;
        }
        return re;
    }

    private Object getRowSet(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, BOSException {
        Object re = null;
        if (!(args[1] instanceof IMetaDataPK)) {
            re = method.invoke((Object)this.iVirtual, args);
            return re;
        }
        re = method.invoke((Object)this.iVirtual, args);
        return re;
    }

    private Object closeQuery(Object proxy, Method method, Object[] args) {
        Uuid uuid = (Uuid)args[0];
        if (queryIdMap.containsKey(uuid)) {
            Uuid queryId = queryIdMap.remove(uuid);
            if (queryId != null) {
                this.iVirtual.closeQuery(queryId);
            }
        } else {
            this.iVirtual.closeQuery(uuid);
        }
        return null;
    }

    private Object getRowCountAsyn(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object re = null;
        if (!(args[1] instanceof IMetaDataPK)) {
            re = method.invoke((Object)this.iVirtual, args);
            return re;
        }
        IMetaDataPK queryPK = (IMetaDataPK)args[1];
        re = method.invoke((Object)this.iVirtual, args);
        return re;
    }

    private Object doAllQueryTask(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object re = null;
        if (!(args[3] instanceof IMetaDataPK)) {
            re = method.invoke((Object)this.iVirtual, args);
            return re;
        }
        re = method.invoke((Object)this.iVirtual, args);
        return re;
    }

    private Object indexOfBillID(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, BOSException {
        Integer re = null;
        Uuid uuid = (Uuid)args[0];
        IMetaDataPK queryPK = (IMetaDataPK)args[1];
        re = (Integer)method.invoke((Object)this.iVirtual, args);
        return re;
    }

    private Object getBillIDList(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, BOSException {
        Object re = null;
        re = method.invoke((Object)this.iVirtual, args);
        return re;
    }

    private Object removeBillID(Object proxy, Method method, Object[] args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, BOSException {
        Object re = null;
        re = method.invoke((Object)this.iVirtual, args);
        IMetaDataPK queryPK = (IMetaDataPK)args[1];
        BOSObjectType type = Utils.getBOSTypeFromQueryPK((IMetaDataPK)queryPK);
        this.cacheSvc.discardType(type);
        return re;
    }
}

