/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.dao.query.server.analysis;

import com.kingdee.bos.dao.query.server.analysis.Aggregator;
import com.kingdee.bos.dao.query.server.analysis.DateUtil;
import java.util.Date;

public abstract class TimeSegmentAggregator {
    protected Aggregator aggregator;

    public abstract boolean aggregate(Object var1, Date var2);

    TimeSegmentAggregator(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    public Object getValue() {
        return this.aggregator.getValue();
    }

    public static TimeSegmentAggregator createAggregator(int timeSegment, String func) {
        switch (timeSegment) {
            case 1: {
                return new TODAY(func);
            }
            case 2: {
                return new YESTERDAY(func);
            }
            case 4: {
                return new THISWEEK(func);
            }
            case 8: {
                return new THISMONTH(func);
            }
            case 16: {
                return new THISYEAR(func);
            }
            case 32: {
                return new BEFORE(func);
            }
        }
        return null;
    }

    public static class BEFORE
    extends TimeSegmentAggregator {
        BEFORE(String func) {
            super(Aggregator.createAggregatorByFunction(func));
        }

        @Override
        public boolean aggregate(Object value, Date date) {
            this.aggregator.aggregate(value);
            return true;
        }
    }

    public static class THISYEAR
    extends TimeSegmentAggregator {
        THISYEAR(String func) {
            super(Aggregator.createAggregatorByFunction(func));
        }

        @Override
        public boolean aggregate(Object value, Date date) {
            if (DateUtil.isThisYear(date)) {
                this.aggregator.aggregate(value);
                return true;
            }
            return false;
        }
    }

    public static class THISMONTH
    extends TimeSegmentAggregator {
        THISMONTH(String func) {
            super(Aggregator.createAggregatorByFunction(func));
        }

        @Override
        public boolean aggregate(Object value, Date date) {
            if (DateUtil.isThisMonth(date)) {
                this.aggregator.aggregate(value);
                return true;
            }
            return false;
        }
    }

    public static class THISWEEK
    extends TimeSegmentAggregator {
        THISWEEK(String func) {
            super(Aggregator.createAggregatorByFunction(func));
        }

        @Override
        public boolean aggregate(Object value, Date date) {
            if (DateUtil.isThisWeek(date)) {
                this.aggregator.aggregate(value);
                return true;
            }
            return false;
        }
    }

    public static class YESTERDAY
    extends TimeSegmentAggregator {
        YESTERDAY(String func) {
            super(Aggregator.createAggregatorByFunction(func));
        }

        @Override
        public boolean aggregate(Object value, Date date) {
            if (DateUtil.isYesterday(date)) {
                this.aggregator.aggregate(value);
                return true;
            }
            return false;
        }
    }

    public static class TODAY
    extends TimeSegmentAggregator {
        TODAY(String func) {
            super(Aggregator.createAggregatorByFunction(func));
        }

        @Override
        public boolean aggregate(Object value, Date date) {
            if (DateUtil.isToday(date)) {
                this.aggregator.aggregate(value);
                return true;
            }
            return false;
        }
    }
}

