/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import bos.org.apache.commons.bos.MySqlDBUtils;
import bos.org.apache.commons.dbutils.QueryRunner;
import com.kingdee.bos.db.BatchTruncateResult;
import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableInfoQueue;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.TempTableUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MySqlVMTableManager {
    private static volatile MySqlVMTableManager manager;
    protected QueryRunner util = null;
    protected FormatOptions formatOptions;
    protected Map usedTableMap = Collections.synchronizedMap(new Hashtable());
    protected int tempRecycleTime = 0;
    protected TempTableRecycleThread recyleThread = null;
    protected Set indexMap = Collections.synchronizedSet(new HashSet());
    protected final String tempTablePrefix;
    protected Map DBSystemTempTableIndexMap = Collections.synchronizedMap(new HashMap());
    protected static final Logger logger;

    public static MySqlVMTableManager getMySqlTableManager() {
        if (manager == null) {
            manager = new MySqlVMTableManager();
        }
        return manager;
    }

    protected MySqlVMTableManager() {
        this.tempTablePrefix = "VT" + UUTN.S_ID;
        this.util = new QueryRunner(MySqlDBUtils.getdataSource());
        this.recyleThread = new TempTableRecycleThread(this, this.usedTableMap, "MySqlVMTableManager");
        this.recyleThread.start();
    }

    public String createTempTableImage(Connection orgConnection, String tablename) throws SQLException {
        return tablename;
    }

    void cleanTempMapping(boolean cleanAll) throws Exception {
        Method method = TempTableUtil.class.getMethod("cleanTempMapping", Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            txInvoker.invoke(method, new Object[]{cleanAll}, 4);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    Map getTempTableMapping() throws Exception {
        Method method = TempTableUtil.class.getMethod("getTempTableMapping", new Class[0]);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            return (Map)txInvoker.invoke(method, new Object[0], 4);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    void addTempTableMapping(TableInfo info) throws Exception {
        String sql = "INSERT INTO T_KSQL_TM(tabname, fields) VALUES('" + info.tableName + "','" + info.tableFields + "')";
        this.executeSQL(sql);
    }

    void deleteUnreuseTempTable(String tables) throws Exception {
        if (tables == null || tables.trim().length() == 0) {
            return;
        }
        String sql = "DELETE FROM T_KSQL_TM WHERE tabname in (" + tables + ")";
        this.executeSQL(sql);
    }

    private void init() {
    }

    void addTableInfo(TableInfo info) {
        this.usedTableMap.put(info.tableName, info);
    }

    public String getTableName(String desc) {
        return this.getTableName(desc, this.tempRecycleTime, null);
    }

    public String getTableName(String desc, long lifeCycle) {
        return this.getTableName(desc, lifeCycle, null);
    }

    public String getTableName(String desc, long lifeCycle, String tableFields) {
        return this.getTableName(desc, lifeCycle, tableFields, true);
    }

    public String getTableName(String desc, long lifeCycle, String tableFields, boolean isPutInMap) {
        String tableName = new UUTN(true).toString();
        if (isPutInMap) {
            TableInfo tableInfo = new TableInfo(tableName, desc, lifeCycle, System.currentTimeMillis(), tableFields);
            this.usedTableMap.put(tableName, tableInfo);
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseTable(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName");
        }
        tableName = tableName.toUpperCase();
        TableInfo info = null;
        Map map = this.usedTableMap;
        synchronized (map) {
            info = (TableInfo)this.usedTableMap.remove(tableName);
        }
        if (info == null) {
            logger.error((Object)("Try to drop table not generat by TableManger, request reject. Table:" + tableName + "@MYSQL"), new Throwable("You can't drop table by this way."));
            return;
        }
        if (info.getState() != -1) {
            logger.error((Object)("Try to release table in illegal state, table is:" + tableName + ", state is:" + info.getState() + ",description :" + info.getDesc()), (Throwable)new IllegalStateException(info.getState() + ""));
            return;
        }
        this.recyleThread.recycleTableQueue.put(info);
    }

    void releaseNew(String tableName) {
        TableInfo info = new TableInfo(tableName, "Release On System Start", -1L, System.currentTimeMillis(), null);
        this.recyleThread.recycleTableQueue.put(info);
    }

    public void releaseTableName(String tableName) {
        this.releaseTable(tableName);
    }

    final String createIndexName() {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 17);
        while (!this.indexMap.add(name)) {
            name = new UUTN(true, "").toString().substring(0, 17);
        }
        return "I" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TableInfo[] getTableInfosByState(int state) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        Collection coll = this.usedTableMap.values();
        Map map = this.usedTableMap;
        synchronized (map) {
            for (TableInfo info : coll) {
                if (state != -1 && info.getState() != state) continue;
                list.add(info);
            }
        }
        return list.toArray(new TableInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTableSize(int state) {
        if (state == -1) {
            return this.usedTableMap.size();
        }
        int size = 0;
        Map map = this.usedTableMap;
        synchronized (map) {
            Collection coll = this.usedTableMap.values();
            for (TableInfo info : coll) {
                if (info.getState() != state) continue;
                ++size;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TableInfo[] getAllTableInfos() {
        ArrayList list = new ArrayList();
        Map map = this.usedTableMap;
        synchronized (map) {
            list.addAll(this.usedTableMap.values());
        }
        return list.toArray(new TableInfo[0]);
    }

    final TableInfo getTableInfo(String tabName) {
        return (TableInfo)this.usedTableMap.get(tabName);
    }

    public final TableInfo removeTableInfo(String tabName) {
        if (tabName != null && this.usedTableMap.containsKey(tabName)) {
            return (TableInfo)this.usedTableMap.remove(tabName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TableInfo[] getTableInfosByTime(long begin, long end) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        Set set = this.usedTableMap.keySet();
        Map map = this.usedTableMap;
        synchronized (map) {
            for (String tabName : set) {
                TableInfo info = this.getTableInfo(tabName);
                if (begin > 0L && begin > info.getLastStateTime() || end > 0L && end < info.getLastStateTime()) continue;
                list.add(info);
            }
        }
        return list.toArray(new TableInfo[0]);
    }

    protected int getThreadIntervalTime() {
        return 3600000;
    }

    protected String getDropTriggerSql(String triggerName) {
        if (triggerName == null || triggerName.length() == 0) {
            throw new IllegalArgumentException("triggerName");
        }
        return "/*dialect*/DROP TRIGGER " + triggerName;
    }

    public final void cleanTempTable(boolean flag) throws Exception {
        Method method = TempTableUtil.class.getMethod("listUselessTempTable", Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            String[] names = (String[])txInvoker.invoke(method, new Object[]{flag}, 4);
            for (int i = 0; i < names.length; ++i) {
                this.releaseNew(names[i]);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable cleanTempTable, AIS:MYSQL, PREFIX:" + this.tempTablePrefix + ", COUNT:" + names.length));
            }
        }
        catch (Throwable t) {
            logger.error((Object)("TempTable cleanTempTable, AIS:MYSQL, PREFIX:VT" + UUTN.S_ID), t);
            throw new Exception(t);
        }
    }

    private void dropTrigger(String triggerName) throws Throwable {
        String sql = this.getDropTriggerSql(triggerName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable dropTrigger, AIS:MYSQL, PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        this.executeSQL(sql);
    }

    public void dropTable(String tableName) throws Throwable {
        if (!this.isTableExists(tableName)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable dropTable, AIS:MYSQL, PREFIX:" + this.tempTablePrefix + "\nSQL: DROP TABLE " + tableName));
        }
        String sql = "DROP TABLE " + tableName;
        this.executeSQL(sql);
    }

    public void dropIndex(String tableName, String index) throws Exception {
        String sql = "DROP INDEX " + tableName + "." + index;
        try {
            this.executeSQL(sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable dropIndex, AIS:MYSQL, PREFIX:" + this.tempTablePrefix + "\nSQL:" + sql));
            }
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public boolean isTableEmpty(String tableName) throws Exception {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName" + tableName);
        }
        Method method = TempTableUtil.class.getMethod("isTableEmpty", String.class);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            Object result = txInvoker.invoke(method, new Object[]{tableName}, 4);
            return (Boolean)result;
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void createTable(String sql) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MYSQL TempTable createTable, AIS:MYSQL, PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.util.update(sql);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void createIndex(String sql) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createIndex, AIS:MYSQL, PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.util.update(sql);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public boolean isTableExists(String tableName) throws Exception {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName" + tableName);
        }
        try {
            return this.util.queryIsExist("SHOW TABLES LIKE '" + tableName + "'");
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void dropTableNow(TableInfo tableInfo) {
        tableInfo.incDropCount();
        try {
            String[] triggers = tableInfo.getTriggerNames();
            if (triggers != null) {
                for (int i = 0; i < triggers.length; ++i) {
                    this.dropTrigger(triggers[i]);
                }
            }
            if (tableInfo.getIndexMap() != null) {
                for (String idxName : tableInfo.getIndexMap().keySet()) {
                    this.dropIndex(tableInfo.tableName, idxName);
                }
            }
            this.dropTable(tableInfo.tableName);
        }
        catch (Throwable ex) {
            logger.error((Object)("Drop Table Error! Table Name:" + tableInfo.tableName + ":" + tableInfo.getDesc()), ex);
        }
    }

    public void truncateTable(String tableName) throws SQLException {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName" + tableName);
        }
        String sql = "truncate table " + tableName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable truncateTable, AIS:MYSQL, PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        this.executeSQL(sql);
    }

    public void executeSQL(String sql) throws SQLException {
        this.util.update(sql);
    }

    BatchTruncateResult batchTruncateTable(List names) throws Exception {
        return this.batchTruncateTable(names, true);
    }

    BatchTruncateResult batchTruncateTable(List names, boolean isUseBatch) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("tableNames" + names);
        }
        Method method = TempTableUtil.class.getMethod("batchTruncateTable", String[].class, Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            Object result = txInvoker.invoke(method, new Object[]{names.toArray(new String[names.size()]), isUseBatch}, 4);
            return (BatchTruncateResult)result;
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void removeTempTableMapping(String tableName) throws Exception {
        String sql = "DELETE FROM T_KSQL_TM WHERE tabname ='" + tableName + "'";
        this.executeSQL(sql);
    }

    public int[] batchByList(String sql, List paramsList) throws SQLException {
        return this.util.batchByList(sql, paramsList);
    }

    public ResultSet Query(String sql, Object[] params) throws SQLException {
        return this.util.Query(sql, params);
    }

    public QueryRunner getUtil() {
        return this.util;
    }

    static {
        logger = Logger.getLogger(TableManager.class);
    }

    private static class TempTableRecycleThread
    extends Thread {
        private MySqlVMTableManager tableManager = null;
        private int intervalTime;
        private TableInfoQueue recycleTableQueue = null;
        private Map usedTableMap = null;

        TempTableRecycleThread(MySqlVMTableManager manager, Map usedTableMap, String name) {
            super(name);
            this.tableManager = manager;
            this.intervalTime = manager.getThreadIntervalTime();
            this.recycleTableQueue = new TableInfoQueue(-1);
            this.usedTableMap = usedTableMap;
            this.setPriority(5);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(Thread.currentThread().getName() + " started."));
            }
            long start = System.currentTimeMillis();
            while (true) {
                long now = System.currentTimeMillis();
                try {
                    this.recycleTable();
                    long rest = (long)this.intervalTime - (now - start);
                    if (rest > 0L) continue;
                    this.guardRecycleTable();
                    continue;
                }
                catch (Throwable e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(Thread.currentThread().getName() + " halted."));
                    continue;
                }
                break;
            }
        }

        private void recycleTable() throws Throwable {
            TableInfo tableInfo = this.recycleTableQueue.get(this.intervalTime);
            int time = 1;
            while (tableInfo != null) {
                tableInfo.incDropCount();
                try {
                    String[] triggers = tableInfo.getTriggerNames();
                    if (triggers != null) {
                        for (int i = 0; i < triggers.length; ++i) {
                            this.tableManager.dropTrigger(triggers[i]);
                        }
                    }
                    if (tableInfo.getIndexMap() != null) {
                        for (String idxName : tableInfo.getIndexMap().keySet()) {
                            this.tableManager.dropIndex(tableInfo.tableName, idxName);
                            this.tableManager.indexMap.remove(idxName);
                        }
                    }
                    this.tableManager.dropTable(tableInfo.tableName);
                    this.tableManager.removeTempTableMapping(tableInfo.tableName);
                }
                catch (Exception ex) {
                    logger.warn((Object)("Drop Table fail! Table Name:" + tableInfo.tableName + ":" + tableInfo.getDesc() + " Cause : " + ex.getMessage()));
                }
                long startTime = System.currentTimeMillis();
                tableInfo = this.recycleTableQueue.get(this.intervalTime);
                time = System.currentTimeMillis() - startTime < 1000L ? ++time : 0;
                if (time <= 10) continue;
                time = 0;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void guardRecycleTable() {
            ArrayList<String> recycleList = new ArrayList<String>();
            Iterator iter = null;
            Map map = this.usedTableMap;
            synchronized (map) {
                iter = this.usedTableMap.keySet().iterator();
            }
            while (iter.hasNext()) {
                long rest;
                TableInfo tableInfo = (TableInfo)this.usedTableMap.get(iter.next());
                if (tableInfo.isReuse() || (rest = tableInfo.getLifeCycle() - (System.currentTimeMillis() - tableInfo.getCreatedDateTime())) > 0L) continue;
                this.recycleTableQueue.put(tableInfo);
                recycleList.add(tableInfo.tableName);
            }
            if (!recycleList.isEmpty()) {
                map = this.usedTableMap;
                synchronized (map) {
                    for (int i = 0; i < recycleList.size(); ++i) {
                        this.usedTableMap.remove(recycleList.get(i));
                    }
                }
            }
        }
    }
}

