/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class OracleTableManager
extends TableManager {
    protected OracleTableManager(String ais) {
        super(ais);
        if (this.formatOptions == null) {
            this.formatOptions = new FormatOptions();
        }
        this.formatOptions.setNologging(true);
    }

    protected OracleTableManager(Connection conn) {
        super(conn);
        if (this.formatOptions == null) {
            this.formatOptions = new FormatOptions();
        }
        this.formatOptions.setNologging(true);
    }

    @Override
    protected String generateTableName() {
        return new UUTN(false).toString();
    }

    @Override
    public void createIndex(String sql) throws Exception {
        sql = this.getDialect(sql);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createIndex, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.executeSQL(sql);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createTempTableImage(Connection orgConnection, String tablename) throws SQLException {
        Object object;
        Connection conn = null;
        Statement stmt = null;
        Statement stmt2 = null;
        ResultSet rs2 = null;
        try {
            conn = this.ais != null ? OracleTableManager.getConnection(this.ais) : this.testConnection;
            stmt = conn.createStatement();
            TableInfo tableInfo = super.getTableInfo(tablename);
            String newTableName = null;
            if (tableInfo != null) {
                TableInfo[] infos = super.getTableInfosByState(0);
                for (int i = 0; i < infos.length; ++i) {
                    TableInfo aTableInfo = infos[i];
                    object = aTableInfo;
                    synchronized (object) {
                        if (tableInfo.tableFields.equals(aTableInfo.tableFields)) {
                            aTableInfo.setState(1);
                            newTableName = aTableInfo.tableName;
                        }
                        continue;
                    }
                }
            }
            if (newTableName == null) {
                newTableName = this.getTableName("TempTable -createTempTableImage");
                stmt.execute("select * into " + newTableName + " from " + tablename + " where 1=0");
            }
            stmt2 = orgConnection.createStatement();
            rs2 = stmt2.executeQuery("select * from " + tablename);
            ResultSetMetaData metaData = rs2.getMetaData();
            int count = metaData.getColumnCount();
            int pos = 0;
            while (rs2.next()) {
                String sql = "insert into " + newTableName + " values(";
                for (int i = 1; i <= count; ++i) {
                    sql = sql + "'" + rs2.getObject(i) + "',";
                }
                sql = sql.substring(0, sql.length() - 1);
                sql = sql + ")";
                stmt.addBatch(sql);
                if (++pos < 200) continue;
                stmt.executeBatch();
                stmt.clearBatch();
                pos = 0;
            }
            if (pos != 0) {
                stmt.executeBatch();
            }
            object = newTableName;
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(stmt2);
            SQLUtils.cleanup(rs2);
            SQLUtils.cleanup(stmt);
            if (this.ais != null) {
                SQLUtils.cleanup((Connection)conn);
            } else {
                try {
                    conn.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        SQLUtils.cleanup((Statement)stmt2);
        SQLUtils.cleanup((ResultSet)rs2);
        SQLUtils.cleanup((Statement)stmt);
        if (this.ais != null) {
            SQLUtils.cleanup((Connection)conn);
        } else {
            try {
                conn.commit();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return object;
    }

    @Override
    String createDBSystemTempTable_Session(String sql, Connection cn) throws Exception {
        String tableName;
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        Object obj = col.iterator().next();
        if (!(obj instanceof SqlCreateTableStmt)) {
            throw new IllegalAccessException("Error! SQL is not a create table sql. SQL: " + sql);
        }
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)obj;
        stmt.name = tableName = new UUTN(false, "GZT").toString();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        boolean isNologging = false;
        if (this.formatOptions != null) {
            isNologging = this.formatOptions.isNologging();
            this.formatOptions.setNologging(false);
        }
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = formater.getBuffer().toString();
        sql2 = sql2.replaceFirst("CREATE TABLE", "CREATE GLOBAL TEMPORARY TABLE");
        sql2 = "/*dialect*/" + sql2 + " ON COMMIT PRESERVE ROWS";
        if (this.formatOptions != null) {
            this.formatOptions.setNologging(isNologging);
        }
        try {
            this.executeSQL(sql2, cn);
            this.addThreadDump(tableName);
        }
        catch (Exception ex) {
            logger.error((Object)("Create Oracle DB System TempTable Error. Org-Sql: [" + sql + "] Sql: [" + sql2 + "]"));
            throw ex;
        }
        this.DBSystemTempTableIndexMap.put(tableName, Collections.synchronizedSet(new HashSet()));
        return tableName;
    }

    @Override
    void releaseDBSystemTempTable(String tableName, Connection cn) throws Exception {
        Set indexMap = (Set)this.DBSystemTempTableIndexMap.get(tableName);
        if (indexMap != null) {
            for (String idxName : indexMap) {
                this.dropDBSystemTempTableIndex(tableName, idxName, cn);
            }
            indexMap.clear();
        }
        try {
            this.executeSQL("/*dialect*/truncate table " + tableName, cn);
        }
        catch (Exception iter) {
            // empty catch block
        }
        try {
            this.executeSQL("drop table " + tableName, cn);
            this.deleteThreadDump(tableName);
        }
        catch (Exception ex) {
            logger.warn((Object)("Release DBSystemTempTable[" + tableName + "] failed. Cause: " + ex.getMessage()));
        }
        this.DBSystemTempTableIndexMap.remove(tableName);
    }

    @Override
    void createTable(SqlCreateTableStmt stmt) throws Exception {
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql = "/*dialect*/" + formater.getBuffer().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.executeSQL(sql);
            this.addThreadDump(stmt.name);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    @Override
    public boolean isOracle() {
        return true;
    }
}

