/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import bos.org.apache.commons.bos.MySqlDBUtils;
import bos.org.apache.commons.dbutils.QueryRunner;
import bos.org.apache.commons.dbutils.ResultSetHandler;
import com.kingdee.bos.db.BatchTruncateResult;
import com.kingdee.bos.db.NativeTimeoutRunnable;
import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TableManager;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class OutMySqlTableManager
extends TableManager {
    protected QueryRunner mysqlRunner = new QueryRunner(MySqlDBUtils.getdataSource());

    protected OutMySqlTableManager(String ais) {
        super(ais, false);
    }

    @Override
    public void analyzeTable(Connection conn, String tableName) throws SQLException {
    }

    @Override
    protected String getManagerName() {
        return "OutMySQLTmgr_";
    }

    @Override
    public String getTableName(String desc) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public String createTempTableImage(Connection orgConnection, String tablename) throws SQLException {
        throw new RuntimeException("Not supported");
    }

    @Override
    void cleanTempMapping(boolean cleanAll) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    List getTempTableMapping(int count, boolean delete) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    protected String getDialect(String kSql) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    void addTableInfo(TableInfo info) {
        super.addTableInfo(info);
    }

    @Override
    public String getTableName(String desc, long lifeCycle) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public String getTableName(String desc, long lifeCycle, String tableFields) {
        return super.getTableName(desc, lifeCycle, tableFields);
    }

    @Override
    public String getTableName(String desc, long lifeCycle, String tableFields, boolean isPutInMap) {
        return super.getTableName(desc, lifeCycle, tableFields, isPutInMap);
    }

    @Override
    protected String generateTableName() {
        return super.generateTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanTempTable(boolean flag) throws Exception {
        String prefix = "VT" + UUTN.S_ID;
        String sql = "show tables like '" + prefix + "%'";
        ResultSet rs = null;
        StringBuffer sql2 = new StringBuffer("drop table ");
        try {
            StringBuffer sb = (StringBuffer)this.mysqlRunner.query(sql, new ResultSetHandler(){

                @Override
                public Object handle(ResultSet rs) throws SQLException {
                    StringBuffer sb = new StringBuffer();
                    while (rs.next()) {
                        String tableName = rs.getString(1);
                        sb.append(tableName).append(",");
                    }
                    return sb;
                }
            });
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                sql2.append(sb);
                this.mysqlRunner.update(sql2.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(rs);
        }
    }

    @Override
    public void releaseTable(String tableName) {
        TableInfo info = null;
        info = (TableInfo)this.tableMap.get(tableName);
        if (info == null) {
            return;
        }
        TempTablePool.getInstance(this.ais).releaseInner(info);
    }

    @Override
    void releaseNew(String tableName) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void releaseTableName(String tableName) {
        throw new RuntimeException("Not supported");
    }

    @Override
    int getTableInfoSize() {
        return super.getTableInfoSize();
    }

    @Override
    int getTableSize(int state) {
        return super.getTableSize(state);
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
    }

    @Override
    public void dropTable(String tableName) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void dropIndex(String tableName, String index) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    public boolean isTableEmpty(String tableName) throws Exception {
        try {
            return this.mysqlRunner.queryIsExist("select * from " + tableName + " limit 1");
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    @Override
    public void createTable(String sql) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.executeSQL(sql);
            try {
                Lexer lexer = new Lexer(sql);
                SqlParser parser2 = new SqlParser(lexer);
                Collection col = parser2.parseStmtList();
                SqlCreateTableStmt stmt = (SqlCreateTableStmt)col.iterator().next();
                this.addThreadDump(stmt.name);
            }
            catch (Throwable lexer) {}
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    @Override
    public void createTable(String sql, Connection cn) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void createIndex(String sql) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    void createTable(SqlCreateTableStmt stmt) throws Exception {
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql = "/*dialect*/" + formater.getBuffer().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.executeSQL(sql);
            this.addThreadDump(stmt.name);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    @Override
    public boolean isTableExists(String tableName) throws Exception {
        try {
            return this.mysqlRunner.queryIsExist("SHOW TABLES LIKE '" + tableName + "'");
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    @Override
    public void dropTableNow(TableInfo tableInfo) {
        throw new RuntimeException("Not supported");
    }

    public List dropTableBatch(List tableInfos) {
        StringBuffer sb = new StringBuffer();
        sb.append("drop table ");
        ArrayList<String> tableNames = new ArrayList<String>();
        int size = tableInfos.size();
        for (int i = 0; i < tableInfos.size(); ++i) {
            sb.append(((TableInfo)tableInfos.get((int)i)).tableName);
            if (i < size - 1) {
                sb.append(",");
            }
            tableNames.add(((TableInfo)tableInfos.get((int)i)).tableName);
        }
        try {
            this.executeSQL(sb.toString());
            this.deleteThreadDump(tableNames);
            logger.info((Object)("Batch Drop Table:" + sb));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void truncateTable(String tableName) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    void executeSQL(String sql, Connection cn) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void executeSQL(String sql) throws SQLException {
        this.mysqlRunner.update(sql);
    }

    BatchTruncateResult batchTruncateTable(List names) throws Exception {
        throw new RuntimeException("Not supported");
    }

    BatchTruncateResult batchTruncateTable(List names, boolean isUseBatch) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void removeTempMapping(String[] tableNames) throws SQLException {
    }

    @Override
    void removeTempMapping(TableInfo[] tableInfos) throws SQLException {
    }

    @Override
    void addTempMapping(TableInfo[] tableInfos) throws SQLException {
    }

    @Override
    String createDBSystemTempTable_Session(String createSql, Connection cn) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    void releaseDBSystemTempTable(String tableName, Connection cn) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    String createDBSystemTempTableIndex(String tableName, String columns, boolean isUnique, boolean isClustered, Connection cn) throws Exception {
        throw new RuntimeException("Not supported");
    }

    @Override
    void dropDBSystemTempTableIndex(String tableName, String indexName, Connection cn) {
        throw new RuntimeException("Not supported");
    }

    public NativeTimeoutRunnable getNativeTimeoutRunnable(int interval) {
        String schema = MySqlDBUtils.getSchema();
        if (schema != null) {
            return new MySqlNativeTimeoutRunnable(schema, interval);
        }
        return null;
    }

    @Override
    public boolean isOutMySql() {
        return true;
    }

    static class MySqlNativeTimeoutRunnable
    implements NativeTimeoutRunnable {
        private String schema;
        private QueryRunner mysqlRunner;
        private int interval = 120;
        public boolean hasPrivileges = true;

        MySqlNativeTimeoutRunnable(String schema, int intervalHour) {
            this.schema = schema;
            this.mysqlRunner = new QueryRunner(MySqlDBUtils.getdataSource());
            this.interval = intervalHour;
        }

        @Override
        public boolean hasPrivileges() {
            return this.hasPrivileges;
        }

        @Override
        public void run() {
            if (!this.hasPrivileges) {
                return;
            }
            String sql = "select table_name from information_schema.tables where table_schema=? and date_add(create_time,interval ? minute)<sysdate()";
            final StringBuffer names = new StringBuffer();
            try {
                this.mysqlRunner.query(sql, new Object[]{this.schema, this.interval}, new ResultSetHandler(){

                    @Override
                    public Object handle(ResultSet rs) throws SQLException {
                        boolean first = true;
                        while (rs.next()) {
                            if (!first) {
                                names.append(",");
                            }
                            names.append(rs.getString(1));
                            first = false;
                        }
                        return null;
                    }
                });
            }
            catch (SQLException e) {
                this.hasPrivileges = false;
                TableManager.logger.error((Object)e);
                e.printStackTrace();
            }
            if (names.length() > 0) {
                sql = "drop table " + names;
                try {
                    this.mysqlRunner.update(sql);
                    TableManager.logger.info((Object)("Batch Drop Table:" + names));
                }
                catch (SQLException e) {
                    TableManager.logger.error((Object)e);
                    e.printStackTrace();
                }
            }
        }
    }
}

