/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.RepositoryController;
import com.kingdee.bos.rpc.RPCConfig;
import com.kingdee.bos.rpc.performance.InvokeMonitor;
import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.RWSplitingConfiguration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RWSplitingManager {
    private static final Logger logger = Logger.getLogger(RWSplitingManager.class);
    private static final Map<String, RWSplitingManager> instances = new HashMap<String, RWSplitingManager>(4);
    private static final HashSet<String> readAises = new HashSet(4);
    private static boolean isRWSplit = false;
    private final String name;
    private String defaultSlaver;
    private final String[] slavers;
    private final int mask;
    private int curr = 0;

    private static RWSplitingManager getInstance(Context ctx) {
        return RWSplitingManager.getInstance(ctx.getAIS());
    }

    private static RWSplitingManager getInstance(String ais) {
        return instances.get(ais);
    }

    private static void initFromConfig() {
        RWSplitingConfiguration config = RWSplitingConfiguration.getInstance();
        ConfigurationItem item = config.getConfigItem("RWSplitManager");
        if (item == null) {
            return;
        }
        String rwSplit = item.getProperty("isRWSplit");
        if ("true".equals(rwSplit)) {
            isRWSplit = true;
        }
        List dataSources = item.getAllChildren();
        for (ConfigurationItem ds : dataSources) {
            String ais = ds.getName();
            String slavers = ds.getProperty("slavers");
            if (slavers != null && slavers.length() > 0) {
                String[] slaversA = slavers.split(",");
                instances.put(ais, new RWSplitingManager(ais, slaversA));
                for (String slaver : slaversA) {
                    instances.put(slaver, new RWSplitingManager(ais, slaversA));
                }
                continue;
            }
            instances.put(ais, new RWSplitingManager(ais, null));
        }
    }

    public static boolean isReadAis(String ais) {
        return readAises.contains(ais);
    }

    public static String getReadAis(Context ctx) {
        RWSplitingManager rw = RWSplitingManager.getInstance(ctx);
        if (rw == null) {
            return ctx.getAIS();
        }
        return rw.getReadAis();
    }

    public static String getMainSlaver(Context ctx) {
        RWSplitingManager rw = RWSplitingManager.getInstance(ctx);
        if (rw == null) {
            return null;
        }
        return rw.getMainSlaver();
    }

    public static boolean isRWSplit(Context ctx) {
        return isRWSplit;
    }

    private RWSplitingManager(String ais, String[] slavers) {
        String[] ss;
        this.name = ais;
        this.defaultSlaver = ais;
        if (slavers != null) {
            int size = slavers.length;
            int newSize = this.getMultiple(size);
            ss = new String[newSize];
            for (int i = 0; i < newSize; ++i) {
                ss[i] = slavers[i % size];
            }
            this.mask = newSize - 1;
        } else {
            ss = null;
            this.mask = -1;
        }
        this.slavers = ss;
        if (ss != null) {
            for (String s : ss) {
                readAises.add(s);
            }
        }
    }

    private int getMultiple(int i) {
        int pos = 0;
        while (i >> pos != 1) {
            ++pos;
        }
        int r = 1 << pos;
        if (r < i) {
            r = 1 << pos + 1;
        }
        return r;
    }

    public boolean hasReadAis() {
        return this.slavers == null;
    }

    public boolean isRWSplit() {
        return isRWSplit;
    }

    public static void setIsRWSplit(boolean isRWS) {
        if (isRWS != isRWSplit) {
            isRWSplit = isRWS;
            if (isRWS) {
                RPCConfig.addInvokeMonitor((InvokeMonitor)RepositoryController.instance);
            } else {
                RPCConfig.removeInvokeMonitor((InvokeMonitor)RepositoryController.instance);
            }
            logger.error((Object)(" Switch rwsplit to " + isRWS));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getReadAis() {
        String ais = this.defaultSlaver;
        if (this.mask >= 0) {
            ais = this.slavers[this.curr & this.mask];
            ++this.curr;
        }
        return ais;
    }

    public void setReadAis(String ais) {
        this.defaultSlaver = ais;
    }

    public String getMainSlaver() {
        return this.name;
    }

    static {
        try {
            RWSplitingManager.initFromConfig();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

