/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

class TableInfo
implements Serializable,
Comparable<TableInfo> {
    private static final long serialVersionUID = -1353500662241604484L;
    public static final int DEFAULT_LIFECYCLE = 0x6DDD00;
    final String tableName;
    final String tableFields;
    private String sequenceName;
    private final Map<String, String> indexMap = new Hashtable<String, String>();
    private String desc;
    private long createdDateTime;
    private long lastStateTime;
    private long lifeCycle;
    private final boolean isReuse;
    private int usingCount = 0;
    private int trunctateCount = 0;
    private int dropCount = 0;
    private int state = -1;
    private int recycleRetry = 0;
    private int deleteTryTime = 0;
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_USABLE = 0;
    public static final int STATE_USING = 1;
    public static final int STATE_TORECYCLE = 4;
    public static final int STATE_TODELETE = 8;
    public static final int STATE_DELETED = 16;
    Throwable usingStack = null;

    public TableInfo(String tableName, String desc, long lifeCycle, long createTimeStamp, String tableFields) {
        this.tableName = tableName;
        this.desc = desc;
        this.lifeCycle = lifeCycle;
        this.createdDateTime = createTimeStamp;
        this.lastStateTime = createTimeStamp;
        this.tableFields = tableFields;
        this.isReuse = lifeCycle >= Integer.MAX_VALUE;
    }

    public void incDeleteTryTime() {
        ++this.deleteTryTime;
    }

    public int getDeleteTryTime() {
        return this.deleteTryTime;
    }

    public long getCreatedDateTime() {
        return this.createdDateTime;
    }

    public String getDesc() {
        return this.desc;
    }

    public synchronized long getLastStateTime() {
        return this.lastStateTime;
    }

    public synchronized long getLifeCycle() {
        return this.lifeCycle;
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public synchronized int getState() {
        return this.state;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getUsingCount() {
        return this.usingCount;
    }

    public Throwable getUsingStack() {
        return this.usingStack;
    }

    public String[] getTriggerNames() {
        return new String[0];
    }

    public Map<String, String> getIndexs() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.putAll(this.indexMap);
        return m;
    }

    public int getIndexSize() {
        if (this.indexMap == null) {
            return 0;
        }
        return this.indexMap.size();
    }

    public Map<String, String> getIndexMap() {
        return this.indexMap;
    }

    public void setLifeCycle(long lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public synchronized void setState(int state) {
        this.state = state;
        this.lastStateTime = System.currentTimeMillis();
    }

    public synchronized void incUsingCount() {
        ++this.usingCount;
    }

    public void setUsingStack(Throwable usingStack) {
        this.usingStack = usingStack;
    }

    public String getTableFields() {
        return this.tableFields;
    }

    public synchronized int getTrunctateCount() {
        return this.trunctateCount;
    }

    synchronized void incTrunctateCount() {
        ++this.trunctateCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TableName=" + this.tableName + ",");
        sb.append("Description=" + this.desc + ",");
        sb.append("State=" + this.state + ",");
        sb.append("CreateTime=" + new Timestamp(this.createdDateTime) + ",");
        sb.append("LastStateTime=" + new Timestamp(this.lastStateTime) + ",");
        sb.append("UsingCount=" + this.usingCount + ",");
        sb.append("UsingStack=" + this.usingStack + ",");
        sb.append("LifeCycle=" + this.lifeCycle + ",");
        sb.append("IndexSize=" + this.indexMap.size() + ",");
        sb.append("TableFields=" + this.tableFields);
        return sb.toString();
    }

    public boolean isReuse() {
        return this.isReuse;
    }

    public int getDropCount() {
        return this.dropCount;
    }

    public void incDropCount() {
        ++this.dropCount;
    }

    public synchronized int getRecycleRetry() {
        return this.recycleRetry;
    }

    public synchronized void resetRecycleRetry() {
        this.recycleRetry = 0;
    }

    public synchronized void incRecycleRetry() {
        ++this.recycleRetry;
    }

    @Override
    public int compareTo(TableInfo o) {
        return this.tableName.compareTo(o.tableName);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof TableInfo) {
            TableInfo other = (TableInfo)o;
            return this.tableName.equalsIgnoreCase(other.tableName);
        }
        return false;
    }

    public int hashCode() {
        return this.tableName.hashCode();
    }
}

