/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.db.TableInfo;
import org.apache.log4j.Logger;

public class TableInfoQueue {
    private static final Logger logger = Logger.getLogger(TableInfoQueue.class);
    public static final int STATE_ALL = -880901;
    private final int infoState;
    private int size = 0;
    private QueueItem first;
    private QueueItem last;
    private int blocked;
    private static QueueItem freeItemChain;

    public TableInfoQueue(int tableInfoState) {
        this.infoState = tableInfoState;
    }

    public synchronized void put(TableInfo info) {
        if (this.infoState != -880901 && info.getState() != this.infoState) {
            IllegalStateException ex = new IllegalStateException("state of table" + info.tableName + " is illegal, the state current is:" + info.getState());
            logger.error((Object)"\u672c\u9519\u8bef\u53ea\u5e94\u8be5\u5728\u6d4b\u8bd5\u73af\u5883\u51fa\u73b0, \u8bf7\u4e0emichael_pan@kindee.com\u8054\u7cfb,\u5206\u673a\u53f78227", (Throwable)ex);
            throw ex;
        }
        if (this.first == null) {
            this.first = this.last = TableInfoQueue.createItem(info);
        } else {
            this.last = this.last.next = TableInfoQueue.createItem(info);
        }
        if (this.blocked != 0) {
            this.notifyAll();
        }
        ++this.size;
    }

    public synchronized TableInfo get(long timeout) {
        if (this.first == null || this.blocked != 0) {
            if (timeout == 0L) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            do {
                long currentTime;
                if ((currentTime = System.currentTimeMillis()) - startTime >= timeout) {
                    return null;
                }
                try {
                    long rest = timeout - currentTime + startTime;
                    ++this.blocked;
                    this.wait(rest);
                    --this.blocked;
                }
                catch (InterruptedException e) {
                    this.notifyAll();
                    --this.blocked;
                    throw new RuntimeException("thread is interrupted");
                }
            } while (this.first == null);
        }
        QueueItem item = this.first;
        TableInfo info = item.info;
        this.first = this.first.next;
        TableInfoQueue.freeItem(item);
        if (this.blocked != 0 && this.first != null) {
            this.notifyAll();
        }
        --this.size;
        return info;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized TableInfo get() {
        return this.get(Long.MAX_VALUE);
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    private static final synchronized QueueItem createItem(TableInfo info) {
        QueueItem item;
        if (freeItemChain == null) {
            item = new QueueItem();
        } else {
            item = freeItemChain;
            freeItemChain = TableInfoQueue.freeItemChain.next;
        }
        item.info = info;
        item.next = null;
        return item;
    }

    private static final synchronized void freeItem(QueueItem item) {
        item.next = freeItemChain;
        freeItemChain = item;
    }

    static class QueueItem {
        QueueItem next;
        TableInfo info;

        QueueItem() {
        }
    }
}

