/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.bos.Context;
import com.kingdee.bos.db.BatchTruncateResult;
import com.kingdee.bos.db.DB2AS400TableManager;
import com.kingdee.bos.db.DB2TableManager;
import com.kingdee.bos.db.DMTableManager;
import com.kingdee.bos.db.GaussDBTableManager;
import com.kingdee.bos.db.KingbaseTableManager;
import com.kingdee.bos.db.MSSQLServerTableManager;
import com.kingdee.bos.db.MySqlTableManager;
import com.kingdee.bos.db.OracleTableManager10g;
import com.kingdee.bos.db.OracleTableManager9i;
import com.kingdee.bos.db.OutMySqlTableManager;
import com.kingdee.bos.db.PostgresTableManager;
import com.kingdee.bos.db.RepositoryFactory;
import com.kingdee.bos.db.SybaseTableManager;
import com.kingdee.bos.db.TableInfo;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.db.TempTableUtil;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.dom.stmt.SqlCreateTableStmt;
import com.kingdee.bos.sql.dom.stmt.SqlStmt;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.bos.sql.formater.FormaterFactory;
import com.kingdee.bos.sql.formater.SQLFormater;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.bos.sql.shell.trace.TraceInfo;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class TableManager {
    protected static final Logger logger = Logger.getLogger(TableManager.class);
    private static final Map<String, TableManager> managerCache = Collections.synchronizedMap(new HashMap(4));
    protected int dbType = -1;
    protected final String ais;
    protected final TempTableUtil util;
    protected FormatOptions formatOptions;
    protected int tempRecycleTime = 0;
    protected final Set<String> indexMap = Collections.synchronizedSet(new HashSet());
    protected final String tempTablePrefix;
    protected final Map<String, Set<String>> DBSystemTempTableIndexMap = Collections.synchronizedMap(new HashMap());
    protected final Map<String, TableInfo> tableMap = Collections.synchronizedMap(new HashMap());
    protected Connection testConnection;

    public static TableManager getTableManager(Context context) throws SQLException {
        return TempTablePool.getInstance(context).getTableManager();
    }

    public static TableManager getTableManager(Context context, String ais) throws SQLException {
        return TempTablePool.getInstance(context, ais).getTableManager();
    }

    TableManager(Connection conn) {
        this.tempTablePrefix = "VT" + UUTN.S_ID;
        this.testConnection = conn;
        this.ais = null;
        this.util = null;
        this.formatOptions = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TableManager getTableManager(Connection conn) throws SQLException {
        String url = null;
        String username = null;
        int dbType = -1;
        String sql = "/*ksql_internal*/ SELECT URL, USERNAME, DBTYPE FROM KSQL_ENV";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                url = rs.getString(1);
                username = rs.getString(2);
                dbType = rs.getInt(3);
            }
        }
        catch (Throwable throwable) {
            KSqlUtil.cleanUp((Statement)stmt, rs);
            throw throwable;
        }
        KSqlUtil.cleanUp((Statement)stmt, (ResultSet)rs);
        assert (url != null && username != null);
        String key = url + ":" + username;
        TableManager manager = managerCache.get(key);
        if (manager != null) {
            return manager;
        }
        switch (dbType) {
            case 2: 
            case 7: {
                manager = new OracleTableManager9i(conn);
                break;
            }
            case 8: {
                manager = new OracleTableManager10g(conn);
                break;
            }
            case 3: {
                manager = new MSSQLServerTableManager(conn);
                break;
            }
            case 1: {
                manager = new DB2TableManager(conn);
                break;
            }
            case 9: {
                manager = new DB2AS400TableManager(conn);
                break;
            }
            case 4: {
                manager = new SybaseTableManager(conn);
                break;
            }
            case 6: {
                manager = new MySqlTableManager(conn);
                break;
            }
            case 5: {
                manager = new PostgresTableManager(conn);
                break;
            }
            case 11: {
                manager = new DMTableManager(conn);
                break;
            }
            case 12: {
                manager = new KingbaseTableManager(conn);
                break;
            }
            case 13: {
                manager = new GaussDBTableManager(conn);
                break;
            }
            default: {
                throw new SQLException("dbTypeName is not support.");
            }
        }
        manager.init(dbType);
        managerCache.put(key, manager);
        return manager;
    }

    public static TableManager getOutMysqlTableManager() {
        return TempTablePool.getInstanceForOutMySql().getTableManager();
    }

    static TableManager innergetOutMysqlTableManager(String ais) {
        TableManager manager;
        if (ais == null) {
            ais = "OutMysql";
        }
        if ((manager = managerCache.get(ais)) != null) {
            return manager;
        }
        manager = new OutMySqlTableManager(ais);
        manager.init(6);
        managerCache.put(ais, manager);
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TableManager innerGetTableManager(String ais) throws SQLException {
        TableManager manager = managerCache.get(ais);
        if (manager != null) {
            return manager;
        }
        try (Connection conn = null;){
            conn = TableManager.getConnection(ais);
            int dbType = KSqlUtil.getDbType((Connection)conn);
            switch (dbType) {
                case 2: 
                case 7: {
                    manager = new OracleTableManager9i(ais);
                    break;
                }
                case 8: {
                    manager = new OracleTableManager10g(ais);
                    break;
                }
                case 3: {
                    manager = new MSSQLServerTableManager(ais);
                    break;
                }
                case 1: {
                    manager = new DB2TableManager(ais);
                    break;
                }
                case 9: {
                    manager = new DB2AS400TableManager(ais);
                    break;
                }
                case 4: {
                    manager = new SybaseTableManager(ais);
                    break;
                }
                case 6: {
                    manager = new MySqlTableManager(ais);
                    break;
                }
                case 5: {
                    manager = new PostgresTableManager(ais);
                    break;
                }
                case 11: {
                    manager = new DMTableManager(ais);
                    break;
                }
                case 12: {
                    manager = new KingbaseTableManager(ais);
                    break;
                }
                default: {
                    throw new SQLException("dbTypeName is not support.");
                }
            }
            manager.init(dbType);
            managerCache.put(ais, manager);
            TableManager tableManager = manager;
            return tableManager;
        }
    }

    protected TableManager(String ais) {
        this(ais, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TableManager(String ais, boolean testConn) {
        this.ais = ais;
        this.tempTablePrefix = "VT" + UUTN.S_ID;
        if (testConn) {
            Connection conn = null;
            TraceInfo info = null;
            try {
                conn = TableManager.getConnection(ais);
                info = KSqlUtil.parseURL((String)KSqlUtil.getURL((Connection)conn));
            }
            catch (SQLException e) {
                logger.error((Object)"tablemanager init error", (Throwable)e);
            }
            finally {
                try {
                    KSqlUtil.cleanUp((Connection)conn, null);
                }
                catch (SQLException sQLException) {}
            }
            this.formatOptions = info != null ? info.getFormatOptions() : null;
        } else {
            this.formatOptions = null;
        }
        this.util = new TempTableUtil(this, ais);
    }

    public String createTempTableImage(Connection orgConnection, String tablename) throws SQLException {
        return tablename;
    }

    void cleanTempMapping(boolean cleanAll) throws Exception {
        Method method = TempTableUtil.class.getMethod("cleanTempMapping", Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            txInvoker.invoke(method, new Object[]{cleanAll}, 4);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    List getTempTableMapping(int count, boolean delete) throws Exception {
        Method method = TempTableUtil.class.getMethod("getTempTableMapping", Integer.TYPE, Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            return (List)txInvoker.invoke(method, new Object[]{count, delete}, 4);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    private void init(int dbType) {
        this.dbType = dbType;
        try {
            this.doInit();
        }
        catch (Exception ex) {
            logger.error((Object)"tablemanager init error", (Throwable)ex);
        }
    }

    protected String getDialect(String kSql) throws Exception {
        return "/*dialect*/" + TransUtil.translate((String)kSql, (int)this.dbType, (FormatOptions)this.formatOptions);
    }

    void addTableInfo(TableInfo info) {
        this.tableMap.put(info.tableName, info);
    }

    public String getTableName(String desc) {
        return this.getTableName(desc, this.tempRecycleTime, null);
    }

    public String getTableName(String desc, long lifeCycle) {
        return this.getTableName(desc, lifeCycle, null);
    }

    public String getTableName(String desc, long lifeCycle, String tableFields) {
        return this.getTableName(desc, lifeCycle, tableFields, true);
    }

    public String getTableName(String desc, long lifeCycle, String tableFields, boolean isPutInMap) {
        String tableName = this.generateTableName();
        isPutInMap = true;
        if (isPutInMap) {
            TableInfo tableInfo = new TableInfo(tableName, desc, lifeCycle, System.currentTimeMillis(), tableFields);
            tableInfo.setState(1);
            this.tableMap.put(tableName, tableInfo);
        }
        return tableName;
    }

    protected String generateTableName() {
        return new UUTN(true).toString();
    }

    public void releaseTable(String tableName) {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName");
        }
        TableInfo info = null;
        info = this.tableMap.get(tableName);
        if (info == null) {
            return;
        }
        TempTablePool.getInstance(this.ais).releaseInner(info);
    }

    void releaseNew(String tableName) {
        TableInfo info = new TableInfo(tableName, "Release On System Start", -1L, System.currentTimeMillis(), null);
        TempTablePool.getInstance(this.ais).releaseInner(info);
    }

    public void releaseTableName(String tableName) {
        this.releaseTable(tableName);
    }

    final String createIndexName() {
        UUTN u = new UUTN(true, "");
        String name = u.toString().substring(0, 17);
        while (!this.indexMap.add(name)) {
            name = new UUTN(true, "").toString().substring(0, 17);
        }
        return "I" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TableInfo[] getTableInfosByState(int state) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        Map<String, TableInfo> map = this.tableMap;
        synchronized (map) {
            for (TableInfo info : this.tableMap.values()) {
                if (state != -1 && info.getState() != state) continue;
                list.add(info);
            }
        }
        return list.toArray(new TableInfo[0]);
    }

    int getTableInfoSize() {
        return this.tableMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTableSize(int state) {
        if (state == -1) {
            return this.tableMap.size();
        }
        int size = 0;
        Map<String, TableInfo> map = this.tableMap;
        synchronized (map) {
            for (TableInfo info : this.tableMap.values()) {
                if (info.getState() != state) continue;
                ++size;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TableInfo[] getAllTableInfos() {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        Map<String, TableInfo> map = this.tableMap;
        synchronized (map) {
            list.addAll(this.tableMap.values());
        }
        return list.toArray(new TableInfo[0]);
    }

    final TableInfo getTableInfo(String tabName) {
        return this.tableMap.get(tabName);
    }

    public final TableInfo removeTableInfo(String tabName) {
        if (tabName != null) {
            return this.tableMap.remove(tabName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TableInfo[] getTableInfosByTime(long begin, long end) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        Map<String, TableInfo> map = this.tableMap;
        synchronized (map) {
            for (String tabName : this.tableMap.keySet()) {
                TableInfo info = this.getTableInfo(tabName);
                if (begin > 0L && begin > info.getLastStateTime() || end > 0L && end < info.getLastStateTime()) continue;
                list.add(info);
            }
        }
        return list.toArray(new TableInfo[0]);
    }

    protected void doInit() throws Exception {
    }

    protected abstract String getManagerName();

    protected int getThreadIntervalTime() {
        return 3600000;
    }

    protected String getDropTriggerSql(String triggerName) {
        if (triggerName == null || triggerName.length() == 0) {
            throw new IllegalArgumentException("triggerName");
        }
        return "/*dialect*/DROP TRIGGER " + triggerName;
    }

    public void cleanTempTable(boolean flag) throws Exception {
        Method method = TempTableUtil.class.getMethod("listUselessTempTable", Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            String[] names = (String[])txInvoker.invoke(method, new Object[]{flag}, 4);
            for (int i = 0; i < names.length; ++i) {
                try {
                    this.dropTableWithoutCheck(names[i]);
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)("TempTable cleanTempTable error, the table is " + names[i] + ",exception:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable cleanTempTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + ", COUNT:" + names.length));
            }
        }
        catch (Throwable t) {
            logger.error((Object)("TempTable cleanTempTable, AIS:" + this.ais + ", PREFIX:" + "VT" + UUTN.S_ID), t);
            throw new Exception(t);
        }
    }

    public void cleanTempTableAll() throws Exception {
        Method method = TempTableUtil.class.getMethod("listUselessTempTableAll", Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            String[] names = (String[])txInvoker.invoke(method, new Object[]{true}, 4);
            for (int i = 0; i < names.length; ++i) {
                try {
                    this.dropTable(names[i]);
                    continue;
                }
                catch (SQLException e) {
                    logger.error((Object)("TempTable cleanTempTable error, the table is " + names[i] + ",exception:" + e.getMessage()));
                    e.printStackTrace();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable cleanTempTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + ", COUNT:" + names.length));
            }
        }
        catch (Throwable t) {
            logger.error((Object)("TempTable cleanTempTable, AIS:" + this.ais + ", PREFIX:" + "VT" + UUTN.S_ID), t);
            throw new Exception(t);
        }
    }

    public void cleanTimeoutTempTableAll(int timeout) throws Exception {
        Method method = TempTableUtil.class.getMethod("listTimeoutTempTableAll", Integer.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            String[] names = (String[])txInvoker.invoke(method, new Object[]{timeout}, 4);
            for (int i = 0; i < names.length; ++i) {
                try {
                    this.dropTableWithoutCheck(names[i]);
                    continue;
                }
                catch (SQLException e) {
                    logger.debug((Object)("TempTable cleanTimeoutTempTableAll error, the table is " + names[i] + ",exception:" + e.getMessage()));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable cleanTimeoutTempTableAll, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + ", COUNT:" + names.length));
            }
        }
        catch (Throwable t) {
            logger.error((Object)("TempTable cleanTempTable, AIS:" + this.ais + ", PREFIX:" + "VT" + UUTN.S_ID), t);
            throw new Exception(t);
        }
    }

    public void dropTableWithoutCheck(String tableName) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable dropTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: DROP TABLE " + tableName));
        }
        String sql = "DROP TABLE " + tableName;
        this.executeSQL(sql);
        this.deleteThreadDump(tableName);
    }

    public void dropTable(String tableName) throws Exception {
        if (!this.isTableExists(tableName)) {
            this.deleteThreadDump(tableName);
        } else {
            this.dropTableWithoutCheck(tableName);
        }
    }

    public void dropIndex(String tableName, String index) throws Exception {
        String sql = "DROP INDEX " + tableName + "." + index;
        try {
            this.executeSQL(sql);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TempTable dropIndex, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL:" + sql));
            }
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public boolean isTableEmpty(String tableName) throws Exception {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName" + tableName);
        }
        Method method = TempTableUtil.class.getMethod("isTableEmpty", String.class);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            Object result = txInvoker.invoke(method, new Object[]{tableName}, 4);
            return (Boolean)result;
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void createTable(String sql) throws Exception {
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)col.iterator().next();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = "/*dialect*/" + formater.getBuffer().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql2));
        }
        try {
            this.executeSQL(sql2);
            this.addThreadDump(stmt.name);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void createTable(String sql, Connection cn) throws Exception {
        Lexer lexer = new Lexer(sql);
        SqlParser parser2 = new SqlParser(lexer);
        Collection col = parser2.parseStmtList();
        SqlCreateTableStmt stmt = (SqlCreateTableStmt)col.iterator().next();
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql2 = "/*dialect*/" + formater.getBuffer().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql2));
        }
        try {
            this.executeSQL(sql2, cn);
            this.addThreadDump(stmt.name);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void createIndex(String sql) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createIndex, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            if (this.isSqlServer()) {
                this.executeSQLDirect(sql);
            } else {
                this.executeSQL(sql);
            }
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    void createTable(SqlCreateTableStmt stmt) throws Exception {
        SQLFormater formater = FormaterFactory.getFormater((int)this.dbType);
        formater.setOptions(this.formatOptions);
        formater.formatStmt((SqlStmt)stmt);
        String sql = "/*dialect*/" + formater.getBuffer().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable createTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        try {
            this.executeSQL(sql);
            this.addThreadDump(stmt.name);
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public boolean isTableExists(String tableName) throws Exception {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName" + tableName);
        }
        try {
            Method method = TempTableUtil.class.getMethod("isTableExists", String.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
            Object result = txInvoker.invoke(method, new Object[]{tableName}, 4);
            return (Boolean)result;
        }
        catch (Throwable ex) {
            throw new SQLException(ex.getMessage());
        }
    }

    public void dropTableNow(TableInfo tableInfo) {
        tableInfo.incDropCount();
        try {
            if (tableInfo.getIndexMap() != null) {
                for (String idxName : tableInfo.getIndexMap().keySet()) {
                    this.indexMap.remove(idxName);
                }
            }
            this.dropTable(tableInfo.tableName);
        }
        catch (Throwable ex) {
            logger.error((Object)("Drop Table Error! Table Name:" + tableInfo.tableName + ":" + tableInfo.getDesc()), ex);
        }
    }

    public List<TableInfo> dropTableBatch(List<TableInfo> tableInfos) {
        ArrayList<TableInfo> list = new ArrayList<TableInfo>();
        for (int i = 0; i < tableInfos.size(); ++i) {
            TableInfo tableInfo = tableInfos.get(i);
            if (tableInfo.getState() == 16) continue;
            tableInfo.incDropCount();
            try {
                if (tableInfo.getIndexMap() != null) {
                    for (String idxName : tableInfo.getIndexMap().keySet()) {
                        this.indexMap.remove(idxName);
                    }
                }
                this.dropTable(tableInfo.tableName);
                tableInfo.setState(16);
                this.removeTableInfo(tableInfo.tableName);
                continue;
            }
            catch (Exception ex) {
                list.add(tableInfo);
            }
        }
        return list;
    }

    public boolean isSqlServer() {
        return false;
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isOutMySql() {
        return false;
    }

    public boolean isPostgres() {
        return false;
    }

    public void truncateTable(String tableName) throws Exception {
        if (tableName == null || tableName.length() == 0) {
            throw new IllegalArgumentException("tableName" + tableName);
        }
        String sql = "truncate table " + tableName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("TempTable truncateTable, AIS:" + this.ais + ", PREFIX:" + this.tempTablePrefix + "\nSQL: " + sql));
        }
        this.executeSQL(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeSQL(String sql, Connection cn) throws Exception {
        if (cn == null) {
            this.executeSQL(sql);
        } else {
            Statement stmt = null;
            try {
                stmt = cn.createStatement();
                stmt.execute(sql);
            }
            finally {
                SQLUtils.cleanup((Statement)stmt);
            }
        }
    }

    void executeSQLDirect(String sql) throws SQLException {
        this.util.executeSQL(sql);
    }

    void executeSQL(String sql) throws SQLException {
        try {
            Method method = TempTableUtil.class.getMethod("executeSQL", String.class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
            txInvoker.invoke(method, new Object[]{sql}, 4);
        }
        catch (Throwable e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(e.getMessage());
        }
    }

    void executeSQL(String sql, Object[] params) throws SQLException {
        try {
            Method method = TempTableUtil.class.getMethod("executeSQL", String.class, Object[].class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
            txInvoker.invoke(method, new Object[]{sql, params}, 4);
        }
        catch (Throwable e) {
            Throwable t = e.getCause();
            if (t != null && t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(e.getMessage());
        }
    }

    BatchTruncateResult batchTruncateTable(List<String> names) throws Exception {
        return this.batchTruncateTable(names, true);
    }

    BatchTruncateResult batchTruncateTable(List<String> names, boolean isUseBatch) throws Exception {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("tableNames" + names);
        }
        Method method = TempTableUtil.class.getMethod("batchTruncateTable", String[].class, Boolean.TYPE);
        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
        try {
            Object result = txInvoker.invoke(method, new Object[]{names.toArray(new String[names.size()]), isUseBatch}, 4);
            return (BatchTruncateResult)result;
        }
        catch (Throwable ex) {
            throw new Exception(ex);
        }
    }

    public void removeTempMapping(String[] tableNames) throws SQLException {
        try {
            Method method = TempTableUtil.class.getMethod("removeTempMapping", String[].class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
            txInvoker.invoke(method, new Object[]{tableNames}, 4);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    void removeTempMapping(TableInfo[] tableInfos) throws SQLException {
        try {
            Method method = TempTableUtil.class.getMethod("removeTempMapping", TableInfo[].class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
            txInvoker.invoke(method, new Object[]{tableInfos}, 4);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    void addTempMapping(TableInfo[] tableInfos) throws SQLException {
        try {
            Method method = TempTableUtil.class.getMethod("addTempMapping", TableInfo[].class);
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy(this.util);
            txInvoker.invoke(method, new Object[]{tableInfos}, 4);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    public abstract void analyzeTable(Connection var1, String var2) throws SQLException;

    String createDBSystemTempTable_Session(String createSql, Connection cn) throws Exception {
        throw new Exception("not suport.");
    }

    void releaseDBSystemTempTable(String tableName, Connection cn) throws Exception {
        Set<String> indexMap = this.DBSystemTempTableIndexMap.get(tableName);
        if (indexMap != null) {
            for (String idxName : indexMap) {
                this.dropDBSystemTempTableIndex(tableName, idxName, cn);
            }
            indexMap.clear();
        }
        try {
            this.executeSQL("drop table " + tableName, cn);
            this.deleteThreadDump(tableName);
        }
        catch (Exception ex) {
            logger.warn((Object)("Release DBSystemTempTable[" + tableName + "] failed. Cause: " + ex.getMessage()));
        }
        this.DBSystemTempTableIndexMap.remove(tableName);
    }

    String createDBSystemTempTableIndex(String tableName, String columns, boolean isUnique, boolean isClustered, Connection cn) throws Exception {
        columns = columns.trim();
        String indexName = this.createIndexName();
        String sql = null;
        sql = isUnique ? "CREATE UNIQUE INDEX " + indexName + " ON " + tableName + " (" + columns + ")" : "CREATE INDEX " + indexName + " ON " + tableName + " (" + columns + ")";
        sql = "/*dialect*/" + sql;
        try {
            this.executeSQL(sql, cn);
        }
        catch (Exception ex) {
            logger.error((Object)("Create DBSystemTempTableIndex Error! tableName:[" + tableName + "], columns:[" + columns + "]"), (Throwable)ex);
            logger.error((Object)sql);
            throw ex;
        }
        Set<String> indexMap = this.DBSystemTempTableIndexMap.get(tableName);
        if (indexMap == null) {
            indexMap = Collections.synchronizedSet(new HashSet());
            this.DBSystemTempTableIndexMap.put(tableName, indexMap);
        }
        indexMap.add(indexName);
        return indexName;
    }

    void dropDBSystemTempTableIndex(String tableName, String indexName, Connection cn) {
        try {
            String sql = "drop index " + indexName;
            sql = "/*dialect*/" + sql;
            this.executeSQL(sql, cn);
        }
        catch (Exception ex) {
            logger.warn((Object)("Drop DBSystemTempTableIndex[" + indexName + "] on table [" + tableName + "] failed. Cause: " + ex.getMessage()));
        }
    }

    protected static Connection getConnection(final String ais) throws SQLException {
        return RepositoryFactory.noShift(new RepositoryFactory.Work<Connection, SQLException>(){

            @Override
            public Connection run() throws SQLException {
                Context context = new Context(null, "eas", ais, null);
                return EJBFactory.getConnection(context);
            }
        });
    }

    private String getThreadDump() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder(1024);
        for (StackTraceElement se : stack) {
            sb.append("\r\n\t at ").append(se.getClassName()).append('.').append(se.getMethodName()).append('(').append(se.getFileName()).append(':').append(se.getLineNumber()).append(")");
        }
        return sb.toString();
    }

    public void addThreadDump(String tableNmae) {
        try {
            this.executeSQL("INSERT INTO T_TM_THREADDUMP(FTableName,FCreatedTime,FTHREADDUMP)values(?,?,?)", new Object[]{tableNmae, new Timestamp(System.currentTimeMillis()), this.getThreadDump()});
        }
        catch (Throwable t) {
            logger.error((Object)("insert TempTable ThreadDump error! AIS:" + this.ais + " TableName:" + tableNmae), t);
        }
    }

    public void deleteThreadDump(String tableNmae) {
        block2: {
            try {
                this.executeSQL("DELETE FROM T_TM_THREADDUMP WHERE FTableName = ?", new Object[]{tableNmae});
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)("delete TempTable ThreadDump error! AIS:" + this.ais + " TableName:" + tableNmae), t);
            }
        }
    }

    public void deleteThreadDump(List<String> tableNames) {
        block5: {
            if (tableNames == null || tableNames.size() == 0) {
                return;
            }
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("DELETE FROM T_TM_THREADDUMP WHERE FTableName IN (");
                for (int i = 0; i < tableNames.size(); ++i) {
                    sb.append(" '").append(tableNames.get(i)).append("'");
                    if ((i + 1) % 500 == 0 || i == tableNames.size() - 1) {
                        sb.append(")");
                        this.executeSQL(sb.toString());
                        continue;
                    }
                    sb.append(",");
                }
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) break block5;
                logger.debug((Object)("delete TempTable ThreadDump error! AIS:" + this.ais + " TableName:" + tableNames), t);
            }
        }
    }

    public void checkTheadDumpTable() {
        block3: {
            try {
                if (!this.isTableExists("T_TM_THREADDUMP")) {
                    this.executeSQL("Create Table T_TM_THREADDUMP (FTableName VARCHAR(50) NOT NULL ,FCreatedTime DateTime NOT NULL ,FTHREADDUMP CLOB(10000));");
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug((Object)("checkTheadDumpTable error! AIS:" + this.ais), (Throwable)e);
            }
        }
    }
}

