/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.db;

import com.kingdee.util.Configuration;
import com.kingdee.util.ConfigurationItem;
import org.apache.log4j.Logger;

public class TempTableConfig {
    public static final Logger logger = Logger.getLogger(TempTableConfig.class);
    public static String MAX_TABLE_SIZE_OPTION = "com.kingdee.bos.sql.schema.TempTablePool.MAX_TABLE_SIZE_OPTION";
    public static final int DEFAULT_MAX_POOL_SIZE = 30000;
    public static final int MIN_POOL_SIZE = 1000;
    String tableRecyclePolicy;
    boolean reuseOnStartUp = false;
    int maxSize = 30000;
    int truncateBatch = 100;
    boolean releaseTempTableUseExecuteBatch = true;
    int usingTimeout = 28800000;
    int usableTimeout = 14400000;
    int minUsingTimes = 5;
    int mainLoopTime = 60000;
    int usingTimeoutLoopTime = 300000;
    int usableTimeoutLoopTime = 300000;
    int recycleLoopTime = 60000;
    int deleteLoopTime = 60000;
    int removeMappingLoopTime = 300000;
    int addMappingLoopTime = 300000;
    int nativeTimeout = 240;
    int nativeTimeoutLoopTime = 600000;
    int switchPolicyRunnableLoopTime = 300000;

    public TempTableConfig() {
        try {
            Configuration config = Configuration.getInstance();
            ConfigurationItem item = config.getConfigItem("tempTable");
            if (item != null) {
                this.initFromConfig("tempTable", item);
            }
        }
        catch (Exception ex) {
            logger.error((Object)":Load config for temp table error", (Throwable)ex);
        }
        String sizeStr = System.getProperty(MAX_TABLE_SIZE_OPTION);
        if (sizeStr != null) {
            try {
                int size = Integer.parseInt(sizeStr);
                if (size > 1000) {
                    this.maxSize = size;
                }
            }
            catch (Exception ex) {
                logger.warn((Object)("TempTablePool.getPoolMaxSize: " + ex.getMessage()));
            }
        }
    }

    public boolean isDrop(String tableRecyclePolicy) {
        return "drop".equalsIgnoreCase(tableRecyclePolicy);
    }

    private void initFromConfig(String name, ConfigurationItem item) {
        int iValue;
        String value = item.getProperty("reuseOnStartup");
        if (value != null) {
            this.reuseOnStartUp = Boolean.valueOf(value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: reuseOnStartUp: " + this.reuseOnStartUp));
            }
        }
        this.tableRecyclePolicy = item.getProperty("tableRecyclePolicy");
        value = item.getProperty("maxPoolSize");
        if (value != null) {
            iValue = Integer.parseInt(value);
            if (iValue > 1000) {
                this.maxSize = iValue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: maxPoolSize: " + this.maxSize));
            }
        }
        if ((value = item.getProperty("recycleTimeout")) == null) {
            value = item.getProperty("usingTimeout");
        }
        if (value != null) {
            iValue = Integer.parseInt(value);
            if (iValue < 5) {
                iValue = 5;
            }
            this.usingTimeout = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: usingTimeout: " + this.usingTimeout));
            }
        }
        if ((value = item.getProperty("dropTimeout")) == null) {
            value = item.getProperty("usableTimeout");
        }
        if (value != null) {
            iValue = Integer.parseInt(value);
            if (iValue < 5) {
                iValue = 5;
            }
            this.usableTimeout = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: usableTimeout: " + this.usableTimeout));
            }
        }
        if ((value = item.getProperty("dropTimes")) == null) {
            value = item.getProperty("minUsingTimes");
        }
        if (value != null) {
            iValue = Integer.parseInt(value);
            if (iValue >= 3) {
                this.minUsingTimes = iValue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: minUsingTimes: " + this.minUsingTimes));
            }
        }
        if ((value = item.getProperty("mainLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.mainLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: mainLoopTime: " + this.mainLoopTime));
            }
        }
        if ((value = item.getProperty("usingTimeoutLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.usingTimeoutLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: usingTimeoutLoopTime: " + this.usingTimeoutLoopTime));
            }
        }
        if ((value = item.getProperty("usableTimeoutLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.usableTimeoutLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: usableTimeoutLoopTime: " + this.usableTimeoutLoopTime));
            }
        }
        if ((value = item.getProperty("recycleLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.recycleLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: recycleLoopTime: " + this.recycleLoopTime));
            }
        }
        if ((value = item.getProperty("deleteLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.deleteLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: deleteLoopTime: " + this.deleteLoopTime));
            }
        }
        if ((value = item.getProperty("removeMappingLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.removeMappingLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: removeMappingLoopTime: " + this.removeMappingLoopTime));
            }
        }
        if ((value = item.getProperty("addMappingLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.addMappingLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: addMappingLoopTime: " + this.addMappingLoopTime));
            }
        }
        if ((value = item.getProperty("nativeTimeoutLoopTime")) != null) {
            iValue = Integer.parseInt(value);
            this.nativeTimeoutLoopTime = iValue * 60 * 1000;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: nativeTimeoutLoopTime: " + this.nativeTimeoutLoopTime));
            }
        }
        if ((value = item.getProperty("nativeTimeout")) != null) {
            this.nativeTimeout = iValue = Integer.parseInt(value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: nativeTimeout: " + this.nativeTimeout));
            }
        }
        if ((value = item.getProperty("truncateBatch")) != null) {
            iValue = Integer.parseInt(value);
            if (iValue >= 2) {
                this.truncateBatch = iValue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: truncateBatch: " + this.truncateBatch));
            }
        }
        if ((value = item.getProperty("releaseTempTableUseExecuteBatch")) != null) {
            this.releaseTempTableUseExecuteBatch = Boolean.valueOf(value);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(name + " Config: releaseTempTableUseExecuteBatch: " + this.releaseTempTableUseExecuteBatch));
            }
        }
    }
}

