/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.config.ServerConfigServiceInitializer;
import com.kingdee.bos.framework.PluginMethodProviderManager;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.service.CannotCreateServiceManagerException;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceExecutionException;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import java.lang.reflect.Method;

public class BOProxy {
    private Context ctx;
    private IMetaDataPK pk;
    private BOSObjectType type;

    BOProxy(Context ctx, IMetaDataPK pk) {
        this.ctx = ctx;
        this.pk = pk;
    }

    BOProxy(Context ctx, BOSObjectType type) {
        this.ctx = ctx;
        this.type = type;
    }

    public BizController getBusinessController() throws BOSException {
        return EJBFactory.getBusinessController(this.ctx, this.type, this.pk);
    }

    public Object callCmethod(String methodSignature, Object[] args) throws Throwable {
        BusinessObjectInfo bo = null;
        bo = this.pk == null ? MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getBusinessObject(this.type) : MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getBusinessObject(this.pk);
        MethodInfo method = null;
        MethodCollection mc = bo.getAllMethodsRuntime();
        for (int i = 0; i < mc.size(); ++i) {
            MethodInfo mi = mc.get(i);
            if (!mi.toString().equals(methodSignature)) continue;
            method = mi;
            break;
        }
        if (method != null) {
            return this.callCmethod(method, args);
        }
        return null;
    }

    public Object callCmethod(MethodInfo method, Object[] args) throws Throwable {
        Class[] parameterTypes = null;
        if (method == null) {
            return null;
        }
        ParameterCollection pc = method.getParameters();
        parameterTypes = new Class[pc.size() + 1];
        parameterTypes[0] = Context.class;
        for (int i = 0; i < pc.size(); ++i) {
            TypeReference tr = pc.get(i).getParameterType();
            String className = null;
            if (tr.getArrayDimension() == 0) {
                className = tr.toString();
            } else {
                className = "";
                for (int j = 0; j < tr.getArrayDimension(); ++j) {
                    className = className + "[";
                }
                if (tr.isSimpleType()) {
                    String type = tr.getArrayElementType().getBaseType();
                    if (type.equalsIgnoreCase("byte")) {
                        className = className + "B";
                    } else if (type.equalsIgnoreCase("char")) {
                        className = className + "C";
                    } else if (type.equalsIgnoreCase("double")) {
                        className = className + "D";
                    } else if (type.equalsIgnoreCase("float")) {
                        className = className + "F";
                    } else if (type.equalsIgnoreCase("int")) {
                        className = className + "I";
                    } else if (type.equalsIgnoreCase("long")) {
                        className = className + "J";
                    } else if (type.equalsIgnoreCase("short")) {
                        className = className + "S";
                    } else if (type.equalsIgnoreCase("boolean")) {
                        className = className + "Z";
                    }
                } else {
                    className = className + "L" + tr.getArrayElementType().getBaseType() + ";";
                }
            }
            parameterTypes[i + 1] = "short".equals(className) ? Short.TYPE : ("int".equals(className) ? Integer.TYPE : ("long".equals(className) ? Long.TYPE : ("float".equals(className) ? Float.TYPE : ("double".equals(className) ? Double.TYPE : ("char".equals(className) ? Character.TYPE : ("byte".equals(className) ? Byte.TYPE : ("boolean".equals(className) ? Boolean.TYPE : Class.forName(className))))))));
        }
        Object[] args2 = new Object[parameterTypes.length];
        args2[0] = this.ctx;
        for (int i = 0; i < args.length; ++i) {
            args2[i + 1] = args[i];
        }
        BizController bc = this.getBusinessController();
        try {
            Method md = bc.getClass().getMethod(method.getName(), parameterTypes);
            return md.invoke((Object)bc, args2);
        }
        catch (NoSuchMethodException nsm) {
            BusinessObjectInfo bo = null;
            bo = this.pk == null ? MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getBusinessObject(this.type) : MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx).getBusinessObject(this.pk);
            return this.callCmethod(args, bo, method, args2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object callCmethod(Object[] args, BusinessObjectInfo bo, MethodInfo method, Object[] args2) throws ServiceExecutionException, BOSException {
        if (PluginMethodProviderManager.getProvider() == null) {
            return null;
        }
        try {
            ServiceContext svcCtx = this.createServiceContext(bo, MetaDataPK.create((String)method.getInnerID()), args2);
            this.invokeServiceBefore(svcCtx);
            this.invokeServiceAfter(svcCtx);
            Object object = svcCtx.getMethodReturnValue();
            return object;
        }
        finally {
            ServiceStateManager.getInstance().finishCall();
        }
    }

    private ServiceContext createServiceContext(BusinessObjectInfo bo, MetaDataPK methodPK, Object[] params) {
        return new ServiceContext(bo.getBOSType(), bo.getType(), (IMetaDataPK)methodPK, params);
    }

    private void invokeServiceBefore(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(0);
        ServiceStateManager.getInstance().setServiceState(this.getServiceState());
        this.checkPluginService();
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    private void checkPluginService() throws CannotCreateServiceManagerException {
        if (!ServiceManagerFactory.getServiceManager().contains("PLUGIN_SERVICE_EP")) {
            ServerConfigServiceInitializer.initPluginService(null);
        }
    }

    private void invokeServiceAfter(ServiceContext svcCtx) throws ServiceExecutionException, BOSException {
        svcCtx.setExecutionMode(1);
        this.checkPluginService();
        ServiceManagerFactory.getServiceManager().execute((IServiceContext)svcCtx);
    }

    private ServiceStateManager.ServiceState getServiceState() {
        ServiceStateManager.ServiceState state = new ServiceStateManager.ServiceState();
        state.enableSpecialService("ALL_SERVICE");
        return state;
    }

    public static BOProxy getProxy(Context ctx, IMetaDataPK pk) {
        return new BOProxy(ctx, pk);
    }

    public static BOProxy getProxy(Context ctx, BOSObjectType type) {
        return new BOProxy(ctx, type);
    }
}

