/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.agent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectCollectionChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.IObjectValueChangeListener;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.agent.AgentContainerFactory;
import com.kingdee.bos.framework.agent.AgentException;
import com.kingdee.bos.framework.agent.AgentState;
import com.kingdee.bos.framework.agent.IAgentStateManager;
import com.kingdee.bos.framework.agent.IObjectCollectionAgent;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import com.kingdee.bos.framework.agent.ObjectCollectionChangeListener;
import com.kingdee.bos.framework.agent.ObjectValueChangeListener;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.InvalidDataException;
import com.kingdee.util.marshal.ExternalizeDelegate;
import com.kingdee.util.marshal.IMarshalObject;
import com.kingdee.util.marshal.Marshaller;
import com.kingdee.util.marshal.Unmarshaller;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class AgentManager
implements IAgentStateManager,
IMarshalObject {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.agent.AgentManager");
    private AgentState state = AgentState.UNKNOWN;
    private IObjectValue sourceInfo = null;

    public static IObjectValueAgent create(IObjectValueAgent agent) {
        AgentManager.registerIntercepter(agent, AgentState.NEW);
        return agent;
    }

    private IObjectValueAgent copyOvToAgent(IObjectValueAgent agent, IObjectValue ov, AgentState state) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("copy ov:[" + ov + "] to agent"));
        }
        this.sourceInfo = ov;
        IObjectValue target = agent.getTarget();
        target.clear();
        target.putAll(ov);
        if (ov instanceof ICommonBOSType && target instanceof ICommonBOSType) {
            ((ICommonBOSType)agent).setBOSType(ov.getBOSType());
            ((ICommonBOSType)agent).setPK(((ICommonBOSType)ov).getPK());
        }
        AgentManager.registerIntercepter(agent, state);
        return agent;
    }

    public IObjectValueAgent copyOvToAgentAsNew(IObjectValueAgent agent, IObjectValue ov) {
        return this.copyOvToAgent(agent, ov, AgentState.NEW);
    }

    public IObjectValueAgent copyOvToAgent(IObjectValueAgent agent, IObjectValue ov) {
        return this.copyOvToAgent(agent, ov, AgentState.INIT);
    }

    public IObjectValueAgent find(IObjectValueAgent agent, IObjectPK id) throws BOSException {
        IObjectValue ov;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("find object[" + id + "]"));
        }
        this.sourceInfo = ov = AgentContainerFactory.getInstance().getDynamicObject().getValue(agent.getTarget().getBOSType(), id);
        agent.getTarget().putAll(ov);
        AgentManager.registerIntercepter(agent, AgentState.INIT);
        return agent;
    }

    public static IObjectPK save(IObjectValueAgent agent) throws BOSException {
        IObjectValue targetOV = agent.getTarget();
        if (agent.getAgentState().equals((Object)AgentState.NEW)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("add object[" + targetOV.getBOSType() + "] " + targetOV));
            }
            return AgentContainerFactory.getInstance().getDynamicObject().addnew(targetOV.getBOSType(), targetOV);
        }
        if (agent.getAgentState().equals((Object)AgentState.MODIFIED)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("update object[" + targetOV.getBOSType() + "] " + targetOV));
            }
            targetOV = AgentManager.filter(targetOV);
            AgentContainerFactory.getInstance().getDynamicObject().updateBigObject(targetOV.getBOSType(), AgentManager.getObjectPK(targetOV), targetOV);
            return AgentManager.getObjectPK(targetOV);
        }
        if (agent.getAgentState().equals((Object)AgentState.INIT)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The object[" + AgentManager.getObjectPK(targetOV) + "] is not be changed!"));
            }
            return AgentManager.getObjectPK(targetOV);
        }
        throw new AgentException("Unsupported agent state " + (Object)((Object)agent.getAgentState()));
    }

    public static void remove(IObjectValueAgent agent) throws BOSException {
        IObjectValue targetOV = agent.getTarget();
        IObjectPK pk = AgentManager.getObjectPK(agent.getTarget());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("remove object[" + targetOV.getBOSType() + "] " + pk));
        }
        AgentContainerFactory.getInstance().getDynamicObject().delete(targetOV.getBOSType(), pk);
    }

    @Override
    public AgentState getAgentState() {
        return this.state;
    }

    @Override
    public void setAgentState(AgentState state) {
        this.state = state;
    }

    public static IObjectPK getObjectPK(IObjectValueAgent agent) {
        return AgentManager.getObjectPK(agent.getTarget());
    }

    public static IObjectPK getObjectPK(IObjectValue ov) {
        ObjectUuidPK pk = null;
        Object tmp = ov.get(ov.getPKField());
        if (tmp instanceof BOSUuid) {
            pk = new ObjectUuidPK((BOSUuid)tmp);
        } else if (tmp instanceof IObjectPK) {
            pk = (IObjectPK)tmp;
        } else {
            throw new IllegalStateException("Unsupported pk type " + (tmp == null ? ov.getClass() + "'s pkfield is NULL" : tmp.getClass()));
        }
        return pk;
    }

    private static IObjectValue filter(IObjectValue targetOV) {
        return targetOV;
    }

    public static IObjectValueAgent registerIntercepter(IObjectValueAgent agent, AgentState state) {
        if (agent.getTarget().size() > 0) {
            BOSObjectType bosType = agent.getTarget().getBOSType();
            EntityObjectInfo entity = AgentContainerFactory.getInstance().getMetaDataLoader().getEntity(bosType);
            PropertyCollection props = entity.getInheritedNoDuplicatedPropertiesRuntime();
            PropertyInfo prop = null;
            LinkPropertyInfo linkProp = null;
            RelationshipInfo relation = null;
            IObjectValue ov = agent.getTarget();
            IObjectValueAgent tmpAgent = null;
            IObjectValue tmp = null;
            int size = props.size();
            for (int i = 0; i < size; ++i) {
                prop = props.get(i);
                if (!(prop instanceof LinkPropertyInfo)) continue;
                linkProp = (LinkPropertyInfo)prop;
                relation = linkProp.getRelationship();
                if (relation == null) {
                    throw new InvalidDataException("Metadata is not integrate!" + entity.getFullName() + ":" + linkProp.getName());
                }
                if (relation.getType().equals((Object)RelationshipType.ASSOCIATION) || !relation.getClientObject().equals((Object)entity)) continue;
                if (relation.getSupplierCardinality().equals((Object)CardinalityType.ONE) || relation.getSupplierCardinality().equals((Object)CardinalityType.ZERO_TO_ONE)) {
                    tmp = ov.getObjectValue(linkProp.getName());
                    if (tmp == null) continue;
                    tmpAgent = AgentManager.create(tmp, relation.getSupplierObject().getBusinessAgent());
                    AgentManager.registerIntercepter(tmpAgent, state);
                    ov.put(linkProp.getName(), (Object)tmpAgent);
                    continue;
                }
                IObjectCollection oc = (IObjectCollection)ov.get(linkProp.getName());
                if (oc == null) continue;
                ov.put(linkProp.getName(), (Object)AgentManager.processCollection(oc, state, relation.getSupplierObject()));
            }
        }
        agent.setAgentState(state);
        AgentManager.registerObjectValueChangeListener(agent);
        return agent;
    }

    public static IObjectCollectionAgent createCollectionAgent(BOSObjectType bosType) {
        String collectionClass = AgentContainerFactory.getInstance().getMetaDataLoader().getEntity(bosType).getObjectCollectionClassRuntime();
        return AgentManager.createCollectionAgent(collectionClass);
    }

    public static IObjectCollectionAgent createCollectionAgent(String collectionClass) {
        try {
            Class<?> collectionClz = Class.forName(collectionClass + "Agent");
            return (IObjectCollectionAgent)collectionClz.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new AgentException("Cannot found collection agent class " + collectionClass, cnfe);
        }
        catch (InstantiationException ie) {
            throw new AgentException("Cannot instantiate collection agent class " + collectionClass, ie);
        }
        catch (IllegalAccessException iae) {
            throw new AgentException("Cannot access collection agent class " + collectionClass, iae);
        }
    }

    private static IObjectValueAgent create(IObjectValue ov, String agentClass) {
        try {
            Class<?> agentClz = Class.forName(agentClass);
            Method createMthd = agentClz.getMethod("create", new Class[0]);
            IObjectValueAgent agent = (IObjectValueAgent)createMthd.invoke(null, new Object[0]);
            IObjectValue target = agent.getTarget();
            target.putAll(ov);
            if (ov instanceof ICommonBOSType && target instanceof ICommonBOSType) {
                ((ICommonBOSType)agent).setBOSType(ov.getBOSType());
                ((ICommonBOSType)agent).setPK(((ICommonBOSType)ov).getPK());
            }
            return agent;
        }
        catch (ClassNotFoundException cnfe) {
            throw new AgentException("Cannot found agent class " + agentClass, cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new AgentException("Cannot found agent create method " + agentClass, nsme);
        }
        catch (InvocationTargetException ite) {
            throw new AgentException("Cannot create agent " + agentClass, ite);
        }
        catch (IllegalAccessException iae) {
            throw new AgentException("Cannot create agent " + agentClass, iae);
        }
    }

    private static IObjectCollectionAgent processCollection(IObjectCollection oc, AgentState state, EntityObjectInfo entity) {
        IObjectCollectionAgent agent = AgentManager.createCollectionAgent(entity.getObjectCollectionClassRuntime());
        int len = oc.size();
        for (int i = 0; i < len; ++i) {
            agent.getTargetOV().addObject(AgentManager.registerIntercepter(AgentManager.create(oc.getObject(i), entity.getBusinessAgent()), state).getTarget());
        }
        agent.getTargetOV().addEventListener((IObjectCollectionChangeListener)new ObjectCollectionChangeListener(agent));
        return agent;
    }

    private static void registerObjectValueChangeListener(IObjectValueAgent agent) {
        agent.getTarget().addEventListener((IObjectValueChangeListener)new ObjectValueChangeListener(agent));
    }

    public IObjectValue getSourceInfo() {
        return this.sourceInfo;
    }

    public void marshal(Marshaller marshaller) throws IOException {
        marshaller.writeObject((Object)this.state);
        marshaller.writeObject((Object)this.sourceInfo);
    }

    public void unmarshal(Unmarshaller unmarshaller) throws IOException, ClassNotFoundException {
        this.state = (AgentState)((Object)unmarshaller.readObject());
        this.sourceInfo = (IObjectValue)unmarshaller.readObject();
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        new ExternalizeDelegate((IMarshalObject)this).readExternal(in);
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        new ExternalizeDelegate((IMarshalObject)this).writeExternal(out);
    }
}

