/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.agent;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.agent.AgentContainer;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;

public class ClientAgentContainer
implements AgentContainer {
    @Override
    public IBOSObject getBOSObject(BOSObjectType bosType) throws BOSException {
        EntityObjectInfo entity = this.getMetaDataLoader().getEntity(bosType);
        if (entity == null) {
            throw new IllegalStateException("Cannot get metadata from cache! [" + bosType + "]");
        }
        String clzName = entity.getBusinessInterface();
        if (clzName == null) {
            throw new IllegalStateException("Cannot get object's interface class from metadata! [" + entity.getFullName() + "]");
        }
        Class<?> clz = null;
        try {
            clz = Class.forName(clzName);
        }
        catch (Exception e) {
            throw new BOSException("Cannot found class " + clzName, (Throwable)e);
        }
        return BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, clz);
    }

    @Override
    public IMetaDataLoader getMetaDataLoader() {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader();
    }

    @Override
    public IDynamicObject getDynamicObject() throws BOSException {
        return DynamicObjectFactory.getRemoteInstance();
    }
}

