/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.framework.agent;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectCollectionChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectCollectionChangeEvent;
import com.kingdee.bos.framework.agent.AgentManager;
import com.kingdee.bos.framework.agent.AgentState;
import com.kingdee.bos.framework.agent.IObjectCollectionAgent;
import com.kingdee.bos.framework.agent.IObjectValueAgent;
import org.apache.log4j.Logger;

public class ObjectCollectionChangeListener
implements IObjectCollectionChangeListener {
    private final IObjectCollectionAgent agent;
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.framework.agent.ObjectCollectionChangeListener");

    public ObjectCollectionChangeListener(IObjectCollectionAgent agent) {
        this.agent = agent;
    }

    public void objectCollectionChange(ObjectCollectionChangeEvent cce) {
        if (5 == cce.getType()) {
            this.processRemove(cce.getItem());
        } else if (3 == cce.getType()) {
            this.processRemove(cce.getItem());
            this.processAdd(cce.getNewItem());
        } else if (6 == cce.getType()) {
            IObjectValue oldOV = null;
            IObjectCollection oc = this.agent.getTargetOV();
            assert (oc != null);
            int len = oc.size();
            for (int i = 0; i < len; ++i) {
                oldOV = oc.getObject(i);
                this.processRemove(oldOV);
            }
        } else if (1 == cce.getType()) {
            this.processAdd(cce.getNewItem());
        }
    }

    private void processRemove(IObjectValue oldOV) {
        assert (oldOV != null);
        IObjectValueAgent ovAgent = null;
        if (oldOV instanceof IObjectValueAgent) {
            ovAgent = (IObjectValueAgent)oldOV;
            if (AgentState.INIT.equals((Object)ovAgent.getAgentState()) || AgentState.MODIFIED.equals((Object)ovAgent.getAgentState())) {
                IObjectPK pk = AgentManager.getObjectPK(ovAgent);
                assert (pk != null);
                this.agent.deleteOV(pk);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("delete objectvalue " + pk));
                }
            }
        } else {
            throw new IllegalStateException("Invalidate objectcollection state, it's element must be IObjectValueAgent instance!");
        }
    }

    private void processAdd(IObjectValue newOV) {
        assert (newOV != null);
        IObjectValueAgent ovAgent = null;
        if (newOV instanceof IObjectValueAgent) {
            ovAgent = (IObjectValueAgent)newOV;
            if (AgentState.INIT.equals((Object)ovAgent.getAgentState()) || AgentState.MODIFIED.equals((Object)ovAgent.getAgentState())) {
                IObjectPK pk = AgentManager.getObjectPK(ovAgent);
                assert (pk != null);
                if (this.agent.isDeletedOV(pk)) {
                    this.agent.addOV(pk);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("delete objectvalue " + pk));
                    }
                }
            }
        } else {
            throw new IllegalStateException("Invalidate objectcollection state, it's element must be IObjectValueAgent instance!");
        }
    }
}

